import FileUpload from "../fileupload/controller.js";

/**
 * 图片上传组件
 * @param {[type]} dataModel [description]
 */
export default class PhotoUpload extends FileUpload {

  constructor(__tfp, dataModel, parent) {
    super(__tfp, dataModel, parent, "PhotoUpload");
  }

  //保持唯一
  get onlyOne() { return this.dataModel.onlyOne }
  set onlyOne(value) {
    this.dataModel.onlyOne = value;
    this.dataModel.size = 1;
    if (this._tfp.isDesigning && this.dataModel.onlyOne) {
      uiDesigner.setCurCptAttrSettingVal("size", "1");
    }
  }

  // 文件数量
  get size() { return this.dataModel.size }
  set size(value) {
    this.dataModel.size = value;
  }

  // 图片宽度
  get imageWidth() { return this.dataModel.imageWidth }
  set imageWidth(value) {
    this.dataModel.imageWidth = value;
    if (this._jqObj) {
      if (value == '19') {
        this._jqObj.find(".image_box").css("height", "70px");
        this.dataModel.imageHeight = 70;
      } else if (value == '24') {
        this._jqObj.find(".image_box").css("height", "90px");
        this.dataModel.imageHeight = 90;
      } else if (value == '32') {
        this._jqObj.find(".image_box").css("height", "115px");
        this.dataModel.imageHeight = 115;
      } else if (value == '49') {
        this._jqObj.find(".image_box").css("height", "175px");
        this.dataModel.imageHeight = 175;
      } else if (value == '99') {
        this._jqObj.find(".image_box").css("height", "175px");
        this.dataModel.imageHeight = 175;
      }
      this._jqObj.find(".image_box").css("width", value + "%");
    }
  }

  // 图片高度
  get imageHeight() { return this.dataModel.imageHeight }
  set imageHeight(value) {
    this.dataModel.imageHeight = value;
    if (this._jqObj) {
      this._jqObj.find(".image_box").css("height", value + "px");
    }
  }

  // 图片边距
  get imageMargin() { return this.dataModel.imageMargin }
  set imageMargin(value) {
    this.dataModel.imageMargin = value;
    if (this._jqObj) {
      this._jqObj.find(".image_box").css("margin-bottom", value + "%");
      this._jqObj.find(".image_box").css("margin-right", value + "%");
    }
  }

  // 隐藏允许删除
  get allowDelete() { return this.dataModel.allowDelete }
  set allowDelete(value) {
    this.dataModel.allowDelete = value;
    if (this._jqObj) {
      if (value) {
        this._jqObj.find(".image_box.delImage_box").css("display", 'none');
      } else {
        this._jqObj.find(".image_box.delImage_box").css("display", 'flex');
      }
    }
  }

  // 隐藏允许添加
  get allowAdd() { return this.dataModel.allowAdd }
  set allowAdd(value) {
    this.dataModel.allowAdd = value;
    if (this._jqObj) {
      if (value) {
        this._jqObj.find(".image_box.addImage_box").css("display", 'none');
      } else {
        this._jqObj.find(".image_box.addImage_box").css("display", 'flex');
      }
    }
  }
  
  initRuntime() {
    let that = this;
    that.dataModel.imageWidth = '24';
  }
}