import TFPComponentRender from '../render.js'

export default class PathPickerRender extends TFPComponentRender {
  
  constructor(__tfp, _dataModel, _level) {
  	super(__tfp, _dataModel, _level);
  }

  getBodyHtml = function (getComponentsHtml) {
    let html = "\r\n";
    let indent = this.getHtmlIndent();
    if (!this.dataModel.value) this.dataModel.value = '';
    if (!this.dataModel.length) this.dataModel.length = '';
    if (!this.dataModel.placeHolder) this.dataModel.placeHolder = '';
    if (this.dataModel.value || this.dataModel.length || this.dataModel.placeHolder) {
      html += indent + "  <input type='text' class='tfp-pathpicker-input' value='" + this.dataModel.value + "' placeholder='"+this.dataModel.placeHolder+"' style='width: "+this.dataModel.length+"' />\r\n";
    } else {
      html += indent + "  <input type='text' class='tfp-pathpicker-input' style='width: 320px' />\r\n";
    }
    html += indent + "  <button class='tfp-pathpicker-choose'>选择</button>\r\n";
    return html + indent;
  }

  getHtml(getComponentsHtml, parentIndent, retainStyleAttr) {
    return super.getHtml("div", false, parentIndent, retainStyleAttr);
  }
}