import { FormInput } from "../controller.js";

/**
 * 路径选择组件
 * @param {[type]} dataModel [description]
 */
export default class PathPicker extends FormInput {

  constructor(__tfp, dataModel, parent, inputType) {
    if (inputType) {
      super(__tfp, inputType, dataModel, parent);
    } else {
      super(__tfp, "PathPicker", dataModel, parent);
    }
  }

  get value() { return this.dataModel.value }
  set value(value) {
    if (this._jqObj.find('.tfp-pathpicker-input').val()) {
      this.dataModel.value = this._jqObj.find('.tfp-pathpicker-input').val();
    }
    if (!value) {
      this._jqObj.find('.tfp-pathpicker-input').val('');
      this.dataModel.value = '';
      return;
    }
    this.dataModel.value = value;
    if (this._jqObj) this._jqObj.find('.tfp-pathpicker-input').val(this.dataModel.value);
  }

  get length() { return this.dataModel.length }
  set length(value) {
    if (!value) {
      this._jqObj.find('.tfp-pathpicker-input').css('width', '320px');
      this.dataModel.length = '';
      return;
    }
    this.dataModel.length = value;
    if (this._jqObj) this._jqObj.find('.tfp-pathpicker-input').css('width', this.dataModel.length);
  }

  get placeHolder() { return this.dataModel.placeHolder }
  set placeHolder(value) {
    if (!value) {
      this._jqObj.find('.tfp-pathpicker-input').attr("placeholder", '');
      this.dataModel.placeHolder = '';
      return;
    }
    this.dataModel.placeHolder = value;
    if (this._jqObj) this._jqObj.find('.tfp-pathpicker-input').attr("placeholder", this.dataModel.placeHolder);
  }

  get fileTypes() { return this.dataModel.fileTypes }
  set fileTypes(value) { this.dataModel.fileTypes = value }

  get onlyDir() { return this.dataModel.onlyDir }
  set onlyDir(value) {
    this.dataModel.onlyDir = value ? true : false;
  }

  get listServerFile() { return this.dataModel.listServerFile }
  set listServerFile(value) {
    this.dataModel.listServerFile = value ? true : false;
  }

  get listClientFile() { return this.dataModel.listClientFile }
  set listClientFile(value) {
    this.dataModel.listClientFile = value ? true : false;
  }

  initRuntime() {
    let that = this;
    let btnPathPicker = this._jqObj.find(".tfp-pathpicker-choose");
    btnPathPicker.click(function () {
      let args = {
        onlyDir: that.dataModel.onlyDir,
        listServerFile: that.dataModel.listServerFile,
        listClientFile: that.dataModel.listClientFile
      };
      that._tfp.openDialog("选择路径", "/node_modules/tfp/src/components/pathpicker/PathPicker.tfp", '502px', '503px', args, function (filePath) {
        let tmpPath = filePath;
        if (tmpPath.startsWith("/app/") && that.dataModel.listServerFile) {
          tmpPath = tmpPath.substr(5);
        } else if (tmpPath.startsWith("/web/")) {
          tmpPath = tmpPath.substr(4);
        }
        that.value = tmpPath;
        that.valueOnChange();
        that.exeEventHandler("onChange", tmpPath);
      });
      //sessionStorage.setItem('_OpenDialogArgs', JSON.stringify(args));
    });
    this._jqObj.find(".tfp-pathpicker-input").blur(function () {
      let val = $(this).val().trim();
      if (!isNull(val)) {
        that.dataModel.value = val;
        that.valueOnChange();
        that.exeEventHandler("onChange", val);
      }
      if (that.disabled) return;
      try {
        if (that.dataModel.onBlur) eval(that.dataModel.onBlur);
      } catch (err) {
        console.log(err.message);
      }
    })

    this._jqObj.find("input").focus(function () {
      if (that.disabled) return;
      try {
        if (that.dataModel.onFocus) eval(that.dataModel.onFocus);
      } catch (err) {
        console.log(err.message);
      }
    })
  }
}