import { ContainerComponent } from '../controller.js'

export default class Page extends ContainerComponent {
	constructor(__tfp, dataModel) {
		super(__tfp, "Page", dataModel);

		if (__tfp.isRuntime) {
			if (dataModel.client != 'mini') {
				if (dataModel.pageElId) {
					this._jqObj = $("#" + dataModel.pageElId);
				} else {
					this._jqObj = $("body");
				}
				this.el = this._jqObj.get(0);
				if (this.dataModel.title) $("title").text(this.dataModel.title);
				//初始化页面样式
				if (this.dataModel.styles) {
					for (var style in this.dataModel.styles) {
						this._jqObj.css(style, this.dataModel.styles[style]);
					}
				}
			}
		}
	}

	get client() { return this.dataModel.client }
	get positionType() { return this.dataModel.positionType }
	get framework() { return this.dataModel.framework }
	get pageType() { return this.dataModel.pageType }

	get cssFiles() { return this.dataModel.cssFiles }
	set cssFiles(value) { this.dataModel.cssFiles = value }

	get jsFiles() { return this.dataModel.jsFiles }
	set jsFiles(value) { this.dataModel.jsFiles = value }

	get styleSheets() { return this.dataModel.styleSheets }
	set styleSheets(value) { this.dataModel.styleSheets = value }

	get title() { return this.dataModel.title }
	set title(value) {
		this.dataModel.title = value;
		$("title").text(value);
		if (this._tfp.isDesigning) {
			if (this.client == "phone" || this.client == "mini") {
				// window.parent.$("#divPhonePageTitle").html(value);
				window.parent.$("#uiDesignerPageTitle").html(value);
			} else if (this.pageType == "dialog") {
				window.parent.$("#uiDesignerPageTitle").html("&nbsp;&nbsp;" + value);
			}
		}
	}

	/**
	 * 背景颜色模式
	 */
	get bgColorMode() { return this.dataModel.bgColorMode }
	set bgColorMode(value) { this.dataModel.bgColorMode = value }

	/**
	 * 内容颜色模式，与背景相反
	 */
	get contentColorMode() { return this.dataModel.bgColorMode == "dark" ? "light" : "dark" }
	set contentColorMode(value) { }

	get width() { return this.dataModel.pageType == "dialog" ? this.dataModel.width : null }
	set width(value) {
		if (!value || this.dataModel.pageType != "dialog") return;
		this.dataModel.width = value;
		let _width = value + "";
		if (_width.indexOf("px") < 0 && _width.indexOf("%") < 0) {
			_width += "px";
		}
		//设置设计和运行时宽度
		if (this._tfp.isDesigning) {
			if (this.pageType == "dialog") {
				window.parent.$("#uiDesignerFrame").css("width", _width);
				window.parent.$("#uiDesignerFrame").find("iframe").css("width", _width);
			}
		} else if (this._tfp.isRuntime) {
			//
		}
	}

	get height() { return this.dataModel.pageType == "dialog" ? this.dataModel.height : null }
	set height(value) {
		if (!value || this.dataModel.pageType != "dialog") return;
		this.dataModel.height = value;
		let _height = value + "";
		if (_height.indexOf("px") < 0 && _height.indexOf("%") < 0) {
			_height += "px";
		}
		//TODO 设置设计和运行时宽度
		if (this._tfp.isDesigning) {
			if (this.pageType == "dialog") {
				window.parent.$("#uiDesignerFrame").css("height", _height);
				window.parent.$("#uiDesignerFrame").find("iframe").css("height", (parseInt(_height.replace("px", "")) - 31) + "px");
			}
		} else if (this._tfp.isRuntime) {
			//
		}
	}

	render() {
		super.render();

		if (this._tfp.isDesigning) {
			if (this.dataModel.style) {
				$("body").attr("style", this.dataModel.style);
			}
			if (this.dataModel.styles) {
				let styles = "";
				for (let styleName in this.dataModel.styles) {
					$("body").css(styleName, this.dataModel.styles[styleName]);
				}
			}
			if (this.dataModel.class) {
				$("body").attr("class", this.dataModel.class);
			}

			if (this.dataModel.styleSheets) {
				let styleCode = "";
				for (var i = 0; i < this.dataModel.styleSheets.length; i++) {
					let styleSheet = this.dataModel.styleSheets[i];
					styleCode += "\t" + styleSheet.id + " {";
					for (var j = 0; j < styleSheet.styles.length; j++) {
						let style = styleSheet.styles[j];
						styleCode += style.name + ": " + style.value + ";";
					}
					styleCode += "}\r\n";
				}
				$("head").append("<style id=\"_tfpPageStyleSetting\">\r\n" + styleCode + "</style>");
			}

			if (this.dataModel.cssFiles) {
				for (var i = 0; i < this.dataModel.cssFiles.length; i++) {
					let cssFile = this.dataModel.cssFiles[i];
					$("head").append("<link rel=\"stylesheet\" type=\"text/css\" href=\"" + cssFile + "\">");
				}
			}
		}
	}

	initRuntime() {
		if (this.dataModel["onLoad"]) {
			eval(this.dataModel["onLoad"]);
		}
	}
}