import { ContainerComponent } from '../controller.js'

export default class Page extends ContainerComponent {
	constructor(__tfp, dataModel) {
		super(__tfp, "Page", dataModel);

		if (__tfp.isRuntime) {
			if (dataModel.client != 'mini') {
				if (dataModel.pageElId) {
					this._jqObj = $("#" + dataModel.pageElId);
				} else {
					this._jqObj = $("body");
				}
				this.el = this._jqObj.get(0);
				if (this.dataModel.title) $("title").text(this.dataModel.title);
				//初始化页面样式
				if (this.dataModel.styles) {
					for (var style in this.dataModel.styles) {
						this._jqObj.css(style, this.dataModel.styles[style]);
					}
				}
			}
		}

		// 计算公式
		this.formulasDict = {};
		(this.dataModel.formulas || []).forEach(formula => {
			if (!Array.isArray(formula.conditions)) return true;

			// 寻找当前公式中需要触发的组件
			const cptIds = [];
			const offMarkReg = /\$\{(.*?)\}/g;
			formula.conditions.forEach(condition => {
				if (!condition.control) return true;
				cptIds.push(condition.control);
			});
			formula.actions.forEach(action => {
				if (!action.formula) return true;
				const fControls = action.formula.match(offMarkReg);
				(fControls || []).forEach(fControl => { cptIds.push(fControl); });
			});

			// 去重组件组并遍历组件组添加至页面公式字典中
			(new Array(...new Set(cptIds))).forEach(cptId => {
				const [dataset, field] = getDatasetAndField(cptId);
				if (field) {
					if (!this.formulasDict[dataset]) this.formulasDict[dataset] = {};
					if (!this.formulasDict[dataset][field]) this.formulasDict[dataset][field] = [];
					this.formulasDict[dataset][field].push(formula);
				}
				else {
					if (!this.formulasDict[dataset]) this.formulasDict[dataset] = [];
					this.formulasDict[dataset].push(formula);
				}
			});

			// 获取组件及其字段，${}中带.为子表组件
			function getDatasetAndField(str) {
				str = str.replace(offMarkReg, '$1');
				const temp = str.split('.');
				if (temp.length == 2) return temp;
				else return [str, null];
			}
		});

		// 业务规则
		this.rulesDict = {};
		(this.dataModel.rules || []).forEach(rule => {
			if (!Array.isArray(rule.conditions)) return true;
			rule.conditions.forEach(condition => {
				if (!condition.control) return true;
				if (!this.rulesDict[condition.control]) this.rulesDict[condition.control] = [];
				this.rulesDict[condition.control].push(rule);
			});
		});
	}

	get client() { return this.dataModel.client }
	get positionType() { return this.dataModel.positionType }
	get framework() { return this.dataModel.framework }
	get pageType() { return this.dataModel.pageType }
	get mobileType() { return this.dataModel.mobileType }

	get cssFiles() { return this.dataModel.cssFiles }
	set cssFiles(value) { this.dataModel.cssFiles = value }

	get jsFiles() { return this.dataModel.jsFiles }
	set jsFiles(value) { this.dataModel.jsFiles = value }

	get styleSheets() { return this.dataModel.styleSheets }
	set styleSheets(value) { this.dataModel.styleSheets = value }

	get title() { return this.dataModel.title }
	set title(value) {
		this.dataModel.title = value;
		$("title").text(value);
		if (this._tfp.isDesigning) {
			if (this.client == "phone" || this.client == "mini") {
				// window.parent.$("#divPhonePageTitle").html(value);
				window.parent.$("#uiDesignerPageTitle").html(value);
			} else if (this.pageType == "dialog") {
				window.parent.$("#uiDesignerPageTitle").html("&nbsp;&nbsp;" + value);
			}
		}
	}

	/**
	 * 背景颜色模式
	 */
	get bgColorMode() { return this.dataModel.bgColorMode }
	set bgColorMode(value) { this.dataModel.bgColorMode = value }

	/**
	 * 页面语言
	 */
	get lang() { return this.dataModel.lang }
	set lang(value) { this.dataModel.lang = value }

	/**
	 * 文档规范
	 */
	get docType() { return this.dataModel.docType }
	set docType(value) { this.dataModel.docType = value }

	/**
	 * 内容颜色模式，与背景相反
	 */
	get contentColorMode() { return this.dataModel.bgColorMode == "dark" ? "light" : "dark" }
	set contentColorMode(value) { }

	get width() { return this.dataModel.pageType == "dialog" ? this.dataModel.width : null }
	set width(value) {
		if (!value || this.dataModel.pageType != "dialog") return;
		this.dataModel.width = value;
		let _width = value + "";
		if (_width.indexOf("px") < 0 && _width.indexOf("%") < 0) {
			_width += "px";
		}
		//设置设计和运行时宽度
		if (this._tfp.isDesigning) {
			if (this.pageType == "dialog") {
				window.parent.$("#uiDesignerFrame").css("width", _width);
				window.parent.$("#uiDesignerFrame").find("iframe").css("width", _width);
			}
		} else if (this._tfp.isRuntime) {
			//
		}
	}

	get height() { return this.dataModel.pageType == "dialog" ? this.dataModel.height : null }
	set height(value) {
		if (!value || this.dataModel.pageType != "dialog") return;
		this.dataModel.height = value;
		let _height = value + "";
		if (_height.indexOf("px") < 0 && _height.indexOf("%") < 0) {
			_height += "px";
		}
		//TODO 设置设计和运行时宽度
		if (this._tfp.isDesigning) {
			if (this.pageType == "dialog") {
				window.parent.$("#uiDesignerFrame").css("height", _height);
				window.parent.$("#uiDesignerFrame").find("iframe").css("height", (parseInt(_height.replace("px", "")) - 40) + "px");
			}
		} else if (this._tfp.isRuntime) {
			//
		}
	}

	get metas() { return this.dataModel.metas ? this.dataModel.metas : [] }
	set metas(value) {
		if (this._jqObj && value && Array.isArray(value)) {
			this.dataModel.metas = value;
		}
	}

	getContainerEl() {
		if(this.dataModel.pageType=="print-report") {
			return $(".print-page-bg-panel");
		} else if(this.dataModel.pageElId) {
			return $("#"+this.dataModel.pageElId);
		}
		else  {
			return $("body");
		}
	}

	render() {
		super.render();

		if (this._tfp.isDesigning) {
			if (this.dataModel.style) {
				$("body").attr("style", this.dataModel.style);
			}
			if (this.dataModel.styles) {
				let styles = "";
				for (let styleName in this.dataModel.styles) {
					let styleVal = this._tfp.replaceStyleUrl(this.dataModel.styles[styleName]);
					$("body").css(styleName, styleVal);
				}
			}
			if (this.dataModel.class) {
				$("body").attr("class", this.dataModel.class);
			}

			if (this.dataModel.styleSheets) {
				let styleCode = "";
				for (var i = 0; i < this.dataModel.styleSheets.length; i++) {
					let styleSheet = this.dataModel.styleSheets[i];
					styleCode += "\t" + styleSheet.id + " {";
					for (var j = 0; j < styleSheet.styles.length; j++) {
						let style = styleSheet.styles[j];
						styleCode += style.name + ": " + style.value + ";";
					}
					styleCode += "}\r\n";
				}
				$("head").append("<style id=\"_tfpPageStyleSetting\">\r\n" + styleCode + "</style>");
			}

			//设计时在tfp.loadPage()方法里加载页面的css文件了，在这里就不要重复加载了
			if (this.dataModel.cssFiles && !this._tfp.isDesigning) {
				for (var i = 0; i < this.dataModel.cssFiles.length; i++) {
					let cssFile = this.dataModel.cssFiles[i];
					$("head").append("<link rel=\"stylesheet\" type=\"text/css\" href=\"" + cssFile + "\">");
				}
			}
		}
	}

	initRuntime() {
		//如果设置了抽屉页有关的事件
		if(this.dataModel.onClickDrawerOKButton || this.dataModel.onClickDrawerCancelButton) {
			let isDrawer = tfp.getUrlArg("_isDrawer");
			if(isDrawer) {
				try {
					let curDrawer = top.curDrawer;
					if(curDrawer) {
						const that = this;
						if(this.dataModel.onClickDrawerOKButton) {
							curDrawer.find(".divDrawerButtonOK").click(function () {
								eval(that.dataModel.onClickDrawerOKButton);
							});
						}
						if(this.dataModel.onClickDrawerCancelButton) {
							curDrawer.find(".divDrawerButtonCancel").click(function () {
								eval(that.dataModel.onClickDrawerCancelButton);
							});
						}
					}
				} catch(err) {
					console.log(err);
				}
			}
		}
		//设置系统主题色
		let sysThemeColor = "#6666FF";
		if(localStorage.getItem("TaskAdminMainThemeColor")) {
			sysThemeColor = localStorage.getItem("TaskAdminMainThemeColor");
		} else {
			try {
				if(top.local.theme.color.theme_color) sysThemeColor = top.local.theme.color.theme_color;
			} catch(err) {
				//
			}
		}
		$("#tfp-page-style-var").html(`
			:root {
				--sys-theme-color: ${sysThemeColor};
			}
		`);
		//如果设置了页面加载后事件
		if (this.dataModel["onLoad"]) {
			eval(this.dataModel["onLoad"]);
		}
	}
}