import TFPComponentRender from "../render.js";

export default class OrgPickerRender extends TFPComponentRender {

  constructor(__tfp, _dataModel, _level) {
    super(__tfp, _dataModel, _level);
  }

  getBodyHtml = function (getComponentsHtml) {
    let html = "\r\n";
    let indent = this.getHtmlIndent();
    let val = "";
    let pla = "";
    let iptWidth = "100%";
    if (this.dataModel.value) val = this.dataModel.value;
    if (this.dataModel.placeHolder) pla = this.dataModel.placeHolder;
    if (this.dataModel.showIcon) iptWidth = "calc(100% - 30px)";
    html += indent + "\t<textarea type=\"text\" readonly value=\"" + val + "\" placeholder=\"" + pla + "\" style=\"width:" + iptWidth + "\"/></textarea>\r\n";
    if (this.cpt.showIcon) html += indent + "\t<img src=\"" + this.cpt.iconUrl + "\" />\r\n";
    return html + indent;
  }

  getHtml(getComponentsHtml, parentIndent, retainStyleAttr) {
    return super.getHtml("div", false, parentIndent, retainStyleAttr);
  }
}