export default {
  "name": "OrgPicker",
  "comment": "组织结构选择",
  "cssFiles": "style.{bgColorMode}.pc.css",
  "attrs": [
    {
      "name": "comment",
      "comment": "组件备注",
      "type": "String"
    },
    {
      "name": "placeHolder",
      "comment": "输入提示",
      "type": "String",
      "isHtmlAttr": true
    },
    {
      "name": "showIcon",
      "comment": "显示图标",
      "type": "Switch",
      "default": true
    },
    {
      "name": "multiCheck",
      "comment": "多选",
      "type": "Switch",
      "default": true
    },
    {
      "name": "valueType",
      "comment": "值类型",
      "type": "Select",
      "options": [
        { "value": "obj", "text": "对象" }
      ],
      "default": "obj",
      "notnull": true
    },
    {
      "name": "dataBindingFormat",
      "comment": "数据绑定格式",
      "type": "String"
    },
    {
      "name": "required",
      "comment": "必填",
      "type": "Switch"
    },
    {
      "name": "readonly",
      "comment": "只读",
      "type": "Switch"
    },
    {
      "name": "disabled",
      "comment": "禁用",
      "type": "Switch"
    },
    {
      "name": "encrypted",
      "comment": "加密发送",
      "type": "Switch"
    }
  ],
  "styles": ["size", "position", "font", "background", "margin", "border", "other"],
  "defaultStyles": {
    "width": "320px",
    "height": "80px"
  },
  "events": [
    {
      "name": "onAfterInitRuntime",
      "comment": "组件初始化后",
      "isNotHtmlEvent": true
    }, {
      "name": "onChange",
      "comment": "值发生变化时",
      "isNotHtmlEvent": true
    }]
}