import { FormInput } from "../controller.js";

/**
* 组织结构组件
* @param {[type]} dataModel [description]
*/
export default class OrgPicker extends FormInput {

  constructor(__tfp, dataModel, parent) {
    super(__tfp, "OrgPicker", dataModel, parent);
  }

  get value() {
    if (this._jqObj && this._jqObj.find("textarea").val() == "") this.dataModel.value = '';
    return this.dataModel.value;
  }
  set value(value) {
    if (isNull(value)) {
      this.dataModel.trueId = undefined;
      this.dataModel.value = '';
      if (!this._tfp.isDesigning) {
        this.valueOnChange();
        this.exeEventHandler("onChange", this.dataModel.value);
      }
      return;
    }
    this.dataModel.value = value;

    if (this._jqObj) {
      let names = "";
      let userTureId = [];
      let roleTureId = [];
      let depTureId = [];

      for (var i = 0; i < this.dataModel.value.length; i++) {
        if (this.dataModel.value[i].type == 'user') userTureId.push(this.dataModel.value[i].id);
        if (this.dataModel.value[i].type == 'role') roleTureId.push(this.dataModel.value[i].id);
        if (this.dataModel.value[i].type == 'dep') depTureId.push(this.dataModel.value[i].id);
        if (names != "") names += ",";
        names += this.dataModel.value[i].name;
      }
      this.dataModel.trueId = {
        user: userTureId,
        role: roleTureId,
        dep: depTureId
      };
      this._jqObj.find("textarea").val(names);
    }
    if (!this._tfp.isDesigning) {
      this.valueOnChange();
      this.exeEventHandler("onChange", this.dataModel.value);
    }
  }

  get placeHolder() { return this.dataModel.placeHolder }
  set placeHolder(value) {
    this.dataModel.placeHolder = value;
    if (this._jqObj) this._jqObj.find("textarea").attr("placeholder", value);
  }

  get iconUrl() {
    return this._tfp.rootPath + "/src/components/"
      + this.dataModel.type.toLowerCase() + "/images/icon-24-"
      + this._tfp.curPage.contentColorMode + ".png";
  }
  set iconUrl(value) { }

  get showIcon() { return this.dataModel.showIcon }
  set showIcon(value) {
    this.dataModel.showIcon = value ? true : false;
    if (this._jqObj) {
      let iptWidth = "100%";
      if (this.dataModel.showIcon) {
        if (this._jqObj.find("img").length == 0) {
          this._jqObj.append("<img src=\"" + this.iconUrl + "\" />");
        }
        iptWidth = "calc(100% - 30px)";
      } else {
        this._jqObj.find("img").remove();
      }
      this._jqObj.find("textarea").css("width", iptWidth);
    }
  }

  get valueType() { return this.dataModel.valueType }
  set valueType(value) {
    if (!this.checkAttrOption("valueType", value)) {
      this._tfp.showMsg("不支持类型：" + value + "！");
      return;
    }
    this.dataModel.valueType = value;
  }

  get multiCheck() { return this.dataModel.multiCheck }
  set multiCheck(value) {
    this.dataModel.multiCheck = value ? true : false;
  }

  showPicker() {
    if (this.dataModel.multiCheck) {
      this._tfp.openDialog("组织结构选择", this._tfp.rootPath + "/src/components/orgpicker/orgsPicker.tfp?cptId=" + this.id + "&trueId=" + JSON.stringify((this.dataModel.trueId)), "445px", "540px");
    } else {
      this._tfp.openDialog("组织结构选择", this._tfp.rootPath + "/src/components/orgpicker/orgPicker.tfp?cptId=" + this.id + "&trueId=" + JSON.stringify((this.dataModel.trueId)), "445px", "540px");
    }
  }

  onSelected(ret) {
    this.value = ret;
  }

  initRuntime() {
    let that = this;
    this._jqObj.click(function () {
      if (that.readonly || that.disabled) return;
      that.showPicker();
    });
  }
}