import { FormInput } from "../controller.js";

/**
 * 组织结构组件
 * @param {[type]} dataModel [description]
 */
export default class Org extends FormInput {

  constructor(__tfp, inputType, dataModel, parent) {
    super(__tfp, inputType, dataModel, parent);
  }

  get value() {
    if (this._jqObj && this._jqObj.find("input").val() == "") {
      this.dataModel.value = '';
    }
    return this.dataModel.value;
  }
  set value(value) {
    let vs;
    if (this._tfp.isNull(value)) {
      value = null;
      this.dataModel.value = value;
    }
    else {
      if (/^[1-9]\d*$/.test(value)) {
        this.getObjectValue(value);
        return;
      }
      try {
        if (typeof (value) == "string") {
          value = JSON.parse(value);
        }
      } catch (e) {
        if (value != '') {
          if (this.dataModel.multiCheck) {
            vs = value.split('#');
          }
          else {
            vs = value.split(',');
          }
        }
      }

      if (this.dataModel.valueType == "obj") {
        if (typeof (value) == "string") {
          this.dataModel.value = [];
          if (this.dataModel.multiCheck) {
            let ids;
            let names;
            ids = vs[0].split(',');
            if (vs.length > 1) names = vs[0].split(',');
            else names = vs[1].split(',');
            for (let i = 0; i < ids.length; i++) {
              this.dataModel.value.push({ "id": ids[i], "name": names[i] });
            }
          }
          else {
            if (vs.length > 1) this.dataModel.value = { "id": vs[0], "name": vs[1] };
            else this.dataModel.value = { "id": vs[0], "name": vs[0] };
          }
        }
        else {
          this.dataModel.value = value;
        }
      }
      else if (this.dataModel.valueType == "str") {
        if (typeof (value) == "string") {
          this.dataModel.value = value;
        }
        else {
          if (this.dataModel.multiCheck) {
            let ids = "";
            let names = "";
            for (var i = 0; i < value.length; i++) {
              if (ids != "") ids += ",";
              if (names != "") names += ",";
              ids += value[i].id;
              names += value[i].name;
            }
            this.dataModel.value = ids + "#" + names;
          }
          else {
            this.dataModel.value = value.id + "," + value.name;
          }
        }
      }
      else {
        if (this.dataModel.multiCheck) {
          if (typeof (value) == "string") {
            this.dataModel.value = vs[0];
          }
          else {
            let val = "";
            for (var i = 0; i < value.length; i++) {
              if (val != "") val += ",";
              val += value[i][this.dataModel.valueType];
            }
            this.dataModel.value = val;
          }
        }
        else {
          if (typeof (value) == "string") {
            this.dataModel.value = vs[0];
          }
          else {
            this.dataModel.value = value[this.dataModel.valueType];
          }
        }
      }
    }

    if (this._jqObj) {
      if (this._tfp.isNull(this.dataModel.value)) {
        this._jqObj.find("input").val("");
        this.dataModel.trueId = undefined;
      } else {
        if (this.dataModel.multiCheck) {
          let names = "";
          let ids = "";
          if (typeof (value) == "string") {
            if (vs.length > 1) names = vs[1];
            else names = vs[0];
            ids = vs[0];
          }
          else {
            for (var i = 0; i < value.length; i++) {
              if (names != "") names += ",";
              names += value[i].name;

              if (ids != "") ids += ",";
              ids += value[i].id;
            }
          }
          this._jqObj.find("input").val(names);

          this.dataModel.trueId = ids;
        }
        else {
          if (typeof (value) == "string") {
            if (vs.length > 1) this._jqObj.find("input").val(vs[1]);
            else this._jqObj.find("input").val(vs[0]);

            this.dataModel.trueId = vs[0];
          }
          else {
            this._jqObj.find("input").val(value.name);

            this.dataModel.trueId = value.id;
          }
        }
      }
    }

    if (!this._tfp.isDesigning) {
      this.valueOnChange();
      if (this.dataModel["onChange"]) eval(this.dataModel["onChange"]);
      //如果onChange事件是字符串形式的函数调用语句，且传了参数值
      //例如可编辑表格里选择部门或人员后，则下面的事件调用会有问题，无法传入当前行和列索引
      //this.exeEventHandler("onChange", this.dataModel.value);
    }
  }

  get placeHolder() { return this.dataModel.placeHolder }
  set placeHolder(value) {
    this.dataModel.placeHolder = value;
    if (this._jqObj) this._jqObj.find("input").attr("placeholder", value);
  }

  get iconUrl() {
    return this._tfp.rootPath + "/src/components/"
      + this.dataModel.type.toLowerCase() + "/images/icon-24-"
      + this._tfp.curPage.contentColorMode + ".png";
  }
  set iconUrl(value) { }

  //数据绑定格式
  get dataBindingFormat() { return this.dataModel.dataBindingFormat }
  set dataBindingFormat(value) { this.dataModel.dataBindingFormat = value }

  get showIcon() { return this.dataModel.showIcon }
  set showIcon(value) {
    this.dataModel.showIcon = value ? true : false;
    if (this._jqObj) {
      if (this.dataModel.showIcon) {
        if (this._jqObj.find("img").length == 0) {
          this._jqObj.append("<img src=\"" + this.iconUrl + "\" />");
        }
      } else {
        this._jqObj.find("img").remove();
      }
      let iptWidth = "100%";
      if (this.dataModel.showIcon) iptWidth = "calc(100% - 30px)";
      this._jqObj.find("input").css("width", iptWidth + "px");
    }
  }

  get valueType() { return this.dataModel.valueType ? this.dataModel.valueType : "id" }
  set valueType(value) {
    if (!this.checkAttrOption("valueType", value)) {
      this._tfp.showMsg("不支持类型：" + value + "！");
      return;
    }
    this.dataModel.valueType = value;
  }

  get multiCheck() { return this.dataModel.multiCheck }
  set multiCheck(value) {
    this.dataModel.multiCheck = value ? true : false;
  }

  showPicker() {
    if (this.dataModel.type == "Dep") {
      if (this.dataModel.multiCheck) {
        this._tfp.openDialog("选择部门", this._tfp.rootPath + "/src/components/org/tfp/depsPicker.tfp?valueType=obj&cptId=" + this.id + "&trueId=" + this.dataModel.trueId, "480px", "480px");
      } else {
        this._tfp.openDialog("选择部门", this._tfp.rootPath + "/src/components/org/tfp/depPicker.tfp?valueType=obj&cptId=" + this.id + "&trueId=" + this.dataModel.trueId, "480px", "480px");
      }
    } else if (this.dataModel.type == "User") {
      if (this.dataModel.multiCheck) {
        this._tfp.openDialog("选择用户", this._tfp.rootPath + "/src/components/org/tfp/usersPicker.tfp?valueType=obj&cptId=" + this.id + "&trueId=" + this.dataModel.trueId, "480px", "480px");
      } else {
        this._tfp.openDialog("选择用户", this._tfp.rootPath + "/src/components/org/tfp/userPicker.tfp?valueType=obj&cptId=" + this.id + "&trueId=" + this.dataModel.trueId, "480px", "480px");
      }
    } else if (this.dataModel.type == "Role") {
      if (this.dataModel.multiCheck) {
        this._tfp.openDialog("选择群组", this._tfp.rootPath + "/src/components/org/tfp/rolesPicker.tfp?valueType=obj&cptId=" + this.id + "&trueId=" + this.dataModel.trueId, "480px", "480px");
      } else {
        this._tfp.openDialog("选择群组", this._tfp.rootPath + "/src/components/org/tfp/rolePicker.tfp?valueType=obj&cptId=" + this.id + "&trueId=" + this.dataModel.trueId, "480px", "480px");
      }
    }
  }

  onSelected(ret) {
    this.value = ret;
    this._jqObj.find("input").focus();
  }

  getObjectValue(val) {
    let that = this;
    this._tfp.use("Service", function () {
      var service = that._tfp["new"]("Service");

      if (that.dataModel.type == 'User') service.path = "sys/service/user/getSimple.tbs";
      if (that.dataModel.type == 'Dep') service.path = "sys/service/dep/getSimple.tbs";
      if (that.dataModel.type == 'Role') service.path = "sys/service/role/getSimple.tbs";
      service.request({
        id: val
      }, function (req, res) {
        if (!res.data) return;
        if (that.dataModel.multiCheck) that.value = [res.data];
        else that.value = res.data;
      });
    });
  }

  initRuntime() {
    let that = this;

    if (this.readonly) {
      this._jqObj.find("input").css({ "margin-left": "0px", "padding-left": "0px" });
    }

    this._jqObj.click(function () {
      if (that.readonly || that.disabled) return;
      that.showPicker();
    });

    this._jqObj.hover(function () {
      if(that.disabled || that.readonly) return;
      if(that._tfp.curPage.bgColorMode=="light") {
        that._jqObj.css("background-color", "#F6F6F6");
        that._jqObj.find("input").css("background-color", "#F6F6F6");
      }
    }, function () {
      if(that.disabled || that.readonly) return;
      if(that._tfp.curPage.bgColorMode=="light" && !that._jqObj.find("input").is(":focus")) {
        that._jqObj.css("background-color", "");
        that._jqObj.find("input").css("background-color", "");
      }
    });

    this._jqObj.find("input").focus(function () {
      if (that.disabled) return;
      if(that._tfp.curPage.bgColorMode=="light") 
        that._jqObj.css("outline", "1px solid var(--sys-theme-color)");
      try {
        if (that.dataModel.onFocus) eval(that.dataModel.onFocus);
      } catch (err) {
        console.log(err.message);
      }
    });

    this._jqObj.find("input").blur(function () {
      if (that.disabled) return;
      if(that._tfp.curPage.bgColorMode=="light") {
        that._jqObj.css("outline", "0");
        that._jqObj.css("background-color", "");
        that._jqObj.find("input").css("background-color", "");
      }
      try {
        if (that.dataModel.onBlur) eval(that.dataModel.onBlur);
      } catch (err) {
        console.log(err.message);
      }
    });

    //因为调用了top对象，为了避免在嵌入到第三方系统里时出现跨域错误，需要在此用try catch捕获一下错误
    try {
      if (this.dataModel.type == "User" && this.dataModel.defaultCurUser && top.curUser) {
        if (this.dataModel.valueType == "id") {
          this.dataModel.value = top.curUser.id;
        } else if (this.dataModel.valueType == "name") {
          this.dataModel.value = top.curUser.name;
        } else if (this.dataModel.valueType == "code") {
          this.dataModel.value = top.curUser.code;
        } else if (this.dataModel.valueType == "obj") {
          this.dataModel.value = {
            id: top.curUser.id,
            name: top.curUser.name,
            code: top.curUser.code
          };
        }
        if (this._jqObj) this._jqObj.find("input").val(top.curUser.name);
      }
    } catch (err) { }
  }
}