import TFPComponentRender from '../render.js'

export default class OneAppModule extends TFPComponentRender {

  constructor(__tfp, _dataModel, _level) {
    super(__tfp, _dataModel, _level);
  }

  getBodyHtml(getComponentsHtml, retainStyleAttr) {
    let html = "";
    let indent = this.getHtmlIndent();
    html += indent;
    html += `<div style="display:flex;align-items:center;width:100%;justify-content:space-evenly;flex-direction:column;height:100%;">`;
    if (this.dataModel.options) {
      let type = this.dataModel.options.srcJson.type;
      if (type == 'iconfont') {
        html += `<div class="` + this.dataModel.options.srcJson.class + `" style="font-size: ` + this.dataModel.imageWidth + `px;`
        if (this.dataModel.options.srcJson.color) {
          html += `color:` + this.dataModel.options.srcJson.color + ';';
        }
        if (this.dataModel.options.srcJson.bgColor) {
          html += `background-color:` + this.dataModel.options.srcJson.bgColor + ';';
        }
        html += `"></div>`;
      } else if (type == 'httpurl') {
        html += `<img class="wx-image" src="` + this.dataModel.options.srcJson.url + `"
          style="width: `+ this.dataModel.imageWidth + `px;height: ` + this.dataModel.imageHeight + `px;">`;
      } else if (type == 'url') {
        html += `<img class="wx-image" src="` + this._tfp.getUrlRealPath(this.dataModel.options.srcJson.url) + `"
          style="width: `+ this.dataModel.imageWidth + `px;height: ` + this.dataModel.imageHeight + `px;">`;
      }
      if(this.dataModel.options.appname){
        html += ` <lable class="wx-label OneAppModuleName" style="line-height: 30px;height: 30px;">
        `+ this.dataModel.options.appname + `
        </lable>`;
      }
      html += `</div>`;
    } else {
      this.dataModel.options = {
        "srcJson": {
          "type": "httpurl",
          "url": "http://www.taskbuilder.org/app/bbs/img/headimg.png"
        },
        "appname": "应用名称",
        "appsrc": "http://www.taskbuilder.org/app/bbs/img/headimg.png",
      };
      this.dataModel.imageWidth = 48;
      this.dataModel.imageHeight = 48;
      html += `<img class="wx-image" src="` + this.dataModel.options.srcJson.url + `"
      style="width: `+ this.dataModel.imageWidth + `px;height: ` + this.dataModel.imageHeight + `px;">`;
      html += ` <lable class="wx-label OneAppModuleName" style="line-height: 30px;height: 30px;">
      `+ this.dataModel.options.appname + `
      </lable></div>`;
    }
    return html + indent;
  }

  getBodyWX(getComponentsHtml, retainStyleAttr, otherOptions) {
    var cpt_wx = {
      "wxjson": "",
      "wxjs": "",
      "wxml": "",
      "wxss": ""
    }
    let bodyHtml = "\r\n";
    let indent = this.getHtmlIndent();
    bodyHtml += indent + "";
    bodyHtml += `\t<view class="wx-oneappmodule-outbox" bindtap="bindclick_toNewPage" data-url="` + this.dataModel.options.appjumpUrl + `" data-type="navigateTo">\n`;
    let type = this.dataModel.options.srcJson.type;
    if (type == 'iconfont') {
      bodyHtml += `<view class="` + this.dataModel.options.srcJson.class + `" style="font-size: ` + this.dataModel.imageWidth * 2 + `rpx;`
      if (this.dataModel.options.srcJson.color) {
        bodyHtml += `color:` + this.dataModel.options.srcJson.color + ';';
      }
      if (this.dataModel.options.srcJson.bgColor) {
        bodyHtml += `background-color:` + this.dataModel.options.srcJson.bgColor + ';';
      }
      bodyHtml += `"></view>`;
    } else if (type == 'httpurl') {
      bodyHtml += `<image class="wx-image" src="` + this.dataModel.options.srcJson.url + `"
        style="width: `+ this.dataModel.imageWidth * 2 + `rpx;height: ` + this.dataModel.imageHeight * 2 + `rpx;"/>`;
    } else if (type == 'url') {
      bodyHtml += `<image class="wx-image" wx-if="{{apiUrl}}" src="{{apiUrl}}` + this._tfp.getUrlRealPath(this.dataModel.options.srcJson.url) + `"
        style="width: `+ this.dataModel.imageWidth * 2 + `rpx;height: ` + this.dataModel.imageHeight * 2 + `rpx;"/>`;
    }
    if(this.dataModel.options.appname){
      bodyHtml += `\t\t\t<text class="wx-label" style="line-height: 60rpx;height: 60rpx;">` + this.dataModel.options.appname + `</text>\n`;
    }
    bodyHtml += `\t\t</view>\n`;
    cpt_wx.wxml = bodyHtml + indent;
    return cpt_wx;
  }

  getHtml(getComponentsHtml, parentIndent, retainStyleAttr) {
    return super.getHtml("div", false, parentIndent, retainStyleAttr);
  }

  getWX(getComponentsHtml, parentIndent, retainStyleAttr, otherOptions) {
    return super.getWX("view", false, parentIndent, retainStyleAttr, otherOptions);
  }
}