import { VisibleComponent } from "../controller.js";
import TaskFrontPage from '../../tfp.js'

/**
 * 单应用模块
 * @param {[type]} dataModel [description]
 */
export default class OneAppModule extends VisibleComponent {

  constructor(__tfp, dataModel, parent) {
    super(__tfp, "OneAppModule", dataModel, parent);
  }

  // 图片宽度
  get imageWidth() { return this.dataModel.imageWidth }
  set imageWidth(value) {
    this.dataModel.imageWidth = value;
    if (this._jqObj) {
      this._jqObj.find("img").css("width", value + 'px');
    }
  }

  // 图片高度
  get imageHeight() { return this.dataModel.imageHeight }
  set imageHeight(value) {
    this.dataModel.imageHeight = value;
    if (this._jqObj) {
      this._jqObj.find("img").css("height", value + 'px');
    }
  }

  // 选项
  get options() {
    return this.dataModel.options;
  }
  set options(value) {
    if (!value) return;
    this.dataModel.options = value;
    let options = [];
    if (typeof (value) == "string") {
      let arr = value.split(",");
      for (var i = 0; i < arr.length; i++) {
        let str = arr[i];
        if (str.trim() != "") {
          options.push({
            value: str,
            text: str
          });
        }
      }
    } else if (Array.isArray(value)) {
      for (var i = 0; i < value.length; i++) {
        let val = value[i];
        if (Object.prototype.toString.call(val) === '[object Object]') {
          options.push(val);
        } else {
          options.push({
            value: val,
            text: val
          });
        }
      }
    }
    this.dataModel.options = options[0];
    if (this._jqObj) {
      this._jqObj.empty();
      if(value.length>0){
        this.addOption(value[0]);
      }
    }
  }

  addOption(option) {
    let indent = this.getHtmlIndent();
    let str = "";
    str += this.getOptionHtml(indent, option);
    if (str != "") {
      this._jqObj.append(str);
    }
  }

  getOptionHtml(indent, option) {
    let optionHtml = "";
    optionHtml += indent;
    optionHtml += `<div style="display:flex;align-items:center;width:100%;justify-content:space-evenly;flex-direction:column;height:100%;">`;
    let type = option.srcJson.type;
    if (type == 'iconfont') {
      optionHtml += `<div class="` + option.srcJson.class + `" style="font-size: ` + this.dataModel.imageWidth + `px;`
      if (option.srcJson.color) {
        optionHtml += `color:` + option.srcJson.color + ';';
      }
      if (option.srcJson.bgColor) {
        optionHtml += `background-color:` + option.srcJson.bgColor + ';';
      }
      optionHtml += `"></div>`;
    } else if (type == 'httpurl') {
      optionHtml += `<img class="wx-image" src="` + option.srcJson.url + `"
        style="width: `+ this.dataModel.imageWidth + `px;height: ` + this.dataModel.imageHeight + `px;">`;
    } else if (type == 'url') {
      optionHtml += `<img class="wx-image" src="` + this._tfp.getUrlRealPath(option.srcJson.url) + `"
        style="width: `+ this.dataModel.imageWidth + `px;height: ` + this.dataModel.imageHeight + `px;">`;
    }
    if(option.appname){
      optionHtml += ` <lable class="wx-label OneAppModuleName" style="line-height: 30px;height: 30px;">
      `+ option.appname + `
      </lable>`;
    }
    optionHtml += `</div>`;
    return optionHtml;
  }

  initRuntime() {
    let that = this;
  }
}