import TFPComponentRender from '../render.js'

export default class MarqueeRender extends TFPComponentRender {

  constructor(__tfp, _dataModel, _level) {
    super(__tfp, _dataModel, _level);
  }

  getBodyHtml(getComponentsHtml) {
    if (this.dataModel.value) return this.dataModel.value;
    return "";
  }

  getAttrHtml(retainStyleAttr) {
    var attrHtml = "";
    if (this.dataModel.direction) attrHtml += " direction=\"" + this.dataModel.direction + "\"";
    if (this.dataModel.behavior) attrHtml += " behavior=\"" + this.dataModel.behavior + "\"";
    if (this.dataModel.scrollamount) attrHtml += " scrollamount=\"" + this.dataModel.scrollamount + "\"";
    if (this.dataModel.scrolldelay) attrHtml += " scrolldelay=\"" + this.dataModel.scrolldelay + "\"";
    if (this.dataModel.loop) attrHtml += " loop=\"" + this.dataModel.loop + "\"";
    if (this.dataModel.bgcolor) attrHtml += " bgcolor=\"" + this.dataModel.bgcolor + "\"";
    if (this.dataModel.onMouse) attrHtml += " onmouseover=\"this.stop()\" onmouseout=\"this.start()\"";
    if (this.dataModel.onClick) attrHtml += " onclick=\"" + this.dataModel.onClick + "\"";
    if (this.dataModel.onMouseOver) attrHtml += " onmouseover=\"" + this.dataModel.onMouseOver + "\"";
    if (this.dataModel.onMouseOut) attrHtml += " onmouseout=\"" + this.dataModel.onMouseOut + "\"";
    return attrHtml;
  }

  getHtml(getComponentsHtml, parentIndent, retainStyleAttr) {
    return super.getHtml("marquee", false, parentIndent, retainStyleAttr);
  }
}