import { VisibleComponent } from "../controller.js";

/**
 * 跑马灯组件
 * @param {[type]} dataModel [description]
 */
export default class Marquee extends VisibleComponent {

  constructor(__tfp, dataModel, parent) {
    super(__tfp, "Marquee", dataModel, parent);
  }

  //标签值
  get value() {
    if (!this.dataModel.value) return "";
    return this.dataModel.value;
  }
  set value(value) {
    this.dataModel.value = value;
    if (this._jqObj) {
      this._jqObj.text(value);
      this.exeEventHandler("onChange");
    }
  }

  //滚动方向
  get direction() { return this.dataModel.direction; }
  set direction(value) {
    this.dataModel.direction = value;
    if (this._jqObj) {
      this._jqObj.attr("direction", this.dataModel.direction);
    }
  }

  //滚动方式
  get behavior() { return this.dataModel.behavior; }
  set behavior(value) {
    this.dataModel.behavior = value;
    if (this._jqObj) {
      this._jqObj.attr("behavior", this.dataModel.behavior);
    }
  }

  //滚动速度
  get scrollamount() { return this.dataModel.scrollamount; }
  set scrollamount(value) {
    this.dataModel.scrollamount = value;
    if (this._jqObj) {
      this._jqObj.attr("scrollamount", this.dataModel.scrollamount);
    }
  }

  //滚动延迟
  get scrolldelay() { return this.dataModel.scrolldelay; }
  set scrolldelay(value) {
    this.dataModel.scrolldelay = value;
    if (this._jqObj) {
      this._jqObj.attr("scrolldelay", this.dataModel.scrolldelay);
    }
  }

  //循环次数
  get loop() { return this.dataModel.loop; }
  set loop(value) {
    this.dataModel.loop = value;
    if (this._jqObj) {
      this._jqObj.attr("loop", this.dataModel.loop);
    }
  }

  //滚动背景颜色
  get bgcolor() { return this.dataModel.bgcolor; }
  set bgcolor(value) {
    this.dataModel.bgcolor = value;
    if (this._jqObj) {
      this._jqObj.attr("bgcolor", this.dataModel.bgcolor);
    }
  }

  // 鼠标事件
  get onMouse() { return this.dataModel.onMouse }
  set onMouse(value) {
    this.dataModel.onMouse = value ? true : false;
    if (this._jqObj) {
      if (this.dataModel.onMouse) {
        this._jqObj.mouseover(function () {
          this.stop();
        }).mouseout(function () {
          this.start();
        });
      } else {
        this._jqObj.unbind('mouseover').unbind('mouseout');
      }
    }

  }

  //数据绑定格式
  get dataBindingFormat() { return this.dataModel.dataBindingFormat }
  set dataBindingFormat(value) { this.dataModel.dataBindingFormat = value }
}