import { FormInput } from "../controller.js";

/**
 * 弹出列表组件
 * @param {[type]} dataModel [description]
 */
export default class List extends FormInput {

  constructor(__tfp, dataModel, parent) {
    super(__tfp, "List", dataModel, parent);
  }

  get value() {
    if (!this.dataModel.value) return "";
    return this.dataModel.value;
  }
  set value(value) {
    let val = value;
    if (isNull(value)) {
      val = "";
      this.dataModel.value = null;
    } else {
      this.dataModel.value = val;
    }
    if (this._jqObj) {
      this.reRender();
    }
    if (!this._tfp.isDesigning) {
      this.valueOnChange();
      this.exeEventHandler("onChange", val);
    }
  }

  get text() {
    if (!this.dataModel.value) return "";
    let item = this.dataModel.options.find(v => v.value == this.dataModel.value);
    if (!item) return "";
    return item.text;
  }
  set text(txt) {
  }

  get options() { return this.dataModel.options }
  set options(options) {
    if (this._jqObj && options && Array.isArray(options)) {
      this.dataModel.options = options;
      if (this._jqObj) {
        this.reRender();
      }
    }
  }

  get orderType() { return this.dataModel.orderType }
  set orderType(value) {
    this.dataModel.orderType = value;
    if (this._jqObj) {
      this.reRender();
    }
  }

  get icon() { return this.dataModel.icon }
  set icon(value) {
    this.dataModel.icon = value;
    if (this._jqObj) {
      this.reRender();
    }
  }

  get color() { return this.dataModel.color }
  set color(value) {
    this.dataModel.color = value;
    if (this._jqObj) {
      this.reRender();
    }
  }

  get bgColor() { return this.dataModel.bgColor }
  set bgColor(value) {
    this.dataModel.bgColor = value;
    if (this._jqObj) {
      this.reRender();
    }
  }
  get loadDataListService() { return this.dataModel.loadDataListService }
  set loadDataListService(value) {
    this.dataModel.loadDataListService = value;
  }

  get dataListBindingMember() { return this.dataModel.dataListBindingMember }
  set dataListBindingMember(value) {
    this.dataModel.dataListBindingMember = value;
  }

  get dataListValueFormat() { return this.dataModel.dataListValueFormat }
  set dataListValueFormat(value) {
    this.dataModel.dataListValueFormat = value;
  }

  get dataListTextFormat() { return this.dataModel.dataListTextFormat }
  set dataListTextFormat(value) {
    this.dataModel.dataListTextFormat = value;
  }

  get showVerticalBar() { return this.dataModel.showVerticalBar }
  set showVerticalBar(value) {
    this.dataModel.showVerticalBar = value ? true : false;
    if (this._jqObj) {
      this.reRender();
    }
  }

  get multiCheck() { return this.dataModel.multiCheck }
  set multiCheck(value) {
    this.dataModel.multiCheck = value ? true : false;
    if (this._jqObj) {
      this.reRender();
    }
  }

  getOption(index) {
    return this.dataModel.options[index];
  }

  getOptionByValue(val) {
    return this.dataModel.options.find(v => v.value == val);
  }

  reRender() {
    this._jqObj.empty();
    this._jqObj.append(this.getBodyHtml());
    if (!this._tfp.isDesigning) this.bindItemEvent();
  }

  getBodyHtml(getComponentsHtml) {
    let indent = this.getHtmlIndent();
    let html = "\r\n";
    let bgColor = '';
    let color = '#666';
    if (this.dataModel.bgColor) bgColor = "background-color:" + this.dataModel.bgColor + ";";
    if (this.dataModel.color) color = this.dataModel.color;
    if (this.dataModel.options) {
      for (var i = 0; i < this.dataModel.options.length; i++) {
        let option = this.dataModel.options[i];
        html += indent + "\t<div data-value=\"" + option.value + "\"";
        if ((option.value + "") == (this.dataModel.value + "")) {
          if (this.dataModel.showVerticalBar && !this.dataModel.color) html += " class=\"tfp-list-border\"";
          html += " style=\"" + bgColor + "";
          if (this.dataModel.showVerticalBar && this.dataModel.color) html += " border-left: 3.5px solid " + color + ";";
          html += "\"";
        }
        // if (!this._tfp.isDesigning && option.onClick) html += " onclick=\"" + option.onClick + "\"";
        let dot = "";
        if (this.dataModel.orderType == "order") {
          dot = "<label";
          if (this.dataModel.color) dot += " style=\"color:" + color + ";\"";
          dot += " class=\"tfp-list-color\"";
          dot += "> " + (i + 1) + ".</label> ";
        }
        if (this.dataModel.icon) {
          let imgUrl = '';
          if (this.dataModel.icon[0] == '/') {
            imgUrl = this._tfp.rootPath + "" + this.dataModel.icon + "";
          } else {
            imgUrl = this.dataModel.icon;
          }
          dot = "<img width=\"16\" height=\"16\" align=\"absmiddle\" src=\"" + imgUrl + "\" />";
        }
        if (option.icon) {
          let iconSize = 20;
          if (option.iconSize) iconSize = option.iconSize;
          iconSize = this._tfp.getPx(iconSize);
          let iconRadius = 4;
          if (option.iconRadius || (option.iconRadius + "") == "0") iconRadius = option.iconRadius;
          iconRadius = this._tfp.getPx(iconRadius);
          if (option.icon.type == "url") {
            dot = "<img src=\"" + option.icon.url + "\" style=\"width:" + iconSize + "px; height:" + iconSize
              + "px; border-radius: " + iconRadius + "px;\">";
          } else {
            dot = "<span class=\"" + option.icon.class + "\" style=\"margin-right:3px;border-radius: " + iconRadius + "px; "
              + "font-size:" + iconSize + "px;height:" + iconSize + "px;line-height:" + iconSize + "px;"
              + "background-color:" + option.icon.bgColor + ";color:" + option.icon.color + ";\"></span>";
          }
        }
        html += ">";
        if (option.href) {
          html += "<a ";
          if (!this._tfp.isDesigning) {
            if (option.target == "self") {
              html += " href=\"" + option.href + "\"";
            } else {
              html += " href=\"javascript:void(0)\" onclick=\"";
              let title = "Tasgine - 任擎";
              if (option.targetTitle) title = option.targetTitle;
              if (option.target == "page") {
                html += "tfp.openPage('" + title + "', '" + option.href + "')";
              } else if (option.target == "dialog") {
                let width = option.dialogWidth;
                if (!width) width = "480px";
                if ((width + "").indexOf("px") < 0) width += "px";
                let height = option.dialogHeight;
                if (!height) height = "480px";
                if ((height + "").indexOf("px") < 0) height += "px";
                html += "tfp.openDialog('" + title + "', '" + option.href + "'"
                  + ", '" + width + "', '" + height + "')";
              } else if (option.target == "window") {
                html += "window.open('" + option.href + "', '" + title + "')";
              }
              html += "\"";
            }
          }
          html += ">";
        }
        if (this.dataModel.multiCheck) {
          html += "" + dot + "<input type=\"checkbox\"><label"
          if ((option.value + "") == (this.dataModel.value + ""))
            if (this.dataModel.color) html += " style=\"color:" + color + ";\"";
            else html += " class=\"tfp-list-color\"";
          html += ">" + (option.text ? option.text : option.value) + "</label > ";
        } else {
          html += "" + dot + " <label "
          if ((option.value + "") == (this.dataModel.value + ""))
            if (this.dataModel.color) html += " style=\"color:" + color + ";\"";
            else html += " class=\"tfp-list-color\"";
          html += ">" + (option.text ? option.text : option.value) + "</label>";
        }
        if (option.href) {
          html += "</a>";
        }
        html += "</div>\r\n";
      }
    }
    return html + "\t";
  }

  setSelectOptionColor(el) {
    if (!this.dataModel.multiCheck) {
      let color = "#666";
      if (this.dataModel.color) color = this.dataModel.color;
      if (this._tfp.curPage.bgColorMode == "dark") {
        this._jqObj.find("label").css("color", "#FFFFFF");
        this._jqObj.find("label").attr("class", "");
      } else {
        this._jqObj.find("label").css("color", "#333333");
        this._jqObj.find("label").attr("class", "");
      }
      if (this.dataModel.bgColor) $(el).css("background-color", this.dataModel.bgColor).siblings("div").css("background-color", "");
      if (this.dataModel.showVerticalBar) {
        if (this.dataModel.color) {
          $(el).css({
            "border-left": "3.5px solid " + color + ""
          }).siblings("div").css({
            "border-left": "none"
          });
        } else {
          $(el).attr({
            "class": "tfp-list-border"
          }).siblings("div").attr({
            "class": ""
          });
        }
      } else {
        $(el).css({
          "border-left": "none",
        }).siblings("div").css({
          "border-left": "none"
        });
      }

      if (this.dataModel.color) $(el).find("label").css("color", color);
      else $(el).find("label").attr("class", "tfp-list-color");
    }
  }

  bindItemEvent() {
    var that = this;
    this._jqObj.children("div").click(function () {
      that.setSelectOptionColor(this);
      var index = $(this).index();
      var option = that.dataModel.options[index];
      var value = "";

      if (that.dataModel.multiCheck) {
        let listItems = that._jqObj.find('div');
        for (var i = 0; i < listItems.length; i++) {
          if (listItems.eq(i).children("input").prop("checked")) {
            if (value == '') {
              value += listItems.eq(i).attr("data-value");
            } else {
              value += ',';
              value += listItems.eq(i).attr("data-value");
            }
          }
        }
      } else {
        if(option) value = option.value;
      }
      that.dataModel.value = value;
      that.valueOnChange();
      that.exeEventHandler("onChange", value);

      try {
        if (option.onClick) eval(option.onClick);
        if (that.dataModel.onClickOption) eval(that.dataModel.onClickOption);
      } catch (err) {
        console.log(err.message);
      }
    });

    this._jqObj.children("div").dblclick(function () {
      that.setSelectOptionColor(this);
      var index = $(this).index();
      var option = that.dataModel.options[index];
      var value = "";

      if (that.dataModel.multiCheck) {
        let listItems = that._jqObj.find('div');
        for (var i = 0; i < listItems.length; i++) {
          if (listItems.eq(i).children("input").prop("checked")) {
            if (value == '') {
              value += listItems.eq(i).attr("data-value");
            } else {
              value += ',';
              value += listItems.eq(i).attr("data-value");
            }
          }
        }
      } else if(option) {
        value = option.value;
      }

      that.dataModel.value = value;
      that.valueOnChange();
      that.exeEventHandler("onChange", value);

      if (that.dataModel.onDblClickOption) {
        try {
          eval(that.dataModel.onDblClickOption);
        } catch (err) {
          console.log(err.message);
        }
      }
    });
  }

  bindData(data) {
    if (isNull(data) || !Array.isArray(data)) return;
    let options = [];
    for (var i = 0; i < data.length; i++) {
      let row = data[i];
      let option = {};
      try {
        let valueFormat = this.dataModel.dataListValueFormat;
        if (valueFormat.indexOf("{") < 0 && valueFormat.indexOf("#[") < 0) valueFormat = "{" + valueFormat + "}";
        option.value = this._tfp.replaceDataField(row, valueFormat);
        if (option.value) option.value = this._tfp.exeExpress(option.value);
      } catch (e) {
        console.log(e);
        return;
      }
      if (isNull(option.value)) continue;
      option.text = option.value;
      if (this.dataModel.dataListTextFormat) {
        try {
          let textFormat = this.dataModel.dataListTextFormat;
          if (textFormat.indexOf("{") < 0 && textFormat.indexOf("#[") < 0) textFormat = "{" + textFormat + "}";
          option.text = this._tfp.replaceDataField(row, textFormat);
          if (option.text) option.text = this._tfp.exeExpress(option.text);
        } catch (e) {
          console.log(e);
          return;
        }
      }
      if (isNull(option.text)) continue;
      options.push(option);
    }
    this.options = options;
  }

  /**
   * 检查数据加载参数是否设置正确
   * @returns 
   */
  checkLoadDataArg() {
    if (!this.dataModel.dataListValueFormat) {
      alert("请为[" + this.id + "]设置选项值数据格式！");
      return false;
    }
    return true;
  }

  initRuntime() {
    //如果设置了服务路径或服务组件，才需要在初始化时加载数据，否则，不加载
    if (this.dataModel.loadDataListService //某些老版本的组件使用的该属性，需要兼容
      || this.dataModel.loadDataService
      || (this.dataModel.dataQuerySetting
        && (this.dataModel.dataQuerySetting.servicePath || this.dataModel.dataQuerySetting.serviceCpt)
      )) {
      this.loadData();
    }
    this.bindItemEvent();
  }
}