import TFPComponentRender from '../render.js'

export default class PreRender extends TFPComponentRender {
  
  constructor(__tfp, _dataModel, _level) {
  	super(__tfp, _dataModel, _level);
  }

  getCustomAttrHtml() {
    if(this._tfp.isDesigning) return " href=\"javascript:void(0)\"";
    if(this.dataModel.onClick) return " href=\"javascript:"+this.dataModel.onClick+"\"";
    let title = "Tasgine - 任擎";
    if(this.dataModel.targetTitle) title = this.dataModel.targetTitle;
    if(this.dataModel.target=="page") {
      return " href=\"javascript:tfp.openPage('"+title+"', '"+this.dataModel.href+"')\"";
    } else if(this.dataModel.target=="dialog") {
      let width = this.dataModel.dialogWidth;
      if(!width) width = "480px";
      if((width+"").indexOf("px")<0) width += "px";
      let height = this.dataModel.dialogHeight;
      if(!height) height = "480px";
      if((height+"").indexOf("px")<0) height += "px";
      return " href=\"javascript:tfp.openDialog('"+title+"', '"+this.dataModel.href+"'"
       +", '"+width+"', '"+height+"')\"";
    } else if(this.dataModel.target=="window") {
      return " href=\"javascript:window.open('"+this.dataModel.href+"', '"+title+"')\"";
    } else {
      return " href=\""+this.dataModel.href+"\"";
    }
  }

  getBodyHtml(getComponentsHtml) {
    if(this.dataModel.text) return this.dataModel.text;
    return "";
  }

  getHtml(getComponentsHtml, parentIndent, retainStyleAttr) {
    return super.getHtml("a", false, parentIndent, retainStyleAttr);
  }
}