export default {
  "name": "Link",
  "comment": "链接",
  "cssFiles": "style.{bgColorMode}.css",
  "attrs": [
    {
      "name": "linkSetting",
      "comment": "链接设置",
      "type": "group",
      "items": [
        {
          "name": "href",
          "comment": "链接地址",
          "type": "String",
          "isHtmlAttr": true,
          "special": true,
          "type": "PathPicker",
          "fileTypes": ["html", "tfp"]
        },
        {
          "name": "text",
          "comment": "链接文本",
          "type": "String",
          "default": "链接"
        },
        {
          "name": "target",
          "comment": "目标页面",
          "type": "Select",
          "default": "self",
          "options": [
            {
              "value": "self",
              "text": "当前页面"
            },
            {
              "value": "page",
              "text": "新页面"
            },
            {
              "value": "dialog",
              "text": "对话框"
            },
            {
              "value": "window",
              "text": "新窗口"
            }
          ]
        },
        {
          "name": "targetTitle",
          "comment": "目标页面标题",
          "type": "String"
        },
        {
          "name": "dialogWidth",
          "comment": "对话框宽度",
          "type": "Int"
        },
        {
          "name": "dialogHeight",
          "comment": "对话框高度",
          "type": "Int"
        }
      ]
    }
  ],
  "styles": ["position", "font", "background", "margin", "other"],
  "defaultStyles": {
    "line-height": "150%"
  },
  "events": [
    {
      "name": "onAfterInitRuntime",
      "comment": "组件初始化后",
      "isNotHtmlEvent": true
    }, {
      "name": "onClick",
      "comment": "点击时"
    }, {
      "name": "onMouseOver",
      "comment": "鼠标经过时"
    }, {
      "name": "onMouseOut",
      "comment": "鼠标移出时"
    }]
}