import {VisibleComponent} from "../controller.js";

/**
 * 链接组件
 * @param {[type]} dataModel [description]
 */
export default class Link extends VisibleComponent {

  constructor(__tfp, dataModel, parent) {
    super(__tfp, "Link", dataModel, parent);
  }

  //链接地址
  get href() { 
    if(!this.dataModel.href) return "";
    return this.dataModel.href; 
  }
  set href(value) {
    this.dataModel.href = value;
    if(this._jqObj && !this._tfp.isDesigning) {
      this._jqObj.attr("href", value);
    }
  }
  
  //链接文本
  get text() { 
    if(!this.dataModel.text) return "";
    return this.dataModel.text; 
  }
  set text(value) {
    this.dataModel.text = value;
    if(this._jqObj) {
      this._jqObj.text(value);
    }
  }

  //目标页面
  get target() { 
    if(!this.dataModel.target) return "";
    return this.dataModel.target; 
  }
  set target(value) {
    this.dataModel.target = value;
    if(this._jqObj) {
      //
    }
  }
  
  //目标页面标题
  get targetTitle() { 
    if(!this.dataModel.targetTitle) return "";
    return this.dataModel.targetTitle; 
  }
  set targetTitle(value) {
    this.dataModel.targetTitle = value;
  }
  
  //目标页面标题
  get dialogWidth() { 
    if(!this.dataModel.dialogWidth) return "";
    return this.dataModel.dialogWidth; 
  }
  set dialogWidth(value) {
    this.dataModel.dialogWidth = value;
  }
  
  //目标页面标题
  get dialogHeight() { 
    if(!this.dataModel.dialogHeight) return "";
    return this.dataModel.dialogHeight; 
  }
  set dialogHeight(value) {
    this.dataModel.dialogHeight = value;
  }
}