import TFPComponentRender from '../render.js'

export default class LayoutRender extends TFPComponentRender {

  constructor(__tfp, _dataModel, _level) {
    super(__tfp, _dataModel, _level);
  }

  getPanelHtml(getComponentsHtml, indent, index) {
    let html = "\r\n";
    let panelModel = this.dataModel.components[index];

    var panelClass = this._tfp.controllers["Panel"];
    var panel = new panelClass(this._tfp, panelModel, this.cpt);

    let Render = this._tfp.renders["Panel"];
    if (!Render) return "";
    let render = new Render(this._tfp, panelModel, this.level + 1);
    html += render.getHtml(getComponentsHtml, indent);
    html += "\r\n";
    return html;
  }

  getBodyHtml = function (getComponentsHtml) {
    let bodyHtml = "\r\n";
    let indent = this.getHtmlIndent();

    let toggleIconPath = this._tfp.rootPath + "/src/components/layout/images/arrow-";

    let topHeight = "";
    if (this.dataModel.topPanelHeight) topHeight = "flex-basis: " + this.dataModel.topPanelHeight + "px;";
    let leftWidth = "";
    if (this.dataModel.leftPanelWidth) leftWidth = "flex-basis: " + this.dataModel.leftPanelWidth + "px;";
    let rightWidth = "";
    if (this.dataModel.rightPanelWidth) rightWidth = "flex-basis: " + this.dataModel.rightPanelWidth + "px;";
    let bottomHeight = "";
    if (this.dataModel.bottomPanelHeight) bottomHeight = "flex-basis: " + this.dataModel.bottomPanelHeight + "px;";

    let topDisplay = "";
    if (!this.dataModel.topPanelShow) topDisplay = "display:none;";
    let topToggleDisplay = "";
    if (!this.dataModel.topPanelToggle) topToggleDisplay = "display:none;";
    let leftDisplay = "";
    if (!this.dataModel.leftPanelShow) leftDisplay = "display:none;";
    let leftToggleDisplay = "";
    if (!this.dataModel.leftPanelToggle) leftToggleDisplay = "display:none;";
    let rightDisplay = "";
    if (!this.dataModel.rightPanelShow) rightDisplay = "display:none;";
    let rightToggleDisplay = "";
    if (!this.dataModel.rightPanelToggle) rightToggleDisplay = "display:none;";
    let bottomDisplay = "";
    if (!this.dataModel.bottomPanelShow) bottomDisplay = "display:none;";
    let bottomToggleDisplay = "";
    if (!this.dataModel.bottomPanelToggle) bottomToggleDisplay = "display:none;";

    let PanelRender = this._tfp.renders["Panel"];

    bodyHtml += indent + "\t<div class=\"tfp-layout-top\" style=\"" + topDisplay + "" + topHeight + "\">\r\n";
    //如果getComponentsHtml=true，表示是服务器端编译时，需要在此获得子组件的html
    //而不是创建子组件控制器，让其自己去渲染
    if (getComponentsHtml) {
      let cdm = this.dataModel.components[0];
      let render = new PanelRender(this._tfp, cdm, this.level + 1);
      bodyHtml += render.getHtml(getComponentsHtml, indent);
    }
    bodyHtml += indent + "\t</div>\r\n";
    bodyHtml += indent + "\t<div class=\"tfp-layout-top-split\">\r\n";
    bodyHtml += indent + "\t\t<div class=\"tfp-layout-top-toggle\" title=\""
      + (topDisplay=="" ? "隐藏" : "显示") +"\" style=\"" + topToggleDisplay 
      + "\"><img src=\"" + toggleIconPath + (topDisplay=="" ? "up" : "down") + ".png\" /></div>\r\n";
    bodyHtml += indent + "\t</div>\r\n";
    bodyHtml += indent + "\t<div class=\"tfp-layout-center\">\r\n";
    bodyHtml += indent + "\t\t<div class=\"tfp-layout-left\" style=\"" + leftDisplay + "" + leftWidth + "\">\r\n";
    if (getComponentsHtml) {
      let cdm = this.dataModel.components[1];
      let render = new PanelRender(this._tfp, cdm, this.level + 1);
      bodyHtml += render.getHtml(getComponentsHtml, indent);
    }
    bodyHtml += indent + "\t</div>\r\n";
    bodyHtml += indent + "\t\t<div class=\"tfp-layout-left-split\">\r\n";
    bodyHtml += indent + "\t\t\t<div class=\"tfp-layout-left-toggle\" title=\""
      + (leftDisplay=="" ? "隐藏" : "显示") +"\" style=\"" + leftToggleDisplay + "\"><img src=\"" 
      + toggleIconPath + (leftDisplay=="" ? "left" : "right") + ".png\" /></div>\r\n";
    bodyHtml += indent + "\t\t</div>\r\n";
    bodyHtml += indent + "\t\t<div class=\"tfp-layout-main\">\r\n";
    if (getComponentsHtml) {
      let cdm = this.dataModel.components[2];
      let render = new PanelRender(this._tfp, cdm, this.level + 1);
      bodyHtml += render.getHtml(getComponentsHtml, indent);
    }
    bodyHtml += indent + "\t\t</div>\r\n";
    bodyHtml += indent + "\t\t<div class=\"tfp-layout-right-split\">\r\n";
    bodyHtml += indent + "\t\t\t<div class=\"tfp-layout-right-toggle\" title=\""
      + (rightDisplay=="" ? "隐藏" : "显示") +"\" style=\"" + rightToggleDisplay + "\"><img src=\"" 
      + toggleIconPath + (rightDisplay=="" ? "right" : "left") + ".png\" /></div>\r\n";
    bodyHtml += indent + "\t\t</div>\r\n";
    bodyHtml += indent + "\t\t<div class=\"tfp-layout-right\" style=\"" + rightDisplay + "" + rightWidth + "\">\r\n";
    if (getComponentsHtml) {
      let cdm = this.dataModel.components[3];
      let render = new PanelRender(this._tfp, cdm, this.level + 1);
      bodyHtml += render.getHtml(getComponentsHtml, indent);
    }
    bodyHtml += indent + "\t\t</div>\r\n";
    bodyHtml += indent + "\t</div>\r\n";
    bodyHtml += indent + "\t<div class=\"tfp-layout-bottom-split\">\r\n";
    bodyHtml += indent + "\t\t<div class=\"tfp-layout-bottom-toggle\" title=\""
      + (bottomDisplay=="" ? "隐藏" : "显示") +"\" style=\"" + bottomToggleDisplay + "\"><img src=\"" 
      + toggleIconPath + (bottomDisplay=="" ? "down" : "up") + ".png\" /></div>\r\n";
    bodyHtml += indent + "\t</div>\r\n";
    bodyHtml += indent + "\t<div class=\"tfp-layout-bottom\" style=\"" + bottomDisplay + "" + bottomHeight + "\">\r\n";
    if (getComponentsHtml) {
      let cdm = this.dataModel.components[4];
      let render = new PanelRender(this._tfp, cdm, this.level + 1);
      bodyHtml += render.getHtml(getComponentsHtml, indent);
    }
    bodyHtml += indent + "\t</div>\r\n";

    return bodyHtml + indent;
  }

  getHtml(getComponentsHtml, parentIndent, retainStyleAttr) {
    return super.getHtml("div", getComponentsHtml, parentIndent, retainStyleAttr);
  }
}