import { ContainerComponent } from "../controller.js";

/**
 * 布局组件
 * @param {[type]} dataModel [description]
 */
export default class Layout extends ContainerComponent {

  constructor(__tfp, dataModel, parent) {
    super(__tfp, "Layout", dataModel, parent);
  }

  get mainPanel() { return this._tfp.components[this.id+"_main_panel"] }
  set mainPanel(value) {}

  get topPanel() { return this._tfp.components[this.id+"_top_panel"] }
  set topPanel(value) {}

  get topPanelHeight() { return this.dataModel.topPanelHeight }
  set topPanelHeight(value) {
    this.dataModel.topPanelHeight = this._tfp.getPx(value);
    if (this._jqObj) {
      this._jqObj.find(".tfp-layout-top").css("flex-basis", value+"px");
    }
  }

  get topPanelShow() { return this.dataModel.topPanelShow ? true : false }
  set topPanelShow(value) {
    this.dataModel.topPanelShow = value ? true : false;
    if (this._jqObj) {
      if(this.dataModel.topPanelShow) {
        this._jqObj.find(".tfp-layout-top").show();
        //if(this.dataModel.topPanelToggle) this._jqObj.find(".tfp-layout-top-toggle").show();
      } else {
        this._jqObj.find(".tfp-layout-top").hide();
        //this._jqObj.find(".tfp-layout-top-toggle").hide();
      }
    }
  }

  get topPanelToggle() { return this.dataModel.topPanelToggle ? true : false }
  set topPanelToggle(value) {
    this.dataModel.topPanelToggle = value ? true : false;
    if (this._jqObj) {
      if(this.dataModel.topPanelToggle) {
        this._jqObj.find(".tfp-layout-top-toggle").show();
      } else {
        this._jqObj.find(".tfp-layout-top-toggle").hide();
      }
    }
  }

  get leftPanel() { return this._tfp.components[this.id+"_left_panel"] }
  set leftPanel(value) {}

  get leftPanelWidth() { return this.dataModel.leftPanelWidth }
  set leftPanelWidth(value) {
    this.dataModel.leftPanelWidth = this._tfp.getPx(value);
    if (this._jqObj) this._jqObj.find(".tfp-layout-left").css("flex-basis", value+"px");
  }

  get leftPanelShow() { return this.dataModel.leftPanelShow ? true : false }
  set leftPanelShow(value) {
    this.dataModel.leftPanelShow = value ? true : false;
    if (this._jqObj) {
      if(this.dataModel.leftPanelShow) {
        this._jqObj.find(".tfp-layout-left").show();
        //if(this.dataModel.leftPanelToggle) this._jqObj.find(".tfp-layout-left-toggle").show();
      } else {
        this._jqObj.find(".tfp-layout-left").hide();
        //this._jqObj.find(".tfp-layout-left-toggle").hide();
      }
    }
  }

  get leftPanelToggle() { return this.dataModel.leftPanelToggle ? true : false }
  set leftPanelToggle(value) {
    this.dataModel.leftPanelToggle = value ? true : false;
    if (this._jqObj) {
      if(this.dataModel.leftPanelToggle) {
        this._jqObj.find(".tfp-layout-left-toggle").show();
      } else {
        this._jqObj.find(".tfp-layout-left-toggle").hide();
      }
    }
  }

  get rightPanel() { return this._tfp.components[this.id+"_right_panel"] }
  set rightPanel(value) {}

  get rightPanelWidth() { return this.dataModel.rightPanelWidth }
  set rightPanelWidth(value) {
    this.dataModel.rightPanelWidth = this._tfp.getPx(value);
    if (this._jqObj) this._jqObj.find(".tfp-layout-right").css("flex-basis", value+"px");
  }

  get rightPanelShow() { return this.dataModel.rightPanelShow ? true : false }
  set rightPanelShow(value) {
    this.dataModel.rightPanelShow = value ? true : false;
    if (this._jqObj) {
      if(this.dataModel.rightPanelShow) {
        this._jqObj.find(".tfp-layout-right").show();
        //if(this.dataModel.rightPanelToggle) this._jqObj.find(".tfp-layout-right-toggle").show();
      } else {
        this._jqObj.find(".tfp-layout-right").hide();
        //this._jqObj.find(".tfp-layout-right-toggle").hide();
      }
    }
  }

  get rightPanelToggle() { return this.dataModel.rightPanelToggle ? true : false }
  set rightPanelToggle(value) {
    this.dataModel.rightPanelToggle = value ? true : false;
    if (this._jqObj) {
      if(this.dataModel.rightPanelToggle) {
        this._jqObj.find(".tfp-layout-right-toggle").show();
      } else {
        this._jqObj.find(".tfp-layout-right-toggle").hide();
      }
    }
  }

  get bottomPanel() { return this._tfp.components[this.id+"_bottom_panel"] }
  set bottomPanel(value) {}

  get bottomPanelHeight() { return this.dataModel.bottomPanelHeight }
  set bottomPanelHeight(value) {
    this.dataModel.bottomPanelHeight = this._tfp.getPx(value);
    if (this._jqObj) this._jqObj.find(".tfp-layout-bottom").css("flex-basis", value+"px");
  }

  get bottomPanelShow() { return this.dataModel.bottomPanelShow ? true : false }
  set bottomPanelShow(value) {
    this.dataModel.bottomPanelShow = value ? true : false;
    if (this._jqObj) {
      if(this.dataModel.bottomPanelShow) {
        this._jqObj.find(".tfp-layout-bottom").show();
        //if(this.dataModel.bottomPanelToggle) this._jqObj.find(".tfp-layout-bottom-toggle").show();
      } else {
        this._jqObj.find(".tfp-layout-bottom").hide();
        //this._jqObj.find(".tfp-layout-bottom-toggle").hide();
      }
    }
  }

  get bottomPanelToggle() { return this.dataModel.bottomPanelToggle ? true : false }
  set bottomPanelToggle(value) {
    this.dataModel.bottomPanelToggle = value ? true : false;
    if (this._jqObj) {
      if(this.dataModel.bottomPanelToggle) {
        this._jqObj.find(".tfp-layout-bottom-toggle").show();
      } else {
        this._jqObj.find(".tfp-layout-bottom-toggle").hide();
      }
    }
  }

  get hasAttachedChilds() {
    return true
  }

  getContainerEl(cptId) {
    let panelType = cptId.substring(cptId.indexOf("_")+1, cptId.lastIndexOf("_"));
    if(panelType=="top") return this._jqObj.find(".tfp-layout-top").get(0);
    if(panelType=="left") return this._jqObj.find(".tfp-layout-left").get(0);
    if(panelType=="main") return this._jqObj.find(".tfp-layout-main").get(0);
    if(panelType=="right") return this._jqObj.find(".tfp-layout-right").get(0);
    if(panelType=="bottom") return this._jqObj.find(".tfp-layout-bottom").get(0);
    return null;
  }

  toggleTopPanel() {
    this.topPanelShow = !this.topPanelShow;
    let toggleEl = this._jqObj.find(".tfp-layout-top-toggle");
    let toggleImg = toggleEl.find("img");
    if(!this.topPanelShow) {
      toggleEl.attr("title", "显示");
      toggleImg.attr("src", toggleImg.attr("src").replace("arrow-up.png", "arrow-down.png"));
    } else {
      toggleEl.attr("title", "隐藏");
      toggleImg.attr("src", toggleImg.attr("src").replace("arrow-down.png", "arrow-up.png"));
    }
    toggleEl.show();
  }

  toggleLeftPanel() {
    this.leftPanelShow = !this.leftPanelShow;
    let toggleEl = this._jqObj.find(".tfp-layout-left-toggle");
    let toggleImg = toggleEl.find("img");
    if(!this.leftPanelShow) {
      toggleEl.attr("title", "显示");
      toggleImg.attr("src", toggleImg.attr("src").replace("arrow-left.png", "arrow-right.png"));
    } else {
      toggleEl.attr("title", "隐藏");
      toggleImg.attr("src", toggleImg.attr("src").replace("arrow-right.png", "arrow-left.png"));
    }
    toggleEl.show();
  }

  toggleRightPanel() {
    this.rightPanelShow = !this.rightPanelShow;
    let toggleEl = this._jqObj.find(".tfp-layout-right-toggle");
    let toggleImg = toggleEl.find("img");
    if(!this.rightPanelShow) {
      toggleEl.attr("title", "显示");
      toggleImg.attr("src", toggleImg.attr("src").replace("arrow-right.png", "arrow-left.png"));
    } else {
      toggleEl.attr("title", "隐藏");
      toggleImg.attr("src", toggleImg.attr("src").replace("arrow-left.png", "arrow-right.png"));
    }
    toggleEl.show();
  }

  toggleBottomPanel() {
    this.bottomPanelShow = !this.bottomPanelShow;
    let toggleEl = this._jqObj.find(".tfp-layout-bottom-toggle");
    let toggleImg = toggleEl.find("img");
    if(!this.bottomPanelShow) {
      toggleEl.attr("title", "显示");
      toggleImg.attr("src", toggleImg.attr("src").replace("arrow-down.png", "arrow-up.png"));
    } else {
      toggleEl.attr("title", "隐藏");
      toggleImg.attr("src", toggleImg.attr("src").replace("arrow-up.png", "arrow-down.png"));
    }
    toggleEl.show();
  }

  initRuntime() {
    var that = this;
    this._jqObj.find(".tfp-layout-top-toggle").click(function() {
      that.toggleTopPanel();
    });
    this._jqObj.find(".tfp-layout-left-toggle").click(function() {
      that.toggleLeftPanel();
    });
    this._jqObj.find(".tfp-layout-right-toggle").click(function() {
      that.toggleRightPanel();
    });
    this._jqObj.find(".tfp-layout-bottom-toggle").click(function() {
      that.toggleBottomPanel();
    });
  }
}