import TFPComponentRender from '../render.js'

export default class LabelRender extends TFPComponentRender {

  constructor(__tfp, _dataModel, _level) {
    super(__tfp, _dataModel, _level);
  }

  getBodyHtml(getComponentsHtml, retainStyleAttr) {
    if (!this._tfp.isDesigning) {
      var vid = escape(this.dataModel.id).replaceAll("%", "");
      return "{{" + vid + "}}";
    }
    else {
      if (this.dataModel.value) return this.dataModel.value;
      if (this.dataModel.dataBindingFormat) return this.dataModel.dataBindingFormat;
    }
    return "";
  }

  getBodyWX(getComponentsHtml, retainStyleAttr, otherOptions) {
    var cpt_wx = {
      "wxjson": "",
      "wxjs": "",
      "wxml": "",
      "wxss": ""
    }
    var vid = escape(this.dataModel.id).replaceAll("%", "");
    if (this.dataModel.dataBindingFormat) {
      if (otherOptions && otherOptions.gridContainer)
        cpt_wx.wxml = "{{item." + vid + "}}";
      else
        cpt_wx.wxml = "{{" + vid + "}}";
    }
    else if (this.dataModel.value) cpt_wx.wxml = this.dataModel.value;
    return cpt_wx;
  }

  getHtml(getComponentsHtml, parentIndent, retainStyleAttr) {
    return super.getHtml("lable", false, parentIndent, retainStyleAttr);
  }

  getWX(getComponentsHtml, parentIndent, retainStyleAttr, otherOptions) {
    return super.getWX("text", false, parentIndent, retainStyleAttr, otherOptions);
  }
}