import TFPComponentRender from '../render.js'

export default class LabelRender extends TFPComponentRender {

  constructor(__tfp, _dataModel, _level) {
    super(__tfp, _dataModel, _level);
  }
  
  getBodyHtml(getComponentsHtml) {
    return this.cpt.getBodyHtml();
  }

  getAttrClass() {
    let c = "";
    if (this.dataModel.size) c += "tfp-label-" + this.dataModel.size;
    //if (this.dataModel.attach) c += "tfp-label-" + this.dataModel.attach;
    return c;
  }

  getCustomStyleHtml() {
    let style = "";
    if (this.dataModel.styles && this.dataModel.styles["text-align"]) {
      let styleValue = this.dataModel.styles["text-align"];
      style = "justify-content: ";
      if(styleValue=="left" || styleValue=="start") {
        style += "flex-start";
      } else if(styleValue=="right" || styleValue=="end") {
        style += "flex-end";
      } else if(styleValue=="center") {
        style += "center";
      } else if(styleValue=="justify") {
        style += "space-between";
      }
      style += ";";
    }
    return style;
  }

  getHtml(getComponentsHtml, parentIndent, retainStyleAttr) {
      return super.getHtml("label", false, parentIndent, retainStyleAttr);
  }
}