export default {
  "name": "Label",
  "comment": "文字标签",
  "cssFiles": [
    "style.css",
    "style.{client}.{bgColorMode}.css",
    {
      "src": "/node_modules/tfp/src/components/iconpicker/iconfont/iconfont.css",
      "onlyRuntime": true
    },
    {
      "src": "/node_modules/tfp/src/components/button/iconfont/iconfont.css",
      "onlyRuntime": true
    },
    {
      "src": "/node_modules/tfp/src/components/iconpicker/iconfont/iconfont_tb.css",
      "onlyDesigning": true
    },
    {
      "src": "/node_modules/tfp/src/components/button/iconfont/iconfont_tb.css",
      "onlyDesigning": true
    }
  ],
  "attrs": [
    {
      "name": "labelSetting",
      "comment": "文本设置",
      "type": "group",
      "items": [
        {
          "name": "value",
          "comment": "组件文本",
          "type": "String",
          "notnull": true,
          "default": "{id}"
        },
        {
          "name": "dataBindingFormat",
          "comment": "数据绑定格式",
          "type": "String"
        },
        {
          "name": "size",
          "comment": "大小",
          "type": "Select",
          "options": [
            {
              "value": "title1",
              "text": "标题1",
            },
            {
              "value": "title2",
              "text": "标题2",
            },
            {
              "value": "title3",
              "text": "标题3",
            },
            {
              "value": "title4",
              "text": "标题4",
            },
            {
              "value": "large",
              "text": "大"
            },
            {
              "value": "medium",
              "text": "中"
            },
            {
              "value": "small",
              "text": "小"
            }
          ]
        },
        {
          "name": "attach",
          "comment": "附加内容",
          "type": "Select",
          "options": [
            {
              "value": "asterisk-prefix",
              "text": "星号前缀",
            },
            {
              "value": "asterisk-suffix",
              "text": "星号后缀"
            },
            {
              "value": "vertical-bar-prefix",
              "text": "竖条前缀"
            }
          ]
        },
        {
          "name": "attachColor",
          "comment": "附加内容颜色",
          "type": "Color"
        }
      ]
    },
    {
      "name": "imageSetting",
      "comment": "小图标设置",
      "type": "group",
      "items": [
        {
          "name": "showImage",
          "comment": "显示小图标",
          "type": "Switch"
        },
        {
          "name": "icon",
          "comment": "文本前面显示小图标",
          "type": "IconPickers",
          "fileTypes": ["image"],
          "hidden": "'{showImage}'!='true'"
        },
        {
          "name": "iconSize",
          "comment": "小图标大小",
          "type": "Int",
          "default": 20,
          "hidden": "'{showImage}'!='true'"
        },
        {
          "name": "iconRadius",
          "comment": "小图标圆角",
          "type": "Int",
          "default": 4,
          "hidden": "'{showImage}'!='true'"
        }
      ]
    }
  ],
  "styles": ["size", "position", "font", "background", "border", "margin", "other"],
  "defaultStyles": {
    "line-height": "30px"
  },
  "events": [
    {
      "name": "onAfterInitRuntime",
      "comment": "组件初始化后",
      "isNotHtmlEvent": true
    }, {
      "name": "onClick",
      "comment": "点击时"
    }, {
      "name": "onMouseOver",
      "comment": "鼠标经过时"
    }, {
      "name": "onMouseOut",
      "comment": "鼠标移出时"
    }]
}