import { VisibleComponent } from "../controller.js";

/**
 * 标签组件
 * @param {[type]} dataModel [description]
 */
export default class Label extends VisibleComponent {

  constructor(__tfp, dataModel, parent) {
    super(__tfp, "Label", dataModel, parent);
  }

  //标签值
  get value() {
    if (!this.dataModel.value) return "";
    return this.dataModel.value;
  }
  set value(value) {
    this.dataModel.value = value;
    if (this._jqObj) {
      if (this.dataModel.value) this._jqObj.text(this.dataModel.value);
      if (this.dataModel.dataBindingFormat) this._jqObj.text(this.dataModel.dataBindingFormat);
      this.exeEventHandler("onChange");
    }
  }

  //数据绑定格式
  get dataBindingFormat() { return this.dataModel.dataBindingFormat }
  set dataBindingFormat(value) {
    this.dataModel.dataBindingFormat = value;
    if (this._jqObj) {
      if (this.dataModel.value) this._jqObj.text(this.dataModel.value);
      if (this.dataModel.dataBindingFormat) this._jqObj.text(this.dataModel.dataBindingFormat);
      this.exeEventHandler("onChange");
    }
  }
}