import { VisibleComponent } from "../controller.js";

/**
 * 标签组件
 * @param {[type]} dataModel [description]
 */
export default class Label extends VisibleComponent {

  constructor(__tfp, dataModel, parent) {
    super(__tfp, "Label", dataModel, parent);
  }

  //标签值
  get value() {
    if (!this.dataModel.value) return "";
    return this.dataModel.value;
  }
  set value(value) {
    this.dataModel.value = value;
    if (this._jqObj) {
      this._jqObj.html(this.getBodyHtml());
      this.exeEventHandler("onChange");
    }
  }

  get size() { return this.dataModel.size }
  set size(value) {
    this.dataModel.size = value;
    if (this._jqObj) {
      const labelEl = this._jqObj; //this.dataModel.attach ? this._jqObj.find("label") : this._jqObj;
      labelEl.removeClass(function (index, className) {
        let ss = className.split(' ');
        for (let s = 0; s < ss.length; s++) {
          if (ss[s].indexOf('tfp-label-') >= 0) return ss[s];
        }
        return "";
      });
      if (value) labelEl.addClass("tfp-label-" + value);
    }
  }

  get attach() { return this.dataModel.attach }
  set attach(value) {
    this.dataModel.attach = value;
    if (this._jqObj) {
      let color = '#f56c6c';
      if (this.dataModel.attachColor) color = this.dataModel.attachColor;
      let colorClass = '';
      if (this.dataModel.attach == 'vertical-bar-prefix' && !this.dataModel.attachColor) {
        colorClass = 'vertical-bar-prefix-color';
        color = '';
      }
      this._jqObj.find(".tfp-label-attach").remove();
      if (this.dataModel.attach == 'asterisk-prefix') {
        this._jqObj.prepend('<span class="tfp-label-attach" style=\"float:left;margin-right:5px;color:' + color + ';\">*</span>');
      } else if (this.dataModel.attach == 'asterisk-suffix') {
        this._jqObj.append('<span class="tfp-label-attach" style=\"float:right;margin-left:5px;color:' + color + ';\">*</span>');
      } else if (this.dataModel.attach == 'vertical-bar-prefix') {
        this._jqObj.prepend('<span class="tfp-label-attach  ' + colorClass + '" style=\"float:left;width:4px;height:24px;margin-right:10px;background-color:' + color + ';\"></span>');
      }
    }
  }

  get attachColor() { return this.dataModel.attachColor }
  set attachColor(value) {
    this.dataModel.attachColor = value;
    if (this.dataModel.attach) {
      if (this.dataModel.attach == 'vertical-bar-prefix') {
        this._jqObj.find(".tfp-label-attach").css("background-color", value);
      } else {
        this._jqObj.find(".tfp-label-attach").css("color", value);
      }
    }
  }

  get showImage() { return this.dataModel.showImage }
  set showImage(value) {
    this.dataModel.showImage = value ? true : false;
    if (this._jqObj) {
      if (value) {
        let iconClass = 'iconfont icon-album';
        let iconColor = '#000';
        let iconBgColor = '#fff';
        let iconSize = '20';
        let iconRadius = '4';

        if (this.dataModel.attach && this.dataModel.attach != 'asterisk-suffix') {
          this._jqObj.find(".tfp-label-attach").after("<span class=\"" + iconClass + "\"  style=\"margin-right:3px;font-size:" + iconSize + "px;border-radius:" + iconRadius + "px;color:" + iconColor + ";background-color:" + iconBgColor + ";\"></span>");
        } else {
          this._jqObj.prepend("<span class=\"" + iconClass + "\"  style=\"line-height: normal;margin-right:3px;font-size:" + iconSize + "px;border-radius:" + iconRadius + "px;color:" + iconColor + ";background-color:" + iconBgColor + ";\"></span>");
        }
      } else {
        this.dataModel.iconSize = 20;
        this.dataModel.iconRadius = 4;
        this.dataModel.icon = undefined;
        this._jqObj.find(".iconfont").remove()
      }
    }
  }

  get icon() { return this.dataModel.icon }
  set icon(value) {
    if (JSON.stringify(value) == '{}') value = undefined;
    this.dataModel.icon = value;

    let iconClass = 'iconfont icon-album';
    if (value && value.class !== 'undefined') iconClass = value.class;
    let iconColor = '#000';
    if (value && value.color !== 'undefined') iconColor = value.color;
    let iconBgColor = '#fff';
    if (value && value.bgColor !== 'undefined') iconBgColor = value.bgColor;
    let iconSize = this.dataModel.iconSize;
    if (!iconSize) iconSize = '20';
    let iconRadius = this.dataModel.iconRadius;
    if (!iconRadius) iconRadius = '4';

    this._jqObj.find(".iconfont").remove()
    if (this.dataModel.attach && this.dataModel.attach != 'asterisk-suffix') {
      this._jqObj.find(".tfp-label-attach").after("<span class=\"" + iconClass + "\"  style=\"line-height: normal;margin-right:3px;font-size:" + iconSize + "px;border-radius:" + iconRadius + "px;color:" + iconColor + ";background-color:" + iconBgColor + ";\"></span>");
    } else {
      this._jqObj.prepend("<span class=\"" + iconClass + "\"  style=\"line-height: normal;margin-right:3px;font-size:" + iconSize + "px;border-radius:" + iconRadius + "px;color:" + iconColor + ";background-color:" + iconBgColor + ";\"></span>");
    }
  }

  get iconSize() { return this.dataModel.iconSize }
  set iconSize(value) {
    this.dataModel.iconSize = value;
    if (this._jqObj) {
      this._jqObj.find(".iconfont").css("font-size", "" + value + "px");
    }
  }

  get iconRadius() { return this.dataModel.iconRadius }
  set iconRadius(value) {
    this.dataModel.iconRadius = value;
    if (this._jqObj) {
      this._jqObj.find(".iconfont").css("border-radius", "" + value + "px");
    }
  }

  //数据绑定格式
  get dataBindingFormat() { return this.dataModel.dataBindingFormat }
  set dataBindingFormat(value) { this.dataModel.dataBindingFormat = value }

  getBodyHtml(getComponentsHtml) {
    let html = '';
    let val = '';

    let iconClass = 'iconfont icon-album';
    if (this.dataModel.icon && this.dataModel.icon.class !== 'undefined') iconClass = this.dataModel.icon.class;
    let iconColor = '#000';
    if (this.dataModel.icon && this.dataModel.icon.color !== 'undefined') iconColor = this.dataModel.icon.color;
    let iconBgColor = '#fff';
    if (this.dataModel.icon && this.dataModel.icon.bgColor !== 'undefined') iconBgColor = this.dataModel.icon.bgColor;
    let iconSize = this.dataModel.iconSize;
    if (!iconSize) iconSize = '20';
    let iconRadius = this.dataModel.iconRadius;
    if (!iconRadius) iconRadius = '4';

    if (!this._tfp.isNull(this.dataModel.value)) {
      val = this.dataModel.value;
    } else if(this._tfp.isDesigning && !this._tfp.isNull(this.dataModel.dataBindingFormat)) {
      val = this.dataModel.dataBindingFormat;
    }
    let color = '#f56c6c';
    if (this.dataModel.attachColor) color = this.dataModel.attachColor;
    let colorClass = '';
    if (this.dataModel.attach == 'vertical-bar-prefix' && !this.dataModel.attachColor) {
      colorClass = 'vertical-bar-prefix-color';
      color = '';
    }

    if (this.dataModel.attach) {
      if (this.dataModel.attach == 'asterisk-prefix') {
        html += '<span class="tfp-label-attach" style=\"float:left;margin-right:5px;color:' + color + ';\">*</span>';
        if (this.dataModel.showImage) html += "<span class=\"" + iconClass + "\"  style=\"line-height: normal;margin-right:3px;font-size:" + iconSize + "px;border-radius:" + iconRadius + "px;color:" + iconColor + ";background-color:" + iconBgColor + ";\"></span>";
        html += val;
      } else if (this.dataModel.attach == 'asterisk-suffix') {
        if (this.dataModel.showImage) html += "<span class=\"" + iconClass + "\"  style=\"line-height: normal;margin-right:3px;font-size:" + iconSize + "px;border-radius:" + iconRadius + "px;color:" + iconColor + ";background-color:" + iconBgColor + ";\"></span>";
        html += val;
        html += '<span class="tfp-label-attach" style=\"float:right;margin-left:5px;color:' + color + ';\">*</span>';
      } else if (this.dataModel.attach == 'vertical-bar-prefix') {
        html += '<span class="tfp-label-attach ' + colorClass + '" style=\"float:left;width:4px;height:24px;margin-right:10px;background-color:' + color + ';\"></span>';
        if (this.dataModel.showImage) html += "<span class=\"" + iconClass + "\"  style=\"line-height: normal;margin-right:3px;font-size:" + iconSize + "px;border-radius:" + iconRadius + "px;color:" + iconColor + ";background-color:" + iconBgColor + ";\"></span>";
        html += val;
      }
      return html;
    } else {
      if (this.dataModel.showImage) html += "<span class=\"" + iconClass + "\"  style=\"line-height: normal;margin-right:3px;font-size:" + iconSize + "px;border-radius:" + iconRadius + "px;color:" + iconColor + ";background-color:" + iconBgColor + ";\"></span>";
      html += val;
      return html;
    }
  }

  css(styleName, styleValue) {
    if (arguments.length == 0) return;
    //获取样式值
    if (arguments.length == 1) {
      if (!this.dataModel.styles) return null;
      return this.dataModel.styles[styleName];
    }
    super.css(styleName, styleValue);
    if (styleName == "text-align" && styleValue) {
      if (this._jqObj) {
        if (styleValue == "left" || styleValue == "start") {
          this._jqObj.css("justify-content", "flex-start");
        } else if (styleValue == "right" || styleValue == "end") {
          this._jqObj.css("justify-content", "flex-end");
        } else if (styleValue == "center") {
          this._jqObj.css("justify-content", "center");
        } else if (styleValue == "justify") {
          this._jqObj.css("justify-content", "space-between");
        }
      }
    }
  }

  show() {
    if (this._jqObj) this._jqObj.css("display", "inline-flex");
  }

  initDesigning() {
    if(this._jqObj) {
      let parentEl = this._jqObj.parent();
      if(parentEl.length>0 && parentEl.get(0).tagName=="TD") {
        this._jqObj.css("vertical-align", "middle");
      }
    }
  }
}