import TFPComponentRender from '../render.js'

export default class InputNumberRender extends TFPComponentRender {

  constructor(__tfp, _dataModel, _level) {
    super(__tfp, _dataModel, _level);
  }

  getBodyHtml(retainStyleAttr) {
    let html = "\r\n";
    let indent = this.getHtmlIndent();
    let attrHtml = super.getAttrHtml(retainStyleAttr);
    let val = "";
    if (this.dataModel.value) {
      if (this.dataModel.accuracy) {
        val = parseFloat(this.dataModel.value).toFixed(2);
      } else {
        val = this.dataModel.value;
      }
    };

    html += indent + "\t<button>－</button><input type=\"text\" value =\"" + val + "\"";
    if (this._tfp.isDesigning && attrHtml.indexOf("readonly") < 0)
      html += " readonly";
    html += "> <button>＋</button>\r\n";
    return html + indent;
  }

  getHtml(getComponentsHtml, parentIndent, retainStyleAttr) {
    return super.getHtml("div", false, parentIndent, retainStyleAttr);
  }
}
