import { FormInput } from "../controller.js";

/**
 * 计数器组件
 * @param {[type]} dataModel [description]
 */
export default class InputNumber extends FormInput {

  constructor(__tfp, dataModel, parent) {
    super(__tfp, "InputNumber", dataModel, parent);
  }

  get value() { return this.dataModel.value }
  set value(value) {
    if (value) {
      this.dataModel.value = value;
    } else {
      this.dataModel.value = 0;
    }
    if (this._jqObj) {
      this._jqObj.find("input").val(this.dataModel.value);
    }
  }

  get maxValue() { return this.dataModel.maxValue }
  set maxValue(value) {
    if (value) {
      this.dataModel.maxValue = value;
    } else {
      this.dataModel.maxValue = "";
    }
  }

  get minValue() { return this.dataModel.minValue }
  set minValue(value) {
    if (value) {
      this.dataModel.minValue = value;
    } else {
      this.dataModel.minValue = "";
    }
  }

  get stepsNumber() { return this.dataModel.stepsNumber }
  set stepsNumber(value) {
    if (value) {
      this.dataModel.stepsNumber = value;
    } else {
      this.dataModel.stepsNumber = 1;
    }
  }

  get accuracy() { return this.dataModel.accuracy }
  set accuracy(value) {
    this.dataModel.accuracy = value ? true : false;
    if (this._jqObj) {
      if (this.dataModel.accuracy) {
        this._jqObj.find("input").val(parseFloat(this.dataModel.value).toFixed(2));
      } else {
        this._jqObj.find("input").val(this.dataModel.value);
      }
    }
  }

  inputNumberChange() {
    let that = this;

    this._jqObj.find("button").eq(0).click(function () {
      let reduceVal = null;
      $(this).siblings("button").css("cursor", "pointer");

      if (parseFloat(that.dataModel.value) - parseFloat(that.dataModel.stepsNumber) < parseFloat(that.dataModel.minValue)) {
        reduceVal = parseFloat(that.dataModel.value)
        $(this).css("cursor", "not-allowed");
      } else {
        reduceVal = parseFloat(parseFloat(that.dataModel.value) - parseFloat(that.dataModel.stepsNumber))
      }
      if (that.dataModel.accuracy) {
        that._jqObj.find("input").val(reduceVal.toFixed(2));
      } else {
        that._jqObj.find("input").val(reduceVal);
      }
      that.dataModel.value = that._jqObj.find("input").val();
      if (!that._tfp.isDesigning) {
        that.valueOnChange();
        that.exeEventHandler("onChange", that.dataModel.value);
      }
    });

    this._jqObj.find("button").eq(1).click(function () {
      let addVal = null;
      $(this).siblings("button").css("cursor", "pointer");

      if (parseFloat(that.dataModel.value) + parseFloat(that.dataModel.stepsNumber) > parseFloat(that.dataModel.maxValue)) {
        addVal = parseFloat(that.dataModel.value)
        $(this).css("cursor", "not-allowed");
      } else {
        addVal = parseFloat((parseFloat(that.dataModel.value) + parseFloat(that.dataModel.stepsNumber)))
      }
      if (that.dataModel.accuracy) {
        that._jqObj.find("input").val(addVal.toFixed(2));
      } else {
        that._jqObj.find("input").val(addVal);
      }

      that.dataModel.value = that._jqObj.find("input").val();
      if (!that._tfp.isDesigning) {
        that.valueOnChange();
        that.exeEventHandler("onChange", that.dataModel.value);
      }
    });

    this._jqObj.find("input").blur(function () {
      let inputVal = $(this).val();
      let val = null;

      if (!/(^[\-0-9][0-9]*(\.[0-9]+)?)$/.test(inputVal)) {
        if (inputVal == '') {
          val = 0;
        } else {
          val = parseFloat(that.dataModel.value);
        }
      } else {
        if (parseFloat(inputVal) < parseFloat(that.dataModel.minValue) && inputVal != '') {
          val = parseFloat(that.dataModel.minValue);
        } else if (parseFloat(inputVal) > parseFloat(that.dataModel.maxValue)) {
          val = parseFloat(that.dataModel.maxValue);
        } else {
          val = parseFloat(inputVal);
        }
      }

      if (that.dataModel.accuracy) {
        $(this).val(val.toFixed(2));
      } else {
        $(this).val(val);
      }

      that.dataModel.value = $(this).val();

      if (!that._tfp.isDesigning) {
        that.valueOnChange();
        that.exeEventHandler("onChange", that.dataModel.value);
      }
    });

    this._jqObj.find("input").keypress(function (even) {
      if (even.which == 13) {
        let inputVal = $(this).val();
        let val = null;

        if (!/(^[\-0-9][0-9]*(\.[0-9]+)?)$/.test(inputVal)) {
          if (inputVal == '') {
            val = 0;
          } else {
            val = parseFloat(that.dataModel.value);
          }
        } else {
          if (parseFloat(inputVal) < parseFloat(that.dataModel.minValue) && inputVal != '') {
            val = parseFloat(that.dataModel.minValue);
          } else if (parseFloat(inputVal) > parseFloat(that.dataModel.maxValue)) {
            val = parseFloat(that.dataModel.maxValue);
          } else {
            val = parseFloat(inputVal);
          }
        }

        if (that.dataModel.accuracy) {
          $(this).val(val.toFixed(2));
        } else {
          $(this).val(val);
        }

        that.dataModel.value = $(this).val();

        if (!that._tfp.isDesigning) {
          that.valueOnChange();
          that.exeEventHandler("onChange", that.dataModel.value);
        }
      }
    });
  }

  initRuntime() {
    let that = this;
    if (that.dataModel.readonly || that.dataModel.disabled) {
      that._jqObj.find("input").attr("disabled", "disabled");
      that._jqObj.find("button").css("cursor", "not-allowed");
      return;
    };
    this.inputNumberChange();
  }
}