import TFPComponentRender from '../render.js'

export default class ImageListRender extends TFPComponentRender {

  constructor(__tfp, _dataModel, _level) {
    super(__tfp, _dataModel, _level);
  }

  getBodyHtml(getComponentsHtml) {
    let html = "\r\n";
    let indent = this.getHtmlIndent();

    if (this._tfp.isDesigning) {
      html += indent + `\r\n<div class="panel-box" style="width: 100%;padding-left: 5px;padding-top: 5px;cursor: pointer;display: flex;align-items: center;  flex-wrap: wrap;">`;
      var imgUrl = this._tfp.rootPath + "/src/components/image/images/default-photo.png";
      html += indent + `
      <div class="image_box"
        style="width: 100px;height:100px;position: relative;
        align-items: center;justify-content: center;margin-bottom: 5px;background: #F7F7F7;margin-right: 5px;display:flex;">
        <img class="tfp-image" src="`+ imgUrl + `" style=" width:100%; height:100%;" alt=\"tfp-image\">
      `;
      html += `</div>`;
    } else {
      html += indent + `\r\n<div class="panel-box" style="width: 100%;padding-left: 5px;padding-top: 5px;cursor: pointer;display: flex;align-items: center;  flex-wrap: wrap;">`;
      html += `</div>`;
    }
    return html + indent;
  }

  getHtml(getComponentsHtml, parentIndent, retainStyleAttr) {
    return super.getHtml("div", getComponentsHtml, parentIndent, retainStyleAttr);
  }
}