import { FormInput } from "../controller.js";

/**
 * 图片组组件
 * @param {[type]} dataModel [description]
 */
export default class ImageList extends FormInput {

  constructor(__tfp, dataModel, parent) {
    super(__tfp, "ImageList", dataModel, parent);
  }

  get value() {
    if (!this.dataModel.value) return [];
    return this.dataModel.value;
  }

  set value(value) {
    if (!value) {
      this.dataModel.value = [];
    } else {
      if (value.indexOf(",") >= 0) {
        this.setHtml(value.split(','));
      } else {
        this.setHtml([value]);
      }
    }
    if (!this._tfp.isDesigning) {
      this.exeEventHandler("onChange");
    }
  }

  setHtml(data) {
    var that = this;
    if (data) {
      let imagesDiv = that._jqObj.find(".panel-box");
      if (!that.dataModel.value) {
        that.dataModel.value = [];
      }
      var imagesize = data.length > 4 ? "100" : "150";
      for (var x = 0; x < data.length; x++) {
        var html = '';
        var src = that._tfp.getUrlRealPath(data[x]);
        var beforesrc = '/Download?showImage=true&fileCode=';
        html += `
        <div class="image_box" data-code="`+ src + x + `"
          style="width: `+ imagesize + `px;height:` + imagesize + `px;position: relative;
          align-items: center;justify-content: center;margin-bottom: 5px;background: #F7F7F7;margin-right: 5px;display:flex;">
          <img class="tfp-image" src="`+ (src.indexOf('http') == -1 ? beforesrc + src : src) + `" style=" width:100%; height:100%;" data-code="` + src + `">
        `;
        html += `</div>`;
        that.dataModel.value.push(src)
        imagesDiv.prepend(html);
        // 查看大图
        this._jqObj.find(".image_box[data-code='" + src + x + "']").find("img").click(function () {
          var code = $(this).attr("data-code");
          if (window.tmClient) {
            alert(window.tmClient.mobileType)
            if (window.tmClient.mobileType == 'renxun') {
              // 任讯
              tmClient.showImage({ imageCode: code });
            } else if (window.tmClient.mobileType == 'dingding') {
              // 钉钉
              window.tmClient.empower(function () {
                window.tmClient.showImage({ imageList: data, imageCode: code }, function () {

                });
              })
            } else if (window.tmClient.mobileType == 'workwx') {
              // 企业微信
              window.tmClient.empower(function () {
                window.tmClient.showImage({ imageList: data, imageCode: code }, function () {

                });
              })
            }
          } else {
            if ($(this).css("height") == imagesize + "px") {
              $(this).parent().css({ "top": "0", "left": "0", "right": "0", "bottom": "0", "position": "fixed", "z-index": "99", "width": "100%", "height": "100%", "background": "black" });
              $(this).css({ "height": "auto" });
            } else {
              $(this).parent().css({ "top": "0", "left": "0", "right": "0", "bottom": "0", "position": "relative", "z-index": "1", "width": imagesize + "px", "height": imagesize + "px", "background": "#F7F7F7" });
              $(this).css({ "height": imagesize + "px" });
            }
          }
        });
      }
    } else {
      return;
    }
  }
}
