import { FormInput } from "../controller.js";

/**
 * 图片组组件
 * @param {[type]} dataModel [description]
 */
export default class ImageList extends FormInput {

  constructor(__tfp, dataModel, parent) {
    super(__tfp, "ImageList", dataModel, parent);
  }

  get value() {
    if (!this.dataModel.value) return [];
    return this.dataModel.value;
  }
  set value(value) {
    if (!value) {
      this.dataModel.value = [];
    } else {
      if (value.indexOf(",") >= 0) {
        this.dataModel.value = value.split(',');
        this.setHtml(value.split(','), 0);
      } else {
        this.dataModel.value = [value];
        this.setHtml([value], 0);
      }
    }

    if (!this._tfp.isDesigning) {
      this.exeEventHandler("onChange");
    }
  }

  get appCode() { return this.dataModel.appCode }
  set appCode(value) {
    this.dataModel.appCode = value;
  }

  get appDataId() { return this.dataModel.appDataId }
  set appDataId(value) {
    this.dataModel.appDataId = value;
  }

  setHtml(data) {
    var that = this;
    if (data) {
      let imagesDiv = that._jqObj.find(".panel-box");
      var imagesize = data.length > 4 ? "100" : "150";
      imagesDiv.children(".image_box").remove();
      for (var x = 0; x < data.length; x++) {
        var html = '';
        var src = that._tfp.getUrlRealPath(data[x]);
        var beforesrc = '/Download?showImage=true&fileCode=';
        html += `
          <div class="image_box" data-code="`+ src + x + `"
          style="width: `+ imagesize + `px;height:` + imagesize + `px;position: relative;
          align-items: center;justify-content: center;margin-bottom: 5px;background: #F7F7F7;margin-right: 5px;display:flex;">
          <img class="tfp-image" src="`+ (src.indexOf('http') == -1 ? beforesrc + src : src) + `" style=" width:100%; height:100%;" data-code="` + src + `"  data-index="` + x + `">`;
        html += `</div>`;
        imagesDiv.append(html);
      }
      this._jqObj.find(".image_box").find("img").click(function () {
        tfp.openImage(JSON.stringify(data), $(this).attr("data-index"));
      })
    } else {
      return;
    }
  }

  onAfterBindData() {
    let args = {};
    if (this.dataModel.appCode && this.dataModel.appDataId) {
      args.app_code = this.dataModel.appCode;
      args.app_data_id = this.dataModel.appDataId;
    }
    //应用代码和应用数据id都设置了才能自动查询附件信息
    if (!args.app_code || !args.app_data_id) return;

    let that = this;
    this._tfp.use("Service", function () {
      var service = that._tfp["new"]("Service");

      service.path = "sys/service/app_attach/getUploadCptVal.tbs";
      service.request(args, function (req, res) {
        if (!res.data) return;
        let val = [];
        res.data.forEach(item => {
          val.push(item.code)
        })
        that.value = val.join(',');
      });
    });
  }
}
