import TFPComponentRender from '../render.js' 

export default class ImageRender extends TFPComponentRender {

  constructor(__tfp, _dataModel, _level) {
    super(__tfp, _dataModel, _level);
  }

  getAttrHtml(retainStyleAttr) {
    let attrHtml = super.getAttrHtml(retainStyleAttr);
    let imgUrl = this.dataModel.src;
    if (this._tfp.isDesigning && (!imgUrl || imgUrl.indexOf('{')>-1)) {
      imgUrl = this._tfp.rootPath + "/src/components/image/images/default-photo.png";
    }
    imgUrl = this._tfp.getUrlRealPath(imgUrl);
    attrHtml += " src=\"" + imgUrl + "\"";
    if(!this.dataModel.alt) attrHtml += " alt=\""+this.dataModel.id+"\"";
    return attrHtml;
  }

  getHtml(getComponentsHtml, parentIndent, retainStyleAttr) {
    return super.getHtml("img", false, parentIndent, retainStyleAttr);
  }
}