import TFPComponentRender from '../render.js'

export default class ImageRender extends TFPComponentRender {

  constructor(__tfp, _dataModel, _level) {
    super(__tfp, _dataModel, _level);
  }

  getAttrHtml(retainStyleAttr, otherOptions) {
    let attrHtml = super.getAttrHtml(retainStyleAttr, otherOptions);

    if (!this._tfp.isDesigning) {
      // if (this.dataModel.dataBindingFormat) {
      if (otherOptions && otherOptions.gridContainer)
        attrHtml += " src=\"{{item." + this.dataModel.id + "}}\"";
      else
        attrHtml += " src=\"{{" + this.dataModel.id + "}}\"";
      // }
    }
    else {
      let imgUrl = this.dataModel.src;
      if (!imgUrl) {
        imgUrl = this._tfp.rootPath + "/src/components/image/images/default-photo.png";
      }
      imgUrl = this._tfp.getUrlRealPath(imgUrl);

      attrHtml += " src=\"" + imgUrl + "\"";
    }
    return attrHtml;
  }

  getHtml(getComponentsHtml, parentIndent, retainStyleAttr) {
    return super.getHtml("img", false, parentIndent, retainStyleAttr);
  }

  getWX(getComponentsHtml, parentIndent, retainStyleAttr, otherOptions) {
    return super.getWX("image", false, parentIndent, retainStyleAttr, otherOptions);
  }
}