import TFPComponentRender from '../render.js'

export default class ImageRender extends TFPComponentRender {
  
  constructor(__tfp, _dataModel, _level) {
  	super(__tfp, _dataModel, _level);
  }

  getImageUrl() {
    let imgUrl = this.dataModel.src;
    if(this._tfp.isDesigning && (!imgUrl || imgUrl.indexOf('{')>-1)) {
      imgUrl = this._tfp.rootPath+"/src/components/image/images/default-photo.png";
    } else {
      imgUrl = this._tfp.getUrlRealPath(imgUrl);
    }
    return imgUrl;
  }

  getAttrHtml(retainStyleAttr) {
    let attrHtml = super.getAttrHtml(retainStyleAttr);
    if(!this._tfp.isDesigning || (this.parentModel && this.parentModel.type=="Table")) {
      attrHtml += " src=\""+this.getImageUrl()+"\"";
    }
    if(!this.dataModel.alt) attrHtml += " alt=\""+this.dataModel.id+"\"";
    return attrHtml;
  }

  //设计时，为了实现拖拽调整位置，需要用div+背景图片的形式，直接用图片无法拖拽
  getCustomStyleHtml() {
    if(this._tfp.isDesigning) {
      return "background-image:url("+this.getImageUrl()+");display:inline-block;background-size:"
        +this.dataModel.styles["width"]+" "+this.dataModel.styles["height"]+";";
    }
    return "";
  }

  getHtml(getComponentsHtml, parentIndent, retainStyleAttr, parentModel) {
    if(this._tfp.isDesigning) {
      return super.getHtml("div", false, parentIndent, retainStyleAttr);
    } else {
      return super.getHtml("img", false, parentIndent, retainStyleAttr);
    }
  }
}