import {VisibleComponent} from "../controller.js";

/**
 * 图片组件
 * @param {[type]} dataModel [description]
 */
export default class Image extends VisibleComponent {

  constructor(__tfp, dataModel, parent) {
    super(__tfp, "Image", dataModel, parent);
  }

  get src() { return this.dataModel.src }
  set src(value) { 
    this.dataModel.src = value;
    if (value && value.indexOf("{") > -1 && value.indexOf("}") > -1) {
      this.dataModel.dataBindingFormat = value;
    }
    if (!this._tfp.isDesigning && value) {
      if (value && (value.indexOf("http") > -1 || value.indexOf("?") > -1 
        || value.indexOf("&") > -1 || value.indexOf("/") > -1 
        || value.indexOf(".") > -1 || value.indexOf("{") > -1)) {
        value = this._tfp.getUrlRealPath(value);
      } else {
        //value = this._tfp.getUrlRealPath(value);
        value = `/Download?showImage=true&fileCode=` + value
      }
      this._jqObj.attr("src", value);
    } else {
      if (value && value.indexOf("{") > -1 && value.indexOf("}") > -1) {
        value = this._tfp.rootPath + "/src/components/image/images/default-photo.png";
      } else {
        value = this._tfp.getUrlRealPath(value)
      }
      this._jqObj.attr("src", value);
    }

    // if(this._jqObj) {
    //   let src = value;
    //   if(this._tfp.isDesigning && src) src = this._tfp.getUrlRealPath(src);
    //   this._jqObj.attr("src", src);
    // }
  }

  get alt() { return this.dataModel.alt }
  set alt(value) { 
    this.dataModel.alt = value;
    if(this._jqObj) {
      this._jqObj.attr("alt", value);
    }
  }

  get title() { return this.dataModel.title }
  set title(value) { 
    this.dataModel.title = value;
    if(this._jqObj) {
      this._jqObj.attr("title", value);
    }
  }
}