import {VisibleComponent} from "../controller.js";

/**
 * 图片组件
 * @param {[type]} dataModel [description]
 */
export default class Image extends VisibleComponent {

  constructor(__tfp, dataModel, parent) {
    super(__tfp, "Image", dataModel, parent);
  }

  get src() { return this.dataModel.src }
  set src(value) { 
    this.dataModel.src = value;
    if (value && value.indexOf("{") > -1 && value.indexOf("}") > -1) {
      this.dataModel.dataBindingFormat = value;
    }
    if (!this._tfp.isDesigning && value) {
      if (value && (value.indexOf("http") > -1 || value.indexOf("?") > -1 
        || value.indexOf("&") > -1 || value.indexOf("/") > -1 
        || value.indexOf(".") > -1 || value.indexOf("{") > -1)) {
        value = this._tfp.getUrlRealPath(value);
      } else {
        value = `/Download?showImage=true&fileCode=` + value
      }
      this._jqObj.attr("src", value);
    } else {
      if (value && value.indexOf("{") > -1 && value.indexOf("}") > -1) {
        value = this._tfp.rootPath + "/src/components/image/images/default-photo.png";
      } else {
        value = this._tfp.getUrlRealPath(value)
      }
      if(this._tfp.isDesigning) {
        this._jqObj.css("background-image", "url("+value+")");
      } else {
        this._jqObj.attr("src", value);
      }
    }
  }

  get alt() { return this.dataModel.alt }
  set alt(value) { 
    this.dataModel.alt = value;
    if(this._jqObj) {
      this._jqObj.attr("alt", value);
    }
  }

  get title() { return this.dataModel.title }
  set title(value) { 
    this.dataModel.title = value;
    if(this._jqObj) {
      this._jqObj.attr("title", value);
    }
  }

  styleOnChange(styleName, styleValue) {
    if(this._tfp.isDesigning && (styleName=="width" || styleName=="height")) 
      this._jqObj.css("background-size", this.dataModel.styles["width"]+" "+this.dataModel.styles["height"]);
  }

  initDesigning() {
    if(this._jqObj) {
      if(this._jqObj.parent().length>0 && this._jqObj.parent().get(0).tagName=="TD") {
        this._jqObj.css("vertical-align", "middle");
        if(!(this.dataModel.styles && this.dataModel.styles.display)) this._jqObj.css("display", "inline-block");
      }
    }
  }

  initRuntime() {
    this.initDesigning();
  }
}