import TFPComponentRender from '../render.js'

export default class IframeRender extends TFPComponentRender {
  
  constructor(__tfp, _dataModel, _level) {
  	super(__tfp, _dataModel, _level);
  }

  getAttrHtml() {
    var attrHtml = "";
    if(!this._tfp.isDesigning) {
      attrHtml += " frameborder=\""+this.dataModel.frameBorder+"\" marginwidth=\""
        +this.dataModel.marginWidth+"\" marginheight=\""+this.dataModel.marginHeight+"\"";
      if(this.dataModel.src) attrHtml += " src=\""+this.dataModel.src+"\"";
      if(this.dataModel.scrolling) attrHtml += " scrolling=\""+this.dataModel.scrolling+"\"";
      if(this.metadata.events) {
        for(var i=0;i<this.metadata.events.length;i++) {
          let eventInfo = this.metadata.events[i];
          if(eventInfo.name in this.dataModel) {
            attrHtml += " "+eventInfo.name.toLowerCase()+"=\""+this.dataModel[eventInfo.name]+"\""
          }
        }
      }
    }
    return attrHtml;
  }

  getBodyHtml(getComponentsHtml) {
    let bodyHtml = "\r\n";
    let indent = this.getHtmlIndent();
    if(this._tfp.isDesigning) {
      bodyHtml += indent+"\t<iframe frameborder=\""+this.dataModel.frameBorder
        +"\" marginwidth=\""+this.dataModel.marginWidth+"\" marginheight=\""
        +this.dataModel.marginHeight+"\" width=\"100%\" height=\"100%\"";
      if(this.dataModel.src) bodyHtml += " src=\""+this.dataModel.src+"\"";
      if(this.dataModel.scrolling) bodyHtml += " scrolling=\""+this.dataModel.scrolling+"\"";
      bodyHtml += "></iframe>\r\n";
      bodyHtml += indent+"\t<div style=\"position: absolute; z-index:2; top:0; left:0; "
        +"right:0; bottom:0; opacity: 0.1; background-color:#ffffff;\">\r\n";
    }
    return bodyHtml;
  }

  getHtml(getComponentsHtml, parentIndent, retainStyleAttr) {
    if(this._tfp.isDesigning) {
      return super.getHtml("div", false, parentIndent, retainStyleAttr);
    } else {
      return super.getHtml("iframe", false, parentIndent, retainStyleAttr);
    }
  }
}