import TFPComponentRender from '../render.js'

export default class IconPickerRender extends TFPComponentRender {
  
  constructor(__tfp, _dataModel, _level) {
  	super(__tfp, _dataModel, _level);
  }

  getBodyHtml = function (getComponentsHtml) {
    let html = "\r\n";
    let indent = this.getHtmlIndent();
    let bgColor = '#ffffff';
    let size = parseInt(this.dataModel.size);
    if (this.dataModel.value && this.dataModel.value.type == 'iconfont') bgColor = this.dataModel.value.bgColor;
    if (this.dataModel.showChooseBtn) {
      html += indent + "  <button class='tfp-iconpicker-choose'>选择</button>\r\n";
    }
    let imgStyle = "";
    let imgTitle = "";
    if(!this.dataModel.readonly) {
      imgStyle = "cursor: pointer;";
      imgTitle = "title='选择图标'";
    }
    if (size < 64) {
      html += indent + "  <div class='tfp-iconpicker-image' style='background-color:"
        + bgColor + "; width:" + size + "px; height:" + size
        + "px; margin-left: calc(50% - " + size / 2 + "px);"+imgStyle+"' "+imgTitle+">\r\n";
    }else{
      html += indent + "  <div class='tfp-iconpicker-image' style='background-color:"
        + bgColor + "; width:" + size + "px; height:" + size + "px;"+imgStyle+"' "+imgTitle+">\r\n";
    }
    if (this.dataModel.value) {
      if (this.dataModel.value.type == "iconfont") {
        html += indent + '    <span class="' + this.dataModel.value.class + '" style="font-size: calc(' + size + 'px / 1.3); color:'
          + this.dataModel.value.color + '"></span>\r\n';
      } else {
       html += indent + '    <img src="'+this.dataModel.value.url+'" style="width:'+size+'px; height:'+size+'px;"></img>\r\n';
      }
    } else {
      let imgUrl = this._tfp.rootPath+"/src/components/iconpicker/images/default-icon.png";
      html += indent + '    <img src="'+imgUrl+'" style="width:'+(size/1.3)+'px; height:'+(size/1.3)+'px;"></img>\r\n';
    }
    html += indent + "  </div>\r\n";
    return html+indent;
  }

  getHtml(getComponentsHtml, parentIndent, retainStyleAttr) {
    return super.getHtml("div", false, parentIndent, retainStyleAttr);
  }
}