export default {
  "name": "IconPicker",
  "comment": "图标",
  "cssFiles": [
    "style.{bgColorMode}.css",
    {
      "src": "/node_modules/tfp/src/components/iconpicker/iconfont/iconfont.css",
      "onlyRuntime": true
    }
  ],
  "attrs": [
    {
      "name": "inputSetting",
      "comment": "输入项设置",
      "type": "group",
      "items": [
        {
          "name": "value",
          "comment": "组件值",
          "type": "String"
        },
        {
          "name": "dataBindingFormat",
          "comment": "数据绑定格式",
          "type": "String"
        },
        {
          "name": "required",
          "comment": "必填",
          "type": "Switch"
        },
        {
          "name": "readonly",
          "comment": "只读",
          "type": "Switch",
          "isHtmlAttr": true
        },
        {
          "name": "showChooseBtn",
          "comment": "显示选择按钮",
          "type": "Switch",
          "default": true
        },
        {
          "name": "size",
          "comment": "图标大小",
          "type": "Select",
          "default": "64",
          "options": [
            {
              "value": "16",
              "text": "16x16"
            },
            {
              "value": "24",
              "text": "24x24"
            },
            {
              "value": "32",
              "text": "32x32"
            },
            {
              "value": "48",
              "text": "48x48"
            },
            {
              "value": "64",
              "text": "64x64"
            },
            {
              "value": "96",
              "text": "96x96"
            },
            {
              "value": "128",
              "text": "128x128"
            },
            {
              "value": "256",
              "text": "256x256"
            }
          ]
        },
      ]
    },
    {
      "name": "iconType",
      "comment": "图标类型",
      "type": "group",
      "items": [
        {
          "name": "iconChoose",
          "comment": "从图标库选择",
          "type": "Switch",
          "default": true
        },
        {
          "name": "localChoose",
          "comment": "从本地上传",
          "type": "Switch",
          "default": true
        },
        {
          "name": "urlChoose",
          "comment": "输入URL地址",
          "type": "Switch",
          "default": true
        }
      ]
    }
  ],
  "styles": ["position", "margin", "other"],
  "defaultStyles": {
  },
  "events": [
    {
      "name": "onAfterInitRuntime",
      "comment": "组件初始化后",
      "isNotHtmlEvent": true
    }, {
      "name": "onClick",
      "comment": "点击时"
    }, {
      "name": "onMouseOver",
      "comment": "鼠标经过时"
    }, {
      "name": "onMouseOut",
      "comment": "鼠标移出时"
    }, {
      "name": "onChange",
      "comment": "值发生变化时",
      "isNotHtmlEvent": true
    }],
}