import { FormInput } from "../controller.js";

/**
 * 图标组件
 * @param {[type]} dataModel [description]
 */
export default class IconPicker extends FormInput {

  constructor(__tfp, dataModel, parent) {
    super(__tfp, "IconPicker", dataModel, parent);
  }

  get value() { return this.dataModel.value }
  set value(value) {
    let val = value;
    if (!val) {
      this._jqObj.find(".tfp-iconpicker-image").empty();
      this._jqObj.find(".tfp-iconpicker-image").css("background-color", "#ffffff");
      this.dataModel.value = null;
      return;
    }

    if (typeof (val) == "string") {
      if (val.indexOf("{") == 0 && val.indexOf("\"type\"") > 0) {
        val = JSON.parse(val);
      } else {
        //TODO url
        val = {
          type: "url",
          url: val
        };
      }
    }
    this.dataModel.value = val;

    if (!this._jqObj) return;

    let html = "";
    if (val.type == "iconfont") {
      html = '<span class="' + this.dataModel.value.class + '"></span>';
      this._jqObj.find(".tfp-iconpicker-image").empty().append(html);
      this._jqObj.find(".tfp-iconpicker-image").children("span").css({
        "font-size": "calc(" + this.dataModel.size + "px / 1.3)",
        "color": this.dataModel.value.color
      });
      this._jqObj.find(".tfp-iconpicker-image").css("background-color", this.dataModel.value.bgColor);
    } else {
      html = '<img src="' + this.dataModel.value.url + '" style="width:' + this.dataModel.size + '; height:' + this.dataModel.size + ';"></img>';
      this._jqObj.find(".tfp-iconpicker-image").empty().append(html);
      this._jqObj.find(".tfp-iconpicker-image").css("background-color", "#ffffff");
    }

    if (!this._tfp.isDesigning) {
      this.valueOnChange();
      this.exeEventHandler("onChange", this.dataModel.value);
    }
  }

  get iconChoose() { return this.dataModel.iconChoose }
  set iconChoose(value) {
    this.dataModel.iconChoose = value ? true : false;
  }

  get localChoose() { return this.dataModel.localChoose }
  set localChoose(value) {
    this.dataModel.localChoose = value ? true : false;
  }

  get urlChoose() { return this.dataModel.urlChoose }
  set urlChoose(value) {
    this.dataModel.urlChoose = value ? true : false;
  }

  get showChooseBtn() { return this.dataModel.showChooseBtn }
  set showChooseBtn(value) {
    this.dataModel.showChooseBtn = value ? true : false;
    if (this._jqObj) {
      if (this.dataModel.showChooseBtn) {
        this._jqObj.find(".tfp-iconpicker-choose").show();
      } else {
        this._jqObj.find(".tfp-iconpicker-choose").hide();
      }
    }
  }

  get size() { return this.dataModel.size }
  set size(value) {
    let size = "64";
    if (value) size = value;
    this.dataModel.size = parseInt(size);
    if (this._jqObj) {
      this._jqObj.find(".tfp-iconpicker-image").css({
        "width": this.dataModel.size + "px",
        "height": this.dataModel.size + "px",
        "margin-left": "calc(50% - " + this.dataModel.size / 2 + "px)"
      });
      if (this._tfp.isDesigning && !this.dataModel.value) {
        let imgSize = Math.round(this.dataModel.size / 1.3);
        this._jqObj.find(".tfp-iconpicker-image").children("img").css({ "width": imgSize + "px", "height": imgSize + "px" });
      } else {
        if (this.dataModel.value.type == "url") {
          this._jqObj.find(".tfp-iconpicker-image").children("img").css({
            "width": this.dataModel.size + "px",
            "height": this.dataModel.size + "px"
          });
        } else {
          this._jqObj.find(".iconfont").css("font-size", imgSize + "px");
        }
      }
    }
  }

  showIconPicker() {
    if(this.readonly) return;
    let args = {
      iconChoose: this.dataModel.iconChoose,
      localChoose: this.dataModel.localChoose,
      urlChoose: this.dataModel.urlChoose
    };
    //sessionStorage.setItem('_OpenDialogArgs', JSON.stringify(args));
    let that = this;
    this._tfp.openDialog("选择图标", "/node_modules/tfp/src/components/iconpicker/IconPicker.tfp", '594px', '458px', args, function (ret) {
      that.value = ret;
    });
  }

  initRuntime() {
    let that = this;
    let btnIconPicker = this._jqObj.find(".tfp-iconpicker-choose");
    btnIconPicker.click(function () {
      that.showIconPicker();
    });
    let imgIconPicker = this._jqObj.find(".tfp-iconpicker-image");
    imgIconPicker.click(function () {
      that.showIconPicker();
    });
  }
}