import TFPComponentRender from '../render.js'

export default class IconRender extends TFPComponentRender {

  constructor(__tfp, _dataModel, _level) {
    super(__tfp, _dataModel, _level);
  }

  getSpecialClass() {
    let iconClass = ' iconfont icon-album';
    if (this.dataModel.icon && this.dataModel.icon.class !== 'undefined') iconClass = " " + this.dataModel.icon.class + "";
    return iconClass;
  }

  getAttrHtml(retainStyleAttr) {
    let attrHtml = super.getAttrHtml(retainStyleAttr);
    let iconSize = this.dataModel.iconSize;
    if (!iconSize) iconSize = '30';
    let iconRadius = this.dataModel.iconRadius;
    if (!iconRadius) iconRadius = '4';
    let iconColor = '#000';
    if (this.dataModel.icon && this.dataModel.icon.color !== 'undefined') iconColor = this.dataModel.icon.color;
    let iconBgColor = '#fff';
    if (this.dataModel.icon && this.dataModel.icon.bgColor !== 'undefined') iconBgColor = this.dataModel.icon.bgColor;
    attrHtml += " style=\"font-size:" + iconSize + "px;border-radius:" + iconRadius + "px;color:" + iconColor + ";background-color:" + iconBgColor + ";\"";
    return attrHtml;
  }

  getBodyHtml(getComponentsHtml) {
    return "";
  }

  getHtml(getComponentsHtml, parentIndent, retainStyleAttr) {
    return super.getHtml("span", false, parentIndent, retainStyleAttr);
  }
}