import { VisibleComponent } from "../controller.js";

/**
 * 小图标组件
 * @param {[type]} dataModel [description]
 */
export default class Icon extends VisibleComponent {

  constructor(__tfp, dataModel, parent) {
    super(__tfp, "Icon", dataModel, parent);
  }

  get icon() { return this.dataModel.icon }
  set icon(value) {
    this.dataModel.icon = value;

    if (JSON.stringify(value) == '{}') value = undefined;
    let iconClass = 'iconfont icon-album';
    if (value && value.class !== 'undefined') iconClass = " " + value.class + "";
    let iconColor = '#000';
    if (value && value.color !== 'undefined') iconColor = value.color;
    let iconBgColor = '#fff';
    if (value && value.bgColor !== 'undefined') iconBgColor = value.bgColor;

    this._jqObj.attr("class", "tfp-icon " + iconClass + "");
    this._jqObj.css("color", "" + iconColor + "");
    this._jqObj.css("background-color", "" + iconBgColor + "");
  }

  get iconSize() { return this.dataModel.iconSize }
  set iconSize(value) {
    this.dataModel.iconSize = value;
    if (this._jqObj) {
      this._jqObj.css("font-size", "" + value + "px");
    }
  }

  get iconRadius() { return this.dataModel.iconRadius }
  set iconRadius(value) {
    this.dataModel.iconRadius = value;
    if (this._jqObj) {
      this._jqObj.css("border-radius", "" + value + "px");
    }
  }
}