import { FormInput } from "../controller.js";

/**
 * 隐藏域组件
 * @param {[type]} dataModel [description]
 */
export default class Hidden extends FormInput {

  constructor(__tfp, dataModel, parent) {
    super(__tfp, "Hidden", dataModel, parent);
  }

  //属性
  get value () { return this.dataModel.value }
  set value (value) {
    this.dataModel.value = value;
    if (this._jqObj) {
      this._jqObj.val(value);
    }
    if (!this._tfp.isDesigning) {
      this.valueOnChange();
      this.exeEventHandler("onChange", value);
    }
  }

  initRuntime () {
    let that = this;
    this._jqObj.change(function () {
      that.dataModel.value = that._jqObj.val();
      that.valueOnChange();
      that.exeEventHandler("onChange", that.dataModel.value);
    });
  }
}