import { VisibleComponent } from "../controller.js";

/**
 * 标题组件
 * @param {[type]} dataModel [description]
 */
export default class Heading extends VisibleComponent {

  constructor(__tfp, dataModel, parent) {
    super(__tfp, "Heading", dataModel, parent);
  }

  //标题值
  get value() {
    if (!this.dataModel.value) return this.headLevel.replace("h", "标题");
    return this.dataModel.value;
  }
  set value(value) {
    this.dataModel.value = value;
    if (this._jqObj) {
      this._jqObj.text(value);
      this.exeEventHandler("onChange");
    }
  }

  get headLevel() { return this.dataModel.headLevel ? this.dataModel.headLevel : "h1" }

  set headLevel(value) {
    this.dataModel.headLevel = value;
    if (this._jqObj) {
      let nextEl = null;
      if(this._jqObj.next().length>0) nextEl = this._jqObj.next();
      let parentEl = this._jqObj.parent();
      this._jqObj.remove();

      let Render = this._tfp.renders[this.type];
      let render = new Render(this._tfp, this.dataModel, this.level);

      if(nextEl) {
        nextEl.before(render.getHtml());
      } else {
        parentEl.append(render.getHtml());
      }
      this._jqObj = $("#" + this.id);
      this.el = this._jqObj.get(0);
      if (this._tfp.isDesigning) {
        this._tfp.initCptDesignSetting(this);
        window.parent.uiDesigner.selectCptEl(this);
        //this._jqObj.css("outline", "#CCCCCC dashed 1px");
      }
    }
  }

}