export default {
  "name": "GridView",
  "comment": "数据表格",
  "cssFiles": [
    "style.{bgColorMode}.pc.css",
    "/node_modules/tfp/src/components/button/style.{bgColorMode}.css",
    {
      "src": "/node_modules/tfp/src/components/iconpicker/iconfont/iconfont.css",
      "onlyRuntime": true
    },
    {
      "src": "/node_modules/tfp/src/components/button/iconfont/iconfont.css",
      "onlyRuntime": true
    },
    {
      "src": "/node_modules/tfp/src/components/iconpicker/iconfont/iconfont_tb.css",
      "onlyDesigning": true
    },
    {
      "src": "/node_modules/tfp/src/components/button/iconfont/iconfont_tb.css",
      "onlyDesigning": true
    }
  ],
  "attrs": [
    {
      "name": "dataBindSetting",
      "comment": "数据绑定设置",
      "type": "group",
      "items": [
        {
          "name": "dataQuerySetting",
          "comment": "数据查询设置",
          "type": "Dialog",
          "path": "taskbuilder-tfp-designer/DataQuerySetting.tfp",
          "width": "800px",
          "height": "640px"
        },
        {
          "name": "columns",
          "comment": "表格列设置",
          "type": "Dataset",
          "isGridCol": true,
          "keyCol": "name",
          "width": "800px",
          "height": "600px",
          "columns": [
            {
              "name": "base",
              "comment": "基本信息",
              "type": "group",
              "items": [
                {
                  "id": "name",
                  "name": "列名",
                  "type": "String",
                  "required": true
                },
                {
                  "id": "contentType",
                  "name": "内容类型",
                  "type": "Select",
                  "default": "text",
                  "options": [
                    {
                      "value": "text",
                      "text": "文本"
                    },
                    {
                      "value": "image",
                      "text": "图片"
                    },
                    {
                      "value": "switch",
                      "text": "开关"
                    },
                    {
                      "value": "progress",
                      "text": "进度条"
                    },
                    {
                      "value": "custom",
                      "text": "自定义"
                    }
                  ]
                },
                {
                  "id": "align",
                  "name": "水平对齐方式",
                  "type": "Select",
                  "default": "center",
                  "options": [
                    {
                      "value": "left",
                      "text": "左对齐"
                    },
                    {
                      "value": "center",
                      "text": "居中对齐"
                    },
                    {
                      "value": "right",
                      "text": "右对齐"
                    }
                  ]
                },
                {
                  "id": "valign",
                  "name": "垂直对齐方式",
                  "type": "Select",
                  "options": [
                    {
                      "value": "top",
                      "text": "顶端对齐"
                    },
                    {
                      "value": "center",
                      "text": "居中对齐"
                    },
                    {
                      "value": "right",
                      "text": "底部对齐"
                    }
                  ]
                },
                {
                  "id": "width",
                  "name": "列宽度",
                  "type": "Size"
                },
                {
                  "id": "fill",
                  "name": "宽度弹性伸缩",
                  "type": "Switch"
                },
                {
                  "id": "fixed",
                  "name": "位置固定",
                  "type": "Switch"
                },
                {
                  "id": "bgColor",
                  "name": "背景颜色",
                  "type": "Color"
                },
                {
                  "id": "format",
                  "name": "数据绑定表达式",
                  "type": "String",
                  "wrap": true
                },
                {
                  "id": "class",
                  "name": "CSS样式class",
                  "type": "String",
                  "wrap": true
                },
                {
                  "id": "style",
                  "name": "自定义CSS样式",
                  "type": "String",
                  "wrap": true
                }
              ]
            },
            {
              "name": "text",
              "comment": "文本设置",
              "type": "group",
              "items": [
                {
                  "id": "dataFormat",
                  "name": "内容格式",
                  "type": "Select",
                  "default": "text",
                  "options": [
                    {
                      "value": "text",
                      "text": "文本"
                    },
                    {
                      "value": "int",
                      "text": "整数"
                    },
                    {
                      "value": "decimal",
                      "text": "小数"
                    },
                    {
                      "value": "filesize",
                      "text": "文件大小：xxxKB,xxxMB,xxxGB,xxxTB"
                    },
                    {
                      "value": "money|0.00",
                      "text": "金额：0.00"
                    },
                    {
                      "value": "money|0,000.00",
                      "text": "金额：0,000.00"
                    },
                    {
                      "value": "week",
                      "text": "星期：X"
                    },
                    {
                      "value": "week|星期",
                      "text": "星期：星期X"
                    },
                    {
                      "value": "date|yyyy",
                      "text": "年份：yyyy"
                    },
                    {
                      "value": "date|MM",
                      "text": "月份：MM"
                    },
                    {
                      "value": "date|yyyy-MM",
                      "text": "年月：yyyy-MM"
                    },
                    {
                      "value": "date|yyyy/MM",
                      "text": "年月：yyyy/MM"
                    },
                    {
                      "value": "date|yyyy-MM-dd",
                      "text": "日期：yyyy-MM-dd"
                    },
                    {
                      "value": "date|yyyy/MM/dd",
                      "text": "日期：yyyy/MM/dd"
                    },
                    {
                      "value": "date|yyyy年MM月dd日",
                      "text": "日期：yyyy年MM月dd日"
                    },
                    {
                      "value": "date|MM-dd",
                      "text": "日期：MM-dd"
                    },
                    {
                      "value": "date|MM/dd",
                      "text": "日期：MM/dd"
                    },
                    {
                      "value": "date|MM月dd日",
                      "text": "日期：MM月dd日"
                    },
                    {
                      "value": "date|dd",
                      "text": "日期：dd"
                    },
                    {
                      "value": "time|HH:mm",
                      "text": "时间：HH:mm"
                    },
                    {
                      "value": "time|HH:mm:ss",
                      "text": "时间：HH:mm:ss"
                    },
                    {
                      "value": "time|HH时mm分",
                      "text": "时间：HH时mm分"
                    },
                    {
                      "value": "time|HH时mm分ss秒",
                      "text": "时间：HH时mm分ss秒"
                    },
                    {
                      "value": "datetime|yyyy-MM-dd HH:mm",
                      "text": "日期时间：yyyy-MM-dd HH:mm"
                    },
                    {
                      "value": "datetime|yyyy-MM-dd HH:mm:ss",
                      "text": "日期时间：yyyy-MM-dd HH:mm:ss"
                    },
                    {
                      "value": "datetime|yyyy/MM/dd HH:mm",
                      "text": "日期时间：yyyy/MM/dd HH:mm"
                    },
                    {
                      "value": "datetime|yyyy/MM/dd HH:mm:ss",
                      "text": "日期时间：yyyy/MM/dd HH:mm:ss"
                    },
                    {
                      "value": "datetime|yyyy年MM月dd日 HH:mm",
                      "text": "日期时间：yyyy年MM月dd日 HH:mm"
                    },
                    {
                      "value": "datetime|yyyy年MM月dd日 HH:mm:ss",
                      "text": "日期时间：yyyy年MM月dd日 HH:mm:ss"
                    },
                    {
                      "value": "datetime|yyyy年MM月dd日 HH时mm分",
                      "text": "日期时间：yyyy年MM月dd日 HH时mm分"
                    },
                    {
                      "value": "datetime|yyyy年MM月dd日 HH时mm分ss秒",
                      "text": "日期时间：yyyy年MM月dd日 HH时mm分ss秒"
                    }
                  ]
                },
                {
                  "id": "decimalCalcReg",
                  "name": "小数取值规则",
                  "type": "Select",
                  "default": "",
                  "options": [
                    {
                      "value": "",
                      "text": "不处理"
                    },
                    {
                      "value": "trunc",
                      "text": "取整"
                    },
                    {
                      "value": "round",
                      "text": "四舍五入"
                    },
                    {
                      "value": "ceil",
                      "text": "向上取整"
                    },
                    {
                      "value": "floor",
                      "text": "向下取整"
                    },
                    {
                      "value": "toFixed",
                      "text": "固定精度"
                    },
                    {
                      "value": "toPrecision",
                      "text": "固定长度"
                    },
                    {
                      "value": "abs",
                      "text": "求绝对值"
                    }
                  ]
                },
                {
                  "id": "decimalLength",
                  "name": "小数位数",
                  "type": "Number"
                },
                {
                  "id": "maxLength",
                  "name": "最多显示字符数(汉字算2位)",
                  "type": "Number"
                },
                {
                  "id": "fontSize",
                  "name": "文字字号",
                  "type": "Number"
                },
                {
                  "id": "color",
                  "name": "文字颜色",
                  "type": "Color"
                },
                {
                  "id": "bold",
                  "name": "文字加粗",
                  "type": "Switch"
                },
                {
                  "id": "nowrap",
                  "name": "不允许换行",
                  "type": "Switch"
                },
                {
                  "id": "sum",
                  "name": "计算合计值",
                  "type": "Switch"
                },
                {
                  "id": "groupContent",
                  "name": "分组显示内容",
                  "type": "Switch"
                },
                {
                  "id": "groupSubTotal",
                  "name": "显示分组小计",
                  "type": "Switch"
                },
                {
                  "id": "subTotalRowBgColor",
                  "name": "小计行背景颜色",
                  "type": "Color"
                },
                {
                  "id": "icon",
                  "name": "文本前面显示小图标",
                  "type": "Icon"
                },
                {
                  "id": "iconSize",
                  "name": "小图标大小",
                  "type": "Size",
                  "default": 20
                },
                {
                  "id": "iconRadius",
                  "name": "小图标圆角",
                  "type": "Size",
                  "default": 4
                }
              ]
            },
            {
              "name": "image",
              "comment": "图片设置",
              "type": "group",
              "items": [
                {
                  "id": "imgWidth",
                  "name": "图片宽度",
                  "type": "Size"
                },
                {
                  "id": "imgHeight",
                  "name": "图片高度",
                  "type": "Size"
                }
              ]
            },
            {
              "name": "switch",
              "comment": "开关设置",
              "type": "group",
              "items": [
                {
                  "id": "selectedValue",
                  "name": "开关选中值",
                  "type": "String"
                }
              ]
            },
            {
              "name": "display",
              "comment": "显示条件",
              "type": "group",
              "items": [
              ]
            },
            {
              "name": "crossTable",
              "comment": "行转列设置",
              "type": "group",
              "items": [
                {
                  "id": "rowDataConvertToCol",
                  "name": "转换类型",
                  "type": "Select",
                  "options": [
                    {
                      "value": "",
                      "text": "不转换"
                    },
                    {
                      "value": "title",
                      "text": "转换为列标题(只支持1列)"
                    },
                    {
                      "value": "data",
                      "text": "转换为列数据"
                    }
                  ]
                },
                {
                  "id": "crossTableTimeGroupType",
                  "name": "按时间分组显示",
                  "type": "Select",
                  "options": [
                    {
                      "value": "",
                      "text": "不按时间分组"
                    },
                    {
                      "value": "day",
                      "text": "按日分组"
                    },
                    {
                      "value": "week",
                      "text": "按周分组"
                    },
                    {
                      "value": "month",
                      "text": "按月分组"
                    }
                  ]
                },
                {
                  "id": "crossTableShowRowsSum",
                  "name": "显示纵向合计值",
                  "type": "Switch"
                },
                {
                  "id": "crossTableShowColsSum",
                  "name": "显示横向合计值",
                  "type": "Switch"
                },
                {
                  "id": "crossTableShowColsMin",
                  "name": "显示横向最小值",
                  "type": "Switch"
                },
                {
                  "id": "crossTableShowColsMax",
                  "name": "显示横向最大值",
                  "type": "Switch"
                },
                {
                  "id": "crossTableShowColsAvg",
                  "name": "显示横向平均值",
                  "type": "Switch"
                },
                {
                  "id": "crossTableShowColsPercent",
                  "name": "显示横向百分比",
                  "type": "Switch"
                },
                {
                  "id": "crossTableDefaultCellVal",
                  "name": "值为空时显示",
                  "type": "String",
                  "default": "0"
                }
              ]
            }
          ]
        }
      ]
    },
    {
      "name": "headerSetting",
      "comment": "表头设置",
      "type": "group",
      "items": [
        {
          "name": "showHeader",
          "comment": "显示表头",
          "type": "Switch",
          "default": true
        },
        {
          "name": "headerBold",
          "comment": "标题加粗",
          "type": "Switch",
          "default": true
        },
        {
          "name": "headerBgColor",
          "comment": "标题栏背景色",
          "type": "Color",
          "default": "#F9F9F9"
        },
        {
          "name": "headerTextColor",
          "comment": "标题栏文字颜色",
          "type": "Color",
          "default": "#333333"
        },
        {
          "name": "headerHeight",
          "comment": "标题栏高度",
          "type": "Number",
          "default": "40"
        }
      ]
    },
    {
      "name": "bodySetting",
      "comment": "表体设置",
      "type": "group",
      "items": [
        {
          "name": "showRowNum",
          "comment": "显示序号",
          "type": "Switch",
          "default": false
        },
        {
          "name": "showBorder",
          "comment": "显示边框",
          "type": "Switch",
          "default": true
        },
        {
          "name": "borderColor",
          "comment": "边框颜色",
          "type": "Color",
          "default": "#000000"
        },
        {
          "name": "singleRowBgColor",
          "comment": "奇数行背景色",
          "type": "Color",
        },
        {
          "name": "doubleRowBgColor",
          "comment": "偶数行背景色",
          "type": "Color"
        },
        {
          "name": "rowHeight",
          "comment": "行高",
          "type": "Number",
          "default": "30"
        }
      ]
    },
    {
      "name": "footerSetting",
      "comment": "表尾设置",
      "type": "group",
      "items": [
        {
          "name": "showSumer",
          "comment": "显示合计栏",
          "type": "Switch"
        }
      ]
    }
  ],
  "styles": ["size", "position", "background", "border", "margin", "other"],
  "defaultStyles": {
    "width": "400",
    "height": "71px",
    "position": "absolute",
    "left": 0,
    "top": 0
  },
  "events": [],
  "methods": []
}