import {
  ContainerComponent
} from "../controller.js";

/**
 * 数据表格组件
 * @param {[type]} dataModel [description]
 */
export default class GridView extends ContainerComponent {

  constructor(__tfp, dataModel, parent) {
    super(__tfp, "GridView", dataModel, parent);

    this.curPage = 1;
    this.pageCount = 0;
    this.rowsCount = 0;
    this.headerResizeStartX = 0;
    this.fixedColCount = 0;
    this.fixedOnRightColCount = 0;
    this.indexColWidth = 50;
    this.selectedRowIndex = -1;
    this.dataList = [];
    this.orders = [];
  }

  /*******************  数据绑定设置  *******************/

  get loadDataService() {
    return this.dataModel.loadDataService
  }
  set loadDataService(value) {
    this.dataModel.loadDataService = value
  }

  get dataBindingMember() {
    return this.dataModel.dataBindingMember
  }
  set dataBindingMember(value) {
    this.dataModel.dataBindingMember = value
  }

  get dataBindingKey() {
    return this.dataModel.dataBindingKey
  }
  set dataBindingKey(value) {
    this.dataModel.dataBindingKey = value
  }

  get delDataService() {
    return this.dataModel.delDataService
  }
  set delDataService(value) {
    this.dataModel.delDataService = value
  }

  get notAutoLoadData() {
    return this.dataModel.notAutoLoadData ? true : false;
  }
  set notAutoLoadData(value) {
    this.dataModel.notAutoLoadData = value ? true : false;
  }

  /*******************  容器设置  *******************/

  get hasAttachedChilds() {
    return true
  }

  getContainerEl(cptId) {
    let cpt = tfp.get(cptId);
    return this.body.find(".tfp-grid-datalist-cell").get(cpt.cellIndex);
  }

  /*******************  工具栏设置  *******************/

  get showToolBar() {
    return this.dataModel.showToolBar ? true : false;
  }
  set showToolBar(value) {
    this.dataModel.showToolBar = value ? true : false;
    if (this._jqObj) {
      this.reRender();
    }
  }

  get showKeywordInput() {
    return this.dataModel.showKeywordInput ? true : false;
  }
  set showKeywordInput(value) {
    this.dataModel.showKeywordInput = value ? true : false;
    this.setKeywordDataQuerySetting();
    if (this._jqObj) {
      this.reRender();
    }
  }

  get queryKeywordFields() {
    return this.dataModel.queryKeywordFields;
  }
  set queryKeywordFields(value) {
    this.dataModel.queryKeywordFields = value;
    this.setKeywordDataQuerySetting();
  }

  get showImportButton() {
    return this.dataModel.showImportButton ? true : false;
  }
  set showImportButton(value) {
    this.dataModel.showImportButton = value ? true : false;
    if (this._jqObj) {
      this.reRender();
    }
  }

  get showExportButton() {
    return this.dataModel.showExportButton ? true : false;
  }
  set showExportButton(value) {
    this.dataModel.showExportButton = value ? true : false;
    if (this._jqObj) {
      this.reRender();
    }
  }

  get showPrintButton() {
    return this.dataModel.showPrintButton ? true : false;
  }
  set showPrintButton(value) {
    this.dataModel.showPrintButton = value ? true : false;
    if (this._jqObj) {
      this.reRender();
    }
  }

  get showPageExportButton() {
    return this.dataModel.showPageExportButton ? true : false;
  }
  set showPageExportButton(value) {
    this.dataModel.showPageExportButton = value ? true : false;
    if (this._jqObj) {
      this.reRender();
    }
  }

  get onlyExportCheckedRow() {
    return this.dataModel.onlyExportCheckedRow ? true : false;
  }
  set onlyExportCheckedRow(value) {
    this.dataModel.onlyExportCheckedRow = value ? true : false;
  }

  get pageExportFileName() {
    return this.dataModel.pageExportFileName;
  }
  set pageExportFileName(value) {
    this.dataModel.pageExportFileName = value;
  }

  get printReportPath() {
    return this.dataModel.printReportPath;
  }
  set printReportPath(value) {
    this.dataModel.printReportPath = value;
  }

  get showCustomQueryButton() {
    return this.dataModel.showCustomQueryButton ? true : false;
  }
  set showCustomQueryButton(value) {
    this.dataModel.showCustomQueryButton = value ? true : false;
    if (this._jqObj) {
      this.reRender();
    }
  }

  get showCustomOrderButton() {
    return this.dataModel.showCustomOrderButton ? true : false;
  }
  set showCustomOrderButton(value) {
    this.dataModel.showCustomOrderButton = value ? true : false;
    if (this._jqObj) {
      this.reRender();
    }
  }

  get showFilterColButton() {
    return this.dataModel.showFilterColButton ? true : false;
  }
  set showFilterColButton(value) {
    this.dataModel.showFilterColButton = value ? true : false;
    if (this._jqObj) {
      this.reRender();
    }
  }

  get toolButtons() { return this.dataModel.toolButtons }
  set toolButtons(buttons) {
    if (buttons && Array.isArray(buttons)) {
      this.dataModel.toolButtons = buttons;
      if (this._jqObj) {
        this.reRender();
      }
    }
  }

  /*******************  表头设置  *******************/

  get showHeader() {
    return this.dataModel.showHeader ? true : false;
  }
  set showHeader(value) {
    this.dataModel.showHeader = value ? true : false;
    if (this._jqObj) {
      this.reRender();
    }
  }

  get headerBold() {
    if (this.dataModel.headerBold == undefined || this.dataModel.headerBold == null) return true;
    return this.dataModel.headerBold ? true : false;
  }
  set headerBold(value) {
    this.dataModel.headerBold = value ? true : false;
    if (this._jqObj) {
      if (this.dataModel.headerBold) {
        this.header.find("div").css("font-weight", "bold");
      } else {
        this.header.find("div").css("font-weight", "normal");
      }
    }
  }

  get headerBgColor() {
    return this.dataModel.headerBgColor ? this.dataModel.headerBgColor : "#F2F2F2";
  }
  set headerBgColor(value) {
    this.dataModel.headerBgColor = value;
    if (this._jqObj) {
      this.header.css("background-color", value);
      this.header.find(".tfp-grid-header-checkbox").css("background-color", value);
      this.header.find(".tfp-grid-header-index").css("background-color", value);
      this.header.find(".tfp-grid-header-col").css("background-color", value);
    }
  }

  get headerTextColor() {
    return this.dataModel.headerTextColor ? this.dataModel.headerTextColor : "#333333";
  }
  set headerTextColor(value) {
    this.dataModel.headerTextColor = value;
    if (this._jqObj) {
      this.header.find(".tfp-grid-header-checkbox").css("color", value);
      this.header.find(".tfp-grid-header-index").css("color", value);
      this.header.find(".tfp-grid-header-col").css("color", value);
    }
  }

  get headerHeight() {
    return this.dataModel.headerHeight ? this.dataModel.headerHeight : 40;
  }
  set headerHeight(value) {
    if (!value) return;
    let height = parseInt((value + "").replace("px", ""));
    this.dataModel.headerHeight = height;
    if (this._jqObj) {
      this.reRender();
    }
  }

  /*******************  表体设置  *******************/

  get showRowNum() {
    return this.dataModel.showRowNum ? true : false;
  }
  set showRowNum(value) {
    this.dataModel.showRowNum = value ? true : false;
    this.reRender();
  }

  get showBorder() {
    return this.dataModel.showBorder ? true : false;
  }
  set showBorder(value) {
    this.dataModel.showBorder = value ? true : false;
    this.reRender();
  }

  get showCheckbox() {
    return this.dataModel.showCheckbox ? true : false;
  }
  set showCheckbox(value) {
    this.dataModel.showCheckbox = value ? true : false;
    this.reRender();
  }

  get notChangeBgColorOnMouseOver() {
    return this.dataModel.notChangeBgColorOnMouseOver ? true : false;
  }
  set notChangeBgColorOnMouseOver(value) {
    this.dataModel.notChangeBgColorOnMouseOver = value ? true : false;
  }

  get borderColor() {
    return this.dataModel.borderColor ? this.dataModel.borderColor : "#E6E6E6";
  }
  set borderColor(value) {
    this.dataModel.borderColor = value;
    this.reRender();
  }

  get singleRowBgColor() {
    if (this.dataModel.singleColor) return this.dataModel.singleColor;
    return this.dataModel.singleRowBgColor;
  }
  set singleRowBgColor(value) {
    this.dataModel.singleRowBgColor = value;
    if (this._jqObj) {
      if (this._tfp.isDesigning) {
        this.reRender();
      } else {
        for (let i = 0; i < this.dataList.length; i++) {
          if (i % 2 == 0) {
            if (this.showCheckbox) {
              this.bodyFixedBox.children(".tfp-grid-datalist-checkbox").children(".tfp-grid-datalist-cell").eq(i).css("background-color", value);
            }
            if (this.showRowNum) {
              this.bodyFixedBox.children(".tfp-grid-datalist-index").children(".tfp-grid-datalist-cell").eq(i).css("background-color", value);
            }
            if (this.fixedColCount == this.dataModel.columns.length) {
              this.bodyFixedBox.children(".tfp-grid-fill-col").children(".tfp-grid-datalist-cell").eq(i).css("background-color", value);
            } else {
              this.bodyScrollBox.children(".tfp-grid-fill-col").children(".tfp-grid-datalist-cell").eq(i).css("background-color", value);
            }
            if (this.showBorder) {
              this.bodyFixedBox.children(".tfp-grid-datalist-border").each(function () {
                let borderCell = $(this).children(".tfp-grid-datalist-cell-border").eq(i);
                if (borderCell.attr("group-content")) return;
                borderCell.css("background-color", value);
              });
              this.bodyScrollBox.children(".tfp-grid-datalist-border").each(function () {
                let borderCell = $(this).children(".tfp-grid-datalist-cell-border").eq(i);
                if (borderCell.attr("group-content")) return;
                borderCell.css("background-color", value);
              });
              this.bodyFixedRightBox.children(".tfp-grid-datalist-border").each(function () {
                let borderCell = $(this).children(".tfp-grid-datalist-cell-border").eq(i);
                if (borderCell.attr("group-content")) return;
                borderCell.css("background-color", value);
              });
            }
            this.setRowBgColor(i, value);
          }
        }
      }
    }
  }

  get doubleRowBgColor() {
    if (this.dataModel.doubleColor) return this.dataModel.doubleColor;
    return this.dataModel.doubleRowBgColor;
  }
  set doubleRowBgColor(value) {
    this.dataModel.doubleRowBgColor = value;
    if (this._jqObj) {
      if (this._tfp.isDesigning) {
        this.reRender();
      } else {
        for (let i = 0; i < this.dataList.length; i++) {
          if (i % 2 == 1) {
            if (this.showCheckbox) {
              this.bodyFixedBox.children(".tfp-grid-datalist-checkbox").children(".tfp-grid-datalist-cell").eq(i).css("background-color", value);
            }
            if (this.showRowNum) {
              this.bodyFixedBox.children(".tfp-grid-datalist-index").children(".tfp-grid-datalist-cell").eq(i).css("background-color", value);
            }
            if (this.fixedColCount == this.columns.length) {
              this.bodyFixedBox.children(".tfp-grid-fill-col").children(".tfp-grid-datalist-cell").eq(i).css("background-color", value);
            } else {
              this.bodyScrollBox.children(".tfp-grid-fill-col").children(".tfp-grid-datalist-cell").eq(i).css("background-color", value);
            }
            if (this.showBorder) {
              this.bodyFixedBox.children(".tfp-grid-datalist-border").each(function () {
                let borderCell = $(this).children(".tfp-grid-datalist-cell-border").eq(i);
                if (borderCell.attr("group-content")) return;
                borderCell.css("background-color", value);
              });
              this.bodyScrollBox.children(".tfp-grid-datalist-border").each(function () {
                let borderCell = $(this).children(".tfp-grid-datalist-cell-border").eq(i);
                if (borderCell.attr("group-content")) return;
                borderCell.css("background-color", value);
              });
              this.bodyFixedRightBox.children(".tfp-grid-datalist-border").each(function () {
                let borderCell = $(this).children(".tfp-grid-datalist-cell-border").eq(i);
                if (borderCell.attr("group-content")) return;
                borderCell.css("background-color", value);
              });
            }
            this.setRowBgColor(i, value);
          }
        }
      }
    }
  }

  get selectedRowBgColor() {
    return this.dataModel.selectedRowBgColor;
  }
  set selectedRowBgColor(value) {
    this.dataModel.selectedRowBgColor = value;
  }

  get rowHeight() {
    return this.dataModel.rowHeight
  }
  set rowHeight(value) {
    this.dataModel.rowHeight = value;
    if (this._jqObj) {
      if (this._tfp.isDesigning) {
        this.reRender();
      } else {
        let height = this._tfp.formatPx(value);
        if (this.showCheckbox) {
          this.bodyFixedBox.children(".tfp-grid-datalist-checkbox").children(".tfp-grid-datalist-cell").css("flex-basis", height);
        }
        if (this.showRowNum) {
          this.bodyFixedBox.children(".tfp-grid-datalist-index").children(".tfp-grid-datalist-cell").css("flex-basis", height);
        }
        if (this.fixedColCount == this.columns.length) {
          this.bodyFixedBox.children(".tfp-grid-fill-col").children(".tfp-grid-datalist-cell").css("flex-basis", height);
        } else {
          this.bodyScrollBox.children(".tfp-grid-fill-col").children(".tfp-grid-datalist-cell").css("flex-basis", height);
        }
        if (this.showBorder) {
          this.bodyFixedBox.children(".tfp-grid-datalist-border").children(".tfp-grid-datalist-cell-border").css("flex-basis", height);
          this.bodyScrollBox.children(".tfp-grid-datalist-border").children(".tfp-grid-datalist-cell-border").css("flex-basis", height);
          this.bodyFixedRightBox.children(".tfp-grid-datalist-border").children(".tfp-grid-datalist-cell-border").css("flex-basis", height);
        }
        for (let i = 0; i < this.dataList.length; i++) {
          let row = this.getRow(i);
          for (let j = 0; j < row.cells.length; j++) {
            let cell = row.cells[j];
            if (j == 0) console.log(i, cell.get(0));
            if (cell.attr("data-group-rows-count")) {
              let rowsCount = parseInt(cell.attr("data-group-rows-count"));
              let sumRowsCount = parseInt(cell.attr("data-group-sum-rows-count"));
              let h = this._tfp.getPx(value);
              h = (rowsCount * h + sumRowsCount * 40) + "px";
              cell.css("flex-basis", h);
              if (this.showBorder && cell.parent().prev().length > 0 && cell.parent().next().hasClass("tfp-grid-datalist-border")) {
                cell.parent().prev().children(".tfp-grid-datalist-cell-border").eq(i).css("flex-basis", h);
              }
            } else {
              cell.css("flex-basis", height);
            }
          }
        }
        this.onResize();
      }
    }
  }

  get columns() {
    let columns = this.dataModel.columns;
    if (!columns) {
      columns = [];
      if (this._tfp.isDesigning) {
        //不能直接修改this.columns，以免保存到tfp文件中
        columns = [{
          name: "列标题1",
          width: "100px",
          align: "center"
        }, {
          name: "列标题2",
          width: "100px",
          align: "center"
        }];
      }
    }
    return columns;
  }
  set columns(value) {
    this.dataModel.columns = value;

    if (this._jqObj) {
      if (!this.dataModel.components) this.dataModel.components = [];
      let components = [];
      for (let i = 0; i < this.dataModel.columns.length; i++) {
        let col = this.dataModel.columns[i];
        if (col.contentType == "custom") {
          let cellCdm = null;
          for (let j = 0; j < this.dataModel.components.length; j++) {
            let cdm = this.dataModel.components[j];
            if (cdm.cellIndex == col.oldIndex) {
              cellCdm = cdm;
              cellCdm.cellIndex = i;
              break;
            }
          }
          //如果原来不是自定义的列，现在变成自定义了，或者新增的自定义列，则需要增加到子组件数组中
          if (!cellCdm) {
            cellCdm = {
              type: "GridCell",
              isAttached: true,
              cellIndex: i
            };
          }
          components.push(JSON.parse(JSON.stringify(cellCdm)));
        }
        delete col["oldIndex"];
      }
      //删除原有的子组件及DOM元素
      for (let i = 0; i < this.dataModel.components.length; i++) {
        let cdmChild = this.dataModel.components[i];
        /*let cellIndex = cdmChild.cellIndex;
        //如果某个列的类型原来就是自定义，需要保留设置
        if(!(cellIndex>=this.dataModel.columns.length || this.dataModel.columns[i].contentType!="custom")) {
          components.push(JSON.parse(JSON.stringify(cdmChild)));
        }*/
        tfp.remove(cdmChild.id);
      }
      //重置子组件列表
      this.dataModel.components = [];

      //重新渲染数据表格组件（不包括子组件）
      this.reRender();

      //重置子组件列表
      this.dataModel.components = components;

      //重新渲染子组件
      for (let i = 0; i < components.length; i++) {
        let cdmChild = components[i];
        cdmChild.id = this.id + "_cell_" + cdmChild.cellIndex;
        tfp.render(cdmChild, this);
      }
    }
  }

  /*******************  表尾设置  *******************/

  get showSumer() {
    return this.dataModel.showSumer
  }
  set showSumer(value) {
    this.dataModel.showSumer = value ? true : false;
    if (this._jqObj) {
      this.resetFooter();
    }
  }

  get allowPaging() {
    return this.dataModel.allowPaging ? true : false;
  }
  set allowPaging(value) {
    this.dataModel.allowPaging = value ? true : false;
    if (this._jqObj) {
      this.resetFooter();
    }
    if (this._tfp.curPage.dataModel.cptDataBindSetting) {
      let dataBindSetting = this._tfp.curPage.dataModel.cptDataBindSetting[this.id];
      if (dataBindSetting && dataBindSetting.dataQuerySetting) {
        dataBindSetting.dataQuerySetting.enableDataPage = this.dataModel.allowPaging;
      }
    }
  }

  get pageSize() {
    return this.dataModel.pageSize ? this.dataModel.pageSize : 20
  }
  set pageSize(value) {
    this.dataModel.pageSize = value ? value : 20
  }

  /*******************  jQuery对象映射  *******************/

  get header() {
    return this._jqObj.children(".tfp-grid-header");
  }
  set header(value) {
    //
  }

  get body() {
    return this._jqObj.children(".tfp-grid-datalist");
  }
  set body(value) {
    //
  }

  get sumer() {
    return this._jqObj.children(".tfp-grid-sumer");
  }
  set sumer(value) {
    //
  }

  get footer() {
    return this._jqObj.children(".tfp-grid-footer");
  }
  set footer(value) {
    //
  }

  get headerFixedBox() {
    return this.header.children(".tfp-grid-header-fixed");
  }
  set headerFixedBox(value) {
    //
  }

  get headerScroll() {
    return this.header.children(".tfp-grid-header-scroll");
  }
  set headerScroll(value) {
    //
  }

  get headerScrollBox() {
    return this.header.children(".tfp-grid-header-scroll").children(".tfp-grid-header-scroll-box");
  }
  set headerScrollBox(value) {
    //
  }

  get headerFixedRightBox() {
    return this.header.children(".tfp-grid-header-fixed-right");
  }
  set headerFixedRightBox(value) {
    //
  }

  get bodyFixedBox() {
    return this.body.children(".tfp-grid-datalist-fixed");
  }
  set bodyFixedBox(value) {
    //
  }

  get bodyScroll() {
    return this.body.children(".tfp-grid-datalist-scroll");
  }
  set bodyScroll(value) {
    //
  }

  get bodyScrollBox() {
    return this.body.children(".tfp-grid-datalist-scroll").children(".tfp-grid-datalist-scroll-box");
  }
  set bodyScrollBox(value) {
    //
  }

  get bodyFixedRightBox() {
    return this.body.children(".tfp-grid-datalist-fixed-right");
  }
  set bodyFixedRightBox(value) {
    //
  }

  get sumerFixedBox() {
    return this.sumer.children(".tfp-grid-sumer-fixed");
  }
  set sumerFixedBox(value) {
    //
  }

  get sumerScroll() {
    return this.sumer.children(".tfp-grid-sumer-scroll");
  }
  set sumerScroll(value) {
    //
  }

  get sumerScrollBox() {
    return this.sumer.children(".tfp-grid-sumer-scroll").children(".tfp-grid-sumer-scroll-box");
  }
  set sumerScrollBox(value) {
    //
  }

  get sumerFixedRightBox() {
    return this.sumer.children(".tfp-grid-sumer-fixed-right");
  }
  set sumerFixedRightBox(value) {
    //
  }

  /*******************  树形显示设置  *******************/

  get showTree() {
    return this.dataModel.showTree ? true : false;
  }
  set showTree(value) {
    this.dataModel.showTree = value ? true : false;
  }

  get expandAllNode() {
    return this.dataModel.expandAllNode ? true : false;
  }
  set expandAllNode(value) {
    this.dataModel.expandAllNode = value ? true : false;
  }

  get dynamicLoadChildNodes() {
    return this.dataModel.dynamicLoadChildNodes ? true : false;
  }
  set dynamicLoadChildNodes(value) {
    this.dataModel.dynamicLoadChildNodes = value ? true : false;
  }

  get treeColIndex() {
    return this.dataModel.treeColIndex
  }
  set treeColIndex(value) {
    this.dataModel.treeColIndex = parseInt(value);
  }

  get nodeIdField() {
    return this.dataModel.nodeIdField
  }
  set nodeIdField(value) {
    this.dataModel.nodeIdField = value;
  }

  get parentNodeIdField() {
    return this.dataModel.parentNodeIdField
  }
  set parentNodeIdField(value) {
    this.dataModel.parentNodeIdField = value;
  }

  get rootNodeId() {
    return this.dataModel.rootNodeId
  }
  set rootNodeId(value) {
    this.dataModel.rootNodeId = value;
  }

  get rowDataIdField() {
    return this.dataModel.rowDataIdField
  }
  set rowDataIdField(value) {
    this.dataModel.rowDataIdField = value;
  }

  get rowDataParentIdField() {
    return this.dataModel.rowDataParentIdField
  }
  set rowDataParentIdField(value) {
    this.dataModel.rowDataParentIdField = value;
  }

  /*******************  组件方法  *******************/

  /**
   * 重新渲染合计栏和底部栏
   */
  resetFooter() {
    let divSumer = this._jqObj.children(".tfp-grid-sumer");
    if (divSumer.length > 0) divSumer.remove();
    let divFooter = this._jqObj.children(".tfp-grid-footer");
    if (divFooter.length > 0) divFooter.remove();
    if (this.showSumer) this._jqObj.append(this.getSumerHtml());
    if (this.allowPaging) this._jqObj.append(this.getFooterHtml());
    this.resetDataListPosition();
  }

  /**
   * 组件重新渲染后需要重新绑定自定义单元格里各个组件的DOM对象
   * 并且需要进行设计时初始化
   * @param {*} cdm 
   * @returns 
   */
  reBindCustomCellCptDOM(cdm) {
    let cpt = this._tfp.get(cdm.id);
    if (!cpt) return;
    cpt._jqObj = $("#" + cpt.id);
    cpt.el = cpt._jqObj.get(0);
    this._tfp.initCptDesignSetting(cpt);
    if (cpt.dataModel.components && cpt.dataModel.components.length > 0) {
      for (let i = 0; i < cpt.dataModel.components.length; i++) {
        this.reBindCustomCellCptDOM(cpt.dataModel.components[i]);
      }
    }
  }

  /**
   * 重新渲染整个组件
   */
  reRender() {
    this._jqObj.empty();
    let Render = this._tfp.renders[this.type];
    if (Render) {
      let render = new Render(this._tfp, this.dataModel, this.level);
      this._jqObj.html(render.getBodyHtml(false));

      if (this._tfp.isDesigning && this.dataModel.components && this.dataModel.components.length > 0) {
        let cellCdm = null;
        let indent = this.getHtmlIndent();
        let CellRender = this._tfp.renders["GridCell"];
        for (let i = 0; i < this.dataModel.components.length; i++) {
          let cellCdm = this.dataModel.components[i];
          this.setCptDataFormat(cellCdm);
          let cellRender = new CellRender(this._tfp, cellCdm);
          let cellHtml = cellRender.getHtml(true, indent, true);
          let cellDiv = this.getCell(0, cellCdm.cellIndex);
          cellDiv.html(cellHtml);
          this.reBindCustomCellCptDOM(cellCdm);
        }
      }
    }

    this.initDesigning();
  }

  openPrintReport() {
    if (!this.dataModel.printReportPath) return;
    let url = this.dataModel.printReportPath;
    //如果设置了查询的请求参数，则绑定到服务对象上
    if (this.dataModel.dataQuerySetting && this.dataModel.dataQuerySetting.requestArgs
      && this.dataModel.dataQuerySetting.requestArgs.length > 0) {
      let args = {};
      tfp.getRequestArgs(args, this.dataModel.dataQuerySetting.requestArgs);
      for (var argName in args) {
        if (!tfp.isNull(args[argName])) {
          url += url.indexOf("?") < 0 ? "?" : "&";
          url += argName + "=" + args[argName];
        }
      }
    }
    tfp.openReport(url);
  }

  checkAllFilterCols(el) {
    if (el.checked) {
      $("#" + this.id + "_FilterColDialog").find(".tfp-grid-col-filter-list").find("input").prop("checked", true);
    } else {
      $("#" + this.id + "_FilterColDialog").find(".tfp-grid-col-filter-list").find("input").prop("checked", false);
    }
  }

  closeFilterColDialog() {
    $("#" + this.id + "_FilterColDialog").remove();
  }

  filterCols() {
    let that = this;
    let hideCols = [];
    $("#" + this.id + "_FilterColDialog").find(".tfp-grid-col-filter-list").find("input").each(function (index) {
      let col = that.columns[index];
      if (this.checked) {
        if (col.hidden) {
          that.showColumn(index);
        }
      } else {
        if (!col.hidden) {
          that.hideColumn(index);
        }
        hideCols.push(index);
      }
    });
    tfp.setCptSettingCache(this.id, "HiddenCols", hideCols);
    this.closeFilterColDialog();
  }

  openFilterColDialog(el) {
    event.stopPropagation();
    $("#" + this.id + "_FilterColDialog").remove();
    let x = $("#" + this.id).offset().left + $("#" + this.id).width() - 264;
    let y = $("#" + this.id).offset().top + 40;
    $("body").append(`<div id="${this.id}_FilterColDialog" class="tfp-grid-col-filter" onclick="event.stopPropagation()" style="left:${x}px;top:${y}px;">
      <div class="tfp-grid-col-filter-checkall">
        <input type="checkbox" style="margin-left: 14px;" onclick="${this.id}.checkAllFilterCols(this)">
        <label style="margin-left: 10px;">全选</label>
      </div>
      <div class="tfp-grid-col-filter-list"></div>
      <div class="tfp-grid-col-filter-footer">
        <div class="tfp-button tfp-button-primary tfp-button-rect" onclick="${this.id}.filterCols()">确定</div>
        <div class="tfp-button tfp-button-default tfp-button-rect" style="margin-left:15px;" onclick="${this.id}.closeFilterColDialog()">关闭</div>
      </div>
    </div>`);
    let filterDialog = $("#" + this.id + "_FilterColDialog");
    let haveHiddenCol = false;
    for (var i = 0; i < this.columns.length; i++) {
      var col = this.columns[i];
      let checked = "";
      if (col.hidden) {
        haveHiddenCol = true;
      } else {
        checked = " checked";
      }
      filterDialog.find(".tfp-grid-col-filter-list").append(`<div>
        <input type="checkbox" class="tfp-grid-col-filter-checkbox"${checked}>
        <label>${col.name}</label>
      </div>`);
    }
    if (!haveHiddenCol) filterDialog.children(".tfp-grid-col-filter-checkall").find("input").prop("checked", true);
    filterDialog.children(".tfp-grid-col-filter-list").find("div").click(function () {
      $(this).find('input').prop('checked', !$(this).find('input').get(0).checked);
      if (filterDialog.children(".tfp-grid-col-filter-list").find("input").length
        == filterDialog.children(".tfp-grid-col-filter-list").find("input:checked").length) {
        filterDialog.children(".tfp-grid-col-filter-checkall").find("input").prop("checked", true);
      } else {
        filterDialog.children(".tfp-grid-col-filter-checkall").find("input").prop("checked", false);
      }
    });
    filterDialog.children(".tfp-grid-col-filter-list").find("input").click((el) => {
      if (filterDialog.children(".tfp-grid-col-filter-list").find("input").length
        == filterDialog.children(".tfp-grid-col-filter-list").find("input:checked").length) {
        filterDialog.children(".tfp-grid-col-filter-checkall").find("input").prop("checked", true);
      } else {
        filterDialog.children(".tfp-grid-col-filter-checkall").find("input").prop("checked", false);
      }
      event.stopPropagation();
    });
    window._curGridPopDialog = filterDialog;
  }

  checkAllFilterValues(el) {
    if (el.checked) {
      $("#" + this.id + "_FilterColDataDialog").find(".tfp-grid-col-filter-list").find("input").prop("checked", true);
    } else {
      $("#" + this.id + "_FilterColDataDialog").find(".tfp-grid-col-filter-list").find("input").prop("checked", false);
    }
  }

  closeFilterColDataDialog() {
    $("#" + this.id + "_FilterColDataDialog").remove();
  }

  filterColData(colIndex) {
    let col = this.columns[colIndex];
    col.checkedFilterValues = [];
    $("#" + this.id + "_FilterColDataDialog").children(".tfp-grid-col-filter-list").find("input").each((index, el) => {
      if ($(el).get(0).checked) col.checkedFilterValues.push($(el).val());
    });
    if (col.checkedFilterValues.length == 0) {
      tfp.showMsg("至少需要选择一个数据值！");
      return;
    }
    this.closeFilterColDataDialog();
    if (!this.originalDataList) this.originalDataList = this.dataList;
    let rows = JSON.parse(JSON.stringify(this.originalDataList));
    let newDataList = [];
    rows.forEach(rowData => {
      let isHiddenRow = false;
      for (var j = 0; j < this.columns.length; j++) {
        let colTmp = this.columns[j];
        if (colTmp.allowFilter && !colTmp.groupContent && !colTmp.rowDataConvertToCol) {
          let colVal = null;
          try {
            colVal = this._tfp.replaceDataField(rowData, colTmp.format);
            colVal = this._tfp.exeExpress(colVal);
            if (colTmp.checkedFilterValues && !colTmp.checkedFilterValues.contains(colVal)) isHiddenRow = true;
          } catch (e) {
            console.log(e);
          }
        }
      }
      if (!isHiddenRow) newDataList.push(rowData);
    });
    this.bindData(newDataList);
  }

  openFilterColDataDialog(colIndex, el) {
    event.stopPropagation();
    $("#" + this.id + "_FilterColDataDialog").remove();
    let x = $(el).offset().left;
    let y = $("#" + this.id).offset().top + parseInt(this.headerHeight) + (this.showToolBar ? 52 : 0);
    let col = this.columns[colIndex];
    let checkAll = "";
    if (!col.checkedFilterValues) checkAll = " checked";
    $("body").append(`<div id="${this.id}_FilterColDataDialog" class="tfp-grid-col-filter" onclick="event.stopPropagation()" style="left:${x}px;top:${y}px;">
      <div class="tfp-grid-col-filter-checkall">
        <input type="checkbox" style="margin-left: 14px;" ${checkAll} onclick="${this.id}.checkAllFilterValues(this)">
        <label style="margin-left: 10px;">全选</label>
      </div>
      <div class="tfp-grid-col-filter-list"></div>
      <div class="tfp-grid-col-filter-footer">
        <div class="tfp-button tfp-button-primary tfp-button-rect" onclick="${this.id}.filterColData(${colIndex})">确定</div>
        <div class="tfp-button tfp-button-default tfp-button-rect" style="margin-left:15px;" onclick="${this.id}.closeFilterColDataDialog()">关闭</div>
      </div>
    </div>`);
    if (!col.filterValues || col.filterValues.length == 0) return;
    let filterColDataDialog = $("#" + this.id + "_FilterColDataDialog");
    for (var i = 0; i < col.filterValues.length; i++) {
      var val = col.filterValues[i];
      let checked = "";
      if (!col.checkedFilterValues || (col.checkedFilterValues && col.checkedFilterValues.contains(val))) {
        checked = " checked";
      }
      filterColDataDialog.find(".tfp-grid-col-filter-list").append(`<div>
        <input type="checkbox" class="tfp-grid-col-filter-checkbox"${checked} value="${val}">
        <label>${val}</label>
      </div>`);
    }
    filterColDataDialog.children(".tfp-grid-col-filter-list").find("div").click(function () {
      $(this).find('input').prop('checked', !$(this).find('input').get(0).checked);
      if (filterColDataDialog.children(".tfp-grid-col-filter-list").find("input").length
        == filterColDataDialog.children(".tfp-grid-col-filter-list").find("input:checked").length) {
        filterColDataDialog.children(".tfp-grid-col-filter-checkall").find("input").prop("checked", true);
      } else {
        filterColDataDialog.children(".tfp-grid-col-filter-checkall").find("input").prop("checked", false);
      }
    });
    filterColDataDialog.children(".tfp-grid-col-filter-list").find("input").click((el) => {
      if (filterColDataDialog.children(".tfp-grid-col-filter-list").find("input").length
        == filterColDataDialog.children(".tfp-grid-col-filter-list").find("input:checked").length) {
        filterColDataDialog.children(".tfp-grid-col-filter-checkall").find("input").prop("checked", true);
      } else {
        filterColDataDialog.children(".tfp-grid-col-filter-checkall").find("input").prop("checked", false);
      }
      event.stopPropagation();
    });
    window._curGridPopDialog = filterColDataDialog;
  }

  setCustomOrders() {
    this.orders = [];
    let customOrderDialog = $("#" + this.id + "_CustomOrderDialog");
    customOrderDialog.children(".tfp-grid-custom-order-right").find("input").each((index, item) => {
      this.orders.push({
        field: $(item).val(),
        type: $(item).parent().find("select").val(),
        comment: $(item).parent().find("label").text()
      });
    });
    tfp.setCptSettingCache(this.id, "Orders", this.orders);
    this.closeCustomOrderDialog();
    this.reloadData();
  }

  closeCustomOrderDialog() {
    $("#" + this.id + "_CustomOrderDialog").remove();
  }

  addCustomOrderField(field) {
    let comment = field.comment;
    if (!comment) comment = field.field;
    $("#" + this.id + "_CustomOrderDialog").find(".tfp-grid-custom-order-right").append(`<div>
      <input type="checkbox" value="${field.field}">
      <label onclick="$(this).prev().prop('checked', !$(this).prev().get(0).checked)">${comment}</label>
      <select style="float:right;margin-right:10px;margin-top:4px;border:1px solid #CCCCCC;color: #666666;">
        <option value="asc" selected>正序</option>
        <option value="desc">倒序</option>
      </select>
    </div>`);
  }

  addCustomOrder() {
    let customOrderDialog = $("#" + this.id + "_CustomOrderDialog");
    customOrderDialog.children(".tfp-grid-custom-order-left").find("input").each((index, item) => {
      if ($(item).get(0).checked) {
        this.dataModel.customOrderFields.forEach(field => {
          if (field.name == $(item).val()) {
            let comment = field.comment;
            if (!comment) comment = field.name;
            customOrderDialog.find(".tfp-grid-custom-order-right").append(`<div>
              <input type="checkbox" value="${field.name}">
              <label onclick="$(this).prev().prop('checked', !$(this).prev().get(0).checked)">${comment}</label>
              <select style="float:right;margin-right:10px;margin-top:4px;border:1px solid #CCCCCC;color: #666666;">
                <option value="asc" selected>正序</option>
                <option value="desc">倒序</option>
              </select>
            </div>`);
            $(item).parent().remove();
          }
        });
      }
    });
  }

  delCustomOrder() {
    let customOrderDialog = $("#" + this.id + "_CustomOrderDialog");
    customOrderDialog.children(".tfp-grid-custom-order-right").find("input").each((index, item) => {
      if ($(item).get(0).checked) {
        this.dataModel.customOrderFields.forEach(field => {
          if (field.name == $(item).val()) {
            let comment = field.comment;
            if (!comment) comment = field.name;
            customOrderDialog.find(".tfp-grid-custom-order-left").append(`<div>
              <input type="checkbox" value="${field.name}">
              <label onclick="$(this).prev().prop('checked', !$(this).prev().get(0).checked)">${comment}</label>
            </div>`);
            $(item).parent().remove();
          }
        });
      }
    });
  }

  clearCustomOrder() {
    let customOrderDialog = $("#" + this.id + "_CustomOrderDialog");
    customOrderDialog.children(".tfp-grid-custom-order-right").find("input").each((index, item) => {
      this.dataModel.customOrderFields.forEach(field => {
        if (field.name == $(item).val()) {
          let comment = field.comment;
          if (!comment) comment = field.name;
          customOrderDialog.find(".tfp-grid-custom-order-left").append(`<div>
            <input type="checkbox" value="${field.name}">
            <label onclick="$(this).prev().prop('checked', !$(this).prev().get(0).checked)">${comment}</label>
          </div>`);
          $(item).parent().remove();
        }
      });
    });
  }

  openCustomOrderDialog(el) {
    event.stopPropagation();
    $("#" + this.id + "_CustomOrderDialog").remove();
    let x = $("#" + this.id).offset().left + $("#" + this.id).width() - 500;
    let y = $("#" + this.id).offset().top + 40;
    $("body").append(`<div id="${this.id}_CustomOrderDialog" class="tfp-grid-custom-order" onclick="event.stopPropagation()" style="left:${x}px;top:${y}px;">
      <div class="tfp-grid-custom-order-left-title">
        <div><label style="font-weight:bold;">可选排序字段</label></div>
      </div>
      <div class="tfp-grid-custom-order-left"></div>
      <div class="tfp-grid-custom-order-center">
        <div class="tfp-button tfp-button-primary tfp-button-rect" onclick="${this.id}.addCustomOrder()">添加</div>
        <div class="tfp-button tfp-button-warning tfp-button-rect" style="margin-top: 20px;" onclick="${this.id}.delCustomOrder()">删除</div>
        <div class="tfp-button tfp-button-danger tfp-button-rect" style="margin-top: 20px;" onclick="${this.id}.clearCustomOrder()">清空</div>
      </div>
      <div class="tfp-grid-custom-order-right-title">
        <div><label style="font-weight:bold;">已选排序字段</label></div>
      </div>
      <div class="tfp-grid-custom-order-right"></div>
      <div class="tfp-grid-custom-order-footer">
        <div class="tfp-button tfp-button-primary tfp-button-rect" onclick="${this.id}.setCustomOrders()">确定</div>
        <div class="tfp-button tfp-button-default tfp-button-rect" style="margin-left:15px;" onclick="${this.id}.closeCustomOrderDialog()">关闭</div>
      </div>
    </div>`);
    let customOrderDialog = $("#" + this.id + "_CustomOrderDialog");
    for (var i = 0; i < this.dataModel.customOrderFields.length; i++) {
      var field = this.dataModel.customOrderFields[i];
      let isAdd = false;
      this.orders.forEach(order => {
        if (order.field == field.name) {
          isAdd = true;
          return;
        }
      });
      if (isAdd) continue;
      let comment = field.comment;
      if (!comment) comment = field.name;
      customOrderDialog.find(".tfp-grid-custom-order-left").append(`<div>
        <input type="checkbox" value="${field.name}">
        <label onclick="$(this).prev().prop('checked', !$(this).prev().get(0).checked)">${comment}</label>
      </div>`);
    }
    this.orders.forEach(field => {
      this.addCustomOrderField(field);
    });
    window._curGridPopDialog = customOrderDialog;
  }

  closeCustomQueryDialog() {
    $("#" + this.id + "_CustomQueryDialog").remove();
  }

  addCustomQueryArg() {
    let customQueryDialog = $("#" + this.id + "_CustomQueryDialog");
    let field = customQueryDialog.find(".tfp-grid-custom-query-fields").val();
    if (!field) {
      tfp.showMsg("请选择要查询的字段！");
      return;
    }
    let queryType = customQueryDialog.find(".tfp-grid-custom-query-types").val();
    if (!queryType) {
      tfp.showMsg("请选择查询类型！");
      return;
    }
    customQueryDialog.find(".tfp-grid-custom-query-args").append(`
    <div class="tfp-grid-custom-query-args-row">
      <div style="flex-basis:150px;"><input type="text" readonly value="${field}"></div>
      <div style="flex-basis:100px;"><input type="text" readonly value="${field}"></div>
      <div style="flex-basis:76px;"><input type="text" readonly value="${queryType}"></div>
      <div style="flex-basis:150px;"><input type="text" style="border: 1px solid #CCCCCC;"></div>
      <div class="tfp-grid-custom-query-args-icon" title="删除" onclick="${this.id}.delCustomQueryArg(this)">-</div>
    </div>`);
  }

  openCustomQueryDialog() {
    event.stopPropagation();
    $("#" + this.id + "_CustomQueryDialog").remove();
    let x = $("#" + this.id).offset().left + $("#" + this.id).width() - 560;
    let y = $("#" + this.id).offset().top + 40;
    $("body").append(`<div id="${this.id}_CustomQueryDialog" class="tfp-grid-custom-query" onclick="event.stopPropagation()" style="left:${x}px;top:${y}px;">
      <div class="tfp-grid-custom-query-top">
        <label style="margin-left:5px;">可选字段：</label>
        <select class="tfp-grid-custom-query-fields" style="width:200px;"></select>
        <label>查询类型：</label>
        <select class="tfp-grid-custom-query-types"></select>
        <div class="tfp-button tfp-button-primary tfp-button-rect" onclick="${this.id}.addCustomQueryArg()">添加</div>
      </div>
      <div class="tfp-grid-custom-query-title">
        <div style="flex-basis:150px;">查询字段名</div>
        <div style="flex-basis:100px;">字段备注</div>
        <div style="flex-basis:76px;">查询类型</div>
        <div style="flex-basis:auto;flex-wrap:1;flex-grow:1;">查询参数值</div>
      </div>
      <div class="tfp-grid-custom-query-args"></div>
      <div class="tfp-grid-custom-query-footer">
        <div class="tfp-button tfp-button-primary tfp-button-rect" onclick="${this.id}.setCustomQuerys()">确定</div>
        <div class="tfp-button tfp-button-default tfp-button-rect" style="margin-left:15px;margin-right:20px;" onclick="${this.id}.closeCustomQueryDialog()">关闭</div>
      </div>
    </div>`);
    let CustomQueryDialog = $("#" + this.id + "_CustomQueryDialog");
    if (this.dataModel.customQueryFields) {
      let sltQueryFields = CustomQueryDialog.find(".tfp-grid-custom-query-fields");
      this.dataModel.customQueryFields.forEach(field => {
        let comment = field.comment;
        if (!comment) comment = field.name;
        sltQueryFields.append(`<option value="${field.name}">${comment}</option>`);
      });
    }
    let queryTypes = [
      {
        "value": "like",
        "text": "模糊查找"
      },
      {
        "value": "=",
        "text": "等于"
      },
      {
        "value": ">",
        "text": "大于"
      },
      {
        "value": "<",
        "text": "小于"
      },
      {
        "value": ">=",
        "text": "大于或等于"
      },
      {
        "value": "<=",
        "text": "小于或等于"
      },
      {
        "value": "<>",
        "text": "不等于"
      },
      {
        "value": "date-range",
        "text": "起止日期"
      },
      {
        "value": "is null",
        "text": "为空"
      },
      {
        "value": "is not null",
        "text": "不为空"
      },
      {
        "value": "in",
        "text": "包含"
      },
      {
        "value": "not in",
        "text": "不包含"
      }
    ];
    let sltQueryTypes = CustomQueryDialog.find(".tfp-grid-custom-query-types");
    queryTypes.forEach(option => {
      sltQueryTypes.append(`<option value="${option.value}">${option.text}</option>`);
    });
    window._curGridPopDialog = CustomQueryDialog;
  }

  onImportData() {
    this.reloadData();
    if (this.dataModel.onImport) {
      try {
        eval(this.dataModel.onImport);
      } catch (err) {
        console.log(err);
      }
    }
  }

  importData() {
    if (!this.dataModel.dataImportSetting) {
      this._tfp.showMsg("请为[" + this.id + "]设置数据导入有关参数！");
      return;
    }

    let args = {};
    let servicePath = "";
    if (this.dataModel.dataImportSetting.servicePath) {
      if (this.dataModel.dataImportSetting.requestArgs
        && this.dataModel.dataImportSetting.requestArgs.length > 0) {
        this._tfp.getRequestArgs(args, this.dataModel.dataImportSetting.requestArgs);
      }
      servicePath = this.dataModel.dataImportSetting.servicePath;
    } else if (this.dataModel.dataImportSetting.serviceCpt) {
      let serviceCpt = this._tfp.get(this.dataModel.dataImportSetting.serviceCpt);
      if (!serviceCpt) {
        this._tfp.showMsg("没有找到id为[" + this.dataModel.dataImportSetting.serviceCpt + "]的组件！");
        return;
      }
      servicePath = serviceCpt.dataModel.path;
      if (serviceCpt.dataModel.argSettings && serviceCpt.dataModel.argSettings.length > 0)
        this._tfp.getRequestArgs(args, serviceCpt.dataModel.argSettings);
    }

    if (!servicePath) {
      this._tfp.showMsg("请为[" + this.id + "]设置数据导入有关参数！");
      return;
    }

    let url = "/node_modules/tfp/src/components/excelimport/tfp/importExcel.tfp?servicePath=" + servicePath;
    url += "&cb=" + this.id + ".onImportData";
    this._tfp.openDialog("导入Excel数据", url, "480px", "320px", { args: args }, window);
  }

  onExportData(res) {
    if (res.code != 0) {
      this._tfp.showMsg(res.message);
      return;
    }
    $('.exportlink').remove();
    $('body').append('<a class="exportlink" style="display:none;" href="javascript:"></a>');
    var that = this;
    $('.exportlink').click(function () {
      let url = "/Download?fileCode=" + res.fileCode;
      window.location.href = that._tfp.setUrlAuthData(url);
    });
    $('.exportlink').click();
  }

  exportData() {
    if (!this.dataModel.dataExportSetting) {
      this._tfp.showMsg("请为[" + this.id + "]设置数据导出有关参数！");
      return;
    }

    let that = this;

    if (this.dataModel.dataExportSetting.serviceCpt) {
      let serviceCptId = this.dataModel.dataExportSetting.serviceCpt;
      let serviceCpt = this._tfp.components[serviceCptId];
      if (!serviceCpt) {
        this._tfp.showMsg("没有找到id为[" + serviceCptId + "]的组件！");
        return;
      }
      serviceCpt.request(null, function (req, res) {
        that.onExportData(res);
      });
    } else if (this.dataModel.dataExportSetting.servicePath) {
      let options = {
        servicePath: this.dataModel.dataExportSetting.servicePath,
        autoShowError: true,
        showLoading: true
      };
      if (this.dataModel.dataExportSetting.requestArgs && this.dataModel.dataExportSetting.requestArgs.length > 0) {
        options.argSettings = this.dataModel.dataExportSetting.requestArgs;
      }
      this._tfp.request(options, function (req, res) {
        that.onExportData(res);
      });
    } else {
      this._tfp.showMsg("请为[" + this.id + "]设置数据导出有关参数！");
    }
  }

  exportPageData() {
    let sheetData = [];
    let titleRow = [];
    //创建标题行数据
    for(let i=0;i<this.columns.length;i++) {
      let col = this.columns[i];
      //只能导出文本列
      if(col.contentType && col.contentType!="text") continue;
      titleRow.push(col.name);
    }
    sheetData.push(titleRow);
    if(this.onlyExportCheckedRow) {
      let rows = this.getRowsChecked();
      if(rows.length==0) {
        tfp.showMsg("请选择要导出的数据！");
        return;
      }
      for(let j=0;j<rows.length;j++) {
        let row = rows[j];
        let rowData = [];
        for(let i=0;i<this.columns.length;i++) {
          let col = this.columns[i];
          //只能导出文本列
          if(col.contentType && col.contentType!="text") continue;
          let cell = row.cells[i];
          rowData.push($(cell).text());
        }
        sheetData.push(rowData);
      }
    } else {
      if(this.dataList.length==0) {
        tfp.showMsg("没有可以导出的数据！");
        return;
      }
      let rows = [];
      for(let j=0;j<this.dataList.length;j++) {
        let row = this.getRow(j);
        let rowData = [];
        for(let i=0;i<this.columns.length;i++) {
          let col = this.columns[i];
          //只能导出文本列
          if(col.contentType && col.contentType!="text") continue;
          let cell = row.cells[i];
          rowData.push($(cell).text());
        }
        sheetData.push(rowData);
      }
    }
    // 将数据转换为工作表
    const ws = XLSX.utils.aoa_to_sheet(sheetData);
    let colWidths = [];
    for(let i=0;i<this.columns.length;i++) {
      let col = this.columns[i];
      if(col.contentType && col.contentType!="text") continue;
      //设置列宽
      let width = 80;
      if(col.width) width = tfp.getPx(col.width);
      width = Math.round(width/7);
      colWidths.push({ wch: width });
    }
    ws['!cols'] = colWidths;
    //设置对齐方式和字号
    /*let arrChar = ['A','B','C','D','E','F','G','H','I','J','K','L','M','N','O','P','Q','R','S','T','U','V','W','X','Y','Z'];
    let colIndex = 0;
    let rowIndex = 1;
    for(let i=0;i<this.columns.length;i++) {
      let col = this.columns[i];
      if(col.contentType && col.contentType!="text") continue;
      //设置对其方式
      if(i<arrChar.length && col.align) {
        for(let j=0;j<sheetData.length;j++) {
          let cellId = arrChar[colIndex]+(j+1);
          if(ws[cellId]) {
            ws[cellId].s = {
              alignment: {
                  horizontal: j==0 ? 'center' : col.align
              }
              //,
              //font: {
              //  sz: 10
              //}
            };
          }
        }
      }
      colIndex++;
    }*/
    const wb = XLSX.utils.book_new();
    XLSX.utils.book_append_sheet(wb, ws, 'Sheet1');
    // 导出文件
    let fileName = "data.xlsx";
    if(this.dataModel.pageExportFileName) fileName = this.dataModel.pageExportFileName;
    if(fileName.toLowerCase().indexOf(".xlsx")<0) fileName += ".xlsx";
    if(fileName.indexOf("{")>=0 && fileName.indexOf("}")>fileName.indexOf("{")) {
      let dateFormat = fileName.substring(fileName.indexOf("{")+1, fileName.indexOf("}"));
      let dateVal = (new Date()).format(dateFormat);
      fileName = fileName.replace("{"+dateFormat+"}", dateVal);
    }
    XLSX.writeFile(wb, fileName);
  }

  /**
   * 设置关键字搜索有关的数据绑定参数
   */
  setKeywordDataQuerySetting() {
    if (this.dataModel.showKeywordInput) {
      if (this.dataModel.dataQuerySetting) {
        if (!this.dataModel.dataQuerySetting.requestArgs) this.dataModel.dataQuerySetting.requestArgs = [];
        let isExists = false;
        this.dataModel.dataQuerySetting.requestArgs.forEach((arg, index) => {
          if (arg.name.indexOf("_keyword") > 0) {
            isExists = true;
            return;
          }
        });
        if (!isExists) {
          this.dataModel.dataQuerySetting.requestArgs.push({
            name: this.id + "_keyword",
            type: "ComponentVal",
            value: this.id + "_keyword"
          });
        }
      }
      if (tfp.curPage.dataModel.cptDataBindSetting && tfp.curPage.dataModel.cptDataBindSetting[this.id]
        && tfp.curPage.dataModel.cptDataBindSetting[this.id].dataQuerySetting) {
        if (!tfp.curPage.dataModel.cptDataBindSetting[this.id].dataQuerySetting.conditions) {
          tfp.curPage.dataModel.cptDataBindSetting[this.id].dataQuerySetting.conditions = [];
        }
        tfp.curPage.dataModel.cptDataBindSetting[this.id].dataQuerySetting.conditions.forEach((arg, index) => {
          if (arg.name.indexOf("_keyword") > 0) {
            tfp.curPage.dataModel.cptDataBindSetting[this.id].dataQuerySetting.conditions.splice(index, 1);
            return;
          }
        });
        if (this.dataModel.queryKeywordFields && this.dataModel.queryKeywordFields.length > 0) {
          let condition = "";
          this.dataModel.queryKeywordFields.forEach((field, index) => {
            if (index > 0) condition += " or ";
            condition += field.name + " like {%req." + this.id + "_keyword%}";
          });
          tfp.curPage.dataModel.cptDataBindSetting[this.id].dataQuerySetting.conditions.push({
            "name": this.id + "_keyword",
            "comment": "关键字",
            "condition": "(" + condition + ")"
          });
        }
        tfp.curPage.dataModel.cptDataBindSetting[this.id].dataQuerySetting.haveModified = true;
      }
    } else {
      if (this.dataModel.dataQuerySetting && this.dataModel.dataQuerySetting.requestArgs) {
        this.dataModel.dataQuerySetting.requestArgs.forEach((arg, index) => {
          if (arg.name.indexOf("_keyword") > 0) {
            this.dataModel.dataQuerySetting.requestArgs.splice(index, 1);
            return;
          }
        });
      }
      if (tfp.curPage.dataModel.cptDataBindSetting && tfp.curPage.dataModel.cptDataBindSetting[this.id]
        && tfp.curPage.dataModel.cptDataBindSetting[this.id].dataQuerySetting) {
        if (tfp.curPage.dataModel.cptDataBindSetting[this.id].dataQuerySetting.conditions) {
          tfp.curPage.dataModel.cptDataBindSetting[this.id].dataQuerySetting.conditions.forEach((arg, index) => {
            if (arg.name.indexOf("_keyword") > 0) {
              tfp.curPage.dataModel.cptDataBindSetting[this.id].dataQuerySetting.conditions.splice(index, 1);
              tfp.curPage.dataModel.cptDataBindSetting[this.id].dataQuerySetting.haveModified = true;
              return;
            }
          });
        }
      }
    }
  }

  /**
   * 获得整个组件的全部html
   * @returns 
   */
  getFullHtml() {
    let indent = this.getHtmlIndent();

    let htmlToolBar = "";
    let toolBarHeight = 0;
    if (this.showToolBar) {
      toolBarHeight = 50;
      let toolbarBorder = "";
      if (this.showBorder) toolbarBorder = "border-top: 1px solid " + this.borderColor + ";"
        + "border-left: 1px solid " + this.borderColor + ";border-right: 1px solid " + this.borderColor + ";";
      htmlToolBar = `<div class="tfp-grid-toolbar" style="background-color:${this.headerBgColor};${toolbarBorder}">`;
      htmlToolBar += '<div class="tfp-grid-toolbar-left">';
      if (this.dataModel.toolButtons && this.dataModel.toolButtons.length > 0) {
        this.dataModel.toolButtons.forEach(button => {
          if (!button.text && !button.buttonIcon) return;
          let buttonTitle = "";
          if (button.title) {
            buttonTitle = button.title;
          } else if (button.text) {
            buttonTitle = button.text;
          }
          let buttonStyle = "";
          if (button.bgColor) buttonStyle += "background-color:" + button.bgColor + ";";
          if (button.textColor) buttonStyle += "color:" + button.textColor + ";";
          if (button.hiddenText) buttonStyle += "padding-left:7px;padding-right:7px;";
          if (button.text && button.buttonIcon && !button.hiddenText) buttonStyle += "min-width:75px;";
          if (buttonStyle != "") buttonStyle = ' style="' + buttonStyle + '"';
          let buttonType = "default";
          if (button.buttonType) buttonType = button.buttonType;
          let buttonTheme = "rect";
          if (button.theme) buttonTheme = button.theme;
          htmlToolBar += '<div class="tfp-button tfp-button-' + buttonType + ' tfp-button-'
            + buttonTheme + '" title="' + buttonTitle + '" ' + buttonStyle;
          if (button.onClick && !this._tfp.isDesigning) htmlToolBar += ' onclick="' + button.onClick + '"';
          htmlToolBar += '>';
          if (button.buttonIcon) {
            if (button.buttonIcon.indexOf("tfp-button-icon") >= 0) {
              htmlToolBar += '<span class="' + button.buttonIcon + '"></span>';
            } else if (button.buttonIcon.indexOf("/") >= 0) {
              htmlToolBar += '<img style=\"width:16px; width:16px;\" src="' + this._tfp.getUrlRealPath(button.buttonIcon) + '" />';
            }
          }
          if (button.text && !button.hiddenText) {
            let marginLeft = "";
            if (!button.buttonIcon) marginLeft = ' style="margin-left:0;"';
            htmlToolBar += '<label ' + marginLeft + '>' + button.text + '</label>';
          }
          htmlToolBar += '</div>';
        });
      }
      htmlToolBar += '</div>';
      htmlToolBar += '<div class="tfp-grid-toolbar-right">';

      if (this.dataModel.showKeywordInput) {
        htmlToolBar += `<div class="tfp-grid-toolbar-keyword">
          <input id="${this.id}_keyword" type="text" placeholder="请输入关键字" onkeydown="if(event.keyCode==13){${this.id}.reloadData()}">
          <span class="tfp-button-icon tfp-button-icon-sousuo" title="查询" onclick="${this.id}.reloadData()"></span>
        </div>`;
      }
      if (this.dataModel.showImportButton) {
        htmlToolBar += `<div class="tfp-grid-toolbar-icon" title="导入" onclick="${this.id}.importData()">
          <span class="tfp-button-icon tfp-button-icon-daoru"></span>
        </div>`;
      }
      if (this.dataModel.showExportButton) {
        htmlToolBar += `<div class="tfp-grid-toolbar-icon" title="从后台导出数据" onclick="${this.id}.exportData()">
          <span class="tfp-button-icon tfp-button-icon-daochu"></span>
        </div>`;
      }
      if (this.dataModel.showPageExportButton) {
        htmlToolBar += `<div class="tfp-grid-toolbar-icon" title="导出前端页面数据" onclick="${this.id}.exportPageData()">
          <span class="tfp-button-icon tfp-button-icon-daochu"></span>
        </div>`;
      }
      if (this.dataModel.showPrintButton) {
        htmlToolBar += `<div class="tfp-grid-toolbar-icon" title="打印" onclick="${this.id}.openPrintReport()">
          <span class="tfp-button-icon tfp-button-icon-dayinji_o"></span>
        </div>`;
      }
      if (this.dataModel.showCustomQueryButton) {
        htmlToolBar += `<div class="tfp-grid-toolbar-icon" title="自定义查询" onclick="${this.id}.openCustomQueryDialog()">
          <span class="tfp-button-icon tfp-button-icon-chaxun"></span>
        </div>`;
      }
      if (this.dataModel.showCustomOrderButton) {
        htmlToolBar += `<div class="tfp-grid-toolbar-icon" title="自定义排序" onclick="${this.id}.openCustomOrderDialog()">
          <span class="tfp-button-icon tfp-button-icon-icon-" style="font-size:18px"></span>
        </div>`;
      }
      if (this.dataModel.showFilterColButton && !(this.dataModel.headerRows && this.dataModel.headerRows.length > 1)) {
        htmlToolBar += `<div class="tfp-grid-toolbar-icon" title="筛选表格列" onclick="${this.id}.openFilterColDialog(this)">
          <span class="tfp-button-icon tfp-button-icon-guolvqi" style="font-size:13px"></span>
        </div>`;
      }
      htmlToolBar += '</div>';
      htmlToolBar += '</div>';
    }

    let headerRowsHeight = parseInt(this.headerHeight);
    //判断是否有多行表头
    let hasHeaderRows = false;
    if (this.dataModel.headerRows && this.dataModel.headerRows.length > 1) {
      headerRowsHeight = headerRowsHeight * this.dataModel.headerRows.length;
      hasHeaderRows = true;
    }
    let headerHeight = "height:" + (headerRowsHeight - 2) + "px;";
    let rowHeight = this.dataModel.rowHeight ? this.dataModel.rowHeight + "" : "40";

    let htmlHeader = indent + "\t<div class=\"tfp-grid-header\" "
      + "style=\"top: " + (toolBarHeight > 0 ? toolBarHeight + "px" : "0") + ";"
      + "background-color:" + this.headerBgColor + ";height:" + headerRowsHeight + "px;";
    if (this.showBorder) {
      htmlHeader += "border: 1px solid " + this.borderColor + ";";
    } else {
      htmlHeader += "border-bottom: 1px solid " + this.borderColor + ";";
    }
    htmlHeader += "\">\r\n";
    let htmlHeaderFixedBox = indent + "\t\t<div class=\"tfp-grid-header-fixed\" style=\""
      + headerHeight + "width:{fixedColWidth}px;" + (hasHeaderRows ? "display:block;" : "") + "\">\r\n";
    let htmlHeaderScrollBox = indent + "\t\t<div class=\"tfp-grid-header-scroll\" style=\""
      + headerHeight + "left:{fixedColWidth}px;right:{fixedColWidthOnRight}px;\">\r\n";
    htmlHeaderScrollBox += indent + "\t\t\t<div class=\"tfp-grid-header-scroll-box\" style=\""
      + headerHeight + (hasHeaderRows ? "display:block;" : "") + "\">\r\n";
    let htmlHeaderFixedBoxRight = indent + "\t\t<div class=\"tfp-grid-header-fixed-right\" style=\""
      + headerHeight + "width:{fixedColWidthOnRight}px;" + (hasHeaderRows ? "display:block;" : "") + "\">\r\n";

    let dataListTop = 0;
    if (this.dataModel.showToolBar) dataListTop = toolBarHeight;
    if (this.dataModel.showHeader) dataListTop += headerRowsHeight;
    let dataListBottom = 0;
    if (this.dataModel.showSumer) dataListBottom += 39;
    if (this.dataModel.allowPaging) dataListBottom += 49;
    let htmlDataList = indent + "\t<div class=\"tfp-grid-datalist\" style=\"bottom:"
      + dataListBottom + "px;top:" + dataListTop + "px;";
    if (this.showBorder) htmlDataList += "border-left: 1px solid "
      + this.borderColor + ";border-right: 1px solid " + this.borderColor + ";";
    if (!this.showHeader) htmlDataList += "border-top:1px solid " + this.borderColor + ";";
    if (!this.showSumer && !this.allowPaging) htmlDataList += "border-bottom:1px solid " + this.borderColor + ";";
    htmlDataList += "\">\r\n";
    let htmlDataListFixedBox = indent + "\t\t<div class=\"tfp-grid-datalist-fixed\" style=\"width:{fixedColWidth}px;\">\r\n";
    let htmlDataListScrollBox = indent + "\t\t<div class=\"tfp-grid-datalist-scroll\" style=\"left:{fixedColWidth}px;right:{fixedColWidthOnRight}px;\">\r\n";
    htmlDataListScrollBox += indent + "\t\t\t<div class=\"tfp-grid-datalist-scroll-box\">\r\n";
    let htmlDataListFixedBoxRight = indent + "\t\t<div class=\"tfp-grid-datalist-fixed-right\" style=\"width:{fixedColWidthOnRight}px;\">\r\n";

    let headerStyle = "";
    let borderStyle = "";
    if (this.headerTextColor) headerStyle += "color:" + this.headerTextColor + ";";
    if (this.headerBold) headerStyle += "font-weight:bold;";
    if (this.showBorder) borderStyle = "border-right:1px solid " + this.borderColor + ";";

    let fixedColWidth = 0;
    let fixedColWidthOnRight = 0;

    if (this.dataModel.showCheckbox) {
      htmlHeaderFixedBox += indent + "\t\t\t<div class=\"tfp-grid-header-checkbox\" "
        + "style=\"flex-basis: 30px;background-color:" + this.headerBgColor
        + ";height:" + headerRowsHeight + "px;" + borderStyle;
      if (hasHeaderRows) htmlHeaderFixedBox += "float:left;width:30px;";
      htmlHeaderFixedBox += "\"><input type=\"checkbox\" onclick=\""
        + this.dataModel.id + ".toggleCheckAll(this)\" /></div>\r\n";
      htmlDataListFixedBox += indent + "\t\t\t<div class=\"tfp-grid-datalist-checkbox\""
        + " style=\"flex-basis: 30px;\">";
      if (this._tfp.isDesigning) {
        htmlDataListFixedBox += "<div style=\"flex-basis:" + rowHeight
          + "px;border-bottom:1px solid " + this.borderColor + ";background-color: " + this.getRowBgColor(0) + ";";
        if (this.showBorder) htmlDataListFixedBox += "border-right:1px solid " + this.borderColor + ";";
        htmlDataListFixedBox += "\"><input type=\"checkbox\" /></div>";
      }
      htmlDataListFixedBox += "</div>\r\n";
      fixedColWidth += 30;
    }
    if (this.dataModel.showRowNum) {
      htmlHeaderFixedBox += indent + "\t\t\t<div class=\"tfp-grid-header-index\" "
        + " style=\"flex-basis: " + this.indexColWidth + "px;background-color:"
        + this.headerBgColor + ";height:" + headerRowsHeight + "px;"
      if (hasHeaderRows) htmlHeaderFixedBox += "float:left;width: " + this.indexColWidth + "px;";
      htmlHeaderFixedBox += headerStyle + borderStyle + "\">序号</div>\r\n";
      htmlDataListFixedBox += indent + "\t\t\t<div class=\"tfp-grid-datalist-index\""
        + " style=\"flex-basis: " + this.indexColWidth + "px;\">";
      if (this._tfp.isDesigning) {
        htmlDataListFixedBox += "<div style=\"flex-basis:" + rowHeight + "px;"
          + "border-bottom:1px solid " + this.borderColor + ";background-color: " + this.getRowBgColor(0) + ";";
        if (this.showBorder) htmlDataListFixedBox += "border-right:1px solid " + this.borderColor + ";";
        htmlDataListFixedBox += "\"><label style=\"font-size:14px;\">1</label></div>";
      }
      htmlDataListFixedBox += "</div>\r\n";
      fixedColWidth += this.indexColWidth;
    }

    let curHeaderCellLeft = [];
    if (hasHeaderRows) {
      for (let i = 0; i < this.dataModel.headerRows.length; i++) {
        curHeaderCellLeft.push(fixedColWidth);
      }
    }

    //编译时，需要先获得固定列的数量
    for (var i = 0; i < this.columns.length; i++) {
      var col = this.columns[i];
      if (col.fixed) {
        this.fixedColCount++;
      } else if (col.fixedOnRight) {
        this.fixedOnRightColCount++;
      }
    }

    let haveFillCol = false;

    for (var i = 0; i < this.columns.length; i++) {
      let col = this.columns[i];

      if (i == this.fixedColCount && hasHeaderRows) {
        curHeaderCellLeft = [];
        for (let i = 0; i < this.dataModel.headerRows.length; i++) {
          curHeaderCellLeft.push(0);
        }
      }

      let ret = this.addColumn(col, i, true, indent, headerHeight, hasHeaderRows, curHeaderCellLeft);
      fixedColWidth += ret.fixedColWidth;
      fixedColWidthOnRight += ret.fixedColWidthOnRight;

      if (col.fixed) {
        htmlHeaderFixedBox += ret.htmlHeaderCol;
        htmlDataListFixedBox += ret.htmlDataCol;
      } else if (col.fixedOnRight) {
        htmlHeaderFixedBoxRight += ret.htmlHeaderCol;
        htmlDataListFixedBoxRight += ret.htmlDataCol;
      } else {
        htmlHeaderScrollBox += ret.htmlHeaderCol;
        htmlDataListScrollBox += ret.htmlDataCol;
      }
    }

    //如果有多行表头，则要在表头最后面加一列显示边框
    if (this.dataModel.headerRows && this.dataModel.headerRows.length > 1) {
      for (let i = 0; i < this.dataModel.headerRows.length - 1; i++) {
        let row = this.dataModel.headerRows[i];
        let lastCell = row[row.length - 1];
        if (lastCell.cols == 0 || lastCell.rows == 0) continue;
        htmlHeaderScrollBox += `<div style="position:absolute;z-index:1;left:${curHeaderCellLeft[i]}px;top:${(this.headerHeight - 2) * i}px;right:0;height:${lastCell.rows * (this.headerHeight - 2)}px;background-color:${this.headerBgColor};border-bottom:1px solid ${this.borderColor};"></div>	`;
      }
    }

    if (!this._tfp.isDesigning && !hasHeaderRows) {
      htmlHeaderScrollBox += indent + "\t\t\t<div style=\"background-color:"
        + this.headerBgColor + ";" + headerHeight + "";
      if (hasHeaderRows || haveFillCol) htmlHeaderScrollBox += "display:none;float:right;";
      htmlHeaderScrollBox += "\"></div>";
    }
    htmlHeader += htmlHeaderFixedBox + indent + "\t\t</div>\r\n";
    htmlHeader += htmlHeaderScrollBox + indent + "\t\t\t</div>\r\n" + indent + "\t\t</div>\r\n";
    htmlHeader += htmlHeaderFixedBoxRight + indent + "\t\t</div>\r\n";
    htmlHeader += indent + "\t</div>\r\n";

    let html = "";
    if (this.showToolBar) html += htmlToolBar;
    if (this.showHeader) html += htmlHeader;

    htmlDataList += htmlDataListFixedBox + indent + "\t\t</div>\r\n";

    //添加一个空列，当所有列宽度之和小于整个组件的宽度时，用该列来填充剩下的空白区域
    //防止内容宽度不够时，表格右侧显示空白
    htmlDataListScrollBox += "<div class=\"tfp-grid-fill-col\"";
    if (haveFillCol) htmlDataListScrollBox += " style=\"display:none;\"";
    htmlDataListScrollBox += ">";
    if (this._tfp.isDesigning) {
      htmlDataListScrollBox += "<div class=\"tfp-grid-datalist-cell\" style=\"width: 100%;"
        + "border-bottom: 1px solid " + this.borderColor + "; flex-basis: " + rowHeight + "px; "
        + "background-color: " + this.getRowBgColor(i) + ";\"></div>";
    }
    htmlDataListScrollBox += "</div>\r\n";

    htmlDataList += htmlDataListScrollBox + indent + "\t\t\t</div>\r\n" + indent + "\t\t</div>\r\n";
    htmlDataList += htmlDataListFixedBoxRight + indent + "\t\t</div>\r\n";
    htmlDataList += indent + "\t</div>\r\n";

    html += htmlDataList;

    html = html.replace(/\{fixedColWidth\}/g, fixedColWidth);
    html = html.replace(/\{fixedColWidthOnRight\}/g, fixedColWidthOnRight);

    if (this.showSumer) html += this.getSumerHtml();

    html += this.getFooterHtml();

    if (!this._tfp.isDesigning) {
      //在编译时，如果有自定义单元格，则需要生成单元格的模版HTML
      if (this.dataModel.components && this.dataModel.components.length > 0) {
        html += indent + "\t<div class=\"tfp-grid-datacell-template\" style=\"display:none;\">\r\n";
        let CellRender = this._tfp.renders["GridCell"];
        for (let i = 0; i < this.dataModel.components.length; i++) {
          let cellCdm = this.dataModel.components[i];
          this.setCptDataFormat(cellCdm);
          let cellRender = new CellRender(this._tfp, cellCdm);
          let cellHtml = cellRender.getHtml(true, indent, true);
          html += cellHtml;
        }
        html += indent + "\t</div>\r\n";
      }
    }

    //console.log(html);
    return html;
  }

  formatTextCellContent(cellDiv, col) {
    let dataFormat = col.dataFormat;
    let cellHtml = cellDiv.html();
    if(this._tfp.isNull(cellHtml.trim())) {
      return;
    }
    try {
      if (dataFormat == "int") {
        cellHtml = parseInt(cellHtml);
      } else if (dataFormat == "decimal") {
        if (col.decimalLength || col.decimalLength == 0) {
          cellHtml = tfp.formatDecimal(cellHtml, col.decimalCalcReg, col.decimalLength);
        } else {
          cellHtml = parseFloat(cellHtml);
        }
      } else if (dataFormat == "money|0.00") {
        cellHtml = tfp.formatMoney(cellHtml, 2);
      } else if (dataFormat == "money|0,000.00") {
        cellHtml = tfp.formatMoney(cellHtml, 2, true);
      } else if (dataFormat.startsWith("date|") || dataFormat.startsWith("time|") || dataFormat.startsWith("datetime|")) {
        cellHtml = tfp.formatDate(cellHtml, dataFormat.substr(dataFormat.indexOf("|") + 1));
      } else if (dataFormat == "week") {
        cellHtml = tfp.getWeekDay(cellHtml);
      } else if (dataFormat == "week|星期") {
        cellHtml = tfp.getWeekDay(cellHtml, true);
      } else if (dataFormat == "filesize") {
        cellHtml = tfp.formatFileSize(cellHtml);
      }
    } catch (err) {
      console.log(err);
    }
    cellDiv.html(cellHtml);
  }

  /*
  getTextCellFormat(col) {
    let cellFormat = col.format;
    if (cellFormat && col.dataFormat) {
      if (col.dataFormat == "int") {
        cellFormat = "#[parseInt(" + cellFormat + ")]";
      } else if (col.dataFormat == "decimal") {
        if (col.decimalLength || col.decimalLength == 0) {
          cellFormat = "#[tfp.formatDecimal(" + cellFormat + ", '" + col.decimalCalcReg + "', " + col.decimalLength + ")]";
        } else {
          cellFormat = "#[parseFloat(" + cellFormat + ")]";
        }
      } else if (col.dataFormat == "money|0.00") {
        cellFormat = "#[tfp.formatMoney(" + cellFormat + ", 2)]";
      } else if (col.dataFormat == "money|0,000.00") {
        cellFormat = "#[tfp.formatMoney(" + cellFormat + ", 2, true)]";
      } else if (col.dataFormat.startsWith("date|") || col.dataFormat.startsWith("time|") || col.dataFormat.startsWith("datetime|")) {
        cellFormat = "#[tfp.formatDate('" + cellFormat + "','" + col.dataFormat.substr(col.dataFormat.indexOf("|") + 1) + "')]";
      } else if (col.dataFormat == "week") {
        cellFormat = "#[tfp.getWeekDay(" + cellFormat + ")]";
      } else if (col.dataFormat == "week|星期") {
        cellFormat = "#[tfp.getWeekDay(" + cellFormat + ", true)]";
      } else if (col.dataFormat == "filesize") {
        cellFormat = "#[tfp.formatFileSize(" + cellFormat + ")]";
      }
    }
    return (cellFormat || cellFormat == 0) ? cellFormat : "";
  }*/

  /**
   * 获得指定列的单元格html模版
   * @param {*} col 
   * @param {*} rowIndex 
   * @param {*} colIndex 
   * @returns 
   */
  getCellHtmlTemplate(col, rowIndex, colIndex, node, parentNode) {
    let indent = this.getHtmlIndent();
    let html = indent + "\t\t\t\t<div col-index=\"" + colIndex + "\"";
    html += " class=\"tfp-grid-datalist-cell";
    if (col.class) html += " " + col.class;
    html += "\"";
    //如果是树形节点，且是第1列，则在属性中要保存节点的id，以便后续各种事件中通过该id获得节点的数据
    if (node && colIndex == 0) {
      html += " grid-tree-node-id=\"" + node.id + "\"";
    }

    let cellFormat = col.format;
    let colStyle = "border-bottom:1px solid " + this.borderColor + ";" + this.getNodeDisplay(node, parentNode);
    if (col.contentType == "custom") colStyle += "position:relative;"
    if (col.bgColor) {
      if (col.contentType == "button") {
        //如果按钮设置了专门的按钮背景色，则bgColor就用来设置单元格背景色，否则bgColor用来设置按钮的背景色
        if (col.buttonBgColor) colStyle += "background-color:" + col.bgColor + ";"
        if (col.buttonBorderColor) colStyle += "border:1px solid " + col.buttonBorderColor + ";"
      } else {
        colStyle += "background-color:" + col.bgColor + ";"
      }
    } else {
      if (!(col.style && col.style.indexOf("background-color") >= 0) && !col.groupContent)
        colStyle += "background-color:" + this.getRowBgColor(rowIndex) + ";"
    }

    let rowHeight = this.dataModel.rowHeight ? this.dataModel.rowHeight + "" : "40";
    rowHeight = rowHeight.replace("px", "");
    colStyle += "width:100%;flex-basis:" + rowHeight + "px;";
    if (col.align == "left") {
      colStyle += "justify-content: flex-start;text-align: left;";
    } else if (col.align == "right") {
      colStyle += "justify-content: flex-end;text-align: right;";
    }
    if (col.valign == "top") {
      colStyle += "align-items: flex-start;";
    } else if (col.valign == "bottom") {
      colStyle += "align-items: flex-end;";
    }
    if (col.style) colStyle += col.style;

    if (!col.contentType || col.contentType == "text") {
      if (col.color) colStyle += "color:" + col.color + ";"
      if (col.bold + '' == 'true') colStyle += "font-weight: bold;"
      if (col.fontSize) colStyle += "font-size: " + col.fontSize + "px;"
      if (col.onClick) colStyle += "cursor: pointer;";
      if (col.nowrap) {
        colStyle += "flex-wrap: nowrap; overflow: hidden;white-space: nowrap;text-overflow: ellipsis;";
      }
      if (colStyle != "") html += " style=\"" + colStyle + "\"";
      if (col.onClick && !this._tfp.isDesigning) html += " onclick=\"" + col.onClick + "\"";
      html += ">";
      if (col.icon) {
        let iconSize = 20;
        if (col.iconSize) iconSize = col.iconSize;
        iconSize = this._tfp.getPx(iconSize);
        let iconRadius = 4;
        if (col.iconRadius || (col.iconRadius + "") == "0") iconRadius = col.iconRadius;
        iconRadius = this._tfp.getPx(iconRadius);
        if (col.icon.type == "url") {
          html += "<img src=\"" + col.icon.url + "\" style=\"width:" + iconSize + "px; height:" + iconSize
            + "px; margin-left:10px; margin-right:10px; border-radius: " + iconRadius + "px;\">";
        } else {
          html += "<span class=\"" + col.icon.class + "\" style=\"border-radius: " + iconRadius + "px; margin-right:10px;"
            + " margin-left:10px;font-size:" + iconSize + "px;height:" + iconSize + "px;line-height:" + iconSize + "px;"
            + "background-color:" + col.icon.bgColor + ";color:" + col.icon.color + ";\"></span>";
        }
      }
      if(col.allowEdit) html += "<input class=\"tfp-grid-cell-input\" style=\"height:"
        +rowHeight+"px;text-align:"+(col.align=="right" ? "right" : "left")+";\" value=\"";
      html += (cellFormat || cellFormat == 0) ? cellFormat : "";
      if(col.allowEdit) html += "\">";
    } else {
      html += " style=\"" + colStyle + "\">\r\n";
      html += indent + "\t\t\t\t";
      if (col.contentType == "link") {
        let linkStyle = "";
        if (col.linkFontColor) linkStyle += "color:" + col.linkFontColor + ";"
        if (col.linkFontBold) linkStyle += "font-weight: bold;"
        if (col.linkFontSize) linkStyle += "font-size: " + col.linkFontSize + "px;"
        if (col.onClick) linkStyle += "cursor: pointer;";
        if (linkStyle != "") linkStyle = " style=\"" + linkStyle + "\"";
        if (this._tfp.isDesigning) {
          html += "<a " + linkStyle + ">" + col.format + "</a>";
        } else {
          if (col.linkUrl) {
            if (col.linkType == "page") { //新页面
              html += `<a href="javascript:tfp.openPage('${col.targetTitle}', '${col.linkUrl}')" ${linkStyle}>${col.format}</a>`;
            } else if (col.linkType == "dialog") { //对话框
              html += `<a href="javascript:tfp.openDialog('${col.targetTitle}', '${col.linkUrl}', '${col.dialogWidth}px', '${col.dialogHeight}px')" ${linkStyle}>
                  ${col.format}
                  </a>`;
            } else if (col.linkType == "drawer") { //抽屉页
              html += `<a href="javascript:tfp.openDrawer('${col.targetTitle}', '${col.linkUrl}')" ${linkStyle}>
                  ${col.format}
                  </a>`;
            } else if (col.linkType == "window") { //新窗口
              html += `<a href="javascript:window.open('${col.linkUrl}', '${col.targetTitle}') " ${linkStyle}>${col.format}</a>`;
            } else {  //当前页面
              html += `<a href="${col.linkUrl}" ${linkStyle}>${col.format}</a>`;
            }
          } else if (col.onClick) {
            html += "<a href=\"javascript:" + col.onClick + "\" " + linkStyle + ">" + col.format + "</a>";
          } else {
            html += "<a " + linkStyle + ">" + col.format + "</a>";
          }
        }
      } else if (col.contentType == "button") {
        html += "<div class=\"tfp-grid-cell-btn";
        if (col.buttonType) {
          html += " tfp-button tfp-button-" + col.buttonType;
          html += "\"";
        } else {
          html += "\" style=\"";
          let bgColor = col.buttonBgColor;
          //如果按钮没有设置专门的按钮背景色，但设置了单元格bgColor，则用这个单元格bgColor设置按钮的背景色
          if (!bgColor && col.bgColor) bgColor = col.bgColor;
          if (!bgColor) bgColor = "var(--sys-theme-color)";
          html += "background-color:" + bgColor + ";"
        }

        if (col.buttonBorderColor) html += "border:1px solid " + col.buttonBorderColor + ";"
        if (col.buttonFontBold) html += "font-weight: bold;"
        if (col.buttonFontSize) html += "font-size: " + col.buttonFontSize + "px;"
        if (col.buttonTheme == "round") {
          html += "border-radius: 4px;";
        } else if (col.buttonTheme == "ellipse") {
          html += "border-radius: 15px;";
        }
        html += "\"";
        if (!this._tfp.isDesigning) html += " onclick=\"" + col.onClick + "\"";
        html += "\">";

        //如果设置了按钮图标
        if (col.buttonIcon) {
          if (typeof (col.buttonIcon) == "string") {
            if (col.buttonIcon.indexOf("tfp-button-icon") < 0) {
              let imgUrl = col.buttonIcon;
              if (imgUrl.startsWith("/web/")) imgUrl = imgUrl.substr(4);
              imgUrl = this._tfp.getUrlRealPath(imgUrl);
              html += "<img src=\"" + imgUrl + "\">";
            } else {
              html += "<span class=\"" + col.buttonIcon + "\"></span>";
            }
          } else if (col.buttonIcon.type) {
            if (col.buttonIcon.type == "url") {
              let imgUrl = col.buttonIcon.url;
              if (imgUrl.startsWith("/web/")) imgUrl = imgUrl.substr(4);
              imgUrl = this._tfp.getUrlRealPath(imgUrl);
              html += "<img src=\"" + imgUrl + "\">";
            } else {
              html += "<span class=\"" + col.buttonIcon.class + "\"></span>";
            }
          }
        }

        let textColor = "";
        if (col.buttonFontColor) textColor = "color:" + col.buttonFontColor + ";";
        if (cellFormat) html += "<label style=\"cursor:pointer;" + textColor + "\">" + cellFormat + "</label>";
        html += "</div>";
      } else if (col.contentType == "image") {
        html += "<img style=\"";
        if (col.onClick) html += "cursor: pointer;";
        if (col.imgWidth) {
          var imgWidth = col.imgWidth;
          if (imgWidth.indexOf("px") < 0 && imgWidth.indexOf("%") < 0) imgWidth += "px";
          html += "width:" + imgWidth + ";";
        }
        if (col.imgHeight) {
          var imgHeight = col.imgHeight;
          if (imgHeight.indexOf("px") < 0 && imgHeight.indexOf("%") < 0) imgHeight += "px";
          html += "height:" + imgHeight + ";";
        }
        let imgSrc = this._tfp.rootPath + "/src/components/image/images/default-photo.png";
        if (cellFormat && (!this._tfp.isDesigning || (this._tfp.isDesigning && cellFormat.indexOf("{") < 0))) imgSrc = cellFormat;
        html += "\" src=\"" + imgSrc + "\"";
        if (!this._tfp.isDesigning) html += " onclick=\"" + col.onClick + "\"";
        html += "/>";
      } else if (col.contentType == "switch") {
        html += "<div class=\"tfp-grid-cell-switch\"";
        if (!this._tfp.isDesigning) html += " onclick=\"" + col.onClick + "\"";
        html += ">";
        let bgColor = "#999999";
        let divFloat = "left";
        if (cellFormat && cellFormat.indexOf("{") == 0 && col.selectedValue) {
          divFloat = "#[('" + cellFormat + "')=='" + col.selectedValue + "' ? 'right' : 'left']";
          let selectedBgColor = "var(--sys-theme-color)";
          //if (col.bgColor) selectedBgColor = col.bgColor;
          bgColor = "#[('" + cellFormat + "')=='" + col.selectedValue + "' ? '" + selectedBgColor + "' : '#999999']";
        }
        html += "<div class=\"tfp-grid-cell-switch-btn\" style=\"float: " + divFloat +
          "; background-color:" + bgColor + ";\"></div></div>";
      } else if (col.contentType == "progress") {
        html += "<div class=\"tfp-grid-cell-progress\">";
        let bgColor = "var(--sys-theme-color)";
        //if (col.bgColor) bgColor = col.bgColor;
        html += "<div class=\"tfp-grid-cell-progress-bar\" style=\"background-color:" + bgColor + ";\"></div></div>";
        html += "<div class=\"tfp-grid-cell-progress-label\"></div>"
      } else if (col.contentType == "custom") {
        //如果不是设计时，则在此直接生成子组件的html
        if (!this._tfp.isDesigning && this.customCells) {
          let cellCdm = null;
          for (let j = 0; j < this.customCells.length; j++) {
            let cdm = this.customCells[j];
            if (cdm.cellIndex == colIndex) {
              cellCdm = JSON.parse(JSON.stringify(cdm));
              break;
            }
          }
          if (cellCdm) {
            let cellHtml = this._jqObj.find("#" + cellCdm.id).get(0).outerHTML;
            cellHtml = cellHtml.replace("\"" + cellCdm.id + "\"", "\"" + this.id + "_cell_" + rowIndex + "_" + cellCdm.cellIndex + "\"");
            cellHtml = this.replaceCustomCellCptId(cellCdm, cellHtml, rowIndex, cellCdm.cellIndex);
            html += cellHtml;
          }
        }
      }
      html += "\r\n" + indent + "\t\t\t";
    }
    html += "</div>\r\n";
    return html;
  }

  /**
   * 当开始鼠标拖拽调整列宽时
   * @param {*} div 
   * @param {*} cellIndex 
   */
  headerResizeOnMouseDown(div, cellIndex) {
    var e = window.event;
    window._curResizeColGridId = this.id;
    this.headerResizeStartX = e.clientX;
    this.headerResizeCellIndex = cellIndex;
    let cell = this.getHeaderCell(cellIndex);
    this.headerResizeDivWidth = cell.width();
    this.header.find(".tfp-grid-header-col").css("cursor", "col-resize");
    document.addEventListener("mousemove", this.headerResizeOnMouseMove);
    document.addEventListener("mouseup", this.headerResizeOnMouseUp);
  }

  /**
   * 当移动鼠标拖拽调整列宽时
   */
  headerResizeOnMouseMove() {
    if (!window._curResizeColGridId) return;
    let curGrid = tfp.get(window._curResizeColGridId);
    if (!curGrid || curGrid.headerResizeStartX < 0) return;
    let x = window.event.clientX;
    let width = curGrid.headerResizeDivWidth + (x - curGrid.headerResizeStartX);
    if (width < 20) width = 20;
    let colIndex = curGrid.headerResizeCellIndex;
    curGrid.setColWidth(colIndex, width);
    let colsWidth = [];
    curGrid.dataModel.columns.forEach(col => {
      let w = 80;
      if (col.width) w = col.width;
      colsWidth.push(parseInt(w));
    });
    tfp.setCptSettingCache(curGrid.id, "ColsWidth", colsWidth);
  }

  setColWidth(colIndex, width) {
    if (this.fixedColCount > 0 && colIndex < this.fixedColCount) {
      let divHeaderCol = this.header.children(".tfp-grid-header-fixed").children(".tfp-grid-header-col").eq(colIndex);
      divHeaderCol.css("flex-basis", width + "px");
      if (this.showSumer) {
        let divSumerCol = this.sumer.children(".tfp-grid-sumer-fixed").children(".tfp-grid-sumer-col").eq(colIndex);
        divSumerCol.css("flex-basis", width + "px");
      }
      this.bodyFixedBox.children(".tfp-grid-datalist-col").eq(colIndex).css("flex-basis", width + "px");

      let fixedBoxWidth = 0;
      this.header.children(".tfp-grid-header-fixed").children("div").each(function () {
        fixedBoxWidth += $(this).outerWidth();
      });
      this.header.children(".tfp-grid-header-fixed").css("width", fixedBoxWidth + "px");
      this.header.children(".tfp-grid-header-scroll").css("left", fixedBoxWidth + "px");
      this.bodyFixedBox.css("width", fixedBoxWidth + "px");
      this.body.children(".tfp-grid-datalist-scroll").css("left", fixedBoxWidth + "px");
      this.sumer.children(".tfp-grid-sumer-fixed").css("width", fixedBoxWidth + "px");
      this.sumer.children(".tfp-grid-sumer-scroll").css("left", fixedBoxWidth + "px");
    } else if (this.fixedOnRightColCount > 0 && colIndex >= (this.dataModel.columns.length - this.fixedOnRightColCount)) {
      colIndex -= this.dataModel.columns.length - this.fixedOnRightColCount;
      let divHeaderCol = this.header.children(".tfp-grid-header-fixed-right").children(".tfp-grid-header-col").eq(colIndex);
      divHeaderCol.css("flex-basis", width + "px");
      if (this.showSumer) {
        let divSumerCol = this.sumer.children(".tfp-grid-sumer-fixed-right").children(".tfp-grid-sumer-col").eq(colIndex);
        divSumerCol.css("flex-basis", width + "px");
      }
      this.bodyFixedRightBox.children(".tfp-grid-datalist-col").eq(colIndex).css("flex-basis", width + "px");

      let fixedBoxWidth = 0;
      this.header.children(".tfp-grid-header-fixed-right").children("div").each(function () {
        fixedBoxWidth += $(this).outerWidth();
      });
      this.header.children(".tfp-grid-header-fixed-right").css("width", fixedBoxWidth + "px");
      this.header.children(".tfp-grid-header-scroll").css("right", fixedBoxWidth + "px");
      this.bodyFixedRightBox.css("width", fixedBoxWidth + "px");
      this.body.children(".tfp-grid-datalist-scroll").css("right", fixedBoxWidth + "px");
      this.sumer.children(".tfp-grid-sumer-fixed-right").css("width", fixedBoxWidth + "px");
      this.sumer.children(".tfp-grid-sumer-scroll").css("right", fixedBoxWidth + "px");
    } else {
      colIndex -= this.fixedColCount;
      let divHeaderCol = this.header.children(".tfp-grid-header-scroll").find(".tfp-grid-header-col").eq(colIndex);
      divHeaderCol.css("flex-basis", width + "px");
      if (this.showSumer) {
        let divSumerCol = this.sumer.children(".tfp-grid-sumer-scroll").find(".tfp-grid-sumer-col").eq(colIndex);
        divSumerCol.css("flex-basis", width + "px");
      }
      this.bodyScrollBox.children(".tfp-grid-datalist-col").eq(colIndex).css("flex-basis", width + "px");
    }
    this.dataModel.columns[colIndex].width = width;
  }

  /**
   * 当松开鼠标拖拽调整列宽时
   */
  headerResizeOnMouseUp() {
    if (!window._curResizeColGridId) return;
    let curGrid = tfp.get(window._curResizeColGridId);
    if (!curGrid || curGrid.headerResizeStartX < 0) return;
    curGrid.headerResizeStartX = -1;
    curGrid.headerResizeCellIndex = -1;
    curGrid.headerResizeDivWidth = 0;
    curGrid.header.find(".tfp-grid-header-col").css("cursor", "");
    window._curResizeColGridId = null;
    document.removeEventListener("mousemove", this.headerResizeOnMouseMove);
    document.removeEventListener("mouseup", this.headerResizeOnMouseUp);
    curGrid.onResize();
  }

  /**
   * 获得列宽
   * @param  {[type]} width [description]
   * @return {[type]}       [description]
   */
  getColWidth(colIndex) {
    if(!this.dataModel.columns || colIndex>(this.dataModel.columns.length-1)) return "80";
    let col = this.dataModel.columns[colIndex];
    if (!col.width || col.width == "px") return "80";
    return (col.width + "").replace("px", "");
  }

  /**
   * 重置数据列表区的位置
   */
  resetDataListPosition() {
    let divDataList = this._jqObj.children(".tfp-grid-datalist");
    if (this.dataModel.showHeader) {
      divDataList.css("top", (this.headerHeight - 1) + "px");
    } else {
      divDataList.css("top", "0");
    }
    let dataListBottom = 0;
    if (this.dataModel.showSumer) dataListBottom += 39;
    if (this.dataModel.allowPaging) dataListBottom += 49;
    divDataList.css("bottom", dataListBottom + "px");
  };

  /**
   * 设置自定义单元格内组件的数据绑定值格式
   * @param {*} cdm 
   */
  setCptDataFormat(cdm) {
    if (cdm.dataBindingFormat) {
      cdm.value = cdm.dataBindingFormat;
    }
    if (cdm.components && cdm.components.length > 0) {
      for (var i = 0; i < cdm.components.length; i++) {
        this.setCptDataFormat(cdm.components[i]);
      }
    }
  }

  /**
   * 重置自定义单元格内组件的id，根据当前行索引动态生成
   * @param {*} cpt 
   * @param {*} html 
   * @param {*} rowIndex 
   * @param {*} cellIndex 
   * @returns 
   */
  replaceCustomCellCptId(cpt, html, rowIndex) {
    if (cpt.components) {
      for (let i = 0; i < cpt.components.length; i++) {
        let childCpt = cpt.components[i];
        html = html.replace("\"" + childCpt.id + "\"", "\"" + childCpt.id + "_" + rowIndex + "\"");
        html = this.replaceCustomCellCptId(childCpt, html, rowIndex);
      }
    }
    return html;
  }

  /**
   * 获得合计栏html
   * @returns 
   */
  getSumerHtml() {
    if (!this.showSumer) return "";
    let indent = this.getHtmlIndent();
    let htmlSumer = indent + "\t<div class=\"tfp-grid-sumer\" style=\"height:40px;"
      + "bottom:" + (this.allowPaging ? "49px" : "0") + ";";
    if (this.showBorder) {
      htmlSumer += "border:1px solid " + this.borderColor + ";";
    } else {
      htmlSumer += "border-top:1px solid " + this.borderColor + ";";
    }
    htmlSumer += "\">\r\n";
    let htmlSumerFixedBox = indent + "\t\t<div class=\"tfp-grid-sumer-fixed\" style=\"height:40px;width:{fixedColWidth}px;\">\r\n";
    let htmlSumerScrollBox = indent + "\t\t<div class=\"tfp-grid-sumer-scroll\" style=\"height:40px;left:{fixedColWidth}px;right:{fixedColWidthOnRight}px;\">\r\n";
    htmlSumerScrollBox += indent + "\t\t\t<div class=\"tfp-grid-sumer-scroll-box\" style=\"height:40px;\">\r\n";
    let fixedColWidth = 0;
    let fixedColWidthOnRight = 0;
    if (this.dataModel.showCheckbox) {
      htmlSumerFixedBox += indent + "\t\t<div style=\"border-right:1px solid rgba(0, 0, 0, 0);flex-basis:30px;\"></div>";
      fixedColWidth += 30;
    }
    if (this.dataModel.showRowNum) {
      htmlSumerFixedBox += indent + "\t\t<div style=\"border-right:1px solid rgba(0, 0, 0, 0);font-weight:bold;"
        + "flex-basis:" + this.indexColWidth + "px;text-align:center;line-height:38px;\">合计</div>";
      fixedColWidth += this.indexColWidth;
    }
    let htmlSumerFixedRightBox = indent + "\t\t<div class=\"tfp-grid-sumer-fixed-right\" style=\"height:40px;width:{fixedColWidthOnRight}px;\">\r\n";
    for (var i = 0; i < this.columns.length; i++) {
      let col = this.columns[i];
      let htmlSumerCol = "";
      if (!col.fixed) htmlSumerCol = "\t";
      let sumColStyle = "";
      if (i == 0) {
        sumColStyle += "font-weight:bold;";
      } else {
        if (col.align == "left") {
          sumColStyle += "justify-content: flex-start;text-align: left;";
        } else if (col.align == "right") {
          sumColStyle += "justify-content: flex-end;text-align: right;";
        }
      }
      if (i > 0 && i < (this.columns.length - 1 - this.fixedOnRightColCount) && this.showBorder)
        sumColStyle += "margin-left:3px;";
      let colWidth = parseInt(this.getColWidth(i));
      if (col.fill) {
        sumColStyle += "flex:1;";
      } else {
        sumColStyle += "flex-basis: " + colWidth + "px;";
      }
      htmlSumerCol += indent + "\t\t\t<div class=\"tfp-grid-sumer-col\" style=\""  //padding-left:2px; padding-right:2px;
        + "box-sizing: content-box;" + sumColStyle + "\">";
      if (i == 0 && !this.dataModel.showRowNum) htmlSumerCol += "合计";
      htmlSumerCol += "</div>\r\n";
      if (col.fixed) {
        htmlSumerFixedBox += htmlSumerCol;
        //TODO 如果列宽是百分比就有问题
        fixedColWidth += parseInt(colWidth);
        if (i < (this.columns.length - 1 - this.fixedOnRightColCount) && this.showBorder) fixedColWidth += 3;
      } else if (col.fixedOnRight) {
        htmlSumerFixedRightBox += htmlSumerCol;
        fixedColWidthOnRight += parseInt(colWidth);
        if (i < (this.columns.length - 1) && this.showBorder) fixedColWidthOnRight += 3;
      } else {
        htmlSumerScrollBox += htmlSumerCol;
      }
    }
    htmlSumer += htmlSumerFixedBox + indent + "\t\t</div>\r\n";
    //if (!this._tfp.isDesigning) htmlSumerScrollBox += indent + "\t\t<div style=\""
    //  + "flex-grow: 1;flex-shrink: 1; flex-basis:auto;\"></div>";
    htmlSumer += htmlSumerScrollBox + indent + "\t\t\t</div>\r\n" + indent + "\t\t</div>\r\n";
    htmlSumer += htmlSumerFixedRightBox + indent + "\t\t</div>\r\n";
    htmlSumer += indent + "\t</div>\r\n";
    htmlSumer = htmlSumer.replace(/\{fixedColWidth\}/g, fixedColWidth);
    htmlSumer = htmlSumer.replace(/\{fixedColWidthOnRight\}/g, fixedColWidthOnRight);
    return htmlSumer;
  }

  /**
   * 获得表尾html
   * @returns 
   */
  getFooterHtml() {
    if (!this.allowPaging) return "";
    let indent = this.getHtmlIndent();
    let html = indent + "\t\t<div class=\"tfp-grid-footer\" style=\"";
    if (this.showBorder) {
      html += "border:1px solid " + this.borderColor + ";";
    } else {
      html += "border-top:1px solid " + this.borderColor + ";";
    }
    html += "\">\r\n";
    html += indent + "\t\t\t<div class=\"tfp-grid-footer-left\">\r\n" +
      indent + "\t\t\t<div class=\"tfp-grid-btn-first\" title=\"首页\">&lt;&lt;</div>"
      + "<div class=\"tfp-grid-btn-prev\" title=\"上一页\">&lt;</div>"
      + "<div class=\"tfp-grid-btn-page\" title=\"\"></div>"
      + "<div class=\"tfp-grid-btn-page\" title=\"\"></div>"
      + "<div class=\"tfp-grid-btn-page\" title=\"\"></div>"
      + "<div class=\"tfp-grid-btn-page\" title=\"\"></div>"
      + "<div class=\"tfp-grid-btn-page\" title=\"\"></div>"
      + "<div class=\"tfp-grid-btn-next\" title=\"下一页\">&gt;</div>"
      + "<div class=\"tfp-grid-btn-last\" title=\"最后一页\">&gt;&gt;</div>"
      + "<div class=\"tfp-grid-input-topage\">到第 <input type=\"text\" value=\"\"> 页</div>"
      + "</div>\r\n" +
      indent + "\t\t\t<div class=\"tfp-grid-footer-right\">\r\n" +
      indent + "\t\t\t共&nbsp;<span class=\"tfp-grid-pagecount\">0</span>&nbsp;页,&nbsp;\r\n" +
      indent + "\t\t\t<span class=\"tfp-grid-rowcount\">0</span>&nbsp;条记录&nbsp;&nbsp;\r\n";
    html += indent + "\t\t\t<select class=\"tfp-grid-pagesize\">\r\n";
    let metaData = this._tfp.type(this.type);
    let pageSizeOptions = [];
    for(let i=0;i<metaData.attrs.length;i++) {
      let attrGroup = metaData.attrs[i];
      if(attrGroup.name=="footerSetting") {
        for(let j=0;j<attrGroup.items.length;j++) {
          let attr = attrGroup.items[j];
          if(attr.name=="pageSize") {
            for(let k=0;k<attr.options.length;k++) {
              pageSizeOptions.push(attr.options[k].value);
            }
            break;
          }
        }
        break;
      }
    }
    for (var i = 0; i < pageSizeOptions.length; i++) {
      let pageSize = pageSizeOptions[i];
      html += indent + "\t\t\t\t<option value=\"" + pageSize + "\"";
      if (this.pageSize == (pageSize + "")) html += " selected";
      html += ">" + pageSize + "</option>\r\n";
    }
    html += indent + "\t\t\t</select>\r\n";
    html += indent + "\t</div></div>";
    return html;
  }

  /**
   * 获得指定索引的列
   * @param {*} colIndex 
   * @returns 
   */
  getColumn(colIndex) {
    let colDiv = null;
    if (this.fixedColCount > 0 && colIndex < this.fixedColCount) {
      colDiv = this.bodyFixedBox.children(".tfp-grid-datalist-col").eq(colIndex);
    } else if (this.fixedOnRightColCount > 0 && colIndex >= (this.dataModel.columns.length - this.fixedOnRightColCount)) {
      colDiv = this.bodyFixedRightBox.children(".tfp-grid-datalist-col").eq(colIndex - (this.dataModel.columns.length - this.fixedOnRightColCount));
    } else {
      colDiv = this.bodyScrollBox.children(".tfp-grid-datalist-col").eq(colIndex - this.fixedColCount);
    }
    return colDiv;
  }

  /**
   * 隐藏指定列
   * @param {*} colIndex 
   */
  hideColumn(colIndex) {
    if (colIndex < 0 || colIndex >= this.columns.length) return;
    let colHeaderDiv = null;
    let colDataDiv = null;
    let colSumerDiv = null;
    let colDataDivWidth = 0;
    if (this.fixedColCount > 0 && colIndex < this.fixedColCount) {
      colDataDiv = this.bodyFixedBox.children(".tfp-grid-datalist-col").eq(colIndex);
      if (this.showHeader) colHeaderDiv = this.headerFixedBox.children(".tfp-grid-header-col").eq(colIndex);
      if (this.showSumer) colSumerDiv = this.sumerFixedBox.children("div").eq(colIndex);
    } else if (this.fixedOnRightColCount > 0 && colIndex >= (this.dataModel.columns.length - this.fixedOnRightColCount)) {
      colDataDiv = this.bodyFixedRightBox.children(".tfp-grid-datalist-col").eq(colIndex - (this.dataModel.columns.length - this.fixedOnRightColCount));
      if (this.showHeader) colHeaderDiv = this.headerFixedRightBox.children(".tfp-grid-header-col").eq(colIndex - (this.dataModel.columns.length - this.fixedOnRightColCount));
      if (this.showSumer) colSumerDiv = this.sumerFixedRightBox.children("div").eq(colIndex - (this.dataModel.columns.length - this.fixedOnRightColCount));
    } else {
      colDataDiv = this.bodyScrollBox.children(".tfp-grid-datalist-col").eq(colIndex - this.fixedColCount);
      if (this.showHeader) colHeaderDiv = this.headerScrollBox.children(".tfp-grid-header-col").eq(colIndex - this.fixedColCount);
      if (this.showSumer) colSumerDiv = this.sumerScrollBox.children("div").eq(colIndex - this.fixedColCount);
    }
    colDataDivWidth = tfp.getPx(colDataDiv.css("flex-basis"));
    colDataDiv.hide();
    //隐藏边框列
    let isHideBorder = false;
    if (colHeaderDiv && colHeaderDiv.length > 0) colHeaderDiv.hide();
    if (colSumerDiv && colSumerDiv.length > 0) colSumerDiv.hide();
    if (colIndex < (this.columns.length - 1) && this.showBorder) {
      if (colHeaderDiv && colHeaderDiv.length > 0) {
        let headerBorderDiv = colHeaderDiv.next();
        if (headerBorderDiv.length > 0 && headerBorderDiv.hasClass("tfp-grid-header-resize")) headerBorderDiv.hide();
      }
      let dataBorderDiv = colDataDiv.next();
      if (dataBorderDiv.length > 0 && dataBorderDiv.hasClass("tfp-grid-datalist-border")) {
        dataBorderDiv.hide();
        isHideBorder = true;
      }
    }
    //重置固定列区域宽度和滚动列左边距
    if (this.fixedColCount > 0 && colIndex < this.fixedColCount) {
      let fixedColsWidth = this.bodyFixedBox.width();
      fixedColsWidth = fixedColsWidth - colDataDivWidth;
      if (isHideBorder) fixedColsWidth -= 3;
      this.bodyFixedBox.css("width", fixedColsWidth + "px");
      this.bodyScroll.css("left", fixedColsWidth + "px");
      this.headerFixedBox.css("width", fixedColsWidth + "px");
      this.headerScroll.css("left", fixedColsWidth + "px");
      this.sumerFixedBox.css("width", fixedColsWidth + "px");
      this.sumerScroll.css("left", fixedColsWidth + "px");
    } else if (this.fixedOnRightColCount > 0 && colIndex >= (this.dataModel.columns.length - this.fixedOnRightColCount)) {
      let fixedColsWidth = this.bodyFixedRightBox.width();
      fixedColsWidth = fixedColsWidth - colDataDivWidth;
      if (isHideBorder) fixedColsWidth -= 3;
      this.bodyFixedRightBox.css("width", fixedColsWidth + "px");
      this.bodyScroll.css("right", fixedColsWidth + "px");
      this.headerFixedRightBox.css("width", fixedColsWidth + "px");
      this.headerScroll.css("right", fixedColsWidth + "px");
      this.sumerFixedRightBox.css("width", fixedColsWidth + "px");
      this.sumerScroll.css("right", fixedColsWidth + "px");
    }
    this.columns[colIndex].hidden = true;
  }

  /**
   * 显示指定列
   */
  showColumn(colIndex) {
    if (colIndex < 0 || colIndex >= this.columns.length) return;
    let colHeaderDiv = null;
    let colDataDiv = null;
    let colSumerDiv = null;
    let colDataDivWidth = 0;
    if (this.fixedColCount > 0 && colIndex < this.fixedColCount) {
      colDataDiv = this.bodyFixedBox.children(".tfp-grid-datalist-col").eq(colIndex);
      if (this.showHeader) colHeaderDiv = this.headerFixedBox.children(".tfp-grid-header-col").eq(colIndex);
      if (this.showSumer) colSumerDiv = this.sumerFixedBox.children("div").eq(colIndex);
    } else if (this.fixedOnRightColCount > 0 && colIndex >= (this.dataModel.columns.length - this.fixedOnRightColCount)) {
      colDataDiv = this.bodyFixedRightBox.children(".tfp-grid-datalist-col").eq(colIndex - (this.dataModel.columns.length - this.fixedOnRightColCount));
      if (this.showHeader) colHeaderDiv = this.headerFixedRightBox.children(".tfp-grid-header-col").eq(colIndex - (this.dataModel.columns.length - this.fixedOnRightColCount));
      if (this.showSumer) colSumerDiv = this.sumerFixedRightBox.children("div").eq(colIndex - (this.dataModel.columns.length - this.fixedOnRightColCount));
    } else {
      colDataDiv = this.bodyScrollBox.children(".tfp-grid-datalist-col").eq(colIndex - this.fixedColCount);
      if (this.showHeader) colHeaderDiv = this.headerScrollBox.children(".tfp-grid-header-col").eq(colIndex - this.fixedColCount);
      if (this.showSumer) colSumerDiv = this.sumerScrollBox.children("div").eq(colIndex - this.fixedColCount);
    }
    colDataDiv.show();
    colDataDivWidth = tfp.getPx(colDataDiv.css("flex-basis"));
    if (colHeaderDiv && colHeaderDiv.length > 0) colHeaderDiv.show();
    if (colSumerDiv && colSumerDiv.length > 0) colSumerDiv.show();
    //显示边框列
    let isShowBorder = false;
    if (colIndex < (this.columns.length - 1) && this.showBorder) {
      if (colHeaderDiv && colHeaderDiv.length > 0) {
        let headerBorderDiv = colHeaderDiv.next();
        if (headerBorderDiv.length > 0 && headerBorderDiv.hasClass("tfp-grid-header-resize")) headerBorderDiv.show();
      }
      let dataBorderDiv = colDataDiv.next();
      if (dataBorderDiv.length > 0 && dataBorderDiv.hasClass("tfp-grid-datalist-border")) {
        dataBorderDiv.show();
        isShowBorder = true;
      }
    }
    //重置固定列区域宽度和滚动列左边距
    if (this.fixedColCount > 0 && colIndex < this.fixedColCount) {
      let fixedColsWidth = this.bodyFixedBox.width();
      fixedColsWidth = fixedColsWidth + colDataDivWidth;
      if (isShowBorder) fixedColsWidth += 3;
      this.bodyFixedBox.css("width", fixedColsWidth + "px");
      this.bodyScroll.css("left", fixedColsWidth + "px");
      this.headerFixedBox.css("width", fixedColsWidth + "px");
      this.headerScroll.css("left", fixedColsWidth + "px");
      this.sumerFixedBox.css("width", fixedColsWidth + "px");
      this.sumerScroll.css("left", fixedColsWidth + "px");
    } else if (this.fixedOnRightColCount > 0 && colIndex >= (this.dataModel.columns.length - this.fixedOnRightColCount)) {
      let fixedColsWidth = this.bodyFixedRightBox.width();
      fixedColsWidth = fixedColsWidth + colDataDivWidth;
      if (isShowBorder) fixedColsWidth += 3;
      this.bodyFixedRightBox.css("width", fixedColsWidth + "px");
      this.bodyScroll.css("right", fixedColsWidth + "px");
      this.headerFixedRightBox.css("width", fixedColsWidth + "px");
      this.headerScroll.css("right", fixedColsWidth + "px");
      this.sumerFixedRightBox.css("width", fixedColsWidth + "px");
      this.sumerScroll.css("right", fixedColsWidth + "px");
    }
    this.columns[colIndex].hidden = false;
  }

  /**
   * 隐藏行
   * @param {*} rowIndex 
   * @returns 
   */
  hideRow(rowIndex) {
    let row = this.getRow(rowIndex);
    if (!row || !row.cells) return;
    for (let i = 0; i < row.cells.length; i++) {
      let cell = row.cells[i];
      cell.hide();
      let col = this.getColumn(i);
      if (this.showBorder) {
        if (col.next().hasClass("tfp-grid-datalist-border")) col.next().find(".tfp-grid-datalist-cell-border").eq(rowIndex).hide();
      }
    }
    if (this.showCheckbox) {
      this.bodyFixedBox.children(".tfp-grid-datalist-checkbox").children(".tfp-grid-datalist-cell").eq(rowIndex).hide();
    }
    if (this.showRowNum) {
      this.bodyFixedBox.children(".tfp-grid-datalist-index").children(".tfp-grid-datalist-cell").eq(rowIndex).hide();
    }
    this.bodyScrollBox.children(".tfp-grid-fill-col").children(".tfp-grid-datalist-cell").eq(rowIndex).hide();
    let index = 0;
    //重置单双行背景颜色
    /*let that = this;
    this.bodyScrollBox.children(".tfp-grid-fill-col").children(".tfp-grid-datalist-cell").each(function() {
      if($(this).css("display")=="flex") {
        that.setRowBgColor(index);
        index++;
      }
    });*/
    //TODO 分组列的高度要根据子数据进行动态调整
  }

  /**
   * 显示行
   * @param {*} rowIndex 
   * @returns 
   */
  showRow(rowIndex) {
    let row = this.getRow(rowIndex);
    if (!row || !row.cells) return;
    for (let i = 0; i < row.cells.length; i++) {
      let cell = row.cells[i];
      cell.show();
      let col = this.getColumn(i);
      if (this.showBorder) col.next().children(".tfp-grid-datalist-cell").eq(rowIndex).show();
    }
    if (this.showCheckbox) {
      this.bodyFixedBox.children(".tfp-grid-datalist-checkbox").children(".tfp-grid-datalist-cell").eq(rowIndex).show();
    }
    if (this.showRowNum) {
      this.bodyFixedBox.children(".tfp-grid-datalist-index").children(".tfp-grid-datalist-cell").eq(rowIndex).show();
    }
    this.bodyScrollBox.children(".tfp-grid-fill-col").children(".tfp-grid-datalist-cell").eq(rowIndex).show();
  }

  /**
   * 隐藏或显示子节点
   * @param {*} nodeId 
   * @returns 
   */
  toggleChildNode(node, show, nodeColDiv) {
    let that = this;
    if (!nodeColDiv) {
      if (this.fixedColCount > 0 && this.treeColIndex < this.fixedColCount) {
        nodeColDiv = this.bodyFixedBox.children(".tfp-grid-datalist-col").eq(this.treeColIndex);
      } else {
        nodeColDiv = this.bodyScrollBox.children(".tfp-grid-datalist-col").eq(this.treeColIndex - this.fixedColCount);
      }
    }
    let imgName = "expand";
    if (show) imgName = "toggle";
    let nodeDiv = nodeColDiv.children(".tfp-grid-tree-node[node-id=" + node.id + "]");

    let iconColor = "dark";
    if (this._tfp.curPage.bgColorMode == "dark") iconColor = "light";

    nodeDiv.children(".tfp-grid-tree-node-icon").attr("src", this._tfp.rootPath + "/src/components/tree/images/" + imgName + "-" + iconColor + ".png");

    for (let i = 0; i < node.childs.length; i++) {
      let nodeChildId = node.childs[i];
      let nodeChild = this.nodes[nodeChildId];
      if (!nodeChild) continue;
      let nodeDivChild = nodeColDiv.children(".tfp-grid-tree-node[node-id=" + nodeChild.id + "]");
      if (nodeDivChild.length == 0) continue;
      let rowIndex = nodeDivChild.index();
      this.bodyFixedBox.children("div").each(function () {
        if (show) {
          $(this).children("div").eq(rowIndex).show();
        } else {
          $(this).children("div").eq(rowIndex).hide();
        }
      });
      this.bodyScrollBox.children("div").each(function () {
        if (show) {
          $(this).children("div").eq(rowIndex).show();
        } else {
          $(this).children("div").eq(rowIndex).hide();
        }
      });
      if (show) {
        nodeDivChild.children(".tfp-grid-tree-node-icon").attr("src", this._tfp.rootPath + "/src/components/tree/images/expand-" + iconColor + ".png");
      } else {
        this.toggleChildNode(nodeChild, show, nodeColDiv);
      }
    }
  }

  addChildNode(parentNode, childNodesData) {
    if (!parentNode || !this.dataModel.nodeIdField || !this.dataModel.parentNodeIdField
      || !childNodesData || !Array.isArray(childNodesData) || childNodesData.length == 0) return;

    let nodeColDiv = null;
    if (this.fixedColCount > 0 && this.treeColIndex < this.fixedColCount) {
      nodeColDiv = this.bodyFixedBox.children(".tfp-grid-datalist-col").eq(this.treeColIndex);
    } else {
      nodeColDiv = this.bodyScrollBox.children(".tfp-grid-datalist-col").eq(this.treeColIndex - this.fixedColCount);
    }
    let parentNodeCellDiv = nodeColDiv.children(".tfp-grid-tree-node[node-id=" + parentNode.id + "]");
    let parentNodeCellIndex = parentNodeCellDiv.index(".tfp-grid-tree-node");

    //生成树形结构
    for (var i = 0; i < childNodesData.length; i++) {
      let rowIndex = parentNodeCellIndex + i + 1;
      let rowData = childNodesData[i];
      rowData._rowNum = rowIndex + 1;
      if (this.dataModel.allowPaging) rowData._rowNum = ((this.curPage ? this.curPage : 1) - 1) * this.pageSize + rowIndex + 1;
      let nodeId = rowData[this.dataModel.nodeIdField];
      let node = {
        id: nodeId,
        parentId: rowData[this.dataModel.parentNodeIdField],
        data: rowData,
        rowIndex: rowIndex,
        prefix: parentNode.prefix + 10,
        childs: []
      };
      this.nodes[nodeId] = node;
      this.nodeIds.push(nodeId);
      parentNode.childs.push(nodeId);
    }
    //重置父节点后面原有数据的行索引
    if (parentNodeCellIndex < (this.dataList.length - 1)) {
      for (let i = parentNodeCellIndex + 1; i < this.dataList.length; i++) {
        this.dataList[i]._rowNum = i + childNodesData.length + 1;
        if (this.dataModel.allowPaging) rowData._rowNum = ((this.curPage ? this.curPage : 1) - 1) * this.pageSize + i + childNodesData.length + 1;
      }
    }
    for (let i = parentNode.childs.length - 1; i >= 0; i--) {
      let nodeId = parentNode.childs[i];
      let node = this.nodes[nodeId];
      if (parentNodeCellIndex == (this.dataList.length - 1)) {
        this.dataList.push(node.data);
      } else {
        this.dataList.splice(parentNodeCellIndex + 1, 0, node.data);
      }
      this.addRow(node.data, node, parentNode.prefix + 10, parentNode, parentNodeCellIndex);
    }
  }

  /**
   * 动态创建自定义单元格的组件
   * @param  {[type]} cdm [description]
   * @return {[type]}     [description]
   */
  createCellCpt(parent, cdm, rowIndex, cellIndex, newCptId, rowData) {

    if (!newCptId) cdm.id = cdm.id + "_" + rowIndex;

    var cptClass = this._tfp.controllers[cdm.type];
    if (!cptClass) {
      console.log("未找到名为[" + cdm.type + "]的组件控制器！");
      return;
    }

    var cpt = new cptClass(this._tfp, cdm, parent);
    window[cpt.id] = cpt;
    cpt._jqObj = $("#" + cpt.id);
    cpt.isRendered = true;
    if (cpt._jqObj.length > 0) cpt.el = cpt._jqObj[0];

    this._tfp.bindCptData(cdm, rowData);

    if (!cdm.components || cdm.components.length == 0) return;

    for (var i = 0; i < cdm.components.length; i++) {
      this.createCellCpt(cpt, cdm.components[i], rowIndex, cellIndex, null, rowData);
    }
  }

  /**
   * 格式化单元格内容
   * @param {*} html 
   * @param {*} rowData 
   * @returns 
   */
  formatCellContent(html, rowData) {
    var cellHtml = "";
    try {
      cellHtml = this._tfp.replaceDataField(rowData, html);
      cellHtml = this._tfp.exeExpress(cellHtml);
    } catch (e) {
      console.log(e);
    }
    return cellHtml;
  }

  /**
   * 获得指定行的背景颜色
   * @param {*} rowIndex 
   * @returns 
   */
  getRowBgColor(rowIndex) {
    let bgColor = ""; //"#FFFFFF";
    //设置单双行背景颜色
    if (rowIndex % 2 == 1) {
      if (this.dataModel.doubleRowBgColor) {
        bgColor = this.dataModel.doubleRowBgColor;
      } else if (this.dataModel.doubleColor) {
        bgColor = this.dataModel.doubleColor;
      }
    } else {
      if (this.dataModel.singleRowBgColor) {
        bgColor = this.dataModel.singleRowBgColor;
      } else if (this.dataModel.singleColor) {
        bgColor = this.dataModel.singleColor;
      }
    }
    return bgColor;
  }

  /**
   * 设置行背景色
   * @param {*} rowIndex 
   * @param {*} color 
   * @returns 
   */
  setRowBgColor(rowIndex, color) {
    let row = this.getRow(rowIndex);
    if (!row) return;
    let bgColor = color;
    if (!bgColor) bgColor = this.getRowBgColor(rowIndex);
    for (let j = 0; j < row.cells.length; j++) {
      let cell = row.cells[j];
      let col = this.columns[j];
      if (col.groupContent) {
        cell.css("background-color", "");
      } else {
        cell.css("background-color", bgColor);
      }
      if (this.showCheckbox) this.bodyFixedBox.children(".tfp-grid-datalist-checkbox").children(".tfp-grid-datalist-cell").eq(rowIndex).css("background-color", bgColor);
      if (this.showRowNum) this.bodyFixedBox.children(".tfp-grid-datalist-index").children(".tfp-grid-datalist-cell").eq(rowIndex).css("background-color", bgColor);
      this.bodyScrollBox.children(".tfp-grid-fill-col").children(".tfp-grid-datalist-cell").eq(rowIndex).css("background-color", bgColor);
    }
  }

  getNodeDisplay(node, parentNode) {
    if (!this.dataModel.showTree || !node || this.dataModel.expandAllNode || parentNode) return "";
    if ((node.parentId + "") == (this.dataModel.rootNodeId + "")) return "";
    return "display:none;";
  }

  /**
   * 添加小计行单元格边框
   * @param {*} colDiv 
   * @param {*} subTotalRowBgColor 
   * @param {*} rowHeight 
   */
  addSubTotalCellBorder(colDiv, subTotalRowBgColor) {
    let borderColDiv = colDiv.prev();
    if (borderColDiv.length > 0 && borderColDiv.hasClass("tfp-grid-datalist-border")) {
      let borderHtml = "<div class=\"tfp-grid-datalist-subtotal-cell-border\" style=\"border-left:1px solid "
        + this.borderColor + ";border-bottom:1px solid " + this.borderColor + ";background-color:" + subTotalRowBgColor + ";\"></div>";
      borderColDiv.append(borderHtml);
    }
  }

  formatSumCellVal(col, cellDiv) {
    let val = 0;
    if (cellDiv.text().trim() == "") return 0;
    if (col.dataFormat == "int") {
      val += parseInt(cellDiv.text());
    } else {
      val += parseFloat(cellDiv.text().replace(",", ""));
    }
    return val;
  }

  getGroupSubTotalVal(col, colDiv, groupKeyObj) {
    if (!col || !col.sum) return "";
    let startIndex = groupKeyObj.newRowIndexs[0];
    let endIndex = groupKeyObj.newRowIndexs[groupKeyObj.newRowIndexs.length - 1];
    let sumVal = 0;
    for (let index = startIndex; index <= endIndex; index++) {
      let dataCellDiv = colDiv.children(".tfp-grid-datalist-cell").eq(index);
      let val = this.formatSumCellVal(col, dataCellDiv);
      sumVal += isNaN(val) ? 0 : val;
    }
    if (sumVal == "") sumVal = 0;
    if (col.dataFormat == "money|0.00") {
      sumVal = this._tfp.formatMoney(sumVal, 2);
    } else if (col.dataFormat == "money|0,000.00") {
      sumVal = this._tfp.formatMoney(sumVal, 2, true);
    } else if (col.dataFormat == "decimal" && col.decimalCalcReg) {
      sumVal = this._tfp.formatDecimal(sumVal, col.decimalCalcReg, col.decimalLength);
    }
    return sumVal;
  }

  /**
   * 添加小计行单元格
   * @param {*} rowData 
   * @param {*} colDiv
   * @returns 
   */
  addSubTotalCell(rowData, colDiv, col, groupKey, rowIndex, colIndex) {
    if (!this.groupRowKeys || !rowData._subTotalRowsCount) return;

    let cellAlign = "";
    if (col && col.align == "left") {
      cellAlign = "justify-content:flex-start;";
    } else if (col && col.align == "right") {
      cellAlign = "justify-content:flex-end;";
    }
    let groupKeyObj = null;
    if (groupKey) groupKeyObj = this.groupRowKeys[groupKey];
    if (rowData._subTotalRowsCount == 1) {
      let subTotalRowBgColor = this.groupSubTotalRowBgColor[this.groupSubTotalRowBgColor.length - 1];
      let cellHtml = "<div class=\"tfp-grid-datalist-subtotal-cell\" style=\"border-bottom:1px solid "
        + this.borderColor + ";" + cellAlign;
      if (subTotalRowBgColor != "") cellHtml += "background-color:" + subTotalRowBgColor + ";";
      if (this.showBorder) {
        if (colDiv.hasClass("tfp-grid-datalist-checkbox") || colDiv.hasClass("tfp-grid-datalist-index")) {
          cellHtml += "border-right:1px solid " + this.borderColor + ";";
        } else {
          this.addSubTotalCellBorder(colDiv, subTotalRowBgColor);
        }
        if (col && col.fixedOnRight && colIndex == (this.dataModel.columns.length - this.fixedOnRightColCount)) {
          cellHtml += "border-left:1px solid " + this.borderColor + ";";
        }
      }
      let sumVal = this.getGroupSubTotalVal(col, colDiv, groupKeyObj);
      cellHtml += "\">" + sumVal + "</div>";
      colDiv.append(cellHtml);
    } else {
      let arrGroupKeyObj = [];
      let gObj = groupKeyObj;
      while (gObj) {
        if (gObj.subTotal) arrGroupKeyObj.unshift(gObj);
        gObj = gObj.parent;
      }
      for (let m = rowData._subTotalRowsCount - 1; m >= 0; m--) {
        let subTotalRowBgColor = this.groupSubTotalRowBgColor[m];
        let cellHtml = "<div class=\"tfp-grid-datalist-subtotal-cell\" style=\"border-bottom:1px solid "
          + this.borderColor + ";" + cellAlign;
        if (subTotalRowBgColor != "") cellHtml += "background-color:" + subTotalRowBgColor + ";";
        if (this.showBorder) {
          if (colDiv.hasClass("tfp-grid-datalist-checkbox") || colDiv.hasClass("tfp-grid-datalist-index")) {
            cellHtml += "border-right:1px solid " + this.borderColor + ";";
          } else {
            this.addSubTotalCellBorder(colDiv, subTotalRowBgColor);
          }
          if (col && col.fixedOnRight && colIndex == (this.dataModel.columns.length - this.fixedOnRightColCount)) {
            cellHtml += "border-left:1px solid " + this.borderColor + ";";
          }
        }
        let sumVal = this.getGroupSubTotalVal(col, colDiv, arrGroupKeyObj[m]);
        cellHtml += "\">" + sumVal + "</div>";
        colDiv.append(cellHtml);
      }
    }
  }

  /**
   * 选中指定行
   * @param {*} rowIndex 
   */
  selectRow(rowIndex, scroll) {
    let _rowIndex = rowIndex;
    if(_rowIndex<0) _rowIndex = 0;
    if(this.dataList && _rowIndex>=this.dataList.length) _rowIndex = this.dataList.length - 1;
    if (this.selectedRowIndex >= 0 && this.dataModel.selectedRowBgColor) {
      this.setRowBgColor(this.selectedRowIndex);
    }
    this.selectedRowIndex = _rowIndex;
    if (this.dataModel.selectedRowBgColor) {
      this.setRowBgColor(_rowIndex, this.dataModel.selectedRowBgColor);
    } else {
      //this.setRowBgColor(_rowIndex);
    }
    let fillCell = this.bodyScrollBox.children(".tfp-grid-fill-col").children(".tfp-grid-datalist-cell").eq(_rowIndex);

    if(this.haveSetTreeNodes) return;

    //TODO 如果是树形显示，则在界面里点击行时，不能滚动，因为有的行隐藏了
    //而下面的代码在计算当前行的top位置时，没有判断上面已经隐藏的行
    if(scroll) {
      if((fillCell.position().top+this._tfp.getPx(this.rowHeight))>this.bodyScroll.height()) {
        this.bodyScroll.get(0).scrollTop = fillCell.position().top - (this.bodyScroll.height() - this._tfp.getPx(this.rowHeight));
      } else if(fillCell.position().top<this.bodyScroll.get(0).scrollTop) {
        this.bodyScroll.get(0).scrollTop = fillCell.position().top;
      }
    }
  }

  /**
   * 获得选中行的数据
   */
  getSelectedRowData() {
    if (this.selectedRowIndex < 0) return null;
    return this.dataList[this.selectedRowIndex];
  }

  /**
   * 获得选中行
   */
  getSelectedRow() {
    if (this.selectedRowIndex < 0) return null;
    return this.getRow[this.selectedRowIndex];
  }

  /**
   * 添加列
   */
  addColumn(col, colIndex, notNew, _indent, _headerHeight, hasHeaderRows, curHeaderCellLeft) {
    if(!col || !col.name) return;
    let _colIndex = -1;
    let indent = _indent ? _indent : "";
    let headerHeight = _headerHeight ? _headerHeight : parseInt(this.headerHeight); 
    let rowHeight = this.dataModel.rowHeight ? this.dataModel.rowHeight + "" : "40";
    if(!_headerHeight) headerHeight = "height:" + (headerHeight - 2) + "px;";
    if(notNew) {
      _colIndex = colIndex;
    } else {
      this.dataModel.columns.push(col);
      if(this.dataModel.headerNodes) this.dataModel.headerNodes.push({
        "name": col.name,
        "colIndex": this.dataModel.headerNodes.length
      });
      if(this.dataModel.headerRows) this.dataModel.headerRows.push({
        "content": col.name,
        "rows": 1,
        "cols": 1
      });
      if (col.allowOrder && col.orderField) {
        this.orders.push({
          field: col.orderField,
          type: col.orderType
        });
      }
      if (col.fixed) {
        this.fixedColCount++;
      } else if (col.fixedOnRight) {
        this.fixedOnRightColCount++;
      }
      if (col.allowFilter) this.haveFilterCols = true;
      _colIndex = this.dataModel.columns.length-1;
    }

    let headerStyle = "";
    let borderStyle = "";
    if (this.headerTextColor) headerStyle += "color:" + this.headerTextColor + ";";
    if (this.headerBold) headerStyle += "font-weight:bold;";
    if (this.showBorder) borderStyle = "border-right:1px solid " + this.borderColor + ";";

    let htmlHeaderCol = "";
    if (!col.fixed) htmlHeaderCol = "\t";
    htmlHeaderCol += indent + "\t\t\t<div class=\"tfp-grid-header-col\"";
    let style = headerStyle;
    let colWidth = this.getColWidth(_colIndex, true);
    var ret = {
      fixedColWidth: 0,
      fixedColWidthOnRight: 0,
      haveFillCol: false
    };
    if (col.fixed) {
      ret.fixedColWidth += parseInt(colWidth);
    } else if (col.fixedOnRight) {
      ret.fixedColWidthOnRight += parseInt(colWidth);
    }
    if (colWidth.indexOf("px") < 0 && colWidth.indexOf("%") < 0) colWidth += "px";
    if (col.fill) {
      style += "flex:1;";
      ret.haveFillCol = true;
    } else {
      style += "flex-basis: " + colWidth + ";";
    }
    if (this.showBorder && col.fixedOnRight && _colIndex == (this.dataModel.columns.length - this.fixedOnRightColCount)) {
      style += "border-left:1px solid " + this.borderColor + ";";
    }
    if(this.showBorder && !notNew) style += "border-right:1px solid " + this.borderColor + ";";
    htmlHeaderCol += " style=\"background-color:" + this.headerBgColor + ";" + headerHeight + style;

    //如果当前列设置了行转列，则运行时不显示列标题，而是根据数据动态生成
    if (!this._tfp.isDesigning && col.rowDataConvertToCol) htmlHeaderCol += "display:none;"

    htmlHeaderCol += "\">";

    if (col.allowFilter && !col.groupContent && !col.rowDataConvertToCol) {
      htmlHeaderCol += "\r\n" + indent + "\t\t\t\t<div class=\"tfp-grid-header-filter\">\r\n"
        + indent + "\t\t\t\t\t<span class=\"tfp-button-icon tfp-button-icon-guolvqi\" onclick=\""
        + this.id + ".openFilterColDataDialog(" + _colIndex + ", this)\" title=\"过滤列数据\"></span>"
        + indent + "\t\t\t\t</div>\r\n";
    }

    htmlHeaderCol += col.name;

    if (col.allowOrder && col.orderField) {
      let up = "";
      let down = "";
      if (col.orderType == "desc") up = "-blue";
      if (col.orderType == "asc") down = "-blue";
      htmlHeaderCol += "\r\n" + indent + "\t\t\t\t<div class=\"tfp-grid-header-order\" style=\"top:" + (this.headerHeight - 26) / 2 + "px;\">\r\n"
        + indent + "\t\t\t\t\t<img title=\"倒序\" src=\"" + this._tfp.rootPath + "/src/components/grid/images/icon-up" + up + ".png\""
        + " onclick=\"" + this.id + ".order('" + col.orderField + "', 'desc', this)\" />\r\n"
        + indent + "\t\t\t\t\t<img title=\"正序\" src=\"" + this._tfp.rootPath + "/src/components/grid/images/icon-down" + down + ".png\""
        + " onclick=\"" + this.id + ".order('" + col.orderField + "', 'asc', this)\" />\r\n"
        + indent + "\t\t\t\t</div>\r\n";
    }

    if (!col.fixed) htmlHeaderCol += "\t";
    htmlHeaderCol += indent + "\t\t\t</div>\r\n";

    let htmlDataCol = "";
    if (!col.fixed) htmlDataCol = "\t";
    let dataColStyle = "";
    if (col.fill) {
      dataColStyle = "flex:1;";
    } else {
      dataColStyle = "flex-basis: " + colWidth + ";";
    }
    htmlDataCol += indent + "\t\t\t<div class=\"tfp-grid-datalist-col\" style=\"" + dataColStyle + "\">\r\n";
    if (this._tfp.isDesigning) {
      htmlDataCol += this.getCellHtmlTemplate(col, 0, _colIndex);
    }
    if (!col.fixed) htmlDataCol += "\t";
    htmlDataCol += indent + "\t\t\t</div>\r\n";

    let htmlHeaderBorder = "";
    let htmlDataBorder = "";
    //增加一个列宽拖拽调节大小的框
    if ((!notNew || (notNew && _colIndex < (this.columns.length - 1))) && this.showBorder) {
      htmlHeaderBorder += indent + "\t\t\t<div class=\"tfp-grid-header-resize\" style=\""
        + headerHeight + "\" onmousedown=\"" + this.id + ".headerResizeOnMouseDown(this, " + _colIndex + ")\">\r\n"
        + indent + "\t\t\t\t<div style=\"width:1px;cursor: col-resize;background-color:"
        + this.borderColor + ";" + headerHeight + "\"></div>\r\n";
        htmlHeaderBorder += indent + "\t\t\t</div>\r\n";

        htmlDataBorder += indent + "\t\t\t<div class=\"tfp-grid-datalist-border\" "
        + "style=\"flex-basis:3px;padding:0;\">";
      if (this._tfp.isDesigning) {
        htmlDataBorder += "<div class=\"tfp-grid-datalist-cell-border\" style=\"border-left: 1px solid " + this.borderColor
          + "; border-bottom: 1px solid " + this.borderColor + "; flex-basis: " + rowHeight + "px; "
          + "background-color: " + this.getRowBgColor(0) + ";\"></div>";
      }
      htmlDataBorder += "</div>\r\n";
      if (col.fixed) ret.fixedColWidth += 3;
      if(notNew) {
        htmlHeaderCol += htmlHeaderBorder;
        htmlDataCol += htmlDataBorder;
      }
    }
    if (hasHeaderRows && curHeaderCellLeft) {
      htmlHeaderCol = "";
      for (let j = 0; j < this.dataModel.headerRows.length; j++) {
        let cellHeader = this.dataModel.headerRows[j][_colIndex];
        if (cellHeader.cols == 0 || cellHeader.rows == 0) {
          htmlHeaderCol += indent + "\t\t\t<div id=\"" + this.id + "_header_cell_" + j + "_" + _colIndex + "\" style=\"display:none;\"></div>";
        } else {
          let cellWidth = this._tfp.getPx(colWidth);
          if (cellHeader.cols > 1) {
            for (let k = 1; k < cellHeader.cols; k++) {
              cellWidth += this._tfp.getPx(this.getColWidth(k + _colIndex, true));
              if (this.showBorder) cellWidth += 3;
            }
          }
          let cellHeight = (this.headerHeight - 2);
          if (cellHeader.rows > 1) {
            cellHeight = cellHeight * cellHeader.rows;
            for (let k = 1; k < cellHeader.rows; k++) {
              curHeaderCellLeft[j + k] += cellWidth;
              if (this.showBorder) curHeaderCellLeft[j + k] += 3;
            }
          }
          htmlHeaderCol += indent + "\t\t\t<div id=\"" + this.id + "_header_cell_" + j + "_" + _colIndex + "\" "
            + " data-cell-width=\"" + cellWidth + "\" style=\"position:absolute;z-index:1;left:"
            + curHeaderCellLeft[j] + "px;top:" + (j * (this.headerHeight - 2)) + "px;width:" + cellWidth
            + "px;height:" + cellHeight + "px;line-height:120%;text-align:center;background-color:"
            + this.headerBgColor + ";display:flex;align-items:center;justify-content: center;";
          if (this.dataModel.headerBold) htmlHeaderCol += "font-weight:bold;";
          if (this.dataModel.headerTextColor) htmlHeaderCol += "color:" + this.dataModel.headerTextColor + ";";
          if ((j + cellHeader.rows) < this.dataModel.headerRows.length) {
            htmlHeaderCol += "border-bottom:1px solid " + this.borderColor + ";";
          }
          htmlHeaderCol += "\">" + cellHeader.content + "</div>";
          //添加边框
          if (_colIndex < (this.columns.length - 1) && this.showBorder && cellHeader.cols > 0) {
            //暂时不支持拖拽改变列宽，也不支持排序
            htmlHeaderCol += indent + "\t\t\t<div class=\"tfp-grid-header-resize\" style=\""
              + "position:absolute;z-index:2;left:" + (curHeaderCellLeft[j] + cellWidth)
              + "px;top:" + (j * (this.headerHeight - 2)) + "px;width:3px;height:" + cellHeight + "px;cursor:default;\""
              //+" onmousedown=\"" + this.id + ".headerResizeOnMouseDown(this, " + _colIndex + ")\""
              + ">\r\n" + indent + "\t\t\t\t<div style=\"width:1px;cursor:default;background-color:"
              + this.borderColor + ";height:" + cellHeight + "px;\"></div>\r\n";
            htmlHeaderCol += indent + "\t\t\t</div>\r\n";
            curHeaderCellLeft[j] += 3;
          }
          curHeaderCellLeft[j] += cellWidth;
        }
      }
    }
    if(notNew) {
      ret.htmlHeaderCol = htmlHeaderCol;
      ret.htmlDataCol = htmlDataCol;
      return ret;
    }
    htmlHeaderCol = htmlHeaderBorder + htmlHeaderCol;
    htmlDataCol = htmlDataBorder + htmlDataCol;
    $(htmlHeaderCol).insertBefore(this.headerScrollBox.children("div").last());
    $(htmlDataCol).insertBefore(this.bodyScrollBox.children(".tfp-grid-fill-col"));
  }

  addNullRow() {
    let rowHeight = this.dataModel.rowHeight ? this.dataModel.rowHeight + "" : "40";
    rowHeight = rowHeight.replace("px", "");
    let divFixed = this.bodyFixedBox;
    let divFixedRight = this.bodyFixedRightBox;
    let divScroll = this.bodyScrollBox;
    if (this.showCheckbox) {
      let colCheckBox = divFixed.children(".tfp-grid-datalist-checkbox").eq(0);
      colCheckBox.append("<div class=\"tfp-grid-datalist-cell\" style=\"width:100%;flex-basis:"+rowHeight+"px;border-bottom:1px solid "+this.borderColor+";\"></div>");
    }
    if (this.showRowNum) {
      let colRowNum = divFixed.children(".tfp-grid-datalist-index").eq(0);
      colRowNum.append("<div class=\"tfp-grid-datalist-cell\" style=\"width:100%;flex-basis:"+rowHeight+"px;border-bottom:1px solid "+this.borderColor+";\"></div>");
    }
    for (var i = 0; i < this.columns.length; i++) {
      let col = this.columns[i];
      let colDiv = null;
      if (col.fixed) {
        colDiv = divFixed.children(".tfp-grid-datalist-col").eq(i);
      } else if (col.fixedOnRight) {
        colDiv = divFixedRight.children(".tfp-grid-datalist-col").eq(i - (this.columns.length - this.fixedOnRightColCount));
      } else {
        colDiv = divScroll.children(".tfp-grid-datalist-col").eq(i - this.fixedColCount);
      }
      colDiv.append("<div class=\"tfp-grid-datalist-cell\" style=\"width:100%;flex-basis:"+rowHeight+"px;border-bottom:1px solid "+this.borderColor+";\"></div>");
      
      //设置边框
      if (this.showBorder && i < (this.dataModel.columns.length - 1)) {
        let borderHtml = "<div class=\"tfp-grid-datalist-cell-border\" style=\"border-left:1px solid "
          + this.borderColor + ";border-bottom:1px solid " + this.borderColor + ";flex-basis:" + rowHeight
          + "px;\"></div>";
        colDiv.next().append(borderHtml);
      }
      //设置固定列最左侧一列的左边框
      if (this.showBorder && col.fixedOnRight && i == (this.dataModel.columns.length - this.fixedOnRightColCount)) {
        cellDiv.css("border-left", "1px solid " + this.borderColor);
      }
    }
    let divFill = divScroll.children(".tfp-grid-fill-col");
    divFill.append("<div class=\"tfp-grid-datalist-cell\" style=\"width:100%;flex-basis:"+ rowHeight + "px;border-bottom:1px solid "+this.borderColor+";\"></div>");
  }

  /**
   * 添加行
   * @param {*} rowData 
   * @param {*} node 
   * @param {*} nodePrefix 
   */
  addRow(rowData, node, nodePrefix, parentNode, parentNodeCellIndex) {
    var that = this;
    let divDataList = this._jqObj.children(".tfp-grid-datalist");
    let divFixed = divDataList.children(".tfp-grid-datalist-fixed");
    let divFixedRight = divDataList.children(".tfp-grid-datalist-fixed-right");
    let divCheckBox = null;
    if (this.showCheckbox) divCheckBox = divFixed.children(".tfp-grid-datalist-checkbox");
    let divRowNum = null;
    if (this.showRowNum) divRowNum = divFixed.children(".tfp-grid-datalist-index");
    let divScroll = divDataList.children(".tfp-grid-datalist-scroll").children(".tfp-grid-datalist-scroll-box");
    let rowIndex = divScroll.children(".tfp-grid-fill-col").eq(0).children(".tfp-grid-datalist-cell").length;
    //如果是要添加树形节点的子节点
    if (parentNode) rowIndex = node.rowIndex;
    rowData._rowIndex = rowIndex;
    rowData._rowNum = rowIndex + 1;
    if (this.dataModel.allowPaging) rowData._rowNum = ((this.curPage ? this.curPage : 1) - 1) * this.pageSize + rowIndex + 1;
    let groupKey = "";

    if (this.dataModel.onBeforeAddDataRow) {
      try {
        eval(this.dataModel.onBeforeAddDataRow);
      } catch (e) {
        console.log(e);
      }
    }

    let bgColor = this.getRowBgColor(rowIndex);

    let rowHeight = this.dataModel.rowHeight ? this.dataModel.rowHeight + "" : "40";
    rowHeight = rowHeight.replace("px", "");

    //设置选择框
    if (this.showCheckbox) {
      let htmlCheckBox = "<div class=\"tfp-grid-datalist-cell\" style=\"flex-basis:" + rowHeight + "px;"
        + "border-bottom:1px solid " + this.borderColor + "; background-color:" + bgColor + ";" 
        + this.getNodeDisplay(node, parentNode);
      if (this.showBorder) htmlCheckBox += "border-right:1px solid " + this.borderColor + ";";
      htmlCheckBox += "\"><input type=\"checkbox\"";
      if (this.dataModel.dataBindingKey) {
        if (this.dataModel.dataBindingKey.indexOf(",") < 0) {
          htmlCheckBox += " value=\"{" + this.dataModel.dataBindingKey + "}\"";
        } else {
          let keys = this.dataModel.dataBindingKey.split(",");
          let keyVal = "";
          for (var i = 0; i < keys.length; i++) {
            if (i > 0) keyVal += "|";
            keyVal += "{" + keys[i] + "}";
          }
          htmlCheckBox += " value=\"" + keyVal + "\"";
        }
      }
      htmlCheckBox += " /></div>";

      let colCheckBox = divFixed.children(".tfp-grid-datalist-checkbox").eq(0);
      let cbk = null;
      //如果是要添加树形节点的子节点
      if (parentNode) {
        let parentCell = colCheckBox.children(".tfp-grid-datalist-cell").eq(parentNodeCellIndex);
        $(this.formatCellContent(htmlCheckBox, rowData)).insertAfter(parentCell);
        cbk = parentCell.next().children("input");
      } else {
        colCheckBox.append(this.formatCellContent(htmlCheckBox, rowData));
        cbk = colCheckBox.children(".tfp-grid-datalist-cell").last().children("input");
      }
      this.addSubTotalCell(rowData, divFixed.children(".tfp-grid-datalist-checkbox").eq(0));
      cbk.click(function () {
        let rowIndex = $(this).parent().index();
        that.selectRow(rowIndex);
        if (that.dataModel.onClickCheckbox) {
          let rowData = that.dataList[rowIndex];
          let checkbox = this;
          let checked = this.checked;
          try {
            eval(that.dataModel.onClickCheckbox);
          } catch (err) {
            console.log(err.message);
          }
        }
      });
    }

    //设置行序号
    if (this.showRowNum) {
      let colRowNum = divFixed.children(".tfp-grid-datalist-index").eq(0);
      let htmlRowNum = "<div class=\"tfp-grid-datalist-cell\" style=\"flex-basis:" + rowHeight + "px;"
        + "border-bottom:1px solid " + this.borderColor + "; background-color:" + bgColor + ";" + this.getNodeDisplay(node, parentNode);
      if (this.showBorder) htmlRowNum += "border-right:1px solid " + this.borderColor + ";";
      htmlRowNum += "\">" + rowData._rowNum + "</div>";
      let cellRowNum = null;
      //如果是要添加树形节点的子节点
      if (parentNode) {
        let parentCell = colRowNum.children(".tfp-grid-datalist-cell").eq(parentNodeCellIndex);
        $(htmlRowNum).insertAfter(parentCell);
        cellRowNum = parentCell.next();
      } else {
        colRowNum.append(htmlRowNum);
        cellRowNum = colRowNum.children(".tfp-grid-datalist-index").last();
      }
      cellRowNum.click(function () {
        let rowIndex = $(this).index();
        that.selectRow(rowIndex);
      });
      this.addSubTotalCell(rowData, colRowNum);
    }

    for (var i = 0; i < this.columns.length; i++) {
      let col = this.columns[i];
      let colIndex = i;
      let celElIndex = i;
      if (this.dataModel.showCheckbox) celElIndex++;
      if (this.dataModel.showRowNum) celElIndex++;

      let cellHtml = this.getCellHtmlTemplate(col, rowIndex, i, node, parentNode);
      let colDiv = null;
      if (col.fixed) {
        colDiv = divFixed.children(".tfp-grid-datalist-col").eq(i);
      } else if (col.fixedOnRight) {
        colDiv = divFixedRight.children(".tfp-grid-datalist-col").eq(i - (this.columns.length - this.fixedOnRightColCount));
      } else {
        colDiv = divScroll.children(".tfp-grid-datalist-col").eq(i - this.fixedColCount);
      }
      let cellDiv = null;
      if (this._tfp.isDesigning) {
        colDiv.append(cellHtml);
        cellDiv = colDiv.children(".tfp-grid-datalist-cell").last();
      } else {
        //如果是要添加树形节点的子节点
        if (parentNode) {
          let parentCell = colDiv.children(".tfp-grid-datalist-cell").eq(parentNodeCellIndex);
          $(this.formatCellContent(cellHtml, rowData)).insertAfter(parentCell);
          cellDiv = parentCell.next();
        } else {
          colDiv.append(this.formatCellContent(cellHtml, rowData));
          cellDiv = colDiv.children(".tfp-grid-datalist-cell").last();
          if ((!col.contentType || col.contentType == "text") && col.dataFormat) {
            this.formatTextCellContent(cellDiv, col);
          }
        }
      }
      cellDiv.attr("row-index", rowIndex);

      let haveSetBgColor = false;

      if (!this._tfp.isDesigning) {
        //如果设置了单元格数据绑定事件
        if (this.dataModel.onCellBindData) {
          try {
            let val = eval(that.dataModel.onCellBindData);
            if (val || val == 0) cellDiv.html(val);
          } catch (err) {
            console.log(err.message);
          }
        } //如果设置了内容显示条件，则按条件显示内容
        else if (col.displayConditions && col.displayConditions.length > 0) {
          let haveMatch = false;
          for (let j = 0; j < col.displayConditions.length; j++) {
            var condition = col.displayConditions[j];
            var conditionExpress = this._tfp.replaceDataField(rowData, condition.condition);
            var conditionRet = false;

            try {
              conditionRet = eval(conditionExpress);
            } catch (e) {
              console.log(condition.condition, conditionExpress, rowData);
              console.log(e);
            }
            if (conditionRet) {
              let cellHtml = "";
              if (condition.content) {
                try {
                  cellHtml = this._tfp.replaceDataField(rowData, condition.content);
                  cellHtml = this._tfp.exeExpress(cellHtml);
                } catch (e) {
                  console.log(e);
                }
              }
              if (col.contentType == "button") {
                cellDiv.children("div").html(cellHtml);
                if (condition.fontColor) cellDiv.children("div").css("color", condition.fontColor);
                if (condition.bgColor) {
                  cellDiv.children("div").css("background-color", condition.bgColor);
                }
                if (condition.bold) cellDiv.children("div").css("font-weight", "bold");
              } else if (col.contentType == "link") {
                cellDiv.children("a").html(cellHtml);
                if (condition.fontColor) cellDiv.children("a").css("color", condition.fontColor);
                if (condition.bgColor) {
                  cellDiv.css("background-color", condition.bgColor);
                  haveSetBgColor = true;
                }
                if (condition.bold) cellDiv.children("a").css("font-weight", "bold");
              } else if (col.contentType == "image") {
                cellDiv.children("img").attr("src", cellHtml);
              } else {
                cellDiv.html(cellHtml);
                if (condition.fontColor) cellDiv.css("color", condition.fontColor);
                if (condition.bgColor) {
                  cellDiv.css("background-color", condition.bgColor);
                  haveSetBgColor = true;
                }
                if (condition.bold) cellDiv.css("font-weight", "bold");
              }
              haveMatch = true;
              break;
            }
          }
          if (!haveMatch && col.notDisplayOnNoCondition) {
            cellDiv.html("");
          }
        }

        if (!col.contentType || col.contentType == "text") {
          if (col.groupContent) {
            let cellContent = this.formatCellContent(col.format, rowData);
            if (groupKey != "") groupKey += "/";
            groupKey += cellContent;
            let groupKeyObj = this.groupRowKeys[groupKey];
            let startIndex = groupKeyObj.newRowIndexs[0];
            let endIndex = groupKeyObj.newRowIndexs[groupKeyObj.newRowIndexs.length - 1];
            let borderColDiv = null;
            let rowsHeight = groupKeyObj.newRowIndexs.length * parseInt(rowHeight) + groupKeyObj.childSumCount * 40;

            //去掉当前行的边框背景
            if (this.showBorder && colDiv.prev().length > 0 && colDiv.prev().hasClass("tfp-grid-datalist-border")) {
              borderColDiv = colDiv.prev();
              let borderDiv = borderColDiv.children(".tfp-grid-datalist-cell-border").eq(rowIndex);
              borderDiv.css("background-color", "");
              borderDiv.attr("group-content", "true");
              if (rowIndex == startIndex) {
                //borderDiv.css("line-height", rowsHeight + "px");
                borderDiv.css("flex-basis", rowsHeight + "px");
              } else {
                borderDiv.hide();
              }
            }
            //如果是分组的第1行，则调整分组高度
            if (rowIndex == startIndex) {
              //cellDiv.css("line-height", rowsHeight + "px");
              cellDiv.css("flex-basis", rowsHeight + "px");
              cellDiv.css("background-color", "");
              cellDiv.attr("data-group-rows-count", groupKeyObj.newRowIndexs.length);
              cellDiv.attr("data-group-sum-rows-count", groupKeyObj.childSumCount);

              if (groupKeyObj.childSumCount > 0) {
                let cellContent = cellDiv.html();
                let borderDiv = null;
                if (borderColDiv) {
                  borderDiv = borderColDiv.children(".tfp-grid-datalist-cell-border").eq(rowIndex);
                }
                for (let k = 0; k < groupKeyObj.childSumCount; k++) {
                  $(`<div col-index="${i}" class="tfp-grid-datalist-null-cell" style="flex-basis: 30px;border-bottom: 1px solid rgb(0, 0, 0); width: 100%; display: none;" row-index="${rowIndex}"></div>`).insertAfter(cellDiv);
                  if (borderDiv) $(`<div class="tfp-grid-datalist-subtotal-cell-border" style="border-left:1px solid #000000;border-bottom:1px solid #000000;display: none;"></div>`).insertAfter(borderDiv);
                }
              }
            } else { //如果不是当前分组的第1行，则隐藏单元格
              cellDiv.hide();
            }
            //如果不是当前分组的最后1行，则隐藏边框列的底部边框
            if (rowIndex != endIndex) {
              if (borderColDiv) {
                let borderDiv = borderColDiv.children(".tfp-grid-datalist-cell-border").eq(rowIndex);
                borderDiv.css("border-bottom", "0");
              }
            } else {
              //如果要计算分组小计
              if (col.groupSubTotal) {
                let prevCellDiv = cellDiv.prev();
                //在当前列底部增加包含小计字样的单元格
                let subTotalRowBgColor = col.subTotalRowBgColor;
                colDiv.append("<div class=\"tfp-grid-datalist-subtotal-cell\" style=\"border-bottom:1px solid "
                  + this.borderColor + ";" + (subTotalRowBgColor ? "background-color:" + subTotalRowBgColor + ";" : "") + "\">小计</div>");
                this.addSubTotalCellBorder(colDiv, subTotalRowBgColor);
              }
              let pObj = groupKeyObj.parent;
              while (pObj) {
                //如果当前行是上级分组的最后一行，则底部添加一个单元格
                if (pObj.subTotal && rowIndex == pObj.newRowIndexs[pObj.newRowIndexs.length - 1]) {
                  let colParent = this.dataModel.columns[pObj.colIndex];
                  let subTotalRowBgColor = colParent.subTotalRowBgColor;
                  colDiv.append("<div class=\"tfp-grid-datalist-subtotal-cell\" style=\"border-bottom:1px solid "
                    + this.borderColor + ";" + (subTotalRowBgColor ? "background-color:" + subTotalRowBgColor + ";" : "") + "\"></div>");
                  this.addSubTotalCellBorder(colDiv, subTotalRowBgColor);
                }
                pObj = pObj.parent;
              }
            }
          } else if (this.groupRowKeys) {
            //如果设置了计算分组小计
            this.addSubTotalCell(rowData, colDiv, col, groupKey, rowIndex, i);
          }
          //如果设置了最大长度
          if (col.maxLength) {
            let content = cellDiv.text();
            if (content.gblen() > col.maxLength) {
              let iconColor = "dark";
              if (this._tfp.curPage.bgColorMode == "dark") iconColor = "light";

              let len = 0;
              for (let k = 0; k < content.length; k++) {
                if (content.charCodeAt(k) > 127 || content.charCodeAt(k) == 94) {
                  len += 2;
                } else {
                  len++;
                }
                if (len > col.maxLength) {
                  let spanC = $("<span style=\"display:none;\">" + content + "</span>");
                  cellDiv.html(content.substr(0, k) + "...");
                  cellDiv.append(spanC);
                  let imgMoreTop = (cellDiv.height() - 16) / 2;
                  cellDiv.append("<img class=\"tfp-grid-datalist-cell-more\" style=\"top:" + imgMoreTop + "px;\" "
                    + "src=\"" + this._tfp.rootPath + "/src/components/grid/images/toggle-" + iconColor + ".png\" title=\"查看全部内容\" />");
                  let imgMore = cellDiv.children(".tfp-grid-datalist-cell-more");
                  imgMore.click(function () {
                    that.showMoreContent(content, imgMore.offset().left, imgMore.offset().top);
                    window.event.stopPropagation();
                  });
                  imgMore.mouseover(function () {
                    window.event.stopPropagation();
                  });
                  break;
                }
              }
            }
          }
        } else {
          this.addSubTotalCell(rowData, colDiv, col, null, rowIndex, i);
        }

        //设置进度条
        if (col.contentType == "progress" && col.format) {
          let progress = 0;
          try {
            progress = this._tfp.replaceDataField(rowData, col.format);
            progress = this._tfp.exeExpress(progress);
            progress = parseInt(progress);
            if (progress < 0) progress = 0;
            if (progress > 100) progress = 100;
          } catch (e) {
            console.log(e);
          }
          if (progress > 0) {
            cellDiv.find(".tfp-grid-cell-progress-bar").css("width", progress + "px");
          }
          cellDiv.find(".tfp-grid-cell-progress-label").html(progress + "%");
        }

        //如果设置了onClick事件，但单元格内容为空，则移除onClick事件
        if (col.onClick && cellDiv.html() == "") cellDiv.removeAttr("onClick");

        //如果有自定义单元格，则需要动态创建单元格及其内部的组件
        if (this.customCells) {
          for (let j = 0; j < this.customCells.length; j++) {
            let cellCdm = JSON.parse(JSON.stringify(this.customCells[j]));
            cellCdm.id = this.id + "_cell_" + rowIndex + "_" + cellCdm.cellIndex;
            this.createCellCpt(this, cellCdm, rowIndex, cellCdm.cellIndex, cellCdm.id, rowData);
            this._tfp.initCptRuntime(this._tfp.get(cellCdm.id));
            this._tfp.bindCptData(cellCdm, rowData);
          }
        }

        cellDiv.click(function () {
          let srcEl = window.event.srcElement;
          //如果点击的是查看更多内容的图标，则不触发单元格点击事件
          if ($(srcEl).hasClass("tfp-grid-datalist-cell-more")) return;
          let rowIndex = $(this).index();
          that.selectRow(rowIndex);
          //如果设置了单元格点击事件
          if (that.dataModel.onCellClick) {
            let colIndex = parseInt($(this).attr("col-index"));
            let rowData = null;
            if (that.haveSetTreeNodes) {
              let rowTmp = that.getRow(rowIndex);
              if (rowTmp) rowData = rowTmp.data;
            } else {
              rowData = that.dataList[rowIndex];
            }
            try {
              eval(that.dataModel.onCellClick);
            } catch (err) {
              console.log(err.message);
            }
          }
        });

        //如果设置了单元格双击事件
        if (this.dataModel.onCellDblClick) {
          cellDiv.dblclick(function () {
            let rowIndex = $(this).index();
            let colIndex = parseInt($(this).attr("col-index"));
            let rowData = null;
            if (that.haveSetTreeNodes) {
              let rowTmp = that.getRow(rowIndex);
              if (rowTmp) rowData = rowTmp.data;
            } else {
              rowData = that.dataList[rowIndex];
            }
            try {
              eval(that.dataModel.onCellDblClick);
            } catch (err) {
              console.log(err.message);
            }
          });
        }

        //如果要显示树形，且当前列是显示树形的列
        if (node && i == this.dataModel.treeColIndex) {
          var htmlNode = cellDiv.html();
          let nodeImage = "<img src=\"" + this._tfp.rootPath + "/src/components/tree/images/transparent.png\" "
            + "style=\"margin-left:" + (nodePrefix + 2) + "px; margin-right:5px;\" />";
          if (node.childs.length > 0 || node.data.isDir) {
            let iconColor = "dark";
            if (this._tfp.curPage.bgColorMode == "dark") iconColor = "light";
            if (this.dataModel.expandAllNode) {
              nodeImage = "<img src=\"" + this._tfp.rootPath + "/src/components/tree/images/toggle-" + iconColor + ".png\" "
                + "class=\"tfp-grid-tree-node-icon\" style=\"" + "margin-left:" + nodePrefix + "px;\" />";
            } else {
              nodeImage = "<img src=\"" + this._tfp.rootPath + "/src/components/tree/images/expand-" + iconColor + ".png\" "
                + "class=\"tfp-grid-tree-node-icon\" style=\"" + "margin-left:" + nodePrefix + "px;\" />";
            }
            if (htmlNode.indexOf("<") < 0) htmlNode = "<span>" + htmlNode + "</span>";
          }
          cellDiv.html(nodeImage + htmlNode);
          cellDiv.addClass("tfp-grid-tree-node");
          cellDiv.attr("node-id", node.id);
          if (node.childs.length > 0 || node.data.isDir) {
            cellDiv.find("img").click(function () {
              let nodeId = $(this).closest(".tfp-grid-tree-node").attr("node-id");
              let nodeTmp = that.nodes[nodeId];
              if ($(this).attr("src").indexOf("expand-") > 0) {
                that.toggleChildNode(nodeTmp, true);
                if (that.dataModel["onExpandNode"]) {
                  try {
                    eval(that.dataModel["onExpandNode"]);
                  } catch (err) {
                    console.log(err);
                  }
                }
              } else {
                that.toggleChildNode(nodeTmp, false);
                if (that.dataModel["onFoldNode"]) {
                  try {
                    eval(that.dataModel["onFoldNode"]);
                  } catch (err) {
                    console.log(err);
                  }
                }
              }
              that.onResize();
            });
          }
        }

        //如果鼠标经过显示全部内容
        if (col.showMoreOnMouseOver) {
          cellDiv.mouseover(function () {
            if (cellDiv.children("span").length > 0) {
              that.showMoreContent(cellDiv.children("span").text());
            } else {
              that.showMoreContent(cellDiv.text());
            }
          });
          cellDiv.mouseout(function () {
            $("#" + that.id + "_more_content").hide();
          });
        }
      }

      //如果当前列没有设置背景颜色
      if (col.bgColor || haveSetBgColor) {
        cellDiv.attr("data-set-bg-color", "true");
      }

      if (this.showBorder && i < (this.dataModel.columns.length - 1)) {
        if (colDiv.prev().length > 0 && colDiv.prev().hasClass("tfp-grid-datalist-border")) {
          let borderBgColor = bgColor;
          if (col.bgColor) {
            if (col.contentType == "button" && !col.buttonBgColor) {
              borderBgColor = "";
            } else {
              borderBgColor = col.bgColor;
            }
            colDiv.prev().children(".tfp-grid-datalist-cell-border").eq(rowIndex).css("background-color", borderBgColor);
          }
        }
        let borderHtml = "<div class=\"tfp-grid-datalist-cell-border\" style=\"border-left:1px solid "
          + this.borderColor + ";border-bottom:1px solid " + this.borderColor + ";flex-basis:" + rowHeight
          + "px;background-color:" + bgColor + ";" + this.getNodeDisplay(node, parentNode) + "\"></div>";
        //TODO 要考虑动态添加树形节点的情况
        colDiv.next().append(borderHtml);
      }
      //设置固定列最左侧一列的左边框
      if (this.showBorder && col.fixedOnRight && i == (this.dataModel.columns.length - this.fixedOnRightColCount)) {
        cellDiv.css("border-left", "1px solid " + this.borderColor);
      }
    }

    //填充列的背景色要和最后一列的背景色一致
    let lastCellBgColor = bgColor;
    let lastCol = divScroll.children(".tfp-grid-datalist-col").last();
    let lastCellSetBgColor = false;
    if (lastCol.length > 0) {
      let lastCell = lastCol.children("div").last();
      let col = this.columns[this.columns.length - 1];
      if (col.bgColor) lastCellBgColor = col.bgColor;
      lastCellSetBgColor = lastCell.attr("data-set-bg-color");
    }
    let htmlFillCol = "<div class=\"tfp-grid-datalist-cell\" style=\"width:100%;flex-basis:"
      + rowHeight + "px;border-bottom:1px solid " + this.borderColor + ";background-color:"
      + lastCellBgColor + ";" + this.getNodeDisplay(node, parentNode) + "\"";
    //如果最后一列设置了特殊的背景色，则填充列也要用该背景色
    if (lastCellSetBgColor == "true") htmlFillCol += " data-set-bg-color=\"true\"";
    htmlFillCol += "></div>";
    let divFill = divScroll.children(".tfp-grid-fill-col");

    //如果是要添加树形节点的子节点
    if (parentNode) {
      let parentCell = divFill.children(".tfp-grid-datalist-cell").eq(parentNodeCellIndex);
      $(htmlFillCol).insertAfter(parentCell);
    } else {
      divFill.append(htmlFillCol);
    }
    this.addSubTotalCell(rowData, divFill);

    this.setCellMouseOverOutEvent(divFixed, divFixed, divScroll, divFixedRight);
    this.setCellMouseOverOutEvent(divScroll, divFixed, divScroll, divFixedRight);
    this.setCellMouseOverOutEvent(divFixedRight, divFixed, divScroll, divFixedRight);

    if (this.dataModel.onAfterAddDataRow) {
      try {
        eval(this.dataModel.onAfterAddDataRow);
      } catch (e) {
        console.log(e);
      }
    }
  }

  /**
   * 设置单元格在鼠标滑过时的背景颜色
   * @param {*} divBox 
   * @param {*} rowIndex 
   */
  setCellMouseOverBgColor(divBox, rowIndex) {
    if (this.notChangeBgColorOnMouseOver) return;
    const that = this;
    divBox.children("div").each(function () {
      let cellDiv = null;
      if ($(this).hasClass("tfp-grid-datalist-border")) {
        cellDiv = $(this).children(".tfp-grid-datalist-cell-border").eq(rowIndex);
      } else {
        cellDiv = $(this).children(".tfp-grid-datalist-cell").eq(rowIndex);
      }
      if (cellDiv.attr("data-set-bg-color") || cellDiv.attr("data-group-rows-count")
        || cellDiv.attr("group-content") || cellDiv.css("display") != "flex") return;
      if (that._tfp.curPage.bgColorMode == "dark") {
        cellDiv.css("background-color", "#444444");
      } else {
        cellDiv.css("background-color", "#F3F3F3");
      }
    });
  }

  /**
   * 设置单元格在鼠标滑出时的背景颜色
   * @param {*} divBox 
   * @param {*} rowIndex 
   * @param {*} bgColor 
   */
  setCellMouseOutBgColor(divBox, rowIndex, bgColor) {
    if (this.notChangeBgColorOnMouseOver) return;
    divBox.children("div").each(function () {
      let cellDiv = null;
      if ($(this).hasClass("tfp-grid-datalist-border")) {
        cellDiv = $(this).children(".tfp-grid-datalist-cell-border").eq(rowIndex);
      } else {
        cellDiv = $(this).children(".tfp-grid-datalist-cell").eq(rowIndex);
      }
      if (cellDiv.attr("data-set-bg-color") || cellDiv.attr("data-group-rows-count")
        || cellDiv.attr("group-content") || cellDiv.css("display") != "flex") return;
      cellDiv.css("background-color", bgColor);
    });
  }

  /**
   * 设置单元格在鼠标滑入滑出时的事件
   * @param {*} divBox 
   * @param {*} divFixed 
   * @param {*} divScroll 
   */
  setCellMouseOverOutEvent(divBox, divFixed, divScroll, divFixedRight) {
    const that = this;
    divBox.children("div").each(function () {
      const lastCell = $(this).children(".tfp-grid-datalist-cell").last();
      lastCell.mouseover(function () {
        let rowIndex = parseInt($(this).attr("row-index"));

        if (!$(this).attr("data-group-rows-count") && rowIndex != that.selectedRowIndex) {
          that.setCellMouseOverBgColor(divFixed, rowIndex);
          that.setCellMouseOverBgColor(divScroll, rowIndex);
          that.setCellMouseOverBgColor(divFixedRight, rowIndex);
        }

        if (that.dataModel.onRowMouseOver) {
          let colIndex = $(this).attr("col-index");
          try {
            eval(that.dataModel.onRowMouseOver);
          } catch (err) {
            console.log(err.message);
          }
        }
      });
      lastCell.mouseout(function () {
        let rowIndex = parseInt($(this).attr("row-index"));
        let bgColor = that.getRowBgColor(rowIndex);

        if (!$(this).attr("data-group-rows-count") && rowIndex != that.selectedRowIndex) {
          that.setCellMouseOutBgColor(divFixed, rowIndex, bgColor);
          that.setCellMouseOutBgColor(divScroll, rowIndex, bgColor);
          that.setCellMouseOutBgColor(divFixedRight, rowIndex, bgColor);
        }

        if (that.dataModel.onRowMouseOut) {
          try {
            eval(that.dataModel.onRowMouseOut);
          } catch (err) {
            console.log(err.message);
          }
        }
      });
    });
  }

  /**
   * 获得指定索引的行
   * @param  {[type]} rowIndex [description]
   * @return {[type]}          [description]
   */
  getRow(rowIndex) {
    let row = {
      index: rowIndex,
      cells: []
    }
    this.bodyFixedBox.children(".tfp-grid-datalist-col").each(function () {
      row.cells.push($(this).children(".tfp-grid-datalist-cell").eq(rowIndex));
    });
    this.bodyScrollBox.children(".tfp-grid-datalist-col").each(function () {
      row.cells.push($(this).children(".tfp-grid-datalist-cell").eq(rowIndex));
    });
    this.bodyFixedRightBox.children(".tfp-grid-datalist-col").each(function () {
      row.cells.push($(this).children(".tfp-grid-datalist-cell").eq(rowIndex));
    });
    if (!this._tfp.isDesigning) {
      if (this.haveSetTreeNodes) {
        if (row.cells.length > 0) {
          let firstCell = row.cells[0];
          let nodeId = firstCell.attr("grid-tree-node-id");
          if (nodeId) {
            let node = this.nodes[nodeId];
            if (node) row.data = node.data;
          }
        }
      } else {
        if (!this.dataList || rowIndex >= this.dataList.length) return null;
        row.data = this.dataList[rowIndex];
      }
    }
    return row;
  }

  /**
   * 获得指定索引行的数据
   * @param  {[type]} rowIndex [description]
   * @return {[type]}          [description]
   */
  getRowData(rowIndex) {
    return this.dataList[rowIndex];
  }

  /**
   * 获得指定单元格
   * @param  {[type]} rowIndex [description]
   * @param  {[type]} colIndex [description]
   * @return {[type]}          [description]
   */
  getCell(rowIndex, colIndex) {
    let row = this.getRow(rowIndex);
    if (!row) return null;
    if (colIndex >= row.cells.length) return null;
    return row.cells[colIndex];
  }

  /**
   * 移除行
   * @param  {[type]} rowIndex [description]
   * @return {[type]}          [description]
   */
  removeRow(rowIndex) {
    if (rowIndex >= this.dataList.length) return;
    this.bodyFixedBox.children(".tfp-grid-datalist-col").each(function () {
      $(this).children(".tfp-grid-datalist-cell").eq(rowIndex).remove();
    });
    this.bodyScrollBox.children(".tfp-grid-datalist-col").each(function () {
      $(this).children(".tfp-grid-datalist-cell").eq(rowIndex).remove();
    });
    this.bodyFixedRightBox.children(".tfp-grid-datalist-col").each(function () {
      $(this).children(".tfp-grid-datalist-cell").eq(rowIndex).remove();
    });
    if (this.showBorder) {
      this.bodyFixedBox.children(".tfp-grid-datalist-border").each(function () {
        $(this).children(".tfp-grid-datalist-cell-border").eq(rowIndex).remove();
      });
      this.bodyScrollBox.children(".tfp-grid-datalist-border").each(function () {
        $(this).children(".tfp-grid-datalist-cell-border").eq(rowIndex).remove();
      });
      this.bodyFixedRightBox.children(".tfp-grid-datalist-border").each(function () {
        $(this).children(".tfp-grid-datalist-cell-border").eq(rowIndex).remove();
      });
    }
    if (this.showCheckbox) this.bodyFixedBox.children(".tfp-grid-datalist-checkbox").children(".tfp-grid-datalist-cell").eq(rowIndex).remove();
    if (this.showRowNum) this.bodyFixedBox.children(".tfp-grid-datalist-index").children(".tfp-grid-datalist-cell").eq(rowIndex).remove();
    this.bodyScrollBox.children(".tfp-grid-fill-col").children(".tfp-grid-datalist-cell").eq(rowIndex).remove();
    this.dataList.splice(rowIndex, 1);
    this.onResize();
    //TODO  分组列需要特殊处理，需要重新设置单双行背景，重新计算行序号
  }

  /**
   * 清空所有行
   */
  clear() {
    this.bodyFixedBox.children(".tfp-grid-datalist-col").each(function () {
      $(this).empty();
    });
    this.bodyScrollBox.children(".tfp-grid-datalist-col").each(function () {
      $(this).empty();
    });
    this.bodyFixedRightBox.children(".tfp-grid-datalist-col").each(function () {
      $(this).empty();
    });
    if (this.showBorder) {
      this.bodyFixedBox.children(".tfp-grid-datalist-border").each(function () {
        $(this).empty();
      });
      this.bodyScrollBox.children(".tfp-grid-datalist-border").each(function () {
        $(this).empty();
      });
      this.bodyFixedRightBox.children(".tfp-grid-datalist-border").each(function () {
        $(this).empty();
      });
    }
    if (this.showCheckbox) this.bodyFixedBox.children(".tfp-grid-datalist-checkbox").empty();
    if (this.showRowNum) this.bodyFixedBox.children(".tfp-grid-datalist-index").empty();
    this.bodyScrollBox.children(".tfp-grid-fill-col").empty();
    this.dataList = [];
  }

  /**
   * 删除行数据
   * @param  {[type]} keyValue [description]
   * @return {[type]}          [description]
   */
  deleteRowData(keyValue) {
    if (!this.dataModel.delDataService && !this.dataModel.dataDeleteSetting) {
      this._tfp.showMsg("请设置删除数据的方式！");
      return;
    }
    if (!this.dataModel.dataBindingKey) {
      this._tfp.showMsg("请设置数据主键字段名！");
      return;
    }
    let __arguments = arguments;
    let that = this;
    this._tfp.showConfirm("确定删除？", function (ret) {
      if (ret) {
        let args = {};
        if (that.dataModel.dataBindingKey.indexOf(",") < 0) {
          args[that.dataModel.dataBindingKey] = keyValue;
        } else {
          let dataKeys = that.dataModel.dataBindingKey.split(",");
          for (var i = 0; i < dataKeys.length; i++) {
            if (__arguments.length < (i + 2)) break;
            args[dataKeys[i]] = __arguments[i + 1];
          }
        }

        if (that.dataModel.onBeforeDeleteData) {
          try {
            eval(that.dataModel.onBeforeDeleteData);
          } catch (err) {
            console.log(err);
          }
        }

        if (that.dataModel.dataDeleteSetting && that.dataModel.dataDeleteSetting.servicePath) {
          that._tfp.use("Service", function () {
            let service = that._tfp.new("Service");
            service.path = that.dataModel.dataDeleteSetting.servicePath;
            if (that.dataModel.dataDeleteSetting.requestArgs && that.dataModel.dataDeleteSetting.requestArgs.length > 0) {
              service.argSettings = that.dataModel.dataDeleteSetting.requestArgs;
            }
            if (that.dataModel.dataDeleteSetting.encryptRequestArgs) service.encryptRequestArgs = that.dataModel.dataDeleteSetting.encryptRequestArgs;
            if (that.dataModel.dataDeleteSetting.encryptResponseArgs) service.encryptResponseArgs = that.dataModel.dataDeleteSetting.encryptResponseArgs;
            service.request(args, function (req, res) {
              if (res.code != 0) {
                that._tfp.showMsg(res.message);
                return;
              }

              if (that.dataModel.onAfterDeleteData) {
                try {
                  eval(that.dataModel.onAfterDeleteData);
                } catch (err) {
                  console.log(err);
                }
              }

              that.reloadData();
            });
          });
        } else {
          let serviceId = that.dataModel.delDataService;
          if (that.dataModel.dataDeleteSetting && that.dataModel.dataDeleteSetting.serviceCpt) {
            serviceId = that.dataModel.dataDeleteSetting.serviceCpt;
          }
          let serviceCpt = that._tfp.components[serviceId];
          if (!serviceCpt) {
            that._tfp.showMsg("ID为[" + serviceId + "]的组件不存在！");
            return;
          }
          serviceCpt.request(args, function (req, res) {
            if (res.code != 0) {
              that._tfp.showMsg(res.message);
              return;
            }

            if (that.dataModel.onAfterDeleteData) {
              try {
                eval(that.dataModel.onAfterDeleteData);
              } catch (err) {
                console.log(err);
              }
            }

            that.reloadData();
          });
        }
      }
    });
  }

  //该方法将来不再使用，请使用deleteRowData
  deleteRow(keyValue) {
    this.deleteRowData(keyValue);
  }

  /**
   * 批量删除选中行的数据
   * @returns 
   */
  deleteCheckedRowsData() {
    let keys = this.getCheckedKeys();
    if (!keys) {
      this._tfp.showMsg("请选择要删除的行！");
      return;
    }
    if (!this.dataModel.delDataService && !this.dataModel.dataDeleteSetting) {
      this._tfp.showMsg("请设置删除数据的方式！");
      return;
    }
    if (!this.dataModel.dataBindingKey) {
      this._tfp.showMsg("请设置数据主键字段名！");
      return;
    }
    let __arguments = arguments;
    let that = this;
    this._tfp.showConfirm("确定删除？", function (ret) {
      if (ret) {
        let args = {};
        if (that.dataModel.dataBindingKey.indexOf(",") < 0) {
          args[that.dataModel.dataBindingKey] = keys;
        } else {
          let dataKeys = that.dataModel.dataBindingKey.split(",");
          let checkedKeys = keys.split(",");
          checkedKeys.forEach(rowKeyVal => {
            let oneRowKeyVals = rowKeyVal.split('|');
            for (var i = 0; i < dataKeys.length; i++) {
              if (oneRowKeyVals.length <= i) continue;
              if (args[dataKeys[i]]) args[dataKeys[i]] += ",";
              args[dataKeys[i]] += oneRowKeyVals[i];
            }
          });
        }

        if (that.dataModel.onBeforeDeleteData) {
          try {
            eval(that.dataModel.onBeforeDeleteData);
          } catch (err) {
            console.log(err);
          }
        }

        if (that.dataModel.dataDeleteSetting && that.dataModel.dataDeleteSetting.servicePath) {
          that._tfp.use("Service", function () {
            let service = that._tfp.new("Service");
            service.path = that.dataModel.dataDeleteSetting.servicePath;
            if (that.dataModel.dataDeleteSetting.requestArgs && that.dataModel.dataDeleteSetting.requestArgs.length > 0) {
              service.argSettings = that.dataModel.dataDeleteSetting.requestArgs;
            }
            if (that.dataModel.dataDeleteSetting.encryptRequestArgs) service.encryptRequestArgs = that.dataModel.dataDeleteSetting.encryptRequestArgs;
            if (that.dataModel.dataDeleteSetting.encryptResponseArgs) service.encryptResponseArgs = that.dataModel.dataDeleteSetting.encryptResponseArgs;
            service.request(args, function (req, res) {
              if (res.code != 0) {
                that._tfp.showMsg(res.message);
                return;
              }

              if (that.dataModel.onAfterDeleteData) {
                try {
                  eval(that.dataModel.onAfterDeleteData);
                } catch (err) {
                  console.log(err);
                }
              }

              that.reloadData();
            });
          });
        } else {
          let serviceId = that.dataModel.delDataService;
          if (that.dataModel.dataDeleteSetting && that.dataModel.dataDeleteSetting.serviceCpt) {
            serviceId = that.dataModel.dataDeleteSetting.serviceCpt;
          }
          let serviceCpt = that._tfp.components[serviceId];
          if (!serviceCpt) {
            that._tfp.showMsg("ID为[" + serviceId + "]的组件不存在！");
            return;
          }
          serviceCpt.request(args, function (req, res) {
            if (res.code != 0) {
              that._tfp.showMsg(res.message);
              return;
            }

            if (that.dataModel.onAfterDeleteData) {
              try {
                eval(that.dataModel.onAfterDeleteData);
              } catch (err) {
                console.log(err);
              }
            }

            that.reloadData();
          });
        }
      }
    });
  }

  /**
   * 根据指定字段的值进行排序
   * @param {*} field 
   * @param {*} type 
   * @param {*} img 
   * @returns 
   */
  order(field, type, img) {
    this.orders = [{
      field: field,
      type: type
    }];
    /*for (let i = 0; i < this.orders.length; i++) {
      let o = this.orders[i];
      if (o.field == field) {
        //如果排序规则没有变化
        if (o.type == type) return;
        o.type = type;
        break;
      }
    }*/
    if (img) {
      let divOrder = $(img).parent();
      if (type == "asc") {
        divOrder.find("img").eq(0).attr("src", this._tfp.rootPath + "/src/components/grid/images/icon-up.png");
        divOrder.find("img").eq(1).attr("src", this._tfp.rootPath + "/src/components/grid/images/icon-down-blue.png");
      } else {
        divOrder.find("img").eq(0).attr("src", this._tfp.rootPath + "/src/components/grid/images/icon-up-blue.png");
        divOrder.find("img").eq(1).attr("src", this._tfp.rootPath + "/src/components/grid/images/icon-down.png");
      }
    }
    this.loadData(1);
  }

  /**
   * 显示单元格的更多内容
   * @param {*} content 
   */
  showMoreContent(content, left, top) {
    let divId = this.id + "_more_content";
    let moreDiv = $("#" + divId);
    let e = window.event;
    if (moreDiv.length == 0) {
      $("body").append("<div id=\"" + divId + "\" class=\"tfp-grid-more-content\"></div>");
      moreDiv = $("#" + divId);
      moreDiv.mouseover(function () {
        moreDiv.show();
      });
      moreDiv.mouseout(function () {
        moreDiv.html("");
        moreDiv.hide();
      });
    }
    let y = e.clientY;
    if (top) y = top;
    if (y < 0) y = 0;
    moreDiv.css("top", y);
    let x = e.clientX;
    if (left) x = left;
    if (x < 0) x = 0;
    moreDiv.css("left", x);
    moreDiv.html(content);

    let sw = document.documentElement.clientWidth;
    let sh = document.documentElement.clientHeight;
    let dw = moreDiv.outerWidth();
    let dh = moreDiv.outerHeight();
    if (y + dh > sh) moreDiv.css("top", (sh - dh - 10) + "px");
    if (x + dw > sw) moreDiv.css("left", (sw - dw - 10) + "px");

    moreDiv.show();
  }

  toggleCheckAll() {
    let cbkAll = this.header.find("input[type=checkbox]").get(0);
    if(cbkAll.checked) {
      this.checkAll();
    } else {
      this.unCheckAll();
    }
    let checked = cbkAll.checked;
    if(this.dataModel.onClickCheckAll) eval(this.dataModel.onClickCheckAll);
  }

  /**
   * 全选 
   */
  checkAll() {
    let divCheckBox = this.bodyFixedBox.children(".tfp-grid-datalist-checkbox");
    divCheckBox.children(".tfp-grid-datalist-cell").each(function () {
      if ($(this).find("input").length > 0 && $(this).find("input").get(0)) {
        $(this).find("input").get(0).checked = true;
      }
    });

    if (this.showHeader) {
      let cbk = this.header.find("input[type=checkbox]").get(0);
      cbk.checked = true;
    }
  }

  /**
   * 取消全选 
   */
  unCheckAll() {
    let divCheckBox = this.bodyFixedBox.children(".tfp-grid-datalist-checkbox");
    divCheckBox.children(".tfp-grid-datalist-cell").each(function () {
      if ($(this).find("input").length > 0 && $(this).find("input").get(0)) {
        $(this).find("input").get(0).checked = false;
      }
    });

    if (this.showHeader) {
      let cbk = this.header.find("input[type=checkbox]").get(0);
      cbk.checked = false;
    }
  }

  /**
   * 选中指定索引的行
   * @param {*} rowIndex 
   */
  checkRow(rowIndex) {
    if (!this.showCheckbox) return;
    let divCheckBox = this.bodyFixedBox.children(".tfp-grid-datalist-checkbox");
    let cbk = divCheckBox.children(".tfp-grid-datalist-cell").eq(rowIndex).children("input");
    if (cbk.length > 0) cbk.get(0).checked = true;
  }

  /**
   * 取消选中指定索引的行
   * @param {*} rowIndex 
   */
  unCheckRow(rowIndex) {
    if (!this.showCheckbox) return;
    let divCheckBox = this.bodyFixedBox.children(".tfp-grid-datalist-checkbox");
    let cbk = divCheckBox.children(".tfp-grid-datalist-cell").eq(rowIndex).children("input");
    if (cbk.length > 0) cbk.get(0).checked = false;
  }

  /**
   * 获得选中行的主键值
   * @return {[type]} [description]
   */
  getCheckedKeys() {
    let vals = "";
    let divCheckBox = this.bodyFixedBox.children(".tfp-grid-datalist-checkbox");
    divCheckBox.children(".tfp-grid-datalist-cell").each(function () {
      if ($(this).find("input").length == 0) return;
      let cbk = $(this).find("input").get(0);
      if (cbk.checked) {
        if (vals != "") vals += ",";
        vals += cbk.value;
      }
    });
    return vals;
  }

  /**
   * 该方法将来不再使用
   * @return {[type]} [description]
   */
  getCheckedValues() {
    return this.getCheckedKeys();
  }

  /**
   * 获得选中的数据
   * @return {[type]} [description]
   */
  getCheckedData() {
    const that = this;
    let rows = [];
    let divCheckBox = this.bodyFixedBox.children(".tfp-grid-datalist-checkbox");
    divCheckBox.children(".tfp-grid-datalist-cell").each(function () {
      if ($(this).find("input").length == 0) return;
      let cbk = $(this).find("input").get(0);
      if (cbk.checked) {
        rows.push(that.dataList[$(this).index()]);
      }
    });
    return rows;
  }

  /**
   * 该方法将来不再使用
   * @return {[type]} [description]
   */
  getCheckedRows() {
    return this.getCheckedData();
  }

  /**
   * 获得选中的行
   * @returns 
   */
  getRowsChecked() {
    const that = this;
    let rows = [];
    let divCheckBox = this.bodyFixedBox.children(".tfp-grid-datalist-checkbox");
    let rowIndex = 0;
    divCheckBox.children(".tfp-grid-datalist-cell").each(function () {
      if ($(this).find("input").length == 0) return;
      let cbk = $(this).find("input").get(0);
      if (cbk.checked) {
        rows.push(that.getRow(rowIndex));
      }
      rowIndex++;
    });
    return rows;
  }

  /**
   * 设置合计行
   * @returns 
   */
  setSumer() {
    if (!this.dataModel.showSumer) return;
    for (var i = 0; i < this.columns.length; i++) {
      let col = this.columns[i];
      var countRows = this.count_rows || {};
      var fieldName = (col.format || '').replace(/^\{/gi, '').replace(/\}$/gi, '');
      if (col.sum) {
        let colIndex = i;
        let colDiv = null;
        if (this.fixedColCount > 0 && i <= (this.fixedColCount - 1)) {
          colDiv = this.sumer.children(".tfp-grid-sumer-fixed").children(".tfp-grid-sumer-col").eq(colIndex);
        } else if (this.fixedOnRightColCount > 0 && i >= (this.dataModel.columns.length - this.fixedOnRightColCount)) {
          colDiv = this.sumer.children(".tfp-grid-sumer-fixed-right").children(".tfp-grid-sumer-col").eq(colIndex - (this.dataModel.columns.length - this.fixedOnRightColCount));
        } else {
          colDiv = this.sumer.find(".tfp-grid-sumer-scroll-box").children(".tfp-grid-sumer-col").eq(colIndex - this.fixedColCount);
        }
        if (col.dataFormat == "int") {
          colDiv.html(parseInt(col.sumValue));
        } else if (col.dataFormat == "money|0.00") {
          colDiv.html(this._tfp.formatMoney(col.sumValue, 2));
        } else if (col.dataFormat == "money|0,000.00") {
          colDiv.html(this._tfp.formatMoney(col.sumValue, 2, true));
        } else {
          if (col.decimalLength && (col.decimalLength + "") != "0") {
            colDiv.html(this._tfp.formatDecimal(col.sumValue, col.decimalCalcReg, col.decimalLength));
          } else if ((col.decimalLength + "") == "0") {
            colDiv.html(parseInt(col.sumValue));
          } else {
            colDiv.html(parseFloat(col.sumValue));
          }
        }

        if (!isNull(countRows[fieldName])) colDiv.html(parseFloat(countRows[fieldName]));
      }
    }
  };

  /**
   * 设置表尾
   */
  setFooter() {
    if (this.dataModel.showSumer) this.setSumer();
    if (this.dataModel.allowPaging) {
      let footerDiv = this._jqObj.children(".tfp-grid-footer");
      let arr = [];
      let index = parseInt(this.curPage);
      while (index > 0 && arr.length < 3) {
        arr.unshift(index);
        index--;
      }
      index = parseInt(this.curPage) + 1;
      while (arr.length < 5 && index <= this.pageCount) {
        arr.push(index);
        index++;
      }
      for (let i = 0; i < arr.length; i++) {
        let btn = footerDiv.find(".tfp-grid-btn-page").eq(i);
        btn.html(arr[i]);
        btn.attr("title", "跳转到第" + arr[i] + "页");
        if (arr[i] == parseInt(this.curPage)) {
          btn.css("background-color", "var(--sys-theme-color)");
          btn.css("color", "#FFFFFF");
        } else {
          btn.css("background-color", "");
          btn.css("color", "");
        }
        btn.show();
      }
      for (let i = arr.length; i < 5; i++) {
        let btn = footerDiv.find(".tfp-grid-btn-page").eq(i);
        btn.html("");
        btn.attr("title", "");
        btn.hide();
      }
      footerDiv.find(".tfp-grid-pagecount").text(this.pageCount);
      footerDiv.find(".tfp-grid-rowcount").text(this.rowsCount);
      footerDiv.find(".tfp-grid-input-topage").find("input").val(this.curPage);
    }
  }

  /**
   * 改变每页显示记录数
   * @param {*} slt 
   * @returns 
   */
  changePageSize(slt) {
    //if (!this.dataModel.loadDataService || !this.dataModel.dataBindingMember) return;
    this.pageSize = tfp.isInt(slt) ? slt : slt.value;
    this.loadData(this.curPage);
  }

  /**
   * 跳转到指定页面
   * @param {*} toPage 
   */
  gotoPage(toPage) {
    this.loadData(toPage);
  }

  treeNodeHaveData(node) {
    if (!node.data.isDir) return true;
    if (node.childs) {
      for (let i = 0; i < node.childs.length; i++) {
        let nodeChild = this.nodes[node.childs[i]];
        if (!nodeChild) continue;
        let ret = this.treeNodeHaveData(nodeChild);
        if (ret) return true;
      }
    }
    return false;
  }

  /**
   * 添加节点行
   * @param {*} nodeId 
   * @param {*} prefix 
   * @returns 
   */
  addNodeRow(nodeId, prefix) {
    let node = this.nodes[nodeId];
    if (!node) return;
    node.prefix = prefix;
    if (!this.dataModel.dynamicLoadChildNodes) {
      let haveData = this.treeNodeHaveData(node);
      if (!haveData) return;
    }
    this.addRow(node.data, node, prefix);
    for (let i = 0; i < node.childs.length; i++) {
      this.addNodeRow(node.childs[i], prefix + 10);
    }
  }

  scrollToTop() {
    let dataListDiv = this.body.children(".tfp-grid-datalist-scroll").get(0);
    dataListDiv.scrollTop = 0;
    if(this.bodyFixedBox && this.bodyFixedBox.length>0) this.bodyFixedBox.get(0).scrollTop = dataListDiv.scrollTop;
    if(this.bodyFixedRightBox && this.bodyFixedRightBox.length>0) this.bodyFixedRightBox.get(0).scrollTop = dataListDiv.scrollTop;
  }

  scrollToBottom() {
    let dataListDiv = this.body.children(".tfp-grid-datalist-scroll").get(0);
    let top = dataListDiv.scrollHeight - this.body.get(0).clientHeight;
    if (top < 0) top = 0;
    dataListDiv.scrollTop = top;
    if(this.bodyFixedBox && this.bodyFixedBox.length>0) this.bodyFixedBox.get(0).scrollTop = dataListDiv.scrollTop;
    if(this.bodyFixedRightBox && this.bodyFixedRightBox.length>0) this.bodyFixedRightBox.get(0).scrollTop = dataListDiv.scrollTop;
  }

  scrollToLeft() {
    let dataListDiv = this.body.children(".tfp-grid-datalist-scroll").get(0);
    dataListDiv.scrollLeft = 0;
  }

  scrollToRight() {
    let dataListDiv = this.body.children(".tfp-grid-datalist-scroll").get(0);
    let left = dataListDiv.scrollWidth - this.body.get(0).clientWidth;
    if (left < 0) left = 0;
    dataListDiv.scrollLeft = left;
  }

  addGroupRow(groupKeyObj, list) {
    let lastRow = this.dataList[groupKeyObj.rowIndexs[groupKeyObj.rowIndexs.length - 1]];
    if (groupKeyObj.subTotal) lastRow._subTotalRowsCount++;
    //数据分组后，数据列表里的行顺序可能与原来不一样了，需要重新记录
    groupKeyObj.newRowIndexs = [];
    //如果是最右边的分组列
    if (groupKeyObj.childKeys.length == 0) {
      for (let i = 0; i < groupKeyObj.rowIndexs.length; i++) {
        let rowData = this.dataList[groupKeyObj.rowIndexs[i]];
        //设置左边列的小计行数量
        if (groupKeyObj.colIndex > 0) {
          for (let j = groupKeyObj.colIndex - 1; j >= 0; j--) {
            let col = this.dataModel.columns[j];
            //如果遇到前一个分组列
            if (col.groupContent) break; {
              //
            }
          }
        }
        list.push(rowData);
        groupKeyObj.newRowIndexs.push(list.length - 1);
        let pObj = groupKeyObj.parent;
        while (pObj) {
          pObj.newRowIndexs.push(list.length - 1);
          pObj = pObj.parent;
        }
      }
    } else {
      for (let i = 0; i < groupKeyObj.childKeys.length; i++) {
        let childKeyObj = this.groupRowKeys[groupKeyObj.childKeys[i]];
        this.addGroupRow(childKeyObj, list);
      }
    }
  }

  /**
   * 执行实际的数据绑定操作
   */
  exeBindData(keepScrollPosition) {
    //如果需要过滤列数据，并且还没有对列数据进行分组
    if (this.haveFilterCols && !this.haveGroupFilterColsData) {
      for (var i = 0; i < this.dataList.length; i++) {
        let rowData = this.dataList[i];
        for (var j = 0; j < this.columns.length; j++) {
          let col = this.columns[j];
          if (col.allowFilter && !col.groupContent && !col.rowDataConvertToCol) {
            let colVal = null;
            try {
              colVal = this._tfp.replaceDataField(this.dataList[i], col.format);
              colVal = this._tfp.exeExpress(colVal);
              if (isNull(colVal)) continue;
              if (!col.filterValues) col.filterValues = [];
              if (!col.filterValues.contains(colVal)) col.filterValues.push(colVal);
            } catch (e) {
              console.log(e);
            }
          }
        }
      }
      this.haveGroupFilterColsData = true;
    }
    if (!this.haveSetTreeNodes) {
      this.initTree();
    }
    //如果显示树形
    if (this.dataModel.showTree && this.dataModel.parentNodeIdField
      && (this.dataModel.treeColIndex || this.dataModel.treeColIndex == 0) && this.dataModel.nodeIdField
      && (this.dataModel.rootNodeId || this.dataModel.rootNodeId == 0)) {
      //如果设置了节点数据查询参数
      if (this.dataModel.gridNodeDataQuerySetting && this.dataModel.gridNodeDataQuerySetting.servicePath
        && this.haveSetTreeNodes && this.dataModel.rowDataIdField && this.dataModel.rowDataParentIdField) {
        //生成树形结构
        for (var i = 0; i < this.dataList.length; i++) {
          let rowData = this.dataList[i];
          //为了避免和上级节点数据的id重复，纯数据节点的id前面加一个字母c
          let nodeId = "c_" + rowData[this.dataModel.rowDataIdField];
          let rowNode = {
            id: nodeId,
            parentId: rowData[this.dataModel.rowDataParentIdField],
            data: rowData,
            rowIndex: i,
            childs: []
          };
          this.nodes[nodeId] = rowNode;
          this.nodeIds.push(nodeId);
          let nodeParent = this.nodes[rowNode.parentId];
          if (nodeParent) nodeParent.childs.push(nodeId);
        }
      } else {
        this.createTreeNodes(this.dataList);
        this.haveSetTreeNodes = true;
      }
      for (let i = 0; i < this.rootNodes.length; i++) {
        this.addNodeRow(this.rootNodes[i], 5);
      }
    } else {
      //判断是否有分组列，如果有，则需要对数据进行分组，然后再绑定
      let haveGroupCol = false;
      this.groupSubTotalRowBgColor = [];
      for (var i = 0; i < this.dataModel.columns.length; i++) {
        let col = this.dataModel.columns[i];
        if (col.groupContent) {
          haveGroupCol = true;
          if (col.groupSubTotal) {
            let subTotalRowBgColor = col.subTotalRowBgColor ? col.subTotalRowBgColor : "";
            this.groupSubTotalRowBgColor.push(subTotalRowBgColor);
          }
        }
      }
      if (haveGroupCol) {
        this.groupRowKeys = {};
        let rootKeys = [];
        for (var i = 0; i < this.dataList.length; i++) {
          let rowData = this.dataList[i];
          rowData._subTotalRowsCount = 0;  //小计行数量
          let rowKey = "";
          for (var j = 0; j < this.dataModel.columns.length; j++) {
            let col = this.dataModel.columns[j];
            if (col.groupContent) {
              let cellContent = this.formatCellContent(col.format, rowData);
              let isRootKey = false;
              let parentKeyObj = null;
              if (rowKey != "") {
                parentKeyObj = this.groupRowKeys[rowKey];
                rowKey += "/";
              } else {
                isRootKey = true;
              }
              rowKey += cellContent;
              let keyObj = this.groupRowKeys[rowKey];
              if (!keyObj) {
                keyObj = {
                  colIndex: j,
                  rowIndexs: [],
                  childKeys: [],
                  parent: parentKeyObj,
                  childSumCount: 0  //记录右侧有几列需要分组小计，以便决定需要多合并几行
                };
                if (col.groupSubTotal) keyObj.subTotal = true;
                this.groupRowKeys[rowKey] = keyObj;
                if (isRootKey) rootKeys.push(rowKey);
                if (parentKeyObj) {
                  parentKeyObj.childKeys.push(rowKey);
                  //如果需要分组小计
                  if (col.groupSubTotal) {
                    let pObj = parentKeyObj;
                    while (pObj) {
                      pObj.childSumCount++;
                      pObj = pObj.parent;
                    }
                  }
                }
              }
              keyObj.rowIndexs.push(i);
            }
          }
        }
        let newList = [];
        for (var i = 0; i < rootKeys.length; i++) {
          let rootKey = rootKeys[i];
          let rootKeyObj = this.groupRowKeys[rootKey];
          this.addGroupRow(rootKeyObj, newList);
        }
        this.dataList = newList;
      }
      /*let dataLen = this.dataList.length;
      //如果数据量超过100，且不翻页，则先加载前50条数据
      if(this.dataList.length>100 && !this.dataModel.allowPaging) {
        dataLen = 50;
        if(this.dataList.length<dataLen) dataLen = this.dataList.length;
        this.curLoadDataCount = dataLen;
      }*/
      for (var i = 0; i < this.dataList.length; i++) {
        this.addRow(this.dataList[i]);
        //如果显示合计栏，则需要计算合计列
        if (this.dataModel.showSumer) {
          for (var j = 0; j < this.columns.length; j++) {
            let col = this.columns[j];
            if (col.sum) {
              //如果当前列参与分组，则计算合计时，隐藏的行不参与计算
              if (col.groupContent) {
                let row = this.getRow(i);
                let cell = row.cells[j];
                if (cell.css("display") != "flex") continue;
              }
              let colVal = 0;
              try {
                colVal = this._tfp.replaceDataField(this.dataList[i], col.format);
                colVal = this._tfp.exeExpress(colVal);
                if (isNull(colVal)) continue;
                if (col.dataFormat == "int") {
                  colVal = parseInt(colVal);
                } else {
                  colVal = parseFloat((colVal + "").replace(",", ""));
                }
                col.sumValue += colVal;
              } catch (e) {
                console.log(e);
              }
            }
          }
        }
      }
      /*if(dataLen<this.dataList.length) {
        this.addRowAsync(keepScrollPosition);
      }*/
      this.setFooter();
      this.onResize();
      if(!keepScrollPosition) this.scrollToTop();

      if (this.dataModel.onAfterBindData) {
        try {
          let data = this.dataList;
          eval(this.dataModel.onAfterBindData);
        } catch (err) {
          console.log(err);
        }
      }
    }
  }

  /**
   * 异步添加行
   * @param {*} keepScrollPosition 
   * @returns 
   */
  addRowAsync(keepScrollPosition) {
    if(this.curLoadDataCount>=this.dataList.length) {
      this.setFooter();
      this.onResize();
      if(!keepScrollPosition) this.scrollToTop();

      if (this.dataModel.onAfterBindData) {
        try {
          let data = this.dataList;
          eval(this.dataModel.onAfterBindData);
        } catch (err) {
          console.log(err);
        }
      }
      return;
    }
    let that = this;
    setTimeout(function() {
        that.addRow(that.dataList[that.curLoadDataCount]);
        that.curLoadDataCount++;
        that.addRowAsync(keepScrollPosition);
    }, 0);
  }

  /**
   * 生成交叉表数据
   * @param {*} newColumns 
   * @param {*} rowDataToColTitle 
   * @param {*} rowDataToColData 
   */
  generateCrossTableData(newColumns, rowDataToColTitle, rowDataToColData, keepScrollPosition) {
    let newRowKeyList = [];
    let newRowKeyDic = {};
    let dynamicColList = [];
    for (var i = 0; i < this.dataList.length; i++) {
      let rowData = this.dataList[i];
      let rowKey = "";
      let newRow = {
        fixedColData: [],
        dynamicColData: {}
      };
      //设置标题列
      for (let j = 0; j < newColumns.length; j++) {
        let col = newColumns[j];
        let colVal = "";
        try {
          colVal = this._tfp.replaceDataField(rowData, col.format);
          colVal = this._tfp.exeExpress(colVal);
          if (isNull(colVal)) colVal = "";
        } catch (e) {
          console.log(e);
        }
        newRow.fixedColData.push(colVal);
        rowKey += "/" + colVal.replaceAll("-", "_");
      }
      //设置行转列标题
      let colTitle = "";
      try {
        colTitle = this._tfp.replaceDataField(rowData, rowDataToColTitle.format);
        colTitle = this._tfp.exeExpress(colTitle);
        if (isNull(colTitle)) colTitle = "";
      } catch (e) {
        console.log(e);
      }
      let colTitle2 = colTitle.replaceAll("-", "_");
      //如果按时间分组
      if (rowDataToColTitle.crossTableTimeGroupType && this._tfp.isDate(colTitle)) {
        let date = new Date(colTitle);
        if (rowDataToColTitle.crossTableTimeGroupType == "day") {
          colTitle = date.format("dd");
        } else if (rowDataToColTitle.crossTableTimeGroupType == "week") {
          let week = date.getDay();
          if (week == 0) { colTitle = "星期日"; }
          else if (week == 1) { colTitle = "星期一"; }
          else if (week == 2) { colTitle = "星期二"; }
          else if (week == 3) { colTitle = "星期三"; }
          else if (week == 4) { colTitle = "星期四"; }
          else if (week == 5) { colTitle = "星期五"; }
          else if (week == 6) { colTitle = "星期六"; }
        } else if (rowDataToColTitle.crossTableTimeGroupType == "month") {
          colTitle = date.format("MM") + "月";
        }
      }
      newRow.dynamicColData[colTitle2] = [];
      if (!dynamicColList.contains(colTitle) && !rowDataToColTitle.crossTableTimeGroupType) dynamicColList.push(colTitle);
      //设置行转列数据
      for (let j = 0; j < rowDataToColData.length; j++) {
        let col = rowDataToColData[j];
        let colVal = "";
        try {
          colVal = this._tfp.replaceDataField(rowData, col.format);
          colVal = this._tfp.exeExpress(colVal);
          if (isNull(colVal)) {
            colVal = "";
            if (col.crossTableDefaultCellVal) colVal = col.crossTableDefaultCellVal;
          }
        } catch (e) {
          console.log(e);
        }
        newRow.dynamicColData[colTitle2].push(colVal);
      }

      //如果分组已经存在，则进行数据累计
      let oldRow = newRowKeyDic[rowKey];
      if (oldRow) {
        for (let colTitle3 in newRow.dynamicColData) {
          if (!oldRow.dynamicColData[colTitle3]) {
            oldRow.dynamicColData[colTitle3] = newRow.dynamicColData[colTitle3];
          } else {
            let arr = newRow.dynamicColData[colTitle3];
            oldRow.dynamicColData[colTitle3].push(arr[0]);
          }
        }
      } else {
        newRowKeyDic[rowKey] = newRow;
        newRowKeyList.push(rowKey);
      }
    }

    //设置表头
    if (rowDataToColData.length > 0) {
      this.dataModel.headerRows = [[], []];
    }

    //设置固定列
    for (let j = 0; j < newColumns.length; j++) {
      let col = newColumns[j];
      col.format = "{" + col.name + "}";
      if (rowDataToColData.length > 0) {
        this.dataModel.headerRows[0].push({
          content: col.name,
          rows: 2,
          cols: 1
        });
        this.dataModel.headerRows[1].push({
          content: "",
          rows: 0,
          cols: 0
        });
      }
    }
    //如果按时间分组
    if (rowDataToColTitle.crossTableTimeGroupType == "day") {
      let groupYear = (new Date()).getFullYear();
      if (this.dataModel.crossTableGroupYear) groupYear = this.dataModel.crossTableGroupYear;
      let groupMonth = (new Date()).format("MM");
      if (this.dataModel.crossTableGroupMonth) groupMonth = this.dataModel.crossTableGroupMonth;
      if (parseInt(groupMonth) < 10) groupMonth = "0" + groupMonth;
      let groupDate = new Date(groupYear + "-" + groupMonth + "-01");
      let days = new Date(groupDate.getFullYear(), groupDate.getMonth() + 1, 0).getDate();
      for (let i = 1; i <= days; i++) {
        let day = i < 10 ? "0" + i : i;
        dynamicColList.push(day);
      }
    } else if (rowDataToColTitle.crossTableTimeGroupType == "week") {
      dynamicColList = ["星期日", "星期一", "星期二", "星期三", "星期四", "星期五", "星期六"];
    } else if (rowDataToColTitle.crossTableTimeGroupType == "month") {
      dynamicColList = ["01月", "02月", "03月", "04月", "05月", "06月", "07月", "08月", "09月", "10月", "11月", "12月"];
    }
    //设置动态列
    for (let i = 0; i < dynamicColList.length; i++) {
      let colTitle = dynamicColList[i];
      if (rowDataToColData.length > 0) {
        this.dataModel.headerRows[0].push({
          content: colTitle,
          rows: 1,
          cols: rowDataToColData.length
        });
      }
      for (let j = 0; j < rowDataToColData.length; j++) {
        let colData = JSON.parse(JSON.stringify(rowDataToColData[j]));
        if (rowDataToColData.length > 0) {
          if (j > 0) {
            this.dataModel.headerRows[0].push({
              content: "",
              rows: 0,
              cols: 0
            });
          }
          this.dataModel.headerRows[1].push({
            content: colData.name,
            rows: 1,
            cols: 1
          });
        }
        colData.format = "{" + colTitle.replaceAll("-", "_") + "_" + colData.name + "}";
        if (colData.style && colData.style.indexOf("{" + colData.name + "}") >= 0) {
          colData.style = colData.style.replace("{" + colData.name + "}", "{" + colTitle.replaceAll("-", "_") + "_" + colData.name + "}");
        }
        colData.name = colTitle.replaceAll("-", "_");
        if (colData.crossTableShowRowsSum) {
          colData.sum = true;
          colData.sumValue = 0;
          this.dataModel.showFooter = true;
          this.dataModel.showSumer = true;
        }
        delete colData["rowDataConvertToCol"];
        newColumns.push(colData);
      }
    }

    let newDataList = [];
    for (let i = 0; i < newRowKeyList.length; i++) {
      let newRow = newRowKeyDic[newRowKeyList[i]];
      let rowData = {};
      for (let j = 0; j < newRow.fixedColData.length; j++) {
        let col = newColumns[j];
        rowData[col.name] = newRow.fixedColData[j];
      }
      for (let j = 0; j < dynamicColList.length; j++) {
        let colName = dynamicColList[j];
        let dynamicData = newRow.dynamicColData[colName.replaceAll("-", "_")];
        for (let k = 0; k < rowDataToColData.length; k++) {
          let colDynamic = rowDataToColData[k];
          if (isNull(rowData[colDynamic.name + "_sum"])) rowData[colDynamic.name + "_sum"] = 0;
          if (isNull(rowData[colDynamic.name + "_max"])) rowData[colDynamic.name + "_max"] = 0;
          //if(isNull(rowData[colDynamic.name+"_min"])) rowData[colDynamic.name+"_min"] = 0;
          if (isNull(colDynamic.totalSum)) colDynamic.totalSum = 0;
          let dataVal = 0;
          if (dynamicData) {
            dataVal = dynamicData[k];
          } else if (colDynamic.crossTableDefaultCellVal) {
            dataVal = colDynamic.crossTableDefaultCellVal;
          }
          rowData[colName.replaceAll("-", "_") + "_" + colDynamic.name] = dataVal;
          let isValidVal = false;
          if (colDynamic.dataFormat == "int") {
            if (this._tfp.isInt(dataVal)) {
              dataVal = parseInt(dataVal);
              isValidVal = true;
            }
          } else {
            if (!isNaN(dataVal)) {
              dataVal = parseFloat(dataVal);
              isValidVal = true;
            }
          }
          if (isValidVal) {
            rowData[colDynamic.name + "_sum"] += dataVal;
            colDynamic.totalSum += dataVal;
            if (dataVal > rowData[colDynamic.name + "_max"]) rowData[colDynamic.name + "_max"] = dataVal;
            if (isNull(rowData[colDynamic.name + "_min"]) || dataVal < rowData[colDynamic.name + "_min"])
              rowData[colDynamic.name + "_min"] = dataVal;
          }
        }
      }
      newDataList.push(rowData);
    }

    //设置横向合计列
    for (let i = 0; i < rowDataToColData.length; i++) {
      let colDynamic = rowDataToColData[i];
      if (colDynamic.crossTableShowColsSum) {
        let colData = JSON.parse(JSON.stringify(colDynamic));
        colData.format = "{" + colData.name + "_sum}";
        colData.name = rowDataToColData.length > 1 ? colData.name + "合计" : "合计";
        if (colDynamic.crossTableShowRowsSum) {
          colData.sum = true;
          colData.sumValue = 0;
          this.dataModel.showFooter = true;
          this.dataModel.showSumer = true;
        }
        delete colData["rowDataConvertToCol"];
        delete colData["crossTableShowColsSum"];
        newColumns.push(colData);

        if (rowDataToColData.length > 0) {
          this.dataModel.headerRows[0].push({
            content: colData.name,
            rows: 2,
            cols: 1
          });
          this.dataModel.headerRows[1].push({
            content: "",
            rows: 0,
            cols: 0
          });
        }
      }
      if (colDynamic.crossTableShowColsMin) {
        let colData = JSON.parse(JSON.stringify(colDynamic));
        colData.format = "{" + colData.name + "_min}";
        colData.name = rowDataToColData.length > 1 ? colData.name + "最小" : "最小";
        colData.sum = false;
        delete colData["rowDataConvertToCol"];
        delete colData["crossTableShowColsMin"];
        newColumns.push(colData);

        if (rowDataToColData.length > 0) {
          this.dataModel.headerRows[0].push({
            content: colData.name,
            rows: 2,
            cols: 1
          });
          this.dataModel.headerRows[1].push({
            content: "",
            rows: 0,
            cols: 0
          });
        }
      }
      if (colDynamic.crossTableShowColsMax) {
        let colData = JSON.parse(JSON.stringify(colDynamic));
        colData.format = "{" + colData.name + "_max}";
        colData.name = rowDataToColData.length > 1 ? colData.name + "最大" : "最大";
        colData.sum = false;
        delete colData["rowDataConvertToCol"];
        delete colData["crossTableShowColsMax"];
        newColumns.push(colData);

        if (rowDataToColData.length > 0) {
          this.dataModel.headerRows[0].push({
            content: colData.name,
            rows: 2,
            cols: 1
          });
          this.dataModel.headerRows[1].push({
            content: "",
            rows: 0,
            cols: 0
          });
        }
      }
      if (colDynamic.crossTableShowColsAvg) {
        let colData = JSON.parse(JSON.stringify(colDynamic));
        colData.format = "#[{" + colData.name + "_sum}/" + dynamicColList.length + "]";
        colData.name = rowDataToColData.length > 1 ? colData.name + "平均" : "平均";
        colData.sum = false;
        delete colData["rowDataConvertToCol"];
        delete colData["crossTableShowColsSum"];
        newColumns.push(colData);

        if (rowDataToColData.length > 0) {
          this.dataModel.headerRows[0].push({
            content: colData.name,
            rows: 2,
            cols: 1
          });
          this.dataModel.headerRows[1].push({
            content: "",
            rows: 0,
            cols: 0
          });
        }
      }
      if (colDynamic.crossTableShowColsPercent) {
        let colData = JSON.parse(JSON.stringify(colDynamic));
        colData.dataFormat = "text";
        colData.format = "#[(parseFloat({" + colData.name + "_sum}*100/" + colDynamic.totalSum + ")).toFixed(1)]%";
        if (!colDynamic.totalSum) colData.format = "0%";
        colData.name = rowDataToColData.length > 1 ? colData.name + "占比" : "占比";
        colData.sum = false;
        colData.width = "60px";
        delete colData["rowDataConvertToCol"];
        delete colData["crossTableShowColsSum"];
        newColumns.push(colData);

        if (rowDataToColData.length > 0) {
          this.dataModel.headerRows[0].push({
            content: colData.name,
            rows: 2,
            cols: 1
          });
          this.dataModel.headerRows[1].push({
            content: "",
            rows: 0,
            cols: 0
          });
        }
      }
    }

    let that = this;
    this.dataList = newDataList;
    this._tfp.use(["GridView"], function () {
      that.initialColumns = JSON.parse(JSON.stringify(that.dataModel.columns));
      that.columns = newColumns;
      that.exeBindData(keepScrollPosition);
    });
  }

  /**
   * 绑定数据
   * @param  {[type]} data [description]
   * @return {[type]}      [description]
   */
  bindData(data, isOnLoad, keepScrollPosition) {
    if (!data || !Array.isArray(data)) return;
    this.dataList = data;
    this.curLoadDataCount = 0;
    //如果不是通过loadData方法加载数据后绑定，而是直接调用bindData方法绑定，则需要初始化树形结构
    if (!isOnLoad) this.initTree();

    if (this.dataModel.onBeforeBindData) {
      try {
        eval(this.dataModel.onBeforeBindData);
      } catch (err) {
        console.log(err);
      }
    }

    //清空现有数据
    this.bodyFixedBox.children("div").each(function () {
      $(this).empty();
    });
    this.bodyScrollBox.children("div").each(function () {
      $(this).empty();
    });
    this.bodyFixedRightBox.children("div").each(function () {
      $(this).empty();
    });

    if (this.showHeader && this.showCheckbox) {
      let cbk = this.header.find(".tfp-grid-header-checkbox");
      if (cbk.length > 0 && cbk.find("input").length > 0) cbk.find("input").get(0).checked = false;
    }
    //如果显示合计栏，则需要初始化合计列的值
    if (this.dataModel.showSumer) {
      for (var j = 0; j < this.columns.length; j++) {
        let col = this.columns[j];
        if (col.sum) col.sumValue = 0;
      }
    }

    //如果是交叉表，且是重新加载数据，则需要重置列信息
    if (this.initialColumns) this.dataModel.columns = this.initialColumns;

    if (Array.isArray(this.dataList)) {
      //如果需要将行数据转换为列
      let rowDataToColTitle = null;
      let rowDataToColData = [];
      let newColumns = [];
      for (var j = 0; j < this.columns.length; j++) {
        let col = this.columns[j];
        if (col.rowDataConvertToCol == "title") {
          rowDataToColTitle = JSON.parse(JSON.stringify(col));
        } else if (col.rowDataConvertToCol == "data") {
          rowDataToColData.push(JSON.parse(JSON.stringify(col)));
        } else {
          newColumns.push(JSON.parse(JSON.stringify(col)));
        }
      }
      if (rowDataToColTitle && rowDataToColData.length > 0) {
        this.generateCrossTableData(newColumns, rowDataToColTitle, rowDataToColData, keepScrollPosition)
        return;
      }
      this.exeBindData(keepScrollPosition);
    } else {
      this.dataList = [];
      this.exeBindData(keepScrollPosition);
    }
  }

  /**
   * 当页面大小发生变化时
   * TODO：把grid放在tab页里时，计算不准，表头最右侧和表格最底部还是会出现错位
   */
  onResize() {
    let that = this;
    let divDataList = this._jqObj.children(".tfp-grid-datalist");
    let divHeader = this._jqObj.children(".tfp-grid-header");
    let divSumer = this._jqObj.children(".tfp-grid-sumer");
    let divFixed = divDataList.children(".tfp-grid-datalist-fixed");
    let divFixedRight = divDataList.children(".tfp-grid-datalist-fixed-right");
    let divScroll = divDataList.children(".tfp-grid-datalist-scroll").children(".tfp-grid-datalist-scroll-box");
    if (divScroll.length == 0) return;

    let rowHeight = this.dataModel.rowHeight ? this.dataModel.rowHeight + "" : "40";
    rowHeight = parseInt(rowHeight.replace("px", ""));
    //出现纵向滚动条时，固定列盒子底部要加一个内边距，否则，滚动到最下面时，倒数第二行的分割线会错位一个像素
    let lastCol = this.dataModel.columns[this.dataModel.columns.length - 1];
    let lastColWidth = this.dataModel.columns[this.dataModel.columns.length - 1 - this.fixedOnRightColCount].width;
    if (!lastColWidth) lastColWidth = 80;
    lastColWidth = tfp.getPx(lastColWidth);
    if (divScroll.height() > divScroll.parent().height()) {
      if (this.showHeader) {
        //当出现纵向滚动条时，表头最后一列可视列要加10像素的宽度，否则，表头的整体宽度就跟下面的数据列表区的宽度不一致了
        divHeader.find(".tfp-grid-header-scroll-box").css("padding-right", "10px");
        if (this.dataModel.headerRows && this.dataModel.headerRows.length > 1) {
          for (let i = 0; i < this.dataModel.headerRows.length; i++) {
            let headerRow = this.dataModel.headerRows[i];
            for (let cellIndex = headerRow.length - 1; cellIndex > 0; cellIndex--) {
              let lastHeaderCell = $("#" + this.id + "_header_cell_" + i + "_" + cellIndex);
              if (lastHeaderCell.length == 0) break;
              if (lastHeaderCell.css("display") == "flex") {
                if (divScroll.get(0).scrollWidth > divScroll.parent().width()) lastHeaderCell.css("width", (parseInt(lastHeaderCell.attr("data-cell-width")) + 10) + "px");
                break;
              }
            }
          }
        } else {
          if (divScroll.get(0).scrollWidth > divScroll.parent().width()) divHeader.find(".tfp-grid-header-scroll-box").children("div").last().css("flex-basis", (lastColWidth + 10) + "px");
        }
      }
      if (this.showSumer) {
        divSumer.find(".tfp-grid-sumer-scroll-box").css("padding-right", "10px");
        if (divScroll.get(0).scrollWidth > divScroll.parent().width()) divSumer.find(".tfp-grid-sumer-scroll-box").children("div").last().css("flex-basis", (lastColWidth + 10) + "px");
      }
      divFixed.children("div").each(function () {
        $(this).children("div").last().css("border-bottom", "0");
      });
      divScroll.children("div").each(function () {
        $(this).children("div").last().css("border-bottom", "0");
      });
      divFixedRight.children("div").each(function () {
        $(this).children("div").last().css("border-bottom", "0");
      });
    } else {
      if (this.showHeader) {
        divHeader.find(".tfp-grid-header-scroll-box").css("padding-right", "0");
        if (this.dataModel.headerRows && this.dataModel.headerRows.length > 1) {
          for (let i = 0; i < this.dataModel.headerRows.length; i++) {
            let headerRow = this.dataModel.headerRows[i];
            for (let cellIndex = headerRow.length - 1; cellIndex > 0; cellIndex--) {
              let lastHeaderCell = $("#" + this.id + "_header_cell_" + i + "_" + cellIndex);
              if (lastHeaderCell.length == 0) break;
              if (lastHeaderCell.css("display") == "flex") {
                lastHeaderCell.css("width", lastHeaderCell.attr("data-cell-width") + "px");
                break;
              }
            }
          }
        } else {
          divHeader.find(".tfp-grid-header-scroll-box").children("div").last().css("flex-basis", lastColWidth + "px");
        }
      }
      if (this.showSumer) {
        divSumer.find(".tfp-grid-sumer-scroll-box").css("padding-right", "0");
        divSumer.find(".tfp-grid-sumer-scroll-box").children("div").last().css("flex-basis", lastColWidth + "px");
      }
      divFixed.css("padding-bottom", "0");
      divFixed.children("div").each(function () {
        $(this).children("div").last().css("border-bottom", "1px solid " + that.borderColor);
      });
      divScroll.children("div").each(function () {
        $(this).children("div").last().css("border-bottom", "1px solid " + that.borderColor);
      });
      divFixedRight.css("padding-bottom", "0");
      divFixedRight.children("div").each(function () {
        $(this).children("div").last().css("border-bottom", "1px solid " + that.borderColor);
      });
    }
    //出现横向滚动条时
    if (divScroll.get(0).scrollWidth > divScroll.parent().width()) {
      if (divScroll.height() > divScroll.parent().height()) rowHeight += 10;
      //固定列底部加上内边距
      divFixed.css("padding-bottom", "10px");
      //固定列最后一行的行高加上滚动条的高度
      divFixed.children("div").each(function () {
        $(this).children("div").last().css("flex-basis", rowHeight + "px");
      });
      if (this.showHeader) {
        let lastHeaderCol = divHeader.find(".tfp-grid-header-scroll-box").children(".tfp-grid-header-col").last();
        if (lastHeaderCol.length > 0) lastHeaderCol.css("flex-basis", (parseInt(lastColWidth) + 10) + "px");
      }
      //固定列底部加上内边距
      this.bodyFixedRightBox.css("padding-bottom", "10px");
      //固定列最后一行的行高加上滚动条的高度
      this.bodyFixedRightBox.children("div").each(function () {
        $(this).children("div").last().css("flex-basis", rowHeight + "px");
      });
      //滚动区最后一列去掉右边框
      if (this.showBorder) {
        if (this.showHeader) {
          if (this.dataModel.headerRows && this.dataModel.headerRows.length > 1) {
            for (let i = 0; i < this.dataModel.headerRows.length; i++) {
              let headerRow = this.dataModel.headerRows[i];
              let lastHeaderCell = headerRow[headerRow.length - 1];
              let lastHeaderCellEl = $(this.id + "_header_cell_" + i + "_" + headerRow.length - 1);
              lastHeaderCellEl.css("border-right", "0");
            }
          } else {
            divHeader.find(".tfp-grid-header-scroll-box").children(".tfp-grid-header-col").last().css("border-right", "0");
          }
        }
        divScroll.children(".tfp-grid-datalist-col").last().css("border-right", "0");
      }
    } else {
      //固定列底部加上内边距
      divFixed.css("padding-bottom", "0");
      divFixed.children("div").each(function () {
        $(this).children("div").last().css("flex-basis", rowHeight + "px");
      });
      if (this.showHeader) {
        let lastHeaderCol = divHeader.find(".tfp-grid-header-scroll-box").children(".tfp-grid-header-col").last();
        if (lastHeaderCol.length > 0) lastHeaderCol.css("flex-basis", lastColWidth + "px");
      }
      //固定列底部加上内边距
      this.bodyFixedRightBox.css("padding-bottom", "0");
      //固定列最后一行的行高加上滚动条的高度
      this.bodyFixedRightBox.children("div").each(function () {
        $(this).children("div").last().css("flex-basis", rowHeight + "px");
      });
      if (this.showBorder) {
        if (this.showHeader) {
          //滚动区最后一列加上右边框
          if (this.dataModel.headerRows && this.dataModel.headerRows.length > 1) {
            for (let i = 0; i < this.dataModel.headerRows.length; i++) {
              let headerRow = this.dataModel.headerRows[i];
              let lastHeaderCellEl = $("#" + this.id + "_header_cell_" + i + "_" + (headerRow.length - 1));
              lastHeaderCellEl.css("border-right", "1px solid " + this.borderColor);
            }
          } else {
            divHeader.find(".tfp-grid-header-scroll-box").children(".tfp-grid-header-col").last().css("border-right", "1px solid " + this.borderColor);
          }
        }
        divScroll.children(".tfp-grid-datalist-col").last().css("border-right", "1px solid " + this.borderColor);
      }
    }
  }

  /**
   * 设置指定属性的数据绑定信息
   * @param {*} attr 
   * @param {*} settingData 
   * @param {*} attrSetting 
   */
  setDataBindSetting(attr, settingData, attrSetting) {
    if (attr.name == "gridNodeDataQuerySetting") {
      settingData.type = "query";
      settingData.serviceNameSuffix = "query_node";
      settingData.serviceComment = "节点数据查询";
      attrSetting.dataMember = "data_node";
    }
  }

  /**
   * 加载数据
   * @param {*} toPage 
   * @returns 
   */
  loadData(toPage, keepScrollPosition) {
    var args = {};
    if (this.allowPaging) {
      args = {
        pageSize: this.pageSize,
        toPage: toPage ? toPage : 1
      };
    }

    if (this.orders && this.orders.length > 0) {
      let arrOrders = [];
      for (let i = 0; i < this.orders.length; i++) {
        let order = this.orders[i];
        if (order.type && order.type != "") arrOrders.push(order);
      }
      args[this.id + "_orderByArgs"] = arrOrders;
    }

    if(keepScrollPosition) args.keepScrollPosition = true;

    super.loadData(args);
  }

  /**
   * 生成树形表格的节点
   * @param {*} nodeDataList 
   */
  createTreeNodes(nodeDataList, isDir) {
    //生成树形结构
    for (var i = 0; i < nodeDataList.length; i++) {
      let nodeData = nodeDataList[i];
      if (isDir) nodeData.isDir = true;
      let nodeId = nodeData[this.dataModel.nodeIdField];
      this.nodes[nodeId] = {
        id: nodeId,
        parentId: nodeData[this.dataModel.parentNodeIdField],
        data: nodeData,
        rowIndex: i,
        childs: []
      };
      this.nodeIds.push(nodeId);
    }
    for (var i = 0; i < this.nodeIds.length; i++) {
      let nodeId = this.nodeIds[i];
      let node = this.nodes[nodeId];
      //如果是一级节点
      if ((node.parentId + "") == (this.dataModel.rootNodeId + "")) {
        this.rootNodes.push(nodeId);
      } else {
        let nodeParent = this.nodes[node.parentId];
        if (nodeParent) nodeParent.childs.push(nodeId);
      }
    }
  }

  /**
   * 初始化树形数据结构
   */
  initTree() {
    this.nodes = {};
    this.rootNodes = [];
    this.nodeIds = [];
    this.haveSetTreeNodes = false;
  }

  /**
   * 加载数据后
   * @param {*} res 
   * @returns 
   */
  onLoadData(req, res) {
    //获得数据绑定成员对象名
    let dataBindingMember = this.dataModel.dataBindingMember;  //某些老版本的组件使用的该属性，需要兼容
    if (this.dataModel.dataQuerySetting && this.dataModel.dataQuerySetting.dataMember) {
      dataBindingMember = this.dataModel.dataQuerySetting.dataMember;
    }
    //如果显示树形
    if (this.dataModel.showTree && this.dataModel.parentNodeIdField && this.dataModel.nodeIdField
      && (this.dataModel.rootNodeId || this.dataModel.rootNodeId == 0)) {
      //如果设置了节点数据查询参数
      if (this.dataModel.gridNodeDataQuerySetting && this.dataModel.gridNodeDataQuerySetting.servicePath) {
        let nodesData = res[this.dataModel.gridNodeDataQuerySetting.dataMember];
        if (nodesData) {
          let nodesRowsData = nodesData.rows ? nodesData.rows : nodesData;
          if (Array.isArray(nodesRowsData)) {
            this.initTree();
            this.createTreeNodes(nodesRowsData, true);
            this.haveSetTreeNodes = true;
          }
        }
      }
    }
    //每次重新加载数据后，需要初始化列数据过滤有关的参数
    if (this.haveFilterCols) {
      this.originalDataList = null;
      this.haveGroupFilterColsData = false;
      this.columns.forEach(col => {
        col.filterValues = null;
        col.checkedFilterValues = null;
      });
    }
    var data = res[dataBindingMember];
    if (!data) return;
    if (this.allowPaging) {
      if (data.rows) {
        this.curPage = data.toPage;
        this.rowsCount = data.rowsCount;
        this.pageCount = data.pageCount;
        this.pageSize = data.pageSize;
        this.count_rows = data.count_rows;
        this.bindData(data.rows, true, req.keepScrollPosition);
      } else if (Array.isArray(data)) {
        this.curPage = 1;
        this.rowsCount = data.length;
        this.pageCount = 1;
        this.pageSize = data.length;
        this.count_rows = {};
        this.bindData(data, true, req.keepScrollPosition);
      }
    } else {
      if (data.rows) {
        this.bindData(data.rows, true, req.keepScrollPosition);
      } else {
        this.bindData(data, true, req.keepScrollPosition);
      }
    }
  }

  /**
   * 重新加载数据
   * keepScrollPosition  是否保留滚动条位置
   */
  reloadData(keepScrollPosition) {
    this.loadData(1, keepScrollPosition);
  }

  /**
   * 重载当前页数据
   */
  reloadCurPage() {
    this.loadData(this.curPage);
  }

  /**
   * 初始化设计时
   */
  initDesigning() {
    let divDataListScroll = this.body.children(".tfp-grid-datalist-scroll");

    if (this.sumer.length > 0 && this.allowPaging) {
      this.sumer.css("bottom", "49px");
    }

    var that = this;

    divDataListScroll.scroll(function () {
      let divScroll = divDataListScroll.get(0);
      if (that.showHeader) {
        let divHeaderScroll = that.header.children(".tfp-grid-header-scroll");
        if (divHeaderScroll.length > 0) {
          divHeaderScroll.get(0).scrollLeft = divScroll.scrollLeft;
          let divHeaderFixed = that.header.children(".tfp-grid-header-fixed");
          let divHeaderFixedRight = that.header.children(".tfp-grid-header-fixed-right");
          if (divScroll.scrollLeft > 0) {
            divHeaderFixed.css("box-shadow", "3px 0px 5px 0 #CCCCCC");
            divHeaderScroll.css("margin-left", "5px");
            divHeaderFixedRight.css("box-shadow", "-3px 0px 5px 0 #CCCCCC");
          } else {
            divHeaderFixed.css("box-shadow", "");
            divHeaderScroll.css("margin-left", "0");
            divHeaderFixedRight.css("box-shadow", "");
          }
        }
      }
      if (that.showSumer) {
        let divSumerScroll = that.sumer.children(".tfp-grid-sumer-scroll");
        if (divSumerScroll.length > 0) {
          divSumerScroll.get(0).scrollLeft = divScroll.scrollLeft;
          let divSumerFixed = that.sumer.children(".tfp-grid-sumer-fixed");
          if (divScroll.scrollLeft > 0) {
            divSumerFixed.css("box-shadow", "3px 0px 5px 0 #CCCCCC");
            divSumerScroll.css("margin-left", "5px");
          } else {
            divSumerFixed.css("box-shadow", "");
            divSumerScroll.css("margin-left", "0");
          }
        }
      }
      that.bodyFixedBox.get(0).scrollTop = divScroll.scrollTop;
      that.bodyFixedRightBox.get(0).scrollTop = divScroll.scrollTop;
      if (divScroll.scrollLeft > 0) {
        that.bodyFixedBox.css("box-shadow", "3px 0px 5px 0 #CCCCCC");
        divDataListScroll.css("margin-left", "5px");
        that.bodyFixedRightBox.css("box-shadow", "-3px 0px 5px 0 #CCCCCC");
      } else {
        that.bodyFixedBox.css("box-shadow", "");
        divDataListScroll.css("margin-left", "0");
        that.bodyFixedRightBox.css("box-shadow", "");
      }
      //出现横向滚动条时
      if (divScroll.scrollWidth > divDataListScroll.parent().width()) {
        that.bodyFixedBox.css("padding-bottom", "10px");
        that.bodyFixedRightBox.css("padding-bottom", "10px");
      } else {
        //
      }
      if (divScroll.scrollHeight > divDataListScroll.parent().height()) {
        if (that.showHeader) {
          let lastHeaderDiv = that.headerScrollBox.children("div").last();
          lastHeaderDiv.css("flex-basis", "10px");
          lastHeaderDiv.css("flex-shrink", "0");
          lastHeaderDiv.css("flex-grow", "0");
        } 
      }
    });
  }

  /**
   * 获得指定索引的表头列
   * @param {*} colIndex 
   * @returns 
   */
  getHeaderCell(colIndex) {
    if (this.fixedColCount > 0 && colIndex < this.fixedColCount) {
      return this.header.children(".tfp-grid-header-fixed").children(".tfp-grid-header-col").eq(colIndex);
    } else if (this.fixedOnRightColCount > 0 && colIndex >= (this.dataModel.columns.length - this.fixedOnRightColCount)) {
      return this.header.children(".tfp-grid-header-fixed-right").children(".tfp-grid-header-col").eq(colIndex - (this.dataModel.columns.length - this.fixedOnRightColCount));
    } else {
      return this.header.children(".tfp-grid-header-scroll").find(".tfp-grid-header-col").eq(colIndex - this.fixedColCount);
    }
  }

  /*async loadXlsxJs() {
    await importJsFile('/node_modules/xlsx/xlsx.js');
  }*/

  /**
   * 初始化运行时
   */
  initRuntime() {
    let that = this;

    //如果没有定义列，则不执行任何操作
    if (!this.dataModel.columns || this.dataModel.columns.length == 0) return;

    //如果有自定义单元格，运行时需要将单元格数据模型从dataModel.components中转存到另外一个变量中，因为要动态生成多行组件
    if (this.dataModel.components && this.dataModel.components.length > 0) {
      this.customCells = JSON.parse(JSON.stringify(this.dataModel.components));
      this.dataModel.components = [];
    }

    //如果启用了前端导出，则添加xlxs.js文件的引用
    if(this.dataModel.showPageExportButton) this._tfp.includeJsFile('/node_modules/xlsx/xlsx.js');

    this.initDesigning();

    this.haveFilterCols = false;

    for (var i = 0; i < this.dataModel.columns.length; i++) {
      let col = this.dataModel.columns[i];
      if (col.allowOrder && col.orderField) {
        this.orders.push({
          field: col.orderField,
          type: col.orderType
        });
      }
      if (col.fixed) {
        this.fixedColCount++;
      } else if (col.fixedOnRight) {
        this.fixedOnRightColCount++;
      }
      if (col.allowFilter) this.haveFilterCols = true;
    }

    let hideCols = tfp.getCptSettingCache(this.id, "HiddenCols");
    if (hideCols) {
      hideCols = JSON.parse(hideCols);
      hideCols.forEach(colIndex => {
        this.hideColumn(colIndex);
      });
    }

    let orders = tfp.getCptSettingCache(this.id, "Orders");
    if (orders) {
      this.orders = JSON.parse(orders);
    }

    let colsWidth = tfp.getCptSettingCache(this.id, "ColsWidth");
    if (colsWidth) {
      colsWidth = JSON.parse(colsWidth);
      colsWidth.forEach((width, index) => {
        if (index < this.dataModel.columns.length) {
          if ((this.dataModel.columns[index].width + "") != (width + "")) {
            this.setColWidth(index, parseInt(width));
          }
        }
      });
    }

    if (this.allowPaging) {
      let divFooter = this._jqObj.children(".tfp-grid-footer");
      divFooter.find(".tfp-grid-btn-first").click(function () {
        that.gotoPage(1);
      });
      divFooter.find(".tfp-grid-btn-prev").click(function () {
        var prevPage = that.curPage - 1;
        if (prevPage < 1) prevPage = 1;
        that.gotoPage(prevPage);
      });
      divFooter.find(".tfp-grid-btn-next").click(function () {
        var nextPage = that.curPage + 1;
        if (nextPage > that.pageCount) nextPage = that.pageCount;
        that.gotoPage(nextPage);
      });
      divFooter.find(".tfp-grid-btn-last").click(function () {
        that.gotoPage(that.pageCount);
      });
      divFooter.find(".tfp-grid-btn-page").click(function () {
        let toPage = parseInt($(this).html());
        if (toPage == that.curPage) return;
        divFooter.find(".tfp-grid-btn-page").css("background-color", "");
        divFooter.find(".tfp-grid-btn-page").css("color", "");
        $(this).css("background-color", "var(--sys-theme-color)");
        $(this).css("color", "#FFFFFF");
        that.gotoPage(toPage);
      });
      divFooter.find(".tfp-grid-input-topage").find("input").blur(function () {
        let topage = $(this).val();
        if (!tfp.isInt(topage)) {
          $(this).val(that.curPage);
          return;
        }
        that.gotoPage(parseInt(topage));
      });
      divFooter.find(".tfp-grid-pagesize").change(function () {
        that.changePageSize($(this).get(0));
      });
    }

    $(window).resize(function () {
      that.onResize();
    });

    document.addEventListener('click', () => {
      if (window._curGridPopDialog) {
        window._curGridPopDialog.remove();
        window._curGridPopDialog = null;
      }
    });

    let toPage = this._tfp.getUrlArg("toPage");
    if (!toPage) toPage = 1;

    if (!this.dataModel.notAutoLoadData) {
      //如果设置了服务路径或服务组件，才需要在初始化时加载数据，否则，不加载
      if (this.dataModel.loadDataService //老版本的组件使用的该属性，需要兼容
        || (this.dataModel.dataQuerySetting
          && (this.dataModel.dataQuerySetting.servicePath || this.dataModel.dataQuerySetting.serviceCpt)
        )) {
        this.loadData(toPage);
      }
    }
  }
}