import TFPComponentRender from '../render.js'

export default class GridDataRowRender extends TFPComponentRender {

  constructor(__tfp, _dataModel, _level) {
    super(__tfp, _dataModel, _level);
  }

  getAttrHtml(retainStyleAttr, otherOptions) {
    var attrHtml = super.getAttrHtml(retainStyleAttr);

    if (!this._tfp.isDesigning) {
      if (otherOptions && otherOptions.gridContainer) {
        attrHtml += " data-index=\"{{index}}\"";
      }
    }

    console.log('attrHtml:'+attrHtml);

    return attrHtml;
  }

  getHtml(getComponentsHtml, parentIndent, retainStyleAttr) {
    return super.getHtml("div", getComponentsHtml, parentIndent, retainStyleAttr);
  }

  getWX(getComponentsHtml, parentIndent, retainStyleAttr, otherOptions) {
    return super.getWX("view", getComponentsHtml, parentIndent, retainStyleAttr, otherOptions);
  }
}