import TFPComponentRender from '../render.js'

export default class GridRender extends TFPComponentRender {

  constructor(__tfp, _dataModel, _level) {
    super(__tfp, _dataModel, _level);
  }

  getBodyHtml(getComponentsHtml) {
    let indent = this.getHtmlIndent();
    let html = "\r\n";
    let dataListTop = 0;
    if (this.dataModel.showHeader) {
      html += this.cpt.getHeaderHtml();
      dataListTop = this.cpt.headerHeight - 1;
    }
    let dataListBottom = 0;
    if (this.dataModel.showSumer) dataListBottom += 39;
    if (this.dataModel.allowPaging) dataListBottom += 49;
    html += indent + "\t<div class=\"tfp-grid-datalist\" style=\"bottom:"
      +dataListBottom+"px;top:" + dataListTop + "px;border-left: 1px solid "
      +this.cpt.borderColor+";border-right: 1px solid "+this.cpt.borderColor+";";
    if(!this.showHeader) html += "border-top:1px solid "+this.cpt.borderColor+";";
    if(!this.showSumer && !this.allowPaging) html += "border-bottom:1px solid "+this.cpt.borderColor+";";
    html += "\">\r\n";
    if (this._tfp.isDesigning) {
      html += this.cpt.getRowTemplate();
    }
    html += indent + "\t</div>\r\n";
    html += this.cpt.getSumerHtml();
    html += this.cpt.getFooterHtml();
    if (!this._tfp.isDesigning) {
      //在编译时，如果有自定义单元格，则需要生成单元格的模版HTML
      if(this.dataModel.components && this.dataModel.components.length>0) {
        html += indent + "\t<div class=\"tfp-grid-datacell-template\" style=\"display:none;\">\r\n";
        let CellRender = this._tfp.renders["GridCell"];
        for(let i=0;i<this.dataModel.components.length;i++) {
          let cellCdm = this.dataModel.components[i];
          this.cpt.setCptDataFormat(cellCdm);
          let cellRender = new CellRender(this._tfp, cellCdm);
          let cellHtml = cellRender.getHtml(true, indent, true);
          html += cellHtml;
        }
        html += indent + "\t</div>\r\n";
      }
    }
    //console.log(html);
    html += indent;
    return html;
  }

  getHtml(getComponentsHtml, parentIndent, retainStyleAttr) {
    return super.getHtml("div", getComponentsHtml, parentIndent, retainStyleAttr);
  }
}