import TFPComponentRender from '../render.js'

export default class GridRender extends TFPComponentRender {

  constructor(__tfp, _dataModel, _level) {
    super(__tfp, _dataModel, _level);
  }

  getBodyHtml(getComponentsHtml, retainStyleAttr) {
    let bodyHtml = "\r\n";
    var indent = this.getHtmlIndent();

    // bodyHtml += this.cpt.getHeaderHtml();
    bodyHtml += indent + "\t<div class=\"wx-grid-datalist\">\r\n";

    if (getComponentsHtml) {
      // let cdm = this.dataModel.components[0];
      //this.cpt.setCptDataFormat(cdm);
      bodyHtml += this.getComponentsHtml(getComponentsHtml, indent + '\t', retainStyleAttr);
    }

    bodyHtml += indent + "\t</div>\r\n";
    // bodyHtml += this.cpt.getFooterHtml();
    return bodyHtml + indent;
  }

  getBodyWX(getComponentsHtml, retainStyleAttr, otherOptions) {
    var vid = escape(this.dataModel.id).replaceAll("%", "");
    var cpt_wx = {
      "wxjson": "",
      "wxjs": "",
      "wxml": "",
      "wxss": ""
    }
    cpt_wx.wxml = "\r\n";
    let indent = this.getHtmlIndent();
    cpt_wx.wxml += indent + "\t<view class=\"wx-grid-datalist\" wx:for=\"{{" + vid + "}}\"";

    if (this.dataModel.dataBindingKey) cpt_wx.wxml += " wx:key=\"" + this.dataModel.id + "_key\"";
    cpt_wx.wxml += ">\r\n";

    if (getComponentsHtml) {
      if (!otherOptions) otherOptions = {};
      otherOptions.gridContainer = this.dataModel.id;
      if (this.dataModel.dataBindingKey) otherOptions.gridKey = this.dataModel.dataBindingKey;

      var coms_wx = this.getComponentsWX(getComponentsHtml, indent + '\t', retainStyleAttr, otherOptions);
      cpt_wx.wxml += coms_wx.wxml;
      cpt_wx.wxjs += coms_wx.wxjs;
    }

    cpt_wx.wxml += indent + "\t\t<view class=\"wx-grid-last\" wx:if=\"{{index==" + vid + "_rowsCount-1}}\">到底了</view>\r\n";
    cpt_wx.wxml += indent + "\t</view>\r\n";
    cpt_wx.wxml += indent;

    //cpt_wx.wxjs += "  onReachBottom(e){\r\n";
    //cpt_wx.wxjs += "    this._wxfp.get(\"" + this.dataModel.id + "\").loadDataTo(1);\r\n";
    //cpt_wx.wxjs += "  },\r\n\r\n";
    return cpt_wx;
  }

  getHtml(getComponentsHtml, parentIndent, retainStyleAttr) {
    return super.getHtml("div", getComponentsHtml, parentIndent, retainStyleAttr);
  }

  getWX(getComponentsHtml, parentIndent, retainStyleAttr, otherOptions) {
    return super.getWX("view", getComponentsHtml, parentIndent, retainStyleAttr, otherOptions);
  }
}