export default {
  "name": "Grid",
  "comment": "数据表格",
  "cssFiles": "style.{bgColorMode}.pc.css",
  "attrs": [
    {
      "name": "dataBindSetting",
      "comment": "数据绑定设置",
      "type": "group",
      "items": [
        {
          "name": "loadDataService",
          "comment": "加载数据服务",
          "type": "Service"
        },
        {
          "name": "delDataService",
          "comment": "删除数据服务",
          "type": "Service"
        },
        {
          "name": "dataBindingMember",
          "comment": "绑定数据成员",
          "type": "String"
        },
        {
          "name": "dataBindingKey",
          "comment": "数据主键字段名",
          "type": "String"
        },
        {
          "name": "columns",
          "comment": "数据列设置",
          "type": "Dataset",
          "isGridCol": true,
          "keyCol": "name",
          "width": "800px",
          "height": "600px",
          "columns": [
            {
              "name": "base",
              "comment": "基本信息",
              "type": "group",
              "items": [
                {
                  "id": "name",
                  "name": "列名",
                  "type": "String",
                  "required": true
                },
                {
                  "id": "contentType",
                  "name": "内容类型",
                  "type": "Select",
                  "default": "text",
                  "options": [
                    {
                      "value": "text",
                      "text": "文本"
                    },
                    {
                      "value": "button",
                      "text": "按钮"
                    },
                    {
                      "value": "link",
                      "text": "链接"
                    },
                    {
                      "value": "image",
                      "text": "图片"
                    },
                    {
                      "value": "switch",
                      "text": "开关"
                    },
                    {
                      "value": "progress",
                      "text": "进度条"
                    },
                    {
                      "value": "custom",
                      "text": "自定义"
                    }
                  ]
                },
                {
                  "id": "align",
                  "name": "水平对齐方式",
                  "type": "Select",
                  "default": "center",
                  "options": [
                    {
                      "value": "left",
                      "text": "左对齐"
                    },
                    {
                      "value": "center",
                      "text": "居中对齐"
                    },
                    {
                      "value": "right",
                      "text": "右对齐"
                    }
                  ]
                },
                {
                  "id": "valign",
                  "name": "垂直对齐方式",
                  "type": "Select",
                  "options": [
                    {
                      "value": "top",
                      "text": "顶端对齐"
                    },
                    {
                      "value": "center",
                      "text": "居中对齐"
                    },
                    {
                      "value": "right",
                      "text": "底部对齐"
                    }
                  ]
                },
                {
                  "id": "width",
                  "name": "列宽度",
                  "type": "Size"
                },
                {
                  "id": "bgColor",
                  "name": "背景颜色",
                  "type": "Color"
                },
                {
                  "id": "format",
                  "name": "数据绑定表达式",
                  "type": "String",
                  "wrap": true
                },
                {
                  "id": "onClick",
                  "name": "点击后执行的脚本",
                  "type": "Event",
                  "wrap": true
                },
                {
                  "id": "class",
                  "name": "CSS样式class",
                  "type": "String",
                  "wrap": true
                },
                {
                  "id": "style",
                  "name": "自定义CSS样式",
                  "type": "String",
                  "wrap": true
                }
              ]
            },
            {
              "name": "text",
              "comment": "文本设置",
              "type": "group",
              "items": [
                {
                  "id": "dataFormat",
                  "name": "内容格式",
                  "type": "Select",
                  "default": "text",
                  "options": [
                    {
                      "value": "text",
                      "text": "文本"
                    },
                    {
                      "value": "int",
                      "text": "整数"
                    },
                    {
                      "value": "decimal",
                      "text": "小数"
                    },
                    {
                      "value": "money|0.00",
                      "text": "金额：0.00"
                    },
                    {
                      "value": "money|0,000.00",
                      "text": "金额：0,000.00"
                    },
                    {
                      "value": "date|yyyy-MM-dd",
                      "text": "日期：yyyy-MM-dd"
                    },
                    {
                      "value": "date|yyyy/MM/dd",
                      "text": "日期：yyyy/MM/dd"
                    },
                    {
                      "value": "date|yyyy年MM月dd日",
                      "text": "日期：yyyy年MM月dd日"
                    },
                    {
                      "value": "date|MM-dd",
                      "text": "日期：MM-dd"
                    },
                    {
                      "value": "date|MM/dd",
                      "text": "日期：MM/dd"
                    },
                    {
                      "value": "date|MM月dd日",
                      "text": "日期：MM月dd日"
                    },
                    {
                      "value": "time|HH:mm",
                      "text": "时间：HH:mm"
                    },
                    {
                      "value": "time|HH:mm:ss",
                      "text": "时间：HH:mm:ss"
                    },
                    {
                      "value": "time|HH时mm分",
                      "text": "时间：HH时mm分"
                    },
                    {
                      "value": "time|HH时mm分ss秒",
                      "text": "时间：HH时mm分ss秒"
                    },
                    {
                      "value": "datetime|yyyy-MM-dd HH:mm",
                      "text": "日期时间：yyyy-MM-dd HH:mm"
                    },
                    {
                      "value": "datetime|yyyy-MM-dd HH:mm:ss",
                      "text": "日期时间：yyyy-MM-dd HH:mm:ss"
                    },
                    {
                      "value": "datetime|yyyy/MM/dd HH:mm",
                      "text": "日期时间：yyyy/MM/dd HH:mm"
                    },
                    {
                      "value": "datetime|yyyy/MM/dd HH:mm:ss",
                      "text": "日期时间：yyyy/MM/dd HH:mm:ss"
                    },
                    {
                      "value": "datetime|yyyy年MM月dd日 HH:mm",
                      "text": "日期时间：yyyy年MM月dd日 HH:mm"
                    },
                    {
                      "value": "datetime|yyyy年MM月dd日 HH:mm:ss",
                      "text": "日期时间：yyyy年MM月dd日 HH:mm:ss"
                    },
                    {
                      "value": "datetime|yyyy年MM月dd日 HH时mm分",
                      "text": "日期时间：yyyy年MM月dd日 HH时mm分"
                    },
                    {
                      "value": "datetime|yyyy年MM月dd日 HH时mm分ss秒",
                      "text": "日期时间：yyyy年MM月dd日 HH时mm分ss秒"
                    }
                  ]
                },
                {
                  "id": "decimalCalcReg",
                  "name": "小数取值规则",
                  "type": "Select",
                  "default": "",
                  "options": [
                    {
                      "value": "",
                      "text": "不处理"
                    },
                    {
                      "value": "trunc",
                      "text": "取整"
                    },
                    {
                      "value": "round",
                      "text": "四舍五入"
                    },
                    {
                      "value": "ceil",
                      "text": "向上取整"
                    },
                    {
                      "value": "floor",
                      "text": "向下取整"
                    },
                    {
                      "value": "toFixed",
                      "text": "固定精度"
                    },
                    {
                      "value": "toPrecision",
                      "text": "固定长度"
                    },
                    {
                      "value": "abs",
                      "text": "求绝对值"
                    }
                  ]
                },
                {
                  "id": "decimalLength",
                  "name": "小数位数",
                  "type": "Number"
                },
                {
                  "id": "maxLength",
                  "name": "最多显示字符数(汉字算2位)",
                  "type": "Number"
                },
                {
                  "id": "fontSize",
                  "name": "文字字号",
                  "type": "Number"
                },
                {
                  "id": "color",
                  "name": "文字颜色",
                  "type": "Color"
                },
                {
                  "id": "bold",
                  "name": "文字加粗",
                  "type": "Switch"
                },
                {
                  "id": "nowrap",
                  "name": "不允许换行",
                  "type": "Switch"
                },
                {
                  "id": "sum",
                  "name": "计算合计值",
                  "type": "Switch"
                },
                {
                  "id": "showMoreOnMouseOver",
                  "name": "鼠标经过显示全部内容",
                  "type": "Switch"
                }
              ]
            },
            {
              "name": "link",
              "comment": "链接设置",
              "type": "group",
              "items": [
                {
                  "id": "linkType",
                  "name": "链接跳转方式",
                  "type": "Select",
                  "default": "self",
                  "options": [
                    {
                      "value": "self",
                      "text": "当前页面"
                    },
                    {
                      "value": "page",
                      "text": "新页面"
                    },
                    {
                      "value": "dialog",
                      "text": "对话框"
                    },
                    {
                      "value": "window",
                      "text": "新窗口"
                    }
                  ]
                },
                {
                  "id": "targetTitle",
                  "name": "跳转页面标题",
                  "comment": "跳转页面标题",
                  "type": "String"
                },
                {
                  "id": "linkUrl",
                  "name": "跳转页面路径",
                  "comment": "跳转页面路径",
                  "type": "String",
                  "wrap": true
                },
                {
                  "id": "dialogWidth",
                  "name": "对话框宽度",
                  "comment": "对话框宽度",
                  "type": "Int"
                },
                {
                  "id": "dialogHeight",
                  "name": "对话框高度",
                  "comment": "对话框高度",
                  "type": "Int"
                },
                {
                  "id": "linkFontSize",
                  "name": "链接文字字号",
                  "type": "Int"
                },
                {
                  "id": "linkFontColor",
                  "name": "链接文字颜色",
                  "type": "Color"
                },
                {
                  "id": "linkFontBold",
                  "name": "链接文字加粗",
                  "type": "Switch"
                }
              ]
            },
            {
              "name": "button",
              "comment": "按钮设置",
              "type": "group",
              "items": [
                {
                  "id": "buttonTheme",
                  "name": "按钮外观样式",
                  "type": "Select",
                  "options": [{
                    "value": "rect",
                    "text": "矩形"
                  }, {
                    "value": "round",
                    "text": "圆角矩形"
                  }, {
                    "value": "ellipse",
                    "text": "椭圆形"
                  }]
                },
                {
                  "id": "buttonBgColor",
                  "name": "按钮背景颜色",
                  "type": "Color"
                },
                {
                  "id": "buttonFontColor",
                  "name": "按钮文字颜色",
                  "type": "Color"
                },
                {
                  "id": "buttonFontSize",
                  "name": "按钮文字字号",
                  "type": "Number"
                },
                {
                  "id": "buttonFontBold",
                  "name": "按钮文字加粗",
                  "type": "Switch"
                }
              ]
            },
            {
              "name": "image",
              "comment": "图片设置",
              "type": "group",
              "items": [
                {
                  "id": "imgWidth",
                  "name": "图片宽度",
                  "type": "Size"
                },
                {
                  "id": "imgHeight",
                  "name": "图片高度",
                  "type": "Size"
                }
              ]
            },
            {
              "name": "switch",
              "comment": "开关设置",
              "type": "group",
              "items": [
                {
                  "id": "selectedValue",
                  "name": "开关选中值",
                  "type": "String"
                }
              ]
            },
            {
              "name": "order",
              "comment": "排序设置",
              "type": "group",
              "items": [
                {
                  "id": "allowOrder",
                  "name": "启用排序",
                  "type": "Switch",
                  "default":false
                },
                {
                  "id": "orderField",
                  "name": "排序字段名",
                  "type": "String"
                },
                {
                  "id": "orderType",
                  "name": "默认排序方式",
                  "type": "select",
                  "options": [
                    {
                      "value": "",
                      "text": "不排序"
                    },
                    {
                      "value": "asc",
                      "text": "正序"
                    },
                    {
                      "value": "desc",
                      "text": "倒叙"
                    }
                  ]
                }
              ]
            },
            {
              "name": "display",
              "comment": "显示条件",
              "type": "group",
              "items": [
              ]
            }
          ]
        }
      ]
    },
    {
      "name": "headerSetting",
      "comment": "表头设置",
      "type": "group",
      "items": [
        {
          "name": "showHeader",
          "comment": "显示表头",
          "type": "Switch",
          "default": true
        },
        {
          "name": "headerBold",
          "comment": "标题加粗",
          "type": "Switch",
          "default": true
        },
        {
          "name": "headerBgColor",
          "comment": "标题栏背景色",
          "type": "Color",
          "default": "#F9F9F9"
        },
        {
          "name": "headerTextColor",
          "comment": "标题栏文字颜色",
          "type": "Color",
          "default": "#333333"
        },
        {
          "name": "headerHeight",
          "comment": "标题栏高度",
          "type": "Number",
          "default": "40"
        }
      ]
    },
    {
      "name": "bodySetting",
      "comment": "表体设置",
      "type": "group",
      "items": [
        {
          "name": "showRowNum",
          "comment": "显示序号",
          "type": "Switch",
          "default": false
        },
        {
          "name": "showBorder",
          "comment": "显示边框",
          "type": "Switch",
          "default": true
        },
        {
          "name": "showCheckbox",
          "comment": "显示选择框",
          "type": "Switch"
        },
        {
          "name": "borderColor",
          "comment": "边框颜色",
          "type": "Color",
          "default": "#E6E6E6"
        },
        {
          "name": "singleRowBgColor",
          "comment": "奇数行背景色",
          "type": "Color",
        },
        {
          "name": "doubleRowBgColor",
          "comment": "偶数行背景色",
          "type": "Color",
          "default": "#f6f6ff"
        },
        {
          "name": "disableMouseOverBg",
          "comment": "禁用鼠标滑过改背景",
          "type": "Switch"
        },
        {
          "name": "rowHeight",
          "comment": "行高",
          "type": "Number"
        }
      ]
    },
    {
      "name": "footerSetting",
      "comment": "表尾设置",
      "type": "group",
      "items": [
        {
          "name": "showSumer",
          "comment": "显示合计栏",
          "type": "Switch"
        },
        {
          "name": "allowPaging",
          "comment": "允许翻页",
          "type": "Switch",
          "default": false
        },
        {
          "name": "pageSize",
          "comment": "每页显示数量",
          "type": "Select",
          "options": [
            {
              "value": "20",
              "text": "20"
            },
            {
              "value": "30",
              "text": "30"
            },
            {
              "value": "50",
              "text": "50"
            },
            {
              "value": "100",
              "text": "100"
            }
          ]
        }
      ]
    },
    {
      "name": "treeSetting",
      "comment": "树形显示设置",
      "type": "group",
      "items": [
        {
          "name": "showTree",
          "comment": "支持树形显示",
          "type": "Switch"
        },
        {
          "name": "expandAllNode",
          "comment": "默认展开全部节点",
          "type": "Switch",
          "default": true
        },
        {
          "name": "treeColIndex",
          "comment": "显示树形的列索引",
          "type": "Number",
          "default": 0
        },
        {
          "name": "nodeIdField",
          "comment": "保存节点ID值的字段名",
          "type": "String",
          "default": "id"
        },
        {
          "name": "parentNodeIdField",
          "comment": "保存父节点ID值的字段名",
          "type": "String",
          "default": "parent_id"
        },
        {
          "name": "rootNodeId",
          "comment": "根节点的ID值",
          "type": "String",
          "default": "0"
        }
      ]
    }
  ],
  "styles": ["size", "position", "background", "border", "margin", "other"],
  "defaultStyles": {
    "width": "100%",
    "height": "120px",
    "position": "relative",
    "left": 0,
    "top": 0
  },
  "events": [
    {
      "name": "onAfterInitRuntime",
      "comment": "组件初始化后",
      "isNotHtmlEvent": true
    }, 
    {
      "name": "onBeforeLoadData",
      "comment": "加载数据前",
      "isNotHtmlEvent": true,
      "args": [{
        "name": "args",
        "type": "Object",
        "comment": "请求数据"
      }]
    }, {
      "name": "onAfterLoadData",
      "comment": "加载数据后",
      "isNotHtmlEvent": true,
      "args": [{
        "name": "req",
        "type": "Object",
        "comment": "请求数据"
      },{
        "name": "res",
        "type": "Object",
        "comment": "响应数据"
      }]
    },
    {
      "name": "onBeforeBindData",
      "comment": "绑定数据前",
      "isNotHtmlEvent": true,
      "args": [{
        "name": "data",
        "type": "Object",
        "comment": "绑定的数据"
      }]
    }, {
      "name": "onAfterBindData",
      "comment": "绑定数据后",
      "isNotHtmlEvent": true,
      "args": [{
        "name": "data",
        "type": "Object",
        "comment": "绑定的数据"
      }]
    }, {
      "name": "onBeforeAddDataRow",
      "comment": "添加数据行前",
      "isNotHtmlEvent": true,
      "args": [{
        "name": "rowIndex",
        "type": "Int",
        "comment": "行索引"
      }, {
        "name": "rowData",
        "type": "Object",
        "comment": "当前行数据"
      }]
    }, {
      "name": "onAfterAddDataRow",
      "comment": "添加数据行后",
      "isNotHtmlEvent": true,
      "args": [{
        "name": "rowIndex",
        "type": "Int",
        "comment": "行索引"
      }, {
        "name": "rowData",
        "type": "Object",
        "comment": "当前行数据"
      }]
    }, {
      "name": "onRowMouseOver",
      "comment": "鼠标进入行时",
      "isNotHtmlEvent": true,
      "args": [{
        "name": "rowIndex",
        "type": "Int",
        "comment": "行索引"
      }]
    }, {
      "name": "onRowMouseOut",
      "comment": "鼠标离开行时",
      "isNotHtmlEvent": true,
      "args": [{
        "name": "rowIndex",
        "type": "Int",
        "comment": "行索引"
      }]
    }, {
      "name": "onCellClick",
      "comment": "单击单元格时",
      "isNotHtmlEvent": true,
      "args": [{
        "name": "rowIndex",
        "type": "Int",
        "comment": "行索引"
      }, {
        "name": "colIndex",
        "type": "Int",
        "comment": "列索引"
      }, {
        "name": "rowData",
        "type": "Object",
        "comment": "当前行数据"
      }]
    }, {
      "name": "onCellDblClick",
      "comment": "双击单元格时",
      "isNotHtmlEvent": true,
      "args": [{
        "name": "rowIndex",
        "type": "Int",
        "comment": "行索引"
      }, {
        "name": "colIndex",
        "type": "Int",
        "comment": "列索引"
      }, {
        "name": "rowData",
        "type": "Object",
        "comment": "当前行数据"
      }]
    }, {
      "name": "onCellBindData",
      "isNotHtmlEvent": true,
      "comment": "绑定单元格数据时",
      "args": [{
        "name": "rowIndex",
        "type": "Int",
        "comment": "行索引"
      }, {
        "name": "colIndex",
        "type": "Int",
        "comment": "列索引"
      }, {
        "name": "rowData",
        "type": "Object",
        "comment": "当前行数据"
      }]
    }
  ],
  "methods": [
    {
      "name": "addRow",
      "comment": "添加行",
      "args": [
        {
          "name": "rowData",
          "comment": "行数据",
          "type": "Object",
          "required": true
        }
      ]
    },
    {
      "name": "bindData",
      "comment": "绑定数据",
      "args": [
        {
          "name": "data",
          "comment": "数据",
          "type": "Object",
          "required": true
        }
      ]
    },
    {
      "name": "deleteRowData",
      "comment": "删除行及对应的数据",
      "args": [
        {
          "name": "keyValue",
          "comment": "主键值",
          "type": "String",
          "required": true
        }
      ]
    },
    {
      "name": "getCell",
      "comment": "获得单元格",
      "args": [
        {
          "name": "rowIndex",
          "comment": "行索引",
          "type": "Int",
          "required": true
        },
        {
          "name": "colIndex",
          "comment": "列索引",
          "type": "Int",
          "required": true
        }
      ]
    },
    {
      "name": "getCheckedData",
      "comment": "获得选中行的数据"
    },
    {
      "name": "getCheckedKeys",
      "comment": "获得选中行的主键值"
    },
    {
      "name": "getRow",
      "comment": "获得行",
      "args": [
        {
          "name": "rowIndex",
          "comment": "行索引",
          "type": "Int",
          "required": true
        }
      ]
    },
    {
      "name": "getRowData",
      "comment": "获得行数据",
      "args": [
        {
          "name": "rowIndex",
          "comment": "行索引",
          "type": "Int",
          "required": true
        }
      ]
    },
    {
      "name": "getRowsChecked",
      "comment": "获得选中行"
    },
    {
      "name": "gotoPage",
      "comment": "跳转到指定页",
      "args": [
        {
          "name": "toPage",
          "comment": "页数",
          "type": "Number",
          "required": true
        }
      ]
    },
    {
      "name": "loadData",
      "comment": "加载指定页的数据",
      "args": [
        {
          "name": "toPage",
          "comment": "页数",
          "type": "Number",
          "required": true
        }
      ]
    },
    {
      "name": "reloadData",
      "comment": "重新加载数据"
    },
    {
      "name": "removeRow",
      "comment": "移除行",
      "args": [
        {
          "name": "rowIndex",
          "comment": "行索引",
          "type": "Int",
          "required": true
        }
      ]
    }
  ]
}