export default {
  "name": "Grid",
  "comment": "数据表格",
  "attrs": [
    {
      "name": "loadDataService",
      "comment": "加载数据服务",
      "type": "Service"
    },
    {
      "name": "dataBindingMember",
      "comment": "数据绑定成员",
      "type": "String"
    },
    {
      "name": "dataBindingKey",
      "comment": "数据绑定主键",
      "type": "String"
    },
    {
      "name": "allowPaging",
      "comment": "启用翻页",
      "type": "Switch",
      "default": true
    }
  ],
  "styles": ["size", "position", "background", "border", "margin", "other"],
  "defaultStyles": {
    "width": "100%",
    "height": "100%",
    "padding-bottom": "160rpx"
  },
  "events": [
    {
      "name": "onBeforeLoadData",
      "comment": "加载数据前",
      "isNotHtmlEvent": true
    }, {
      "name": "onAfterLoadData",
      "comment": "加载数据后",
      "isNotHtmlEvent": true
    }, {
      "name": "onAddDataRow",
      "comment": "添加数据行时",
      "isNotHtmlEvent": true
    }, {
      "name": "onClickDataRow",
      "comment": "点击数据行时",
      "isNotHtmlEvent": true
    }, {
      "name": "onMouseOverDataRow",
      "comment": "鼠标经过数据行时",
      "isNotHtmlEvent": true
    }, {
      "name": "onMouseOutDataRow",
      "comment": "鼠标移出数据行时",
      "isNotHtmlEvent": true
    }
  ],
  "methods": [
    {
      "name": "addRow",
      "comment": "添加行",
      "args": [
        {
          "name": "rowData",
          "comment": "行数据",
          "type": "Object",
          "required": true
        }
      ]
    },
    {
      "name": "deleteRow",
      "comment": "删除行",
      "args": [
        {
          "name": "keyValue",
          "comment": "主键值",
          "type": "String",
          "required": true
        }
      ]
    },
    {
      "name": "reloadData",
      "comment": "重新加载数据"
    }
  ]
}