import {VisibleComponent} from "../controller.js";

/**
 * 数据表格组件
 * @param {[type]} dataModel [description]
 */
export default class Grid extends VisibleComponent {

  constructor(__tfp, dataModel, parent) {
    super(__tfp, "Grid", dataModel, parent);

    this.pageSize = 20;
    this.curPage = 0;
    this.pageCount = 0;
    this.rowsCount = 0;
    this.dataList = [];

    if(__tfp.isDesigning) {
      if(!this.dataModel.components || this.dataModel.components.length==0) {
        this.dataModel.components = [{
          id: this.id+"_DataRow",
          type: "GridDataRow",
          styles: {
            "position": "absolute",
            "top": "0",
            "left": "10px",
            "right": "10px",
            "height": "60px",
            "border": "1px solid #cccccc",
            "border-radius": "10px"
          }
        }];
      }
    }
  }

  //属性
  get loadDataService() { return this.dataModel.loadDataService }
  set loadDataService(value) {this.dataModel.loadDataService = value}

  get dataBindingMember() { return this.dataModel.dataBindingMember }
  set dataBindingMember(value) {this.dataModel.dataBindingMember = value}

  get dataBindingKey() { return this.dataModel.dataBindingKey }
  set dataBindingKey(value) {this.dataModel.dataBindingKey = value}

  get showSearchBox() { return this.dataModel.showSearchBox }
  set showSearchBox(value) {
    this.dataModel.showSearchBox = value ? true : false;
    if(this._jqObj) {
      if(this.dataModel.showSearchBox) {
        if(this._jqObj.find(".tfp-grid-searchbox").length>0) {
          this._jqObj.find(".tfp-grid-searchbox").show();
        } else {
          $(this.getSearchBoxHtml()).insertBefore(this._jqObj.find(".tfp-grid-datalist"));
        }
        this._jqObj.find(".tfp-grid-datalist").css("top", "50px");
      } else {
        this._jqObj.find(".tfp-grid-searchbox").hide();
        this._jqObj.find(".tfp-grid-datalist").css("top", "0");
      }
    }
  }

  get allowPaging() { return this.dataModel.allowPaging }
  set allowPaging(value) { 
    this.dataModel.allowPaging = value ? true : false;
    if(this._jqObj) {
      if(this.dataModel.allowPaging) {
        if(this._jqObj.find(".tfp-grid-footer").length>0) {
          this._jqObj.find(".tfp-grid-footer").show();
        } else {
          $(this.getFooterHtml()).insertAfter(this._jqObj.find(".tfp-grid-datalist"));
        }
        this._jqObj.find(".tfp-grid-datalist").css("bottom", "50px");
      } else {
        this._jqObj.find(".tfp-grid-footer").hide();
        this._jqObj.find(".tfp-grid-footer").css("bottom", "0");
      }
    }
  }

  get containerEl() { 
    return this._jqObj.find(".tfp-grid-datalist").get(0);
  }

  deleteCptId(cptHtml) {
    let start = cptHtml.indexOf("id=\"");
    if(start<0) return cptHtml;
    let end = cptHtml.indexOf("\"", start+4);
    if(end<0) return cptHtml;
    cptHtml = cptHtml.substr(0, start)+cptHtml.substr(end+2);
    return this.deleteCptId(cptHtml);
  }

  setCptDataFormat(cdm) {
    //let cpt = this._tfp.get(cdm.id);
    if(cdm.dataBindingFormat) {
      cdm.value = cdm.dataBindingFormat;
    }
    if(cdm.components && cdm.components.length>0) {
      for(var i=0;i<cdm.components.length;i++) {
        this.setCptDataFormat(cdm.components[i]);
      }
    }
  }

  getSearchBoxHtml() {
    var html = "";
    if(this.showSearchBox) {
      var indent = this.getHtmlIndent();
      let imgUrl = this._tfp.rootPath+"/src/components/grid/images/search.png";
      let readonly = "";
      if(this._tfp.isDesigning) readonly = " readonly";
      html += indent+"\t<div class=\"tfp-grid-searchbox\">"
        +"<img src=\""+imgUrl+"\" /><input type=\"text\""+readonly+">"
        +"<label>搜索</label></div>\r\n";
    }
    return html;
  }

  getFooterHtml() {
    var html = "";
    if(this.allowPaging) {
      var indent = this.getHtmlIndent();
      html += indent+"\t<div class=\"tfp-grid-footer\">\r\n";
      html += indent+"\t\t<div style=\"border:0;\"></div>\r\n";
      html += indent+"\t\t<div>首页</div>\r\n";
      html += indent+"\t\t<div>上一页</div>\r\n";
      html += indent+"\t\t<div>下一页</div>\r\n";
      html += indent+"\t\t<div>尾页</div>\r\n";
      html += indent+"\t</div>\r\n";
    }
    return html;
  }

  /**
   * 动态创建行模板内的组件
   * @param  {[type]} cdm [description]
   * @return {[type]}     [description]
   */
  createRowCpt(parent, cdm, rowIndex, rowData) {

    $("#"+cdm.id).attr("id", cdm.id+"_"+rowIndex);
    
    cdm.id = cdm.id+"_"+rowIndex;

    var cptClass = this._tfp.controllers[cdm.type];
    if (!cptClass) {
      console.log("未找到名为[" + cdm.type + "]的组件控制器！");
      return;
    }

    //绑定组件属性中的动态数据
    for(let pname in cdm) {
      if(["id", "type"].includes(pname)) continue;
      let pval = cdm[pname];
      if(!pval || typeof(pval)!="string") continue;
      if(pval.indexOf("{")>=0 && pval.indexOf("}")>0) {
        try {
          pval = this._tfp.replaceDataField(rowData, pval);
          pval = this._tfp.exeExpress(pval);
        } catch (e) {
          console.log(e);
          return;
        }
        cdm[pname] = pval;
      }
    }
    
    var cpt = new cptClass(this._tfp, cdm, parent);
    window[cpt.id] = cpt;
    cpt._jqObj = $("#"+cpt.id);
    cpt.isRendered = true;
    if(cpt._jqObj.length>0) cpt.el = cpt._jqObj[0];

    if(!cdm.components || cdm.components.length==0) return;

    for(var i=0;i<cdm.components.length;i++) {
      this.createRowCpt(cpt, cdm.components[i], rowIndex, rowData);
    }
  }
 
  bindData(data) {
    if(!data || !Array.isArray(data)) return;
    this.dataList = data;
    let top = 0;

    for(var i=0;i<this.dataModel.components.length;i++) {
      this._tfp.remove(this.dataModel.components[i]);
    }
    this.dataModel.components = [];

    let dataListDiv = this._jqObj.find(".tfp-grid-datalist");
    dataListDiv.empty();
    if(!this.showSearchBox) dataListDiv.css("top", "0");

    for(var i=0;i<data.length;i++) {
      let rowData = data[i];
      let rowIndex = i;
      if(this.templateRowCdm.beforeBindingData) {
        try {
          rowData = eval(this.templateRowCdm.beforeBindingData);
        } catch(err) {
          console.log(err);
        }
      }
      let dataRowHtml = this.dataRowHtmlTemplate;
      top = i*(this.rowHeight+10);
      try {
        dataRowHtml = this._tfp.replaceDataField(rowData, dataRowHtml);
        dataRowHtml = this._tfp.exeExpress(dataRowHtml);
      } catch(e) {
        console.log(e);
        return;
      }
      dataListDiv.append(dataRowHtml);

      let cdmRow = JSON.parse(JSON.stringify(this.templateRowCdm));
      this.createRowCpt(this, cdmRow, i, rowData);
      this._tfp.initCptRuntime(this._tfp.components[cdmRow.id]);

      let newRow = dataListDiv.find(".tfp-griddatarow").last();
      newRow.css("top", top+"px");
      var that = this;
      if(this.dataModel.onClickDataRow) {
        newRow.click(function() {
          let rowIndex = $(this).index();
          let rowData = that.dataList[rowIndex];
          try {
            eval(that.dataModel.onClickDataRow);
          } catch (err) {
            console.log(err.message);
          }
        });
      }
      if(this.templateRowCdm.afterBindingData) {
        try {
          eval(this.templateRowCdm.afterBindingData);
        } catch(err) {
          console.log(err);
        }
      }
    }
    dataListDiv.get(0).scrollTop = 0;
    if(this.allowPaging) this._jqObj.find(".tfp-grid-footer").find("div").eq(0).html(this.curPage+"/"+this.pageCount);
  }

  onLoadData(req, res) {
    var data = [];
    if (this.dataModel.dataBindingMember) {
      data = res[this.dataModel.dataBindingMember];
    } else if(this.dataModel.dataQuerySetting && this.dataModel.dataQuerySetting.dataMember) {
      data = res[this.dataModel.dataQuerySetting.dataMember];
    }
    if(!data) return;
    if(this.allowPaging) {
      this.curPage = data.toPage;
      this.rowsCount = data.rowsCount;
      this.pageCount = data.pageCount;
      this.pageSize = data.pageSize;
      this.bindData(data.rows);
    } else {
      this.bindData(data);
    }
  }

  loadData(toPage) {
    var args = {};
    if(this.allowPaging) {
      args = {
        pageSize: this.pageSize,
        toPage: toPage
      };
    }

    if(this.showSearchBox) {
      let keyword = this._jqObj.find(".tfp-grid-searchbox").find("input").val();
      if(keyword.trim()!="") args.keyword = keyword;
    }

    super.loadData(args);
  }

  reloadData() {
    this.loadData(1);
  }

  initRuntime() {
    let that = this;

    let templateRow = this._jqObj.find(".tfp-griddatarow-template");
    this.dataRowHtmlTemplate = templateRow.get(0).outerHTML;
    this.dataRowHtmlTemplate = this.dataRowHtmlTemplate.replace("tfp-griddatarow-template", "tfp-griddatarow");
    this.rowHeight = templateRow.height();
    let tmpCdm = this.dataModel.components[0];
    this.templateRowCdm = JSON.parse(JSON.stringify(tmpCdm));
    this.dataModel.components = [];
    this._tfp.remove(tmpCdm.id);
    this._jqObj.find(".tfp-griddatarow-template").remove();

    this._jqObj.find(".tfp-grid-searchbox").find("label").click(function() {
      that.loadData(1);
    });

    if(this.allowPaging) {
      let footerDivs = this._jqObj.find(".tfp-grid-footer").find("div");
      let that = this;
      footerDivs.eq(1).click(function() {
        that.loadData(1);
      });
      footerDivs.eq(2).click(function() {
        let prevPage = that.curPage - 1;
        if(prevPage<1) prevPage = 1;
        that.loadData(prevPage);
      });
      footerDivs.eq(3).click(function() {
        let nextPage = that.curPage + 1;
        if(nextPage>that.pageCount) nextPage = that.pageCount;
        that.loadData(nextPage);
      });
      footerDivs.eq(4).click(function() {
        that.loadData(that.pageCount);
      });
    }

    //如果设置了服务路径或服务组件，才需要在初始化时加载数据，否则，不加载
    if (this.dataModel.loadDataListService //某些老版本的组件使用的该属性，需要兼容
      || this.dataModel.loadDataService 
      || (this.dataModel.dataQuerySetting 
      && (this.dataModel.dataQuerySetting.servicePath || this.dataModel.dataQuerySetting.serviceCpt)
    )) {
      this.loadData(1);
    }
  }
}